-- Copyright (C) 2000-2007 MySQL AB
-- 
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; version 2 of the License.
-- 
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
-- 
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

-- DO NOT EDIT THIS FILE. It is generated automatically.

-- To use this file, load its contents into the mysql database. For example,
-- with the mysql client program, process the file like this, where
-- file_name is the name of this file:

--     mysql -u root -p mysql < file_name

set names 'utf8';

delete from help_topic;
delete from help_category;
delete from help_keyword;
delete from help_relation;

insert into help_category (help_category_id,name,parent_category_id,url) values (1,'Geographic',0,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (2,'Polygon properties',31,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (3,'WKT',31,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (4,'Numeric Functions',35,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (5,'Plugins',32,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (6,'MBR',31,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (7,'Control flow functions',35,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (8,'Transactions',32,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (9,'Account Management',32,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (10,'Point properties',31,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (11,'Encryption Functions',35,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (12,'LineString properties',31,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (13,'Logical operators',35,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (14,'Miscellaneous Functions',35,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (15,'Functions and Modifiers for Use with GROUP BY',32,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (16,'Information Functions',35,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (17,'Storage Engines',32,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (18,'Comparison operators',35,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (19,'Bit Functions',35,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (20,'Table Maintenance',32,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (21,'Data Types',32,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (22,'Triggers',32,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (23,'Geometry constructors',31,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (24,'GeometryCollection properties',1,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (25,'Administration',32,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (26,'Data Manipulation',32,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (27,'Geometry relations',31,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (28,'Language Structure',32,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (29,'Date and Time Functions',35,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (30,'WKB',31,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (31,'Geographic Features',32,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (32,'Contents',0,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (33,'Geometry properties',31,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (34,'String Functions',35,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (35,'Functions',32,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (36,'Stored Routines',32,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (37,'Data Definition',32,'');

insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (0,26,'JOIN','MySQL supports the following JOIN syntaxes for the table_references\npart of SELECT statements and multiple-table DELETE and UPDATE\nstatements:\n\ntable_references:\n    table_reference [, table_reference] ...\n\ntable_reference:\n    table_factor\n  | join_table\n\ntable_factor:\n    tbl_name [[AS] alias] [index_hint_list)]\n  | ( table_references )\n  | { OJ table_reference LEFT OUTER JOIN table_reference\n        ON conditional_expr }\n\njoin_table:\n    table_reference [INNER | CROSS] JOIN table_factor [join_condition]\n  | table_reference STRAIGHT_JOIN table_factor\n  | table_reference STRAIGHT_JOIN table_factor ON condition\n  | table_reference LEFT [OUTER] JOIN table_reference join_condition\n  | table_reference NATURAL [LEFT [OUTER]] JOIN table_factor\n  | table_reference RIGHT [OUTER] JOIN table_reference join_condition\n  | table_reference NATURAL [RIGHT [OUTER]] JOIN table_factor\n\njoin_condition:\n    ON conditional_expr\n  | USING (column_list)\n\nindex_hint_list:\n    index_hint [, index_hint] ...\n\nindex_hint:\n    USE {INDEX|KEY}\n      [{FOR {JOIN|ORDER BY|GROUP BY}] ([index_list])\n  | IGNORE {INDEX|KEY}\n      [{FOR {JOIN|ORDER BY|GROUP BY}] (index_list)\n  | FORCE {INDEX|KEY}\n      [{FOR {JOIN|ORDER BY|GROUP BY}] (index_list)\n\nindex_list:\n    index_name [, index_name] ...\n\nA table reference is also known as a join expression.\n\nThe syntax of table_factor is extended in comparison with the SQL\nStandard. The latter accepts only table_reference, not a list of them\ninside a pair of parentheses.\n\nThis is a conservative extension if we consider each comma in a list of\ntable_reference items as equivalent to an inner join. For example:\n\nSELECT * FROM t1 LEFT JOIN (t2, t3, t4)\n                 ON (t2.a=t1.a AND t3.b=t1.b AND t4.c=t1.c)\n\nis equivalent to:\n\nSELECT * FROM t1 LEFT JOIN (t2 CROSS JOIN t3 CROSS JOIN t4)\n                 ON (t2.a=t1.a AND t3.b=t1.b AND t4.c=t1.c)\n\nIn MySQL, CROSS JOIN is a syntactic equivalent to INNER JOIN (they can\nreplace each other). In standard SQL, they are not equivalent. INNER\nJOIN is used with an ON clause, CROSS JOIN is used otherwise.\n\nIn general, parentheses can be ignored in join expressions containing\nonly inner join operations. MySQL also supports nested joins (see\nhttp://dev.mysql.com/doc/refman/5.1/en/nested-joins.html).\n\nIndex hints can be specified to affect how the MySQL optimizer makes\nuse of indexes. For more information, see\nhttp://dev.mysql.com/doc/refman/5.1/en/index-hints.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/join.html\n\n','SELECT table1.* FROM table1\n  LEFT JOIN table2 ON table1.id=table2.id\n  WHERE table2.id IS NULL;\n','http://dev.mysql.com/doc/refman/5.1/en/join.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (1,34,'HEX','Syntax:\nHEX(N_or_S)\n\nIf N_or_S is a number, returns a string representation of the\nhexadecimal value of N, where N is a longlong (BIGINT) number. This is\nequivalent to CONV(N,10,16).\n\nIf N_or_S is a string, returns a hexadecimal string representation of\nN_or_S where each character in N_or_S is converted to two hexadecimal\ndigits.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT HEX(255);\n        -> \'FF\'\nmysql> SELECT 0x616263;\n        -> \'abc\'\nmysql> SELECT HEX(\'abc\');\n        -> 616263\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (2,34,'REPLACE','Syntax:\nREPLACE(str,from_str,to_str)\n\nReturns the string str with all occurrences of the string from_str\nreplaced by the string to_str. REPLACE() performs a case-sensitive\nmatch when searching for from_str.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT REPLACE(\'www.mysql.com\', \'w\', \'Ww\');\n        -> \'WwWwWw.mysql.com\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (3,27,'CONTAINS','Contains(g1,g2)\n\nReturns 1 or 0 to indicate whether g1 completely contains g2. This\ntests the opposite relationship as Within().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/functions-that-test-spatial-relationships-between-geometries.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/functions-that-test-spatial-relationships-between-geometries.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (4,33,'SRID','SRID(g)\n\nReturns an integer indicating the Spatial Reference System ID for the\ngeometry value g.\n\nIn MySQL, the SRID value is just an integer associated with the\ngeometry value. All calculations are done assuming Euclidean (planar)\ngeometry.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/general-geometry-property-functions.html\n\n','mysql> SELECT SRID(GeomFromText(\'LineString(1 1,2 2)\',101));\n+-----------------------------------------------+\n| SRID(GeomFromText(\'LineString(1 1,2 2)\',101)) |\n+-----------------------------------------------+\n|                                           101 |\n+-----------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.1/en/general-geometry-property-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (5,29,'CURRENT_TIMESTAMP','Syntax:\nCURRENT_TIMESTAMP, CURRENT_TIMESTAMP()\n\nCURRENT_TIMESTAMP and CURRENT_TIMESTAMP() are synonyms for NOW().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (6,26,'SHOW CONTRIBUTORS','Syntax:\nSHOW CONTRIBUTORS\n\nThe SHOW CONTRIBUTORS statement displays information about the people\nwho contribute to MySQL source or to causes that MySQL AB supports. For\neach contributor, it displays Name, Location, and Comment values.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-contributors.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-contributors.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (7,15,'VARIANCE','Syntax:\nVARIANCE(expr)\n\nReturns the population standard variance of expr. This is an extension\nto standard SQL. The standard SQL function VAR_POP() can be used\ninstead.\n\nVARIANCE() returns NULL if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (8,37,'DROP SERVER','Syntax:\nDROP SERVER [ IF EXISTS ] server_name\n\nDrops the server definition for the server named server_name. The\ncorresponding row within the mysql.servers table will be deleted. This\nstatement requires the SUPER privilege.\n\nDropping a server for a table does not affect any FEDERATED tables that\nused this connection information when they were created. See [HELP\nCREATE SERVER].\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/drop-server.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/drop-server.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (9,26,'SHOW AUTHORS','Syntax:\nSHOW AUTHORS\n\nThe SHOW AUTHORS statement displays information about the people who\nwork on MySQL. For each author, it displays Name, Location, and Comment\nvalues.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-authors.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-authors.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (10,15,'VAR_SAMP','Syntax:\nVAR_SAMP(expr)\n\nReturns the sample variance of expr. That is, the denominator is the\nnumber of rows minus one.\n\nVAR_SAMP() returns NULL if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (11,34,'CONCAT','Syntax:\nCONCAT(str1,str2,...)\n\nReturns the string that results from concatenating the arguments. May\nhave one or more arguments. If all arguments are non-binary strings,\nthe result is a non-binary string. If the arguments include any binary\nstrings, the result is a binary string. A numeric argument is converted\nto its equivalent binary string form; if you want to avoid that, you\ncan use an explicit type cast, as in this example:\n\nSELECT CONCAT(CAST(int_col AS CHAR), char_col);\n\nCONCAT() returns NULL if any argument is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT CONCAT(\'My\', \'S\', \'QL\');\n        -> \'MySQL\'\nmysql> SELECT CONCAT(\'My\', NULL, \'QL\');\n        -> NULL\nmysql> SELECT CONCAT(14.3);\n        -> \'14.3\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (12,31,'GEOMETRY HIERARCHY','Geometry is the base class. It is an abstract class. The instantiable\nsubclasses of Geometry are restricted to zero-, one-, and\ntwo-dimensional geometric objects that exist in two-dimensional\ncoordinate space. All instantiable geometry classes are defined so that\nvalid instances of a geometry class are topologically closed (that is,\nall defined geometries include their boundary).\n\nThe base Geometry class has subclasses for Point, Curve, Surface, and\nGeometryCollection:\n\no Point represents zero-dimensional objects.\n\no Curve represents one-dimensional objects, and has subclass\n  LineString, with sub-subclasses Line and LinearRing.\n\no Surface is designed for two-dimensional objects and has subclass\n  Polygon.\n\no GeometryCollection has specialized zero-, one-, and two-dimensional\n  collection classes named MultiPoint, MultiLineString, and\n  MultiPolygon for modeling geometries corresponding to collections of\n  Points, LineStrings, and Polygons, respectively. MultiCurve and\n  MultiSurface are introduced as abstract superclasses that generalize\n  the collection interfaces to handle Curves and Surfaces.\n\nGeometry, Curve, Surface, MultiCurve, and MultiSurface are defined as\nnon-instantiable classes. They define a common set of methods for their\nsubclasses and are included for extensibility.\n\nPoint, LineString, Polygon, GeometryCollection, MultiPoint,\nMultiLineString, and MultiPolygon are instantiable classes.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/gis-geometry-class-hierarchy.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/gis-geometry-class-hierarchy.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (13,34,'CHAR FUNCTION','Syntax:\nCHAR(N,... [USING charset_name])\n\nCHAR() interprets each argument N as an integer and returns a string\nconsisting of the characters given by the code values of those\nintegers. NULL values are skipped.\nBy default, CHAR() returns a binary string. To produce a string in a\ngiven character set, use the optional USING clause:\n\nmysql> SELECT CHARSET(CHAR(0x65)), CHARSET(CHAR(0x65 USING utf8));\n+---------------------+--------------------------------+\n| CHARSET(CHAR(0x65)) | CHARSET(CHAR(0x65 USING utf8)) |\n+---------------------+--------------------------------+\n| binary              | utf8                           |\n+---------------------+--------------------------------+\n\nIf USING is given and the result string is illegal for the given\ncharacter set, a warning is issued. Also, if strict SQL mode is\nenabled, the result from CHAR() becomes NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT CHAR(77,121,83,81,\'76\');\n        -> \'MySQL\'\nmysql> SELECT CHAR(77,77.3,\'77.3\');\n        -> \'MMM\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (14,21,'DATETIME','DATETIME\n\nA date and time combination. The supported range is \'1000-01-01\n00:00:00\' to \'9999-12-31 23:59:59\'. MySQL displays DATETIME values in\n\'YYYY-MM-DD HH:MM:SS\' format, but allows assignment of values to\nDATETIME columns using either strings or numbers.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (15,36,'OPEN','Syntax:\nOPEN cursor_name\n\nThis statement opens a previously declared cursor.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/open.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/open.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (16,26,'SHOW CREATE PROCEDURE','Syntax:\nSHOW CREATE {PROCEDURE | FUNCTION} sp_name\n\nThese statements are MySQL extensions. Similar to SHOW CREATE TABLE,\nthey return the exact string that can be used to re-create the named\nroutine. The statements require that you be the owner of the routine or\nhave SELECT access to the mysql.proc table.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-create-procedure.html\n\n','mysql> SHOW CREATE FUNCTION test.hello\\G\n*************************** 1. row ***************************\n       Function: hello\n       sql_mode:\nCreate Function: CREATE FUNCTION `test`.`hello`(s CHAR(20)) »\n                 RETURNS CHAR(50)\n                 RETURN CONCAT(\'Hello, \',s,\'!\')\n','http://dev.mysql.com/doc/refman/5.1/en/show-create-procedure.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (17,21,'INTEGER','INTEGER[(M)] [UNSIGNED] [ZEROFILL]\n\nThis type is a synonym for INT.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (18,34,'LOWER','Syntax:\nLOWER(str)\n\nReturns the string str with all characters changed to lowercase\naccording to the current character set mapping. The default is latin1\n(cp1252 West European).\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT LOWER(\'QUADRATICALLY\');\n        -> \'quadratically\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (19,22,'CREATE TRIGGER','Syntax:\nCREATE\n    [DEFINER = { user | CURRENT_USER }]\n    TRIGGER trigger_name trigger_time trigger_event\n    ON tbl_name FOR EACH ROW trigger_stmt\n\nThis statement creates a new trigger. A trigger is a named database\nobject that is associated with a table, and that activates when a\nparticular event occurs for the table. Currently, CREATE TRIGGER\nrequires the TRIGGER privilege for the table associated with the\ntrigger. (This statement requires the SUPER privilege prior to MySQL\n5.1.6.)\n\nThe trigger becomes associated with the table named tbl_name, which\nmust refer to a permanent table. You cannot associate a trigger with a\nTEMPORARY table or a view.\n\nWhen the trigger is activated, the DEFINER clause determines the\nprivileges that apply, as described later in this section.\n\ntrigger_time is the trigger action time. It can be BEFORE or AFTER to\nindicate that the trigger activates before or after the statement that\nactivated it.\n\ntrigger_event indicates the kind of statement that activates the\ntrigger. The trigger_event can be one of the following:\n\no INSERT: The trigger is activated whenever a new row is inserted into\n  the table; for example, through INSERT, LOAD DATA, and REPLACE\n  statements.\n\no UPDATE: The trigger is activated whenever a row is modified; for\n  example, through UPDATE statements.\n\no DELETE: The trigger is activated whenever a row is deleted from the\n  table; for example, through DELETE and REPLACE statements. However,\n  DROP TABLE and TRUNCATE statements on the table do not activate this\n  trigger, because they do not use DELETE. Dropping a partition does\n  not activate DELETE triggers, either. See [HELP TRUNCATE TABLE].\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/create-trigger.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/create-trigger.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (20,26,'SHOW COLUMNS','Syntax:\nSHOW [FULL] COLUMNS FROM tbl_name [FROM db_name] [LIKE \'pattern\']\n\nSHOW COLUMNS displays information about the columns in a given table.\nIt also works for views.\n\nThe FULL keyword causes the output to include the privileges you have\nas well as any per-column comments for each column.\n\nYou can use db_name.tbl_name as an alternative to the tbl_name FROM\ndb_name syntax. In other words, these two statements are equivalent:\n\nmysql> SHOW COLUMNS FROM mytable FROM mydb;\nmysql> SHOW COLUMNS FROM mydb.mytable;\n\nSHOW FIELDS is a synonym for SHOW COLUMNS. You can also list a table\'s\ncolumns with the mysqlshow db_name tbl_name command.\n\nThe DESCRIBE statement provides information similar to SHOW COLUMNS.\nSee [HELP DESCRIBE].\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-columns.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-columns.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (21,29,'MONTH','Syntax:\nMONTH(date)\n\nReturns the month for date, in the range 0 to 12.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT MONTH(\'1998-02-03\');\n        -> 2\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (22,21,'TINYINT','TINYINT[(M)] [UNSIGNED] [ZEROFILL]\n\nA very small integer. The signed range is -128 to 127. The unsigned\nrange is 0 to 255.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (23,26,'SHOW TRIGGERS','Syntax:\nSHOW TRIGGERS [FROM db_name] [LIKE expr]\n\nSHOW TRIGGERS lists the triggers currently defined on the MySQL server.\nThis statement requires the SUPER privilege.\n\nFor the trigger ins_sum as defined in\nhttp://dev.mysql.com/doc/refman/5.1/en/using-triggers.html, the output\nof this statement is as shown here:\n\nmysql> SHOW TRIGGERS LIKE \'acc%\'\\G\n*************************** 1. row ***************************\n  Trigger: ins_sum\n    Event: INSERT\n    Table: account\nStatement: SET @sum = @sum + NEW.amount\n   Timing: BEFORE\n  Created: NULL\n sql_mode:\n  Definer: myname@localhost\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-triggers.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-triggers.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (24,14,'MASTER_POS_WAIT','Syntax:\nMASTER_POS_WAIT(log_name,log_pos[,timeout])\n\nThis function is useful for control of master/slave synchronization. It\nblocks until the slave has read and applied all updates up to the\nspecified position in the master log. The return value is the number of\nlog events the slave had to wait for to advance to the specified\nposition. The function returns NULL if the slave SQL thread is not\nstarted, the slave\'s master information is not initialized, the\narguments are incorrect, or an error occurs. It returns -1 if the\ntimeout has been exceeded. If the slave SQL thread stops while\nMASTER_POS_WAIT() is waiting, the function returns NULL. If the slave\nis past the specified position, the function returns immediately.\n\nIf a timeout value is specified, MASTER_POS_WAIT() stops waiting when\ntimeout seconds have elapsed. timeout must be greater than 0; a zero or\nnegative timeout means no timeout.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (25,34,'REGEXP','Syntax:\nexpr REGEXP pat, expr RLIKE pat\n\nPerforms a pattern match of a string expression expr against a pattern\npat. The pattern can be an extended regular expression. The syntax for\nregular expressions is discussed in\nhttp://dev.mysql.com/doc/refman/5.1/en/regexp.html. Returns 1 if expr\nmatches pat; otherwise it returns 0. If either expr or pat is NULL, the\nresult is NULL. RLIKE is a synonym for REGEXP, provided for mSQL\ncompatibility.\n\nThe pattern need not be a literal string. For example, it can be\nspecified as a string expression or table column.\n\nNote: Because MySQL uses the C escape syntax in strings (for example,\n`\\n\' to represent the newline character), you must double any `\\\' that\nyou use in your REGEXP strings.\n\nREGEXP is not case sensitive, except when used with binary strings.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-comparison-functions.html\n\n','mysql> SELECT \'Monty!\' REGEXP \'m%y%%\';\n        -> 0\nmysql> SELECT \'Monty!\' REGEXP \'.*\';\n        -> 1\nmysql> SELECT \'new*\\n*line\' REGEXP \'new\\\\*.\\\\*line\';\n        -> 1\nmysql> SELECT \'a\' REGEXP \'A\', \'a\' REGEXP BINARY \'A\';\n        -> 1  0\nmysql> SELECT \'a\' REGEXP \'^[a-d]\';\n        -> 1\n','http://dev.mysql.com/doc/refman/5.1/en/string-comparison-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (26,36,'IF STATEMENT','Syntax:\nIF search_condition THEN statement_list\n    [ELSEIF search_condition THEN statement_list] ...\n    [ELSE statement_list]\nEND IF\n\nIF implements a basic conditional construct. If the search_condition\nevaluates to true, the corresponding SQL statement list is executed. If\nno search_condition matches, the statement list in the ELSE clause is\nexecuted. Each statement_list consists of one or more statements.\n\nNote: There is also an IF() function, which differs from the IF\nstatement described here. See [HELP CASE function].\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/if-statement.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/if-statement.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (27,19,'^','Syntax:\n^\n\nBitwise XOR:\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/bit-functions.html\n\n','mysql> SELECT 1 ^ 1;\n        -> 0\nmysql> SELECT 1 ^ 0;\n        -> 1\nmysql> SELECT 11 ^ 3;\n        -> 8\n','http://dev.mysql.com/doc/refman/5.1/en/bit-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (28,37,'DROP VIEW','Syntax:\nDROP VIEW [IF EXISTS]\n    view_name [, view_name] ...\n    [RESTRICT | CASCADE]\n\nDROP VIEW removes one or more views. You must have the DROP privilege\nfor each view. If any of the views named in the argument list do not\nexist, MySQL returns an error indicating by name which non-existing\nviews it was unable to drop, but it also drops all of the views in the\nlist that do exist.\n\nThe IF EXISTS clause prevents an error from occurring for views that\ndon\'t exist. When this clause is given, a NOTE is generated for each\nnon-existent view. See [HELP SHOW WARNINGS].\n\nRESTRICT and CASCADE, if given, are parsed and ignored.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/drop-view.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/drop-view.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (29,27,'WITHIN','Within(g1,g2)\n\nReturns 1 or 0 to indicate whether g1 is spatially within g2. This\ntests the opposite relationship as Contains().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/functions-that-test-spatial-relationships-between-geometries.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/functions-that-test-spatial-relationships-between-geometries.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (30,29,'WEEK','Syntax:\nWEEK(date[,mode])\n\nThis function returns the week number for date. The two-argument form\nof WEEK() allows you to specify whether the week starts on Sunday or\nMonday and whether the return value should be in the range from 0 to 53\nor from 1 to 53. If the mode argument is omitted, the value of the\ndefault_week_format system variable is used. See\nhttp://dev.mysql.com/doc/refman/5.1/en/server-system-variables.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT WEEK(\'1998-02-20\');\n        -> 7\nmysql> SELECT WEEK(\'1998-02-20\',0);\n        -> 7\nmysql> SELECT WEEK(\'1998-02-20\',1);\n        -> 8\nmysql> SELECT WEEK(\'1998-12-31\',1);\n        -> 53\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (31,26,'SHOW PLUGINS','Syntax:\nSHOW PLUGINS\n\nSHOW PLUGINS displays information about known plugins.\n\nmysql> SHOW PLUGINS;\n+------------+--------+----------------+---------+\n| Name       | Status | Type           | Library |\n+------------+--------+----------------+---------+\n| MEMORY     | ACTIVE | STORAGE ENGINE | NULL    |\n| MyISAM     | ACTIVE | STORAGE ENGINE | NULL    |\n| InnoDB     | ACTIVE | STORAGE ENGINE | NULL    |\n| ARCHIVE    | ACTIVE | STORAGE ENGINE | NULL    |\n| CSV        | ACTIVE | STORAGE ENGINE | NULL    |\n| BLACKHOLE  | ACTIVE | STORAGE ENGINE | NULL    |\n| FEDERATED  | ACTIVE | STORAGE ENGINE | NULL    |\n| MRG_MYISAM | ACTIVE | STORAGE ENGINE | NULL    |\n+------------+--------+----------------+---------+\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-plugins.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-plugins.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (32,26,'PREPARE','Syntax:\nPREPARE stmt_name FROM preparable_stmt\n\nThe PREPARE statement prepares a statement and assigns it a name,\nstmt_name, by which to refer to the statement later. Statement names\nare not case sensitive. preparable_stmt is either a string literal or a\nuser variable that contains the text of the statement. The text must\nrepresent a single SQL statement, not multiple statements. Within the\nstatement, `?\' characters can be used as parameter markers to indicate\nwhere data values are to be bound to the query later when you execute\nit. The `?\' characters should not be enclosed within quotes, even if\nyou intend to bind them to string values. Parameter markers can be used\nonly where data values should appear, not for SQL keywords,\nidentifiers, and so forth.\n\nIf a prepared statement with the given name already exists, it is\ndeallocated implicitly before the new statement is prepared. This means\nthat if the new statement contains an error and cannot be prepared, an\nerror is returned and no statement with the given name exists.\n\nThe scope of a prepared statement is the client session within which it\nis created. Other clients cannot see it.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/sqlps.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/sqlps.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (33,8,'LOCK','Syntax:\nLOCK TABLES\n    tbl_name [AS alias]\n      {READ [LOCAL] | [LOW_PRIORITY] WRITE}\n    [, tbl_name [AS alias]\n      {READ [LOCAL] | [LOW_PRIORITY] WRITE}] ...\nUNLOCK TABLES\n\nLOCK TABLES locks base tables (but not views) for the current thread.\nIf any of the tables are locked by other threads, it blocks until all\nlocks can be acquired.\n\nUNLOCK TABLES explicitly releases any locks held by the current thread.\nAll tables that are locked by the current thread are implicitly\nunlocked when the thread issues another LOCK TABLES, or when the\nconnection to the server is closed. UNLOCK TABLES is also used after\nacquiring a global read lock with FLUSH TABLES WITH READ LOCK to\nrelease that lock. (You can lock all tables in all databases with read\nlocks with the FLUSH TABLES WITH READ LOCK statement. See [HELP FLUSH].\nThis is a very convenient way to get backups if you have a filesystem\nsuch as Veritas that can take snapshots in time.)\n\nTo use LOCK TABLES, you must have the LOCK TABLES privilege and the\nSELECT privilege for the involved tables.\n\nThe main reasons to use LOCK TABLES are to emulate transactions or to\nget more speed when updating tables. This is explained in more detail\nlater.\n\nA table lock protects only against inappropriate reads or writes by\nother clients. The client holding the lock, even a read lock, can\nperform table-level operations such as DROP TABLE. Truncate operations\nare not transaction-safe, so an error occurs if the client attempts one\nduring an active transaction or while holding a table lock.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/lock-tables.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/lock-tables.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (34,34,'UPDATEXML','Syntax:\nUpdateXML(xml_target, xpath_expr, new_xml)\n\nThis function replaces a single portion of a given fragment of XML\nmarkup xml_target with a new XML fragment new_xml, and then returns the\nchanged XML. The portion of xml_target that is replaced matches an\nXPath expression xpath_expr supplied by the user. If no expression\nmatching xpath_expr is found, or if multiple matches are found, the\nfunction returns the original xml_target XML fragment. All three\narguments must be strings.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/xml-functions.html\n\n','mysql> SELECT\n    ->   UpdateXML(\'<a><b>ccc</b><d></d></a>\', \'/a\', \'<e>fff</e>\') AS val1,\n    ->   UpdateXML(\'<a><b>ccc</b><d></d></a>\', \'/b\', \'<e>fff</e>\') AS val2,\n    ->   UpdateXML(\'<a><b>ccc</b><d></d></a>\', \'//b\', \'<e>fff</e>\') AS val3,\n    ->   UpdateXML(\'<a><b>ccc</b><d></d></a>\', \'/a/d\', \'<e>fff</e>\') AS val4,\n    ->   UpdateXML(\'<a><d></d><b>ccc</b><d></d></a>\', \'/a/d\', \'<e>fff</e>\') AS val5\n    -> \\G\n\n*************************** 1. row ***************************\nval1: <e>fff</e>\nval2: <a><b>ccc</b><d></d></a>\nval3: <a><e>fff</e><d></d></a>\nval4: <a><b>ccc</b><e>fff</e></a>\nval5: <a><d></d><b>ccc</b><d></d></a>\n','http://dev.mysql.com/doc/refman/5.1/en/xml-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (35,26,'RESET SLAVE','Syntax:\nRESET SLAVE\n\nRESET SLAVE makes the slave forget its replication position in the\nmaster\'s binary logs. This statement is meant to be used for a clean\nstart: It deletes the master.info and relay-log.info files, all the\nrelay logs, and starts a new relay log.\n\nNote: All relay logs are deleted, even if they have not been completely\nexecuted by the slave SQL thread. (This is a condition likely to exist\non a replication slave if you have issued a STOP SLAVE statement or if\nthe slave is highly loaded.)\n\nConnection information stored in the master.info file is immediately\nreset using any values specified in the corresponding startup options.\nThis information includes values such as master host, master port,\nmaster user, and master password. If the slave SQL thread was in the\nmiddle of replicating temporary tables when it was stopped, and RESET\nSLAVE is issued, these replicated temporary tables are deleted on the\nslave.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/reset-slave.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/reset-slave.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (36,26,'SHOW BINARY LOGS','Syntax:\nSHOW BINARY LOGS\nSHOW MASTER LOGS\n\nLists the binary log files on the server. This statement is used as\npart of the procedure described in [HELP PURGE MASTER LOGS], that shows\nhow to determine which logs can be purged.\n\nmysql> SHOW BINARY LOGS;\n+---------------+-----------+\n| Log_name      | File_size |\n+---------------+-----------+\n| binlog.000015 |    724935 |\n| binlog.000016 |    733481 |\n+---------------+-----------+\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-binary-logs.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-binary-logs.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (37,23,'POLYGON','Polygon(ls1,ls2,...)\n\nConstructs a WKB Polygon value from a number of WKB LineString\narguments. If any argument does not represent the WKB of a LinearRing\n(that is, not a closed and simple LineString) the return value is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/gis-mysql-specific-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/gis-mysql-specific-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (38,29,'MINUTE','Syntax:\nMINUTE(time)\n\nReturns the minute for time, in the range 0 to 59.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT MINUTE(\'98-02-03 10:05:03\');\n        -> 5\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (39,29,'DAY','Syntax:\nDAY(date)\n\nDAY() is a synonym for DAYOFMONTH().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (40,34,'MID','Syntax:\nMID(str,pos,len)\n\nMID(str,pos,len) is a synonym for SUBSTRING(str,pos,len).\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (41,26,'REPLACE INTO','Syntax:\nREPLACE [LOW_PRIORITY | DELAYED]\n    [INTO] tbl_name [(col_name,...)]\n    VALUES ({expr | DEFAULT},...),(...),...\n\nOr:\n\nREPLACE [LOW_PRIORITY | DELAYED]\n    [INTO] tbl_name\n    SET col_name={expr | DEFAULT}, ...\n\nOr:\n\nREPLACE [LOW_PRIORITY | DELAYED]\n    [INTO] tbl_name [(col_name,...)]\n    SELECT ...\n\nREPLACE works exactly like INSERT, except that if an old row in the\ntable has the same value as a new row for a PRIMARY KEY or a UNIQUE\nindex, the old row is deleted before the new row is inserted. See [HELP\nINSERT].\n\nREPLACE is a MySQL extension to the SQL standard. It either inserts, or\ndeletes and inserts. For another MySQL extension to standard SQL ---\nthat either inserts or updates --- see\nhttp://dev.mysql.com/doc/refman/5.1/en/insert-on-duplicate.html.\n\nNote that unless the table has a PRIMARY KEY or UNIQUE index, using a\nREPLACE statement makes no sense. It becomes equivalent to INSERT,\nbecause there is no index to be used to determine whether a new row\nduplicates another.\n\nValues for all columns are taken from the values specified in the\nREPLACE statement. Any missing columns are set to their default values,\njust as happens for INSERT. You cannot refer to values from the current\nrow and use them in the new row. If you use an assignment such as SET\ncol_name = col_name + 1, the reference to the column name on the right\nhand side is treated as DEFAULT(col_name), so the assignment is\nequivalent to SET col_name = DEFAULT(col_name) + 1.\n\nTo use REPLACE, you must have both the INSERT and DELETE privileges for\nthe table.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/replace.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/replace.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (42,14,'UUID','Syntax:\nUUID()\n\nReturns a Universal Unique Identifier (UUID) generated according to\n"DCE 1.1: Remote Procedure Call" (Appendix A) CAE (Common Applications\nEnvironment) Specifications published by The Open Group in October 1997\n(Document Number C706,\nhttp://www.opengroup.org/public/pubs/catalog/c706.htm).\n\nA UUID is designed as a number that is globally unique in space and\ntime. Two calls to UUID() are expected to generate two different\nvalues, even if these calls are performed on two separate computers\nthat are not connected to each other.\n\nA UUID is a 128-bit number represented by a string of five hexadecimal\nnumbers in aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee format:\n\no The first three numbers are generated from a timestamp.\n\no The fourth number preserves temporal uniqueness in case the timestamp\n  value loses monotonicity (for example, due to daylight saving time).\n\no The fifth number is an IEEE 802 node number that provides spatial\n  uniqueness. A random number is substituted if the latter is not\n  available (for example, because the host computer has no Ethernet\n  card, or we do not know how to find the hardware address of an\n  interface on your operating system). In this case, spatial uniqueness\n  cannot be guaranteed. Nevertheless, a collision should have very low\n  probability.\n\n  Currently, the MAC address of an interface is taken into account only\n  on FreeBSD and Linux. On other operating systems, MySQL uses a\n  randomly generated 48-bit number.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html\n\n','mysql> SELECT UUID();\n        -> \'6ccd780c-baba-1026-9564-0040f4311e29\'\n','http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (43,23,'LINESTRING','LineString(pt1,pt2,...)\n\nConstructs a WKB LineString value from a number of WKB Point arguments.\nIf any argument is not a WKB Point, the return value is NULL. If the\nnumber of Point arguments is less than two, the return value is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/gis-mysql-specific-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/gis-mysql-specific-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (44,14,'SLEEP','Syntax:\nSLEEP(duration)\n\nSleeps (pauses) for the number of seconds given by the duration\nargument, then returns 0. If SLEEP() is interrupted, it returns 1. The\nduration may have a fractional part given in microseconds.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (45,16,'CONNECTION_ID','Syntax:\nCONNECTION_ID()\n\nReturns the connection ID (thread ID) for the connection. Every\nconnection has an ID that is unique among the set of currently\nconnected clients.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/information-functions.html\n\n','mysql> SELECT CONNECTION_ID();\n        -> 23786\n','http://dev.mysql.com/doc/refman/5.1/en/information-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (46,26,'DELETE','Syntax:\nSingle-table syntax:\n\nDELETE [LOW_PRIORITY] [QUICK] [IGNORE] FROM tbl_name\n    [WHERE where_condition]\n    [ORDER BY ...]\n    [LIMIT row_count]\n\nMultiple-table syntax:\n\nDELETE [LOW_PRIORITY] [QUICK] [IGNORE]\n    tbl_name[.*] [, tbl_name[.*]] ...\n    FROM table_references\n    [WHERE where_condition]\n\nOr:\n\nDELETE [LOW_PRIORITY] [QUICK] [IGNORE]\n    FROM tbl_name[.*] [, tbl_name[.*]] ...\n    USING table_references\n    [WHERE where_condition]\n\nFor the single-table syntax, the DELETE statement deletes rows from\ntbl_name and returns the number of rows deleted. The WHERE clause, if\ngiven, specifies the conditions that identify which rows to delete.\nWith no WHERE clause, all rows are deleted. If the ORDER BY clause is\nspecified, the rows are deleted in the order that is specified. The\nLIMIT clause places a limit on the number of rows that can be deleted.\n\nFor the multiple-table syntax, DELETE deletes from each tbl_name the\nrows that satisfy the conditions. In this case, ORDER BY and LIMIT\ncannot be used.\n\nwhere_condition is an expression that evaluates to true for each row to\nbe deleted. It is specified as described in [HELP SELECT].\n\nAs stated, a DELETE statement with no WHERE clause deletes all rows. A\nfaster way to do this, when you do not want to know the number of\ndeleted rows, is to use TRUNCATE TABLE. See [HELP TRUNCATE TABLE].\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/delete.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/delete.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (47,4,'ROUND','Syntax:\nROUND(X), ROUND(X,D)\n\nRounds the argument X to D decimal places. The rounding algorithm\ndepends on the data type of X. D defaults to 0 if not specified. D can\nbe negative to cause D digits left of the decimal point of the value X\nto become zero.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT ROUND(-1.23);\n        -> -1\nmysql> SELECT ROUND(-1.58);\n        -> -2\nmysql> SELECT ROUND(1.58);\n        -> 2\nmysql> SELECT ROUND(1.298, 1);\n        -> 1.3\nmysql> SELECT ROUND(1.298, 0);\n        -> 1\nmysql> SELECT ROUND(23.298, -1);\n        -> 20\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (48,7,'NULLIF','Syntax:\nNULLIF(expr1,expr2)\n\nReturns NULL if expr1 = expr2 is true, otherwise returns expr1. This is\nthe same as CASE WHEN expr1 = expr2 THEN NULL ELSE expr1 END.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/control-flow-functions.html\n\n','mysql> SELECT NULLIF(1,1);\n        -> NULL\nmysql> SELECT NULLIF(1,2);\n        -> 1\n','http://dev.mysql.com/doc/refman/5.1/en/control-flow-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (49,36,'CLOSE','Syntax:\nCLOSE cursor_name\n\nThis statement closes a previously opened cursor.\n\nIf not closed explicitly, a cursor is closed at the end of the compound\nstatement in which it was declared.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/close.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/close.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (50,26,'STOP SLAVE','Syntax:\nSTOP SLAVE [thread_type [, thread_type] ... ]\n\nthread_type: IO_THREAD | SQL_THREAD\n\nStops the slave threads. STOP SLAVE requires the SUPER privilege.\n\nLike START SLAVE, this statement may be used with the IO_THREAD and\nSQL_THREAD options to name the thread or threads to be stopped.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/stop-slave.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/stop-slave.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (51,29,'TIMEDIFF','Syntax:\nTIMEDIFF(expr1,expr2)\n\nTIMEDIFF() returns expr1 - expr2 expressed as a time value. expr1 and\nexpr2 are time or date-and-time expressions, but both must be of the\nsame type.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT TIMEDIFF(\'2000:01:01 00:00:00\',\n    ->                 \'2000:01:01 00:00:00.000001\');\n        -> \'-00:00:00.000001\'\nmysql> SELECT TIMEDIFF(\'1997-12-31 23:59:59.000001\',\n    ->                 \'1997-12-30 01:01:01.000002\');\n        -> \'46:58:57.999999\'\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (52,3,'LINEFROMTEXT','LineFromText(wkt[,srid]), LineStringFromText(wkt[,srid])\n\nConstructs a LINESTRING value using its WKT representation and SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/gis-wkt-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/gis-wkt-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (53,26,'SHOW MASTER STATUS','Syntax:\nSHOW MASTER STATUS\n\nProvides status information about the binary log files of the master.\nExample:\n\nmysql > SHOW MASTER STATUS;\n+---------------+----------+--------------+------------------+\n| File          | Position | Binlog_Do_DB | Binlog_Ignore_DB |\n+---------------+----------+--------------+------------------+\n| mysql-bin.003 | 73       | test         | manual,mysql     |\n+---------------+----------+--------------+------------------+\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-master-status.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-master-status.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (54,29,'ADDTIME','Syntax:\nADDTIME(expr1,expr2)\n\nADDTIME() adds expr2 to expr1 and returns the result. expr1 is a time\nor datetime expression, and expr2 is a time expression.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT ADDTIME(\'1997-12-31 23:59:59.999999\',\n    ->                \'1 1:1:1.000002\');\n        -> \'1998-01-02 01:01:01.000001\'\nmysql> SELECT ADDTIME(\'01:00:00.999999\', \'02:00:00.999998\');\n        -> \'03:00:01.999997\'\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (55,31,'SPATIAL','MySQL can create spatial indexes using syntax similar to that for\ncreating regular indexes, but extended with the SPATIAL keyword.\nCurrently, columns in spatial indexes must be declared NOT NULL. The\nfollowing examples demonstrate how to create spatial indexes:\n\no With CREATE TABLE:\n\nCREATE TABLE geom (g GEOMETRY NOT NULL, SPATIAL INDEX(g));\n\no With ALTER TABLE:\n\nALTER TABLE geom ADD SPATIAL INDEX(g);\n\no With CREATE INDEX:\n\nCREATE SPATIAL INDEX sp_index ON geom (g);\n\nFor MyISAM tables, SPATIAL INDEX creates an R-tree index. For storage\nengines that support non-spatial indexing of spatial columns, the\nengine creates a B-tree index. A B-tree index on spatial values will be\nuseful for exact-value lookups, but not for range scans.\n\nFor more information on indexing spatial columns, see [HELP CREATE\nINDEX].\n\nTo drop spatial indexes, use ALTER TABLE or DROP INDEX:\n\no With ALTER TABLE:\n\nALTER TABLE geom DROP INDEX g;\n\no With DROP INDEX:\n\nDROP INDEX sp_index ON geom;\n\nExample: Suppose that a table geom contains more than 32,000\ngeometries, which are stored in the column g of type GEOMETRY. The\ntable also has an AUTO_INCREMENT column fid for storing object ID\nvalues.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-indexes.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-indexes.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (56,29,'TIMESTAMPDIFF','Syntax:\nTIMESTAMPDIFF(unit,datetime_expr1,datetime_expr2)\n\nReturns the integer difference between the date or datetime expressions\ndatetime_expr1 and datetime_expr2. The unit for the result is given by\nthe unit argument. The legal values for unit are the same as those\nlisted in the description of the TIMESTAMPADD() function.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT TIMESTAMPDIFF(MONTH,\'2003-02-01\',\'2003-05-01\');\n        -> 3\nmysql> SELECT TIMESTAMPDIFF(YEAR,\'2002-05-01\',\'2001-01-01\');\n        -> -1\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (57,34,'UPPER','Syntax:\nUPPER(str)\n\nReturns the string str with all characters changed to uppercase\naccording to the current character set mapping. The default is latin1\n(cp1252 West European).\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT UPPER(\'Hej\');\n        -> \'HEJ\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (58,29,'FROM_UNIXTIME','Syntax:\nFROM_UNIXTIME(unix_timestamp), FROM_UNIXTIME(unix_timestamp,format)\n\nReturns a representation of the unix_timestamp argument as a value in\n\'YYYY-MM-DD HH:MM:SS\' or YYYYMMDDHHMMSS format, depending on whether\nthe function is used in a string or numeric context. The value is\nexpressed in the current time zone. unix_timestamp is an internal\ntimestamp value such as is produced by the UNIX_TIMESTAMP() function.\n\nIf format is given, the result is formatted according to the format\nstring, which is used the same way as listed in the entry for the\nDATE_FORMAT() function.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT FROM_UNIXTIME(875996580);\n        -> \'1997-10-04 22:23:00\'\nmysql> SELECT FROM_UNIXTIME(875996580) + 0;\n        -> 19971004222300\nmysql> SELECT FROM_UNIXTIME(UNIX_TIMESTAMP(),\n    ->                      \'%Y %D %M %h:%i:%s %x\');\n        -> \'2003 6th August 06:22:58 2003\'\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (59,21,'MEDIUMBLOB','MEDIUMBLOB\n\nA BLOB column with a maximum length of 16,777,215 (224 - 1) bytes.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (60,7,'IFNULL','Syntax:\nIFNULL(expr1,expr2)\n\nIf expr1 is not NULL, IFNULL() returns expr1; otherwise it returns\nexpr2. IFNULL() returns a numeric or string value, depending on the\ncontext in which it is used.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/control-flow-functions.html\n\n','mysql> SELECT IFNULL(1,0);\n        -> 1\nmysql> SELECT IFNULL(NULL,10);\n        -> 10\nmysql> SELECT IFNULL(1/0,10);\n        -> 10\nmysql> SELECT IFNULL(1/0,\'yes\');\n        -> \'yes\'\n','http://dev.mysql.com/doc/refman/5.1/en/control-flow-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (61,26,'SHOW ERRORS','Syntax:\nSHOW ERRORS [LIMIT [offset,] row_count]\nSHOW COUNT(*) ERRORS\n\nThis statement is similar to SHOW WARNINGS, except that instead of\ndisplaying errors, warnings, and notes, it displays only errors.\n\nThe LIMIT clause has the same syntax as for the SELECT statement. See\n[HELP SELECT].\n\nThe SHOW COUNT(*) ERRORS statement displays the number of errors. You\ncan also retrieve this number from the error_count variable:\n\nSHOW COUNT(*) ERRORS;\nSELECT @@error_count;\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-errors.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-errors.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (62,18,'LEAST','Syntax:\nLEAST(value1,value2,...)\n\nWith two or more arguments, returns the smallest (minimum-valued)\nargument. The arguments are compared using the following rules:\n\no If the return value is used in an INTEGER context or all arguments\n  are integer-valued, they are compared as integers.\n\no If the return value is used in a REAL context or all arguments are\n  real-valued, they are compared as reals.\n\no If any argument is a case-sensitive string, the arguments are\n  compared as case-sensitive strings.\n\no In all other cases, the arguments are compared as case-insensitive\n  strings.\n\nLEAST() returns NULL if any argument is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html\n\n','mysql> SELECT LEAST(2,0);\n        -> 0\nmysql> SELECT LEAST(34.0,3.0,5.0,767.0);\n        -> 3.0\nmysql> SELECT LEAST(\'B\',\'A\',\'C\');\n        -> \'A\'\n','http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (63,18,'=','=\n\nEqual:\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html\n\n','mysql> SELECT 1 = 0;\n        -> 0\nmysql> SELECT \'0\' = 0;\n        -> 1\nmysql> SELECT \'0.0\' = 0;\n        -> 1\nmysql> SELECT \'0.01\' = 0;\n        -> 0\nmysql> SELECT \'.01\' = 0.01;\n        -> 1\n','http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (64,34,'REVERSE','Syntax:\nREVERSE(str)\n\nReturns the string str with the order of the characters reversed.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT REVERSE(\'abc\');\n        -> \'cba\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (65,18,'ISNULL','Syntax:\nISNULL(expr)\n\nIf expr is NULL, ISNULL() returns 1, otherwise it returns 0.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html\n\n','mysql> SELECT ISNULL(1+1);\n        -> 0\nmysql> SELECT ISNULL(1/0);\n        -> 1\n','http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (66,21,'BINARY','BINARY(M)\n\nThe BINARY type is similar to the CHAR type, but stores binary byte\nstrings rather than non-binary character strings.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (67,21,'BLOB DATA TYPE','A BLOB is a binary large object that can hold a variable amount of\ndata. The four BLOB types are TINYBLOB, BLOB, MEDIUMBLOB, and LONGBLOB.\nThese differ only in the maximum length of the values they can hold.\nThe four TEXT types are TINYTEXT, TEXT, MEDIUMTEXT, and LONGTEXT. These\ncorrespond to the four BLOB types and have the same maximum lengths and\nstorage requirements. See\nhttp://dev.mysql.com/doc/refman/5.1/en/storage-requirements.html. No\nlettercase conversion for TEXT or BLOB columns takes place during\nstorage or retrieval.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/blob.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/blob.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (68,33,'BOUNDARY','Boundary(g)\n\nReturns a geometry that is the closure of the combinatorial boundary of\nthe geometry value g.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/general-geometry-property-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/general-geometry-property-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (69,9,'CREATE USER','Syntax:\nCREATE USER user [IDENTIFIED BY [PASSWORD] \'password\']\n    [, user [IDENTIFIED BY [PASSWORD] \'password\']] ...\n\nThe CREATE USER statement creates new MySQL accounts. To use it, you\nmust have the global CREATE USER privilege or the INSERT privilege for\nthe mysql database. For each account, CREATE USER creates a new row in\nthe mysql.user table that has no privileges. An error occurs if the\naccount already exists. Each account is named using the same format as\nfor the GRANT statement; for example, \'jeffrey\'@\'localhost\'. If you\nspecify only the username part of the account name, a hostname part of\n\'%\' is used. For additional information about specifying account names,\nsee [HELP GRANT].\n\nThe account can be given a password with the optional IDENTIFIED BY\nclause. The user value and the password are given the same way as for\nthe GRANT statement. In particular, to specify the password in plain\ntext, omit the PASSWORD keyword. To specify the password as the hashed\nvalue as returned by the PASSWORD() function, include the PASSWORD\nkeyword. See [HELP GRANT].\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/create-user.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/create-user.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (70,23,'POINT','Point(x,y)\n\nConstructs a WKB Point using its coordinates.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/gis-mysql-specific-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/gis-mysql-specific-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (71,16,'CURRENT_USER','Syntax:\nCURRENT_USER, CURRENT_USER()\n\nReturns the username and hostname combination for the MySQL account\nthat the server used to authenticate the current client. This account\ndetermines your access privileges. Within a stored routine that is\ndefined with the SQL SECURITY DEFINER characteristic, CURRENT_USER()\nreturns the creator of the routine. The return value is a string in the\nutf8 character set.\n\nThe value of CURRENT_USER() can differ from the value of USER().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/information-functions.html\n\n','mysql> SELECT USER();\n        -> \'davida@localhost\'\nmysql> SELECT * FROM mysql.user;\nERROR 1044: Access denied for user \'\'@\'localhost\' to\ndatabase \'mysql\'\nmysql> SELECT CURRENT_USER();\n        -> \'@localhost\'\n','http://dev.mysql.com/doc/refman/5.1/en/information-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (72,34,'LCASE','Syntax:\nLCASE(str)\n\nLCASE() is a synonym for LOWER().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (73,18,'<=','Syntax:\n<=\n\nLess than or equal:\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html\n\n','mysql> SELECT 0.1 <= 2;\n        -> 1\n','http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (74,26,'UPDATE','Syntax:\nSingle-table syntax:\n\nUPDATE [LOW_PRIORITY] [IGNORE] tbl_name\n    SET col_name1=expr1 [, col_name2=expr2 ...]\n    [WHERE where_condition]\n    [ORDER BY ...]\n    [LIMIT row_count]\n\nMultiple-table syntax:\n\nUPDATE [LOW_PRIORITY] [IGNORE] table_references\n    SET col_name1=expr1 [, col_name2=expr2 ...]\n    [WHERE where_condition]\n\nFor the single-table syntax, the UPDATE statement updates columns of\nexisting rows in tbl_name with new values. The SET clause indicates\nwhich columns to modify and the values they should be given. The WHERE\nclause, if given, specifies the conditions that identify which rows to\nupdate. With no WHERE clause, all rows are updated. If the ORDER BY\nclause is specified, the rows are updated in the order that is\nspecified. The LIMIT clause places a limit on the number of rows that\ncan be updated.\n\nFor the multiple-table syntax, UPDATE updates rows in each table named\nin table_references that satisfy the conditions. In this case, ORDER BY\nand LIMIT cannot be used.\n\nwhere_condition is an expression that evaluates to true for each row to\nbe updated. It is specified as described in [HELP SELECT].\n\nThe UPDATE statement supports the following modifiers:\n\no If you use the LOW_PRIORITY keyword, execution of the UPDATE is\n  delayed until no other clients are reading from the table. This\n  affects only storage engines that use only table-level locking\n  (MyISAM, MEMORY, MERGE).\n\no If you use the IGNORE keyword, the update statement does not abort\n  even if errors occur during the update. Rows for which duplicate-key\n  conflicts occur are not updated. Rows for which columns are updated\n  to values that would cause data conversion errors are updated to the\n  closest valid values instead.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/update.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/update.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (75,36,'CASE STATEMENT','Syntax:\nCASE case_value\n    WHEN when_value THEN statement_list\n    [WHEN when_value THEN statement_list] ...\n    [ELSE statement_list]\nEND CASE\n\nOr:\n\nCASE\n    WHEN search_condition THEN statement_list\n    [WHEN search_condition THEN statement_list] ...\n    [ELSE statement_list]\nEND CASE\n\nThe CASE statement for stored routines implements a complex conditional\nconstruct. If a search_condition evaluates to true, the corresponding\nSQL statement list is executed. If no search condition matches, the\nstatement list in the ELSE clause is executed. Each statement_list\nconsists of one or more statements.\n\nNote: The syntax of the CASE statement shown here for use inside stored\nroutines differs slightly from that of the SQL CASE expression\ndescribed in [HELP CASE function]. The CASE statement cannot have an\nELSE NULL clause, and it is terminated with END CASE instead of END.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/case-statement.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/case-statement.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (76,26,'EXECUTE STATEMENT','Syntax:\nEXECUTE stmt_name [USING @var_name [, @var_name] ...]\n\nAfter preparing a statement, you execute it with an EXECUTE statement\nthat refers to the prepared statement name. If the prepared statement\ncontains any parameter markers, you must supply a USING clause that\nlists user variables containing the values to be bound to the\nparameters. Parameter values can be supplied only by user variables,\nand the USING clause must name exactly as many variables as the number\nof parameter markers in the statement.\n\nYou can execute a given prepared statement multiple times, passing\ndifferent variables to it or setting the variables to different values\nbefore each execution.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/sqlps.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/sqlps.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (77,37,'DROP INDEX','Syntax:\nDROP INDEX index_name ON tbl_name\n\nDROP INDEX drops the index named index_name from the table tbl_name.\nThis statement is mapped to an ALTER TABLE statement to drop the index.\nSee [HELP ALTER TABLE].\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/drop-index.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/drop-index.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (78,34,'MATCH AGAINST','Syntax:\nMATCH (col1,col2,...) AGAINST (expr [search_modifier])\n\nsearch_modifier:\n  {\n       IN BOOLEAN MODE\n     | IN NATURAL LANGUAGE MODE\n     | IN NATURAL LANGUAGE MODE WITH QUERY EXPANSION\n     | WITH QUERY EXPANSION\n  }\n\nMySQL has support for full-text indexing and searching:\n\no A full-text index in MySQL is an index of type FULLTEXT.\n\no Full-text indexes can be used only with MyISAM tables, and can be\n  created only for CHAR, VARCHAR, or TEXT columns.\n\no A FULLTEXT index definition can be given in the CREATE TABLE\n  statement when a table is created, or added later using ALTER TABLE\n  or CREATE INDEX.\n\no For large datasets, it is much faster to load your data into a table\n  that has no FULLTEXT index and then create the index after that, than\n  to load data into a table that has an existing FULLTEXT index.\n\nFull-text searching is performed using MATCH() ... AGAINST syntax.\nMATCH() takes a comma-separated list that names the columns to be\nsearched. AGAINST takes a string to search for, and an optional\nmodifier that indicates what type of search to perform. The search\nstring must be a literal string, not a variable or a column name. There\nare three types of full-text searches:\n\no A boolean search interprets the search string using the rules of a\n  special query language. The string contains the words to search for.\n  It can also contain operators that specify requirements such that a\n  word must be present or absent in matching rows, or that it should be\n  weighted higher or lower than usual. Common words such as "some" or\n  "then" are stopwords and do not match if present in the search\n  string. The IN BOOLEAN MODE modifier specifies a boolean search. For\n  more information, see\n  http://dev.mysql.com/doc/refman/5.1/en/fulltext-boolean.html.\n\no A natural language search interprets the search string as a phrase in\n  natural human language (a phrase in free text). There are no special\n  operators. The stopword list applies. In addition, words that are\n  present in more than 50% of the rows are considered common and do not\n  match. Full-text searches are natural language searches if the IN\n  NATURAL LANGUAGE MODE modifier is given or if no modifier is given.\n\no A query expansion search is a modification of a natural language\n  search. The search string is used to perform a natural language\n  search. Then words from the most relevant rows returned by the search\n  are added to the search string and the search is done again. The\n  query returns the rows from the second search. The IN NATURAL\n  LANGUAGE MODE WITH QUERY EXPANSION or WITH QUERY EXPANSION modifier\n  specifies a query expansion search. For more information, see\n  http://dev.mysql.com/doc/refman/5.1/en/fulltext-query-expansion.html.\n\nThe IN NATURAL LANGUAGE MODE and IN NATURAL LANGUAGE MODE WITH QUERY\nEXPANSION modifiers were added in MySQL 5.1.7.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/fulltext-search.html\n\n','mysql> SELECT id, body, MATCH (title,body) AGAINST\n    -> (\'Security implications of running MySQL as root\'\n    -> IN NATURAL LANGUAGE MODE) AS score\n    -> FROM articles WHERE MATCH (title,body) AGAINST\n    -> (\'Security implications of running MySQL as root\'\n    -> IN NATURAL LANGUAGE MODE);\n+----+-------------------------------------+-----------------+\n| id | body                                | score           |\n+----+-------------------------------------+-----------------+\n|  4 | 1. Never run mysqld as root. 2. ... | 1.5219271183014 |\n|  6 | When configured properly, MySQL ... | 1.3114095926285 |\n+----+-------------------------------------+-----------------+\n2 rows in set (0.00 sec)\n','http://dev.mysql.com/doc/refman/5.1/en/fulltext-search.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (79,4,'ABS','Syntax:\nABS(X)\n\nReturns the absolute value of X.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT ABS(2);\n        -> 2\nmysql> SELECT ABS(-32);\n        -> 32\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (80,30,'POLYFROMWKB','PolyFromWKB(wkb[,srid]), PolygonFromWKB(wkb[,srid])\n\nConstructs a POLYGON value using its WKB representation and SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/gis-wkb-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/gis-wkb-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (81,34,'NOT LIKE','Syntax:\nexpr NOT LIKE pat [ESCAPE \'escape_char\']\n\nThis is the same as NOT (expr LIKE pat [ESCAPE \'escape_char\']).\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-comparison-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-comparison-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (82,34,'SPACE','Syntax:\nSPACE(N)\n\nReturns a string consisting of N space characters.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT SPACE(6);\n        -> \'      \'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (83,6,'MBR DEFINITION','Its MBR (Minimum Bounding Rectangle), or Envelope. This is the bounding\ngeometry, formed by the minimum and maximum (X,Y) coordinates:\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/gis-class-geometry.html\n\n','((MINX MINY, MAXX MINY, MAXX MAXY, MINX MAXY, MINX MINY))\n','http://dev.mysql.com/doc/refman/5.1/en/gis-class-geometry.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (84,23,'GEOMETRYCOLLECTION','GeometryCollection(g1,g2,...)\n\nConstructs a WKB GeometryCollection. If any argument is not a\nwell-formed WKB representation of a geometry, the return value is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/gis-mysql-specific-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/gis-mysql-specific-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (85,4,'*','Syntax:\n*\n\nMultiplication:\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/arithmetic-functions.html\n\n','mysql> SELECT 3*5;\n        -> 15\nmysql> SELECT 18014398509481984*18014398509481984.0;\n        -> 324518553658426726783156020576256.0\nmysql> SELECT 18014398509481984*18014398509481984;\n        -> 0\n','http://dev.mysql.com/doc/refman/5.1/en/arithmetic-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (86,21,'TIMESTAMP','TIMESTAMP\n\nA timestamp. The range is \'1970-01-01 00:00:01\' UTC to partway through\nthe year 2038. TIMESTAMP values are stored as the number of seconds\nsince the epoch (\'1970-01-01 00:00:00\' UTC). A TIMESTAMP cannot\nrepresent the value \'1970-01-01 00:00:00\' because that is equivalent to\n0 seconds from the epoch and the value 0 is reserved for representing\n\'0000-00-00 00:00:00\', the "zero" TIMESTAMP value.\n\nA TIMESTAMP column is useful for recording the date and time of an\nINSERT or UPDATE operation. By default, the first TIMESTAMP column in a\ntable is automatically set to the date and time of the most recent\noperation if you do not assign it a value yourself. You can also set\nany TIMESTAMP column to the current date and time by assigning it a\nNULL value. Variations on automatic initialization and update\nproperties are described in\nhttp://dev.mysql.com/doc/refman/5.1/en/timestamp-4-1.html.\n\nA TIMESTAMP value is returned as a string in the format \'YYYY-MM-DD\nHH:MM:SS\' with a display width fixed at 19 characters. To obtain the\nvalue as a number, you should add +0 to the timestamp column.\n\nNote: The TIMESTAMP format that was used prior to MySQL 4.1 is not\nsupported in MySQL 5.1; see MySQL 3.23, 4.0, 4.1 Reference Manual for\ninformation regarding the old format.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (87,11,'DES_DECRYPT','Syntax:\nDES_DECRYPT(crypt_str[,key_str])\n\nDecrypts a string encrypted with DES_ENCRYPT(). If an error occurs,\nthis function returns NULL.\n\nNote that this function works only if MySQL has been configured with\nSSL support. See\nhttp://dev.mysql.com/doc/refman/5.1/en/secure-connections.html.\n\nIf no key_str argument is given, DES_DECRYPT() examines the first byte\nof the encrypted string to determine the DES key number that was used\nto encrypt the original string, and then reads the key from the DES key\nfile to decrypt the message. For this to work, the user must have the\nSUPER privilege. The key file can be specified with the --des-key-file\nserver option.\n\nIf you pass this function a key_str argument, that string is used as\nthe key for decrypting the message.\n\nIf the crypt_str argument does not appear to be an encrypted string,\nMySQL returns the given crypt_str.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (88,12,'ENDPOINT','EndPoint(ls)\n\nReturns the Point that is the endpoint of the LineString value ls.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/linestring-property-functions.html\n\n','mysql> SET @ls = \'LineString(1 1,2 2,3 3)\';\nmysql> SELECT AsText(EndPoint(GeomFromText(@ls)));\n+-------------------------------------+\n| AsText(EndPoint(GeomFromText(@ls))) |\n+-------------------------------------+\n| POINT(3 3)                          |\n+-------------------------------------+\n','http://dev.mysql.com/doc/refman/5.1/en/linestring-property-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (89,26,'CACHE INDEX','Syntax:\nCACHE INDEX\n  tbl_index_list [, tbl_index_list] ...\n  IN key_cache_name\n\ntbl_index_list:\n  tbl_name [[INDEX|KEY] (index_name[, index_name] ...)]\n\nThe CACHE INDEX statement assigns table indexes to a specific key\ncache. It is used only for MyISAM tables.\n\nThe following statement assigns indexes from the tables t1, t2, and t3\nto the key cache named hot_cache:\n\nmysql> CACHE INDEX t1, t2, t3 IN hot_cache;\n+---------+--------------------+----------+----------+\n| Table   | Op                 | Msg_type | Msg_text |\n+---------+--------------------+----------+----------+\n| test.t1 | assign_to_keycache | status   | OK       |\n| test.t2 | assign_to_keycache | status   | OK       |\n| test.t3 | assign_to_keycache | status   | OK       |\n+---------+--------------------+----------+----------+\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/cache-index.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/cache-index.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (90,11,'COMPRESS','Syntax:\nCOMPRESS(string_to_compress)\n\nCompresses a string and returns the result as a binary string. This\nfunction requires MySQL to have been compiled with a compression\nlibrary such as zlib. Otherwise, the return value is always NULL. The\ncompressed string can be uncompressed with UNCOMPRESS().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html\n\n','mysql> SELECT LENGTH(COMPRESS(REPEAT(\'a\',1000)));\n        -> 21\nmysql> SELECT LENGTH(COMPRESS(\'\'));\n        -> 0\nmysql> SELECT LENGTH(COMPRESS(\'a\'));\n        -> 13\nmysql> SELECT LENGTH(COMPRESS(REPEAT(\'a\',16)));\n        -> 15\n','http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (91,26,'INSERT','Syntax:\nINSERT [LOW_PRIORITY | DELAYED | HIGH_PRIORITY] [IGNORE]\n    [INTO] tbl_name [(col_name,...)]\n    VALUES ({expr | DEFAULT},...),(...),...\n    [ ON DUPLICATE KEY UPDATE col_name=expr, ... ]\n\nOr:\n\nINSERT [LOW_PRIORITY | DELAYED | HIGH_PRIORITY] [IGNORE]\n    [INTO] tbl_name\n    SET col_name={expr | DEFAULT}, ...\n    [ ON DUPLICATE KEY UPDATE col_name=expr, ... ]\n\nOr:\n\nINSERT [LOW_PRIORITY | HIGH_PRIORITY] [IGNORE]\n    [INTO] tbl_name [(col_name,...)]\n    SELECT ...\n    [ ON DUPLICATE KEY UPDATE col_name=expr, ... ]\n\nINSERT inserts new rows into an existing table. The INSERT ... VALUES\nand INSERT ... SET forms of the statement insert rows based on\nexplicitly specified values. The INSERT ... SELECT form inserts rows\nselected from another table or tables. INSERT ... SELECT is discussed\nfurther in [HELP INSERT SELECT].\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/insert.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/insert.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (92,15,'COUNT','Syntax:\nCOUNT(expr)\n\nReturns a count of the number of non-NULL values in the rows retrieved\nby a SELECT statement. The result is a BIGINT value.\n\nCOUNT() returns 0 if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html\n\n','mysql> SELECT student.student_name,COUNT(*)\n    ->        FROM student,course\n    ->        WHERE student.student_id=course.student_id\n    ->        GROUP BY student_name;\n','http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (93,26,'HANDLER','Syntax:\nHANDLER tbl_name OPEN [ AS alias ]\nHANDLER tbl_name READ index_name { = | >= | <= | < } (value1,value2,...)\n    [ WHERE where_condition ] [LIMIT ... ]\nHANDLER tbl_name READ index_name { FIRST | NEXT | PREV | LAST }\n    [ WHERE where_condition ] [LIMIT ... ]\nHANDLER tbl_name READ { FIRST | NEXT }\n    [ WHERE where_condition ] [LIMIT ... ]\nHANDLER tbl_name CLOSE\n\nThe HANDLER statement provides direct access to table storage engine\ninterfaces. It is available for MyISAM and InnoDB tables.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/handler.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/handler.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (94,3,'MLINEFROMTEXT','MLineFromText(wkt[,srid]), MultiLineStringFromText(wkt[,srid])\n\nConstructs a MULTILINESTRING value using its WKT representation and\nSRID.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/gis-wkt-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/gis-wkt-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (95,30,'GEOMCOLLFROMWKB','GeomCollFromWKB(wkb[,srid]), GeometryCollectionFromWKB(wkb[,srid])\n\nConstructs a GEOMETRYCOLLECTION value using its WKB representation and\nSRID.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/gis-wkb-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/gis-wkb-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (96,37,'RENAME TABLE','Syntax:\nRENAME TABLE tbl_name TO new_tbl_name\n    [, tbl_name2 TO new_tbl_name2] ...\n\nThis statement renames one or more tables.\n\nThe rename operation is done atomically, which means that no other\nthread can access any of the tables while the rename is running. For\nexample, if you have an existing table old_table, you can create\nanother table new_table that has the same structure but is empty, and\nthen replace the existing table with the empty one as follows (assuming\nthat backup_table does not already exist):\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/rename-table.html\n\n','CREATE TABLE new_table (...);\nRENAME TABLE old_table TO backup_table, new_table TO old_table;\n','http://dev.mysql.com/doc/refman/5.1/en/rename-table.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (97,21,'BOOLEAN','BOOL, BOOLEAN\n\nThese types are synonyms for TINYINT(1). A value of zero is considered\nfalse. Non-zero values are considered true:\n\nmysql> SELECT IF(0, \'true\', \'false\');\n+------------------------+\n| IF(0, \'true\', \'false\') |\n+------------------------+\n| false                  |\n+------------------------+\n\nmysql> SELECT IF(1, \'true\', \'false\');\n+------------------------+\n| IF(1, \'true\', \'false\') |\n+------------------------+\n| true                   |\n+------------------------+\n\nmysql> SELECT IF(2, \'true\', \'false\');\n+------------------------+\n| IF(2, \'true\', \'false\') |\n+------------------------+\n| true                   |\n+------------------------+\n\nHowever, the values TRUE and FALSE are merely aliases for 1 and 0,\nrespectively, as shown here:\n\nmysql> SELECT IF(0 = FALSE, \'true\', \'false\');\n+--------------------------------+\n| IF(0 = FALSE, \'true\', \'false\') |\n+--------------------------------+\n| true                           |\n+--------------------------------+\n\nmysql> SELECT IF(1 = TRUE, \'true\', \'false\');\n+-------------------------------+\n| IF(1 = TRUE, \'true\', \'false\') |\n+-------------------------------+\n| true                          |\n+-------------------------------+\n\nmysql> SELECT IF(2 = TRUE, \'true\', \'false\');\n+-------------------------------+\n| IF(2 = TRUE, \'true\', \'false\') |\n+-------------------------------+\n| false                         |\n+-------------------------------+\n\nmysql> SELECT IF(2 = FALSE, \'true\', \'false\');\n+--------------------------------+\n| IF(2 = FALSE, \'true\', \'false\') |\n+--------------------------------+\n| false                          |\n+--------------------------------+\n\nThe last two statements display the results shown because 2 is equal to\nneither 1 nor 0.\n\nWe intend to implement full boolean type handling, in accordance with\nstandard SQL, in a future MySQL release.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (98,14,'DEFAULT','Syntax:\nDEFAULT(col_name)\n\nReturns the default value for a table column. An error results if the\ncolumn has no default value.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html\n\n','mysql> UPDATE t SET i = DEFAULT(i)+1 WHERE id < 100;\n','http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (99,4,'MOD','Syntax:\nMOD(N,M), N % M, N MOD M\n\nModulo operation. Returns the remainder of N divided by M.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT MOD(234, 10);\n        -> 4\nmysql> SELECT 253 % 7;\n        -> 1\nmysql> SELECT MOD(29,9);\n        -> 2\nmysql> SELECT 29 MOD 9;\n        -> 2\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (100,21,'TINYTEXT','TINYTEXT [CHARACTER SET charset_name] [COLLATE collation_name]\n\nA TEXT column with a maximum length of 255 (28 - 1) characters.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (101,20,'OPTIMIZE TABLE','Syntax:\nOPTIMIZE [LOCAL | NO_WRITE_TO_BINLOG] TABLE tbl_name [, tbl_name] ...\n\nOPTIMIZE TABLE should be used if you have deleted a large part of a\ntable or if you have made many changes to a table with variable-length\nrows (tables that have VARCHAR, VARBINARY, BLOB, or TEXT columns).\nDeleted rows are maintained in a linked list and subsequent INSERT\noperations reuse old row positions. You can use OPTIMIZE TABLE to\nreclaim the unused space and to defragment the data file.\n\nThis statement requires SELECT and INSERT privileges for the table.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/optimize-table.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/optimize-table.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (102,11,'DECODE','Syntax:\nDECODE(crypt_str,pass_str)\n\nDecrypts the encrypted string crypt_str using pass_str as the password.\ncrypt_str should be a string returned from ENCODE().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (103,18,'<=>','Syntax:\n<=>\n\nNULL-safe equal. This operator performs an equality comparison like the\n= operator, but returns 1 rather than NULL if both operands are NULL,\nand 0 rather than NULL if one operand is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html\n\n','mysql> SELECT 1 <=> 1, NULL <=> NULL, 1 <=> NULL;\n        -> 1, 1, 0\nmysql> SELECT 1 = 1, NULL = NULL, 1 = NULL;\n        -> 1, NULL, NULL\n','http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (104,26,'LOAD DATA FROM MASTER','Syntax:\nLOAD DATA FROM MASTER\n\nThis feature is deprecated. We recommend not using it anymore. It is\nsubject to removal in a future version of MySQL.\n\nSince the current implementation of LOAD DATA FROM MASTER and LOAD\nTABLE FROM MASTER is very limited, these statements are deprecated in\nversions 4.1 of MySQL and above. We will introduce a more advanced\ntechnique (called "online backup") in a future version. That technique\nwill have the additional advantage of working with more storage\nengines.\n\nFor MySQL 5.1 and earlier, the recommended alternative solution to\nusing LOAD DATA FROM MASTER or LOAD TABLE FROM MASTER is using\nmysqldump or mysqlhotcopy. The latter requires Perl and two Perl\nmodules (DBI and DBD:mysql) and works for MyISAM and ARCHIVE tables\nonly. With mysqldump, you can create SQL dumps on the master and pipe\n(or copy) these to a mysql client on the slave. This has the advantage\nof working for all storage engines, but can be quite slow, since it\nworks using SELECT.\n\nThis statement takes a snapshot of the master and copies it to the\nslave. It updates the values of MASTER_LOG_FILE and MASTER_LOG_POS so\nthat the slave starts replicating from the correct position. Any table\nand database exclusion rules specified with the --replicate-*-do-* and\n--replicate-*-ignore-* options are honored. --replicate-rewrite-db is\nnot taken into account because a user could use this option to set up a\nnon-unique mapping such as --replicate-rewrite-db="db1->db3" and\n--replicate-rewrite-db="db2->db3", which would confuse the slave when\nloading tables from the master.\n\nUse of this statement is subject to the following conditions:\n\no It works only for MyISAM tables. Attempting to load a non-MyISAM\n  table results in the following error:\n\nERROR 1189 (08S01): Net error reading from master\n\no It acquires a global read lock on the master while taking the\n  snapshot, which prevents updates on the master during the load\n  operation.\n\nIf you are loading large tables, you might have to increase the values\nof net_read_timeout and net_write_timeout on both the master and slave\nservers. See\nhttp://dev.mysql.com/doc/refman/5.1/en/server-system-variables.html.\n\nNote that LOAD DATA FROM MASTER does not copy any tables from the mysql\ndatabase. This makes it easy to have different users and privileges on\nthe master and the slave.\n\nTo use LOAD DATA FROM MASTER, the replication account that is used to\nconnect to the master must have the RELOAD and SUPER privileges on the\nmaster and the SELECT privilege for all master tables you want to load.\nAll master tables for which the user does not have the SELECT privilege\nare ignored by LOAD DATA FROM MASTER. This is because the master hides\nthem from the user: LOAD DATA FROM MASTER calls SHOW DATABASES to know\nthe master databases to load, but SHOW DATABASES returns only databases\nfor which the user has some privilege. See [HELP SHOW DATABASES]. On\nthe slave side, the user that issues LOAD DATA FROM MASTER must have\nprivileges for dropping and creating the databases and tables that are\ncopied.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/load-data-from-master.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/load-data-from-master.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (105,26,'RESET','Syntax:\nRESET reset_option [, reset_option] ...\n\nThe RESET statement is used to clear the state of various server\noperations. You must have the RELOAD privilege to execute RESET.\n\nRESET acts as a stronger version of the FLUSH statement. See [HELP\nFLUSH].\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/reset.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/reset.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (106,25,'HELP STATEMENT','Syntax:\nHELP \'search_string\'\n\nThe HELP statement returns online information from the MySQL Reference\nmanual. Its proper operation requires that the help tables in the mysql\ndatabase be initialized with help topic information (see\nhttp://dev.mysql.com/doc/refman/5.1/en/server-side-help-support.html).\n\nThe HELP statement searches the help tables for the given search string\nand displays the result of the search. The search string is not case\nsensitive.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/help.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/help.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (107,14,'GET_LOCK','Syntax:\nGET_LOCK(str,timeout)\n\nTries to obtain a lock with a name given by the string str, using a\ntimeout of timeout seconds. Returns 1 if the lock was obtained\nsuccessfully, 0 if the attempt timed out (for example, because another\nclient has previously locked the name), or NULL if an error occurred\n(such as running out of memory or the thread was killed with mysqladmin\nkill). If you have a lock obtained with GET_LOCK(), it is released when\nyou execute RELEASE_LOCK(), execute a new GET_LOCK(), or your\nconnection terminates (either normally or abnormally). Locks obtained\nwith GET_LOCK() do not interact with transactions. That is, committing\na transaction does not release any such locks obtained during the\ntransaction.\n\nThis function can be used to implement application locks or to simulate\nrecord locks. Names are locked on a server-wide basis. If a name has\nbeen locked by one client, GET_LOCK() blocks any request by another\nclient for a lock with the same name. This allows clients that agree on\na given lock name to use the name to perform cooperative advisory\nlocking. But be aware that it also allows a client that is not among\nthe set of cooperating clients to lock a name, either inadvertently or\ndeliberately, and thus prevent any of the cooperating clients from\nlocking that name. One way to reduce the likelihood of this is to use\nlock names that are database-specific or application-specific. For\nexample, use lock names of the form db_name.str or app_name.str.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html\n\n','mysql> SELECT GET_LOCK(\'lock1\',10);\n        -> 1\nmysql> SELECT IS_FREE_LOCK(\'lock2\');\n        -> 1\nmysql> SELECT GET_LOCK(\'lock2\',10);\n        -> 1\nmysql> SELECT RELEASE_LOCK(\'lock2\');\n        -> 1\nmysql> SELECT RELEASE_LOCK(\'lock1\');\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (108,34,'UCASE','Syntax:\nUCASE(str)\n\nUCASE() is a synonym for UPPER().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (109,26,'SHOW BINLOG EVENTS','Syntax:\nSHOW BINLOG EVENTS\n   [IN \'log_name\'] [FROM pos] [LIMIT [offset,] row_count]\n\nShows the events in the binary log. If you do not specify \'log_name\',\nthe first binary log is displayed.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-binlog-events.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-binlog-events.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (110,30,'MPOLYFROMWKB','MPolyFromWKB(wkb[,srid]), MultiPolygonFromWKB(wkb[,srid])\n\nConstructs a MULTIPOLYGON value using its WKB representation and SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/gis-wkb-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/gis-wkb-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (111,36,'ITERATE','Syntax:\nITERATE label\n\nITERATE can appear only within LOOP, REPEAT, and WHILE statements.\nITERATE means "do the loop again."\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/iterate-statement.html\n\n','CREATE PROCEDURE doiterate(p1 INT)\nBEGIN\n  label1: LOOP\n    SET p1 = p1 + 1;\n    IF p1 < 10 THEN ITERATE label1; END IF;\n    LEAVE label1;\n  END LOOP label1;\n  SET @x = p1;\nEND\n','http://dev.mysql.com/doc/refman/5.1/en/iterate-statement.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (112,26,'DO','Syntax:\nDO expr [, expr] ...\n\nDO executes the expressions but does not return any results. In most\nrespects, DO is shorthand for SELECT expr, ..., but has the advantage\nthat it is slightly faster when you do not care about the result.\n\nDO is useful primarily with functions that have side effects, such as\nRELEASE_LOCK().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/do.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/do.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (113,29,'CURTIME','Syntax:\nCURTIME()\n\nReturns the current time as a value in \'HH:MM:SS\' or HHMMSS format,\ndepending on whether the function is used in a string or numeric\ncontext. The value is expressed in the current time zone.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT CURTIME();\n        -> \'23:50:26\'\nmysql> SELECT CURTIME() + 0;\n        -> 235026\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (114,34,'CHAR_LENGTH','Syntax:\nCHAR_LENGTH(str)\n\nReturns the length of the string str, measured in characters. A\nmulti-byte character counts as a single character. This means that for\na string containing five two-byte characters, LENGTH() returns 10,\nwhereas CHAR_LENGTH() returns 5.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (115,21,'BIGINT','BIGINT[(M)] [UNSIGNED] [ZEROFILL]\n\nA large integer. The signed range is -9223372036854775808 to\n9223372036854775807. The unsigned range is 0 to 18446744073709551615.\n\nSERIAL is an alias for BIGINT UNSIGNED NOT NULL AUTO_INCREMENT UNIQUE.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (116,26,'SET','Syntax:\nSET variable_assignment [, variable_assignment] ...\n\nvariable_assignment:\n      user_var_name = expr\n    | [GLOBAL | SESSION] system_var_name = expr\n    | [@@global. | @@session. | @@]system_var_name = expr\n\nThe SET statement assigns values to different types of variables that\naffect the operation of the server or your client. Older versions of\nMySQL employed SET OPTION, but this syntax is deprecated in favor of\nSET without OPTION.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/set-option.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/set-option.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (117,21,'DATE','DATE\n\nA date. The supported range is \'1000-01-01\' to \'9999-12-31\'. MySQL\ndisplays DATE values in \'YYYY-MM-DD\' format, but allows assignment of\nvalues to DATE columns using either strings or numbers.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (118,34,'CONV','Syntax:\nCONV(N,from_base,to_base)\n\nConverts numbers between different number bases. Returns a string\nrepresentation of the number N, converted from base from_base to base\nto_base. Returns NULL if any argument is NULL. The argument N is\ninterpreted as an integer, but may be specified as an integer or a\nstring. The minimum base is 2 and the maximum base is 36. If to_base is\na negative number, N is regarded as a signed number. Otherwise, N is\ntreated as unsigned. CONV() works with 64-bit precision.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT CONV(\'a\',16,2);\n        -> \'1010\'\nmysql> SELECT CONV(\'6E\',18,8);\n        -> \'172\'\nmysql> SELECT CONV(-17,10,-18);\n        -> \'-H\'\nmysql> SELECT CONV(10+\'10\'+\'10\'+0xa,10,10);\n        -> \'40\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (119,26,'SHOW OPEN TABLES','Syntax:\nSHOW OPEN TABLES [FROM db_name] [LIKE \'pattern\']\n\nSHOW OPEN TABLES lists the non-TEMPORARY tables that are currently open\nin the table cache. See\nhttp://dev.mysql.com/doc/refman/5.1/en/table-cache.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-open-tables.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-open-tables.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (120,29,'EXTRACT','Syntax:\nEXTRACT(unit FROM date)\n\nThe EXTRACT() function uses the same kinds of unit specifiers as\nDATE_ADD() or DATE_SUB(), but extracts parts from the date rather than\nperforming date arithmetic.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT EXTRACT(YEAR FROM \'1999-07-02\');\n       -> 1999\nmysql> SELECT EXTRACT(YEAR_MONTH FROM \'1999-07-02 01:02:03\');\n       -> 199907\nmysql> SELECT EXTRACT(DAY_MINUTE FROM \'1999-07-02 01:02:03\');\n       -> 20102\nmysql> SELECT EXTRACT(MICROSECOND\n    ->                FROM \'2003-01-02 10:30:00.000123\');\n        -> 123\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (121,11,'ENCRYPT','Syntax:\nENCRYPT(str[,salt])\n\nEncrypts str using the Unix crypt() system call and returns a binary\nstring. The salt argument should be a string with at least two\ncharacters. If no salt argument is given, a random value is used.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html\n\n','mysql> SELECT ENCRYPT(\'hello\');\n        -> \'VxuFAJXVARROc\'\n','http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (122,26,'SHOW STATUS','Syntax:\nSHOW [GLOBAL | SESSION] STATUS [LIKE \'pattern\']\n\nSHOW STATUS provides server status information. This information also\ncan be obtained using the mysqladmin extended-status command.\nWith a LIKE clause, the statement displays only rows for those\nvariables with names that match the pattern:\n\nmysql> SHOW STATUS LIKE \'Key%\';\n+--------------------+----------+\n| Variable_name      | Value    |\n+--------------------+----------+\n| Key_blocks_used    | 14955    |\n| Key_read_requests  | 96854827 |\n| Key_reads          | 162040   |\n| Key_write_requests | 7589728  |\n| Key_writes         | 3813196  |\n+--------------------+----------+\n\nWith the GLOBAL modifier, SHOW STATUS displays the status values for\nall connections to MySQL. With SESSION, it displays the status values\nfor the current connection. If no modifier is present, the default is\nSESSION. LOCAL is a synonym for SESSION.\n\nSome status variables have only a global value. For these, you get the\nsame value for both GLOBAL and SESSION.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-status.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-status.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (123,34,'EXTRACTVALUE','Syntax:\nExtractValue(xml_frag, xpath_expr)\n\nExtractValue() takes two string arguments, a fragment of XML markup\nxml_frag and an XPath expression xpath_expr (also known as a locator);\nit returns the text (CDATA) of the first text node which is a child of\nthe element(s) matched by the XPath expression. It is the equivalent of\nperforming a match using the xpath_expr after appending /text(). In\nother words, ExtractValue(\'<a><b>Sakila</b></a>\', \'/a/b\') and\nExtractValue(\'<a><b>Sakila</b></a>\', \'/a/b/text()\') produce the same\nresult.\n\nIf multiple matches are found, then the content of the first child text\nnode of each matching element is returned (in the order matched) as a\nsingle, space-delimited string.\n\nIf no matching text node is found for the (augmented) expression ---\nfor whatever reason, as long as xpth_expr is valid, and xml_frag is\nwell-formed --- an empty string is returned. No distinction is made\nbetween a match on an empty element and no match at all. This is by\ndesign.\n\nIf you need to determine whether no matching element was found in\nxml_frag or such an element was found but contained no child text\nnodes, you should test the result of an expression that uses the XPath\ncount() function. For example, both of these statements return an empty\nstring, as shown here:\n\nmysql> SELECT ExtractValue(\'<a><b/></a>\', \'/a/b\');\n+-------------------------------------+\n| ExtractValue(\'<a><b/></a>\', \'/a/b\') |\n+-------------------------------------+\n|                                     |\n+-------------------------------------+\n1 row in set (0.00 sec)\n\nmysql> SELECT ExtractValue(\'<a><c/></a>\', \'/a/b\');\n+-------------------------------------+\n| ExtractValue(\'<a><c/></a>\', \'/a/b\') |\n+-------------------------------------+\n|                                     |\n+-------------------------------------+\n1 row in set (0.00 sec)\n\nHowever, you can determine whether there was actually a matching\nelement using the following:\n\nmysql> SELECT ExtractValue(\'<a><b/></a>\', \'count(/a/b)\');\n+-------------------------------------+\n| ExtractValue(\'<a><b/></a>\', \'count(/a/b)\') |\n+-------------------------------------+\n| 1                                   |\n+-------------------------------------+\n1 row in set (0.00 sec)\n\nmysql> SELECT ExtractValue(\'<a><c/></a>\', \'count(/a/b)\');\n+-------------------------------------+\n| ExtractValue(\'<a><c/></a>\', \'count(/a/b)\') |\n+-------------------------------------+\n| 0                                   |\n+-------------------------------------+\n1 row in set (0.01 sec)\n\nNote that ExtractValue() returns only CDATA, and does not return any\ntags that might be contained within a matching tag, nor any of their\ncontent (see the result returned as val1 in the following example).\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/xml-functions.html\n\n','mysql> SELECT\n    ->   ExtractValue(\'<a>ccc<b>ddd</b></a>\', \'/a\') AS val1,\n    ->   ExtractValue(\'<a>ccc<b>ddd</b></a>\', \'/a/b\') AS val2,\n    ->   ExtractValue(\'<a>ccc<b>ddd</b></a>\', \'//b\') AS val3,\n    ->   ExtractValue(\'<a>ccc<b>ddd</b></a>\', \'/b\') AS val4,\n    ->   ExtractValue(\'<a>ccc<b>ddd</b><b>eee</b></a>\', \'//b\') AS val5;\n\n+------+------+------+------+---------+\n| val1 | val2 | val3 | val4 | val5    |\n+------+------+------+------+---------+\n| ccc  | ddd  | ddd  |      | ddd eee |\n+------+------+------+------+---------+\n','http://dev.mysql.com/doc/refman/5.1/en/xml-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (124,11,'OLD_PASSWORD','Syntax:\nOLD_PASSWORD(str)\n\nOLD_PASSWORD() was added to MySQL when the implementation of PASSWORD()\nwas changed to improve security. OLD_PASSWORD() returns the value of\nthe old (pre-4.1) implementation of PASSWORD() as a binary string, and\nis intended to permit you to reset passwords for any pre-4.1 clients\nthat need to connect to your version 5.1 MySQL server without locking\nthem out. See\nhttp://dev.mysql.com/doc/refman/5.1/en/password-hashing.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (125,36,'SET VARIABLE','Syntax:\nSET var_name = expr [, var_name = expr] ...\n\nThe SET statement in stored routines is an extended version of the\ngeneral SET statement. Referenced variables may be ones declared inside\na routine, or global system variables.\n\nThe SET statement in stored routines is implemented as part of the\npre-existing SET syntax. This allows an extended syntax of SET a=x,\nb=y, ... where different variable types (locally declared variables and\nglobal and session server variables) can be mixed. This also allows\ncombinations of local variables and some options that make sense only\nfor system variables; in that case, the options are recognized but\nignored.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/set-statement.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/set-statement.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (126,34,'FORMAT','Syntax:\nFORMAT(X,D)\n\nFormats the number X to a format like \'#,###,###.##\', rounded to D\ndecimal places, and returns the result as a string. If D is 0, the\nresult has no decimal point or fractional part.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT FORMAT(12332.123456, 4);\n        -> \'12,332.1235\'\nmysql> SELECT FORMAT(12332.1,4);\n        -> \'12,332.1000\'\nmysql> SELECT FORMAT(12332.2,0);\n        -> \'12,332\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (127,13,'||','Syntax:\nOR, ||\n\nLogical OR. When both operands are non-NULL, the result is 1 if any\noperand is non-zero, and 0 otherwise. With a NULL operand, the result\nis 1 if the other operand is non-zero, and NULL otherwise. If both\noperands are NULL, the result is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/logical-operators.html\n\n','mysql> SELECT 1 || 1;\n        -> 1\nmysql> SELECT 1 || 0;\n        -> 1\nmysql> SELECT 0 || 0;\n        -> 0\nmysql> SELECT 0 || NULL;\n        -> NULL\nmysql> SELECT 1 || NULL;\n        -> 1\n','http://dev.mysql.com/doc/refman/5.1/en/logical-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (128,34,'BIT_LENGTH','Syntax:\nBIT_LENGTH(str)\n\nReturns the length of the string str in bits.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT BIT_LENGTH(\'text\');\n        -> 32\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (129,2,'EXTERIORRING','ExteriorRing(poly)\n\nReturns the exterior ring of the Polygon value poly as a LineString.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/polygon-property-functions.html\n\n','mysql> SET @poly =\n    -> \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\nmysql> SELECT AsText(ExteriorRing(GeomFromText(@poly)));\n+-------------------------------------------+\n| AsText(ExteriorRing(GeomFromText(@poly))) |\n+-------------------------------------------+\n| LINESTRING(0 0,0 3,3 3,3 0,0 0)           |\n+-------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.1/en/polygon-property-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (130,30,'GEOMFROMWKB','GeomFromWKB(wkb[,srid]), GeometryFromWKB(wkb[,srid])\n\nConstructs a geometry value of any type using its WKB representation\nand SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/gis-wkb-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/gis-wkb-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (131,26,'SHOW SLAVE HOSTS','Syntax:\nSHOW SLAVE HOSTS\n\nDisplays a list of replication slaves currently registered with the\nmaster. Only slaves started with the --report-host=slave_name option\nare visible in this list.\n\nThe list is displayed on any server (not just the master server). The\noutput looks like this: mysql> SHOW SLAVE HOSTS;\n+------------+-----------+------+-----------+ | Server_id | Host | Port\n| Master_id | +------------+-----------+------+-----------+ | 192168010\n| iconnect2 | 3306 | 192168011 | | 1921680101 | athena | 3306 |\n192168011 | +------------+-----------+------+-----------+ Server_id:\nThe unique server ID of the slave server, as configured in the server\'s\noption file, or on the command line with --server-id=value . Host: The\nhost name of the slave server, as configured in the server\'s option\nfile, or on the command line with --report-host=value. Note that this\ncan differ from the machine name as configured in the operating system.\nPort: The port the slave server is listening on. Master_id: The unique\nserver ID of the master server that the slave server is replicating\nfrom. Some MySQL versions report another variable, Rpl_recovery_rank.\nThis variable was never used, and was eventually removed.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-slave-hosts.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-slave-hosts.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (132,8,'START TRANSACTION','Syntax:\nSTART TRANSACTION | BEGIN [WORK]\nCOMMIT [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\nROLLBACK [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\nSET AUTOCOMMIT = {0 | 1}\n\nThe START TRANSACTION and BEGIN statement begin a new transaction.\nCOMMIT commits the current transaction, making its changes permanent.\nROLLBACK rolls back the current transaction, canceling its changes. The\nSET AUTOCOMMIT statement disables or enables the default autocommit\nmode for the current connection.\n\nThe optional WORK keyword is supported for COMMIT and ROLLBACK, as are\nthe CHAIN and RELEASE clauses. CHAIN and RELEASE can be used for\nadditional control over transaction completion. The value of the\ncompletion_type system variable determines the default completion\nbehavior. See\nhttp://dev.mysql.com/doc/refman/5.1/en/server-system-variables.html.\n\nThe AND CHAIN clause causes a new transaction to begin as soon as the\ncurrent one ends, and the new transaction has the same isolation level\nas the just-terminated transaction. The RELEASE clause causes the\nserver to disconnect the current client connection after terminating\nthe current transaction. Including the NO keyword suppresses CHAIN or\nRELEASE completion, which can be useful if the completion_type system\nvariable is set to cause chaining or release completion by default.\n\nBy default, MySQL runs with autocommit mode enabled. This means that as\nsoon as you execute a statement that updates (modifies) a table, MySQL\nstores the update on disk.\n\nIf you are using a transaction-safe storage engine (such as InnoDB, or\nNDB Cluster), you can disable autocommit mode with the following\nstatement:\n\nSET AUTOCOMMIT=0;\n\nAfter disabling autocommit mode by setting the AUTOCOMMIT variable to\nzero, you must use COMMIT to store your changes to disk or ROLLBACK if\nyou want to ignore the changes you have made since the beginning of\nyour transaction.\n\nTo disable autocommit mode for a single series of statements, use the\nSTART TRANSACTION statement:\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/commit.html\n\n','START TRANSACTION;\nSELECT @A:=SUM(salary) FROM table1 WHERE type=1;\nUPDATE table2 SET summary=@A WHERE type=1;\nCOMMIT;\n','http://dev.mysql.com/doc/refman/5.1/en/commit.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (133,18,'BETWEEN AND','Syntax:\nexpr BETWEEN min AND max\n\nIf expr is greater than or equal to min and expr is less than or equal\nto max, BETWEEN returns 1, otherwise it returns 0. This is equivalent\nto the expression (min <= expr AND expr <= max) if all the arguments\nare of the same type. Otherwise type conversion takes place according\nto the rules described in\nhttp://dev.mysql.com/doc/refman/5.1/en/type-conversion.html, but\napplied to all the three arguments.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html\n\n','mysql> SELECT 1 BETWEEN 2 AND 3;\n        -> 0\nmysql> SELECT \'b\' BETWEEN \'a\' AND \'c\';\n        -> 1\nmysql> SELECT 2 BETWEEN 2 AND \'3\';\n        -> 1\nmysql> SELECT 2 BETWEEN 2 AND \'x-3\';\n        -> 0\n','http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (134,23,'MULTIPOLYGON','MultiPolygon(poly1,poly2,...)\n\nConstructs a WKB MultiPolygon value from a set of WKB Polygon\narguments. If any argument is not a WKB Polygon, the return value is\nNULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/gis-mysql-specific-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/gis-mysql-specific-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (135,29,'TIME_FORMAT','Syntax:\nTIME_FORMAT(time,format)\n\nThis is used like the DATE_FORMAT() function, but the format string may\ncontain format specifiers only for hours, minutes, and seconds. Other\nspecifiers produce a NULL value or 0.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT TIME_FORMAT(\'100:00:00\', \'%H %k %h %I %l\');\n        -> \'100 100 04 04 4\'\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (136,34,'LEFT','Syntax:\nLEFT(str,len)\n\nReturns the leftmost len characters from the string str, or NULL if any\nargument is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT LEFT(\'foobarbar\', 5);\n        -> \'fooba\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (137,25,'FLUSH QUERY CACHE','You can defragment the query cache to better utilize its memory with\nthe FLUSH QUERY CACHE statement. The statement does not remove any\nqueries from the cache.\n\nThe RESET QUERY CACHE statement removes all query results from the\nquery cache. The FLUSH TABLES statement also does this.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/query-cache-status-and-maintenance.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/query-cache-status-and-maintenance.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (138,21,'SET DATA TYPE','SET(\'value1\',\'value2\',...) [CHARACTER SET charset_name] [COLLATE\ncollation_name]\n\nA set. A string object that can have zero or more values, each of which\nmust be chosen from the list of values \'value1\', \'value2\', ... A SET\ncolumn can have a maximum of 64 members. SET values are represented\ninternally as integers.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (139,4,'RAND','Syntax:\nRAND(), RAND(N)\n\nReturns a random floating-point value v in the range 0 <= v < 1.0. If a\nconstant integer argument N is specified, it is used as the seed value,\nwhich produces a repeatable sequence of column values.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT RAND();\n        -> 0.9233482386203\nmysql> SELECT RAND(20);\n        -> 0.15888261251047\nmysql> SELECT RAND(20);\n        -> 0.15888261251047\nmysql> SELECT RAND();\n        -> 0.63553050033332\nmysql> SELECT RAND();\n        -> 0.70100469486881\nmysql> SELECT RAND(20);\n        -> 0.15888261251047\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (140,34,'RPAD','Syntax:\nRPAD(str,len,padstr)\n\nReturns the string str, right-padded with the string padstr to a length\nof len characters. If str is longer than len, the return value is\nshortened to len characters.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT RPAD(\'hi\',5,\'?\');\n        -> \'hi???\'\nmysql> SELECT RPAD(\'hi\',1,\'?\');\n        -> \'h\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (141,37,'CREATE DATABASE','Syntax:\nCREATE {DATABASE | SCHEMA} [IF NOT EXISTS] db_name\n    [create_specification [create_specification] ...]\n\ncreate_specification:\n    [DEFAULT] CHARACTER SET charset_name\n  | [DEFAULT] COLLATE collation_name\n\nCREATE DATABASE creates a database with the given name. To use this\nstatement, you need the CREATE privilege for the database. CREATE\nSCHEMA is a synonym for CREATE DATABASE.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/create-database.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/create-database.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (142,21,'DEC','DEC[(M[,D])] [UNSIGNED] [ZEROFILL], NUMERIC[(M[,D])] [UNSIGNED]\n[ZEROFILL], FIXED[(M[,D])] [UNSIGNED] [ZEROFILL]\n\nThese types are synonyms for DECIMAL. The FIXED synonym is available\nfor compatibility with other database systems.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (143,15,'VAR_POP','Syntax:\nVAR_POP(expr)\n\nReturns the population standard variance of expr. It considers rows as\nthe whole population, not as a sample, so it has the number of rows as\nthe denominator. You can also use VARIANCE(), which is equivalent but\nis not standard SQL.\n\nVAR_POP() returns NULL if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (144,34,'ELT','Syntax:\nELT(N,str1,str2,str3,...)\n\nReturns str1 if N = 1, str2 if N = 2, and so on. Returns NULL if N is\nless than 1 or greater than the number of arguments. ELT() is the\ncomplement of FIELD().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT ELT(1, \'ej\', \'Heja\', \'hej\', \'foo\');\n        -> \'ej\'\nmysql> SELECT ELT(4, \'ej\', \'Heja\', \'hej\', \'foo\');\n        -> \'foo\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (145,37,'ALTER VIEW','Syntax:\nALTER\n    [ALGORITHM = {UNDEFINED | MERGE | TEMPTABLE}]\n    [DEFINER = { user | CURRENT_USER }]\n    [SQL SECURITY { DEFINER | INVOKER }]\n    VIEW view_name [(column_list)]\n    AS select_statement\n    [WITH [CASCADED | LOCAL] CHECK OPTION]\n\nThis statement changes the definition of a view, which must exist. The\nsyntax is similar to that for CREATE VIEW and the effect is the same as\nfor CREATE OR REPLACE VIEW. See [HELP CREATE VIEW]. This statement\nrequires the CREATE VIEW and DROP privileges for the view, and some\nprivilege for each column referred to in the SELECT statement.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/alter-view.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/alter-view.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (146,26,'SHOW DATABASES','Syntax:\nSHOW {DATABASES | SCHEMAS} [LIKE \'pattern\']\n\nSHOW DATABASES lists the databases on the MySQL server host. SHOW\nSCHEMAS is a synonym for SHOW DATABASES.\n\nYou see only those databases for which you have some kind of privilege,\nunless you have the global SHOW DATABASES privilege. You can also get\nthis list using the mysqlshow command.\n\nIf the server was started with the --skip-show-database option, you\ncannot use this statement at all unless you have the SHOW DATABASES\nprivilege.\n\nSHOW SCHEMAS can also be used.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-databases.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-databases.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (147,19,'~','Syntax:\n~\n\nInvert all bits.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/bit-functions.html\n\n','mysql> SELECT 5 & ~1;\n        -> 4\n','http://dev.mysql.com/doc/refman/5.1/en/bit-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (148,21,'TEXT','TEXT[(M)] [CHARACTER SET charset_name] [COLLATE collation_name]\n\nA TEXT column with a maximum length of 65,535 (216 - 1) characters.\n\nAn optional length M can be given for this type. If this is done, MySQL\ncreates the column as the smallest TEXT type large enough to hold\nvalues M characters long.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (149,34,'CONCAT_WS','Syntax:\nCONCAT_WS(separator,str1,str2,...)\n\nCONCAT_WS() stands for Concatenate With Separator and is a special form\nof CONCAT(). The first argument is the separator for the rest of the\narguments. The separator is added between the strings to be\nconcatenated. The separator can be a string, as can the rest of the\narguments. If the separator is NULL, the result is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT CONCAT_WS(\',\',\'First name\',\'Second name\',\'Last Name\');\n        -> \'First name,Second name,Last Name\'\nmysql> SELECT CONCAT_WS(\',\',\'First name\',NULL,\'Last Name\');\n        -> \'First name,Last Name\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (150,16,'ROW_COUNT','Syntax:\nROW_COUNT()\n\nROW_COUNT() returns the number of rows updated, inserted, or deleted by\nthe preceding statement. This is the same as the row count that the\nmysql client displays and the value from the mysql_affected_rows() C\nAPI function.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/information-functions.html\n\n','mysql> INSERT INTO t VALUES(1),(2),(3);\nQuery OK, 3 rows affected (0.00 sec)\nRecords: 3  Duplicates: 0  Warnings: 0\n\nmysql> SELECT ROW_COUNT();\n+-------------+\n| ROW_COUNT() |\n+-------------+\n|           3 |\n+-------------+\n1 row in set (0.00 sec)\n\nmysql> DELETE FROM t WHERE i IN(1,2);\nQuery OK, 2 rows affected (0.00 sec)\n\nmysql> SELECT ROW_COUNT();\n+-------------+\n| ROW_COUNT() |\n+-------------+\n|           2 |\n+-------------+\n1 row in set (0.00 sec)\n','http://dev.mysql.com/doc/refman/5.1/en/information-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (151,4,'ASIN','Syntax:\nASIN(X)\n\nReturns the arc sine of X, that is, the value whose sine is X. Returns\nNULL if X is not in the range -1 to 1.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT ASIN(0.2);\n        -> 0.20135792079033\nmysql> SELECT ASIN(\'foo\');\n\n+-------------+\n| ASIN(\'foo\') |\n+-------------+\n|           0 |\n+-------------+\n1 row in set, 1 warning (0.00 sec)\n\nmysql> SHOW WARNINGS;\n+---------+------+-----------------------------------------+\n| Level   | Code | Message                                 |\n+---------+------+-----------------------------------------+\n| Warning | 1292 | Truncated incorrect DOUBLE value: \'foo\' |\n+---------+------+-----------------------------------------+\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (152,4,'SIGN','Syntax:\nSIGN(X)\n\nReturns the sign of the argument as -1, 0, or 1, depending on whether X\nis negative, zero, or positive.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT SIGN(-32);\n        -> -1\nmysql> SELECT SIGN(0);\n        -> 0\nmysql> SELECT SIGN(234);\n        -> 1\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (153,29,'SEC_TO_TIME','Syntax:\nSEC_TO_TIME(seconds)\n\nReturns the seconds argument, converted to hours, minutes, and seconds,\nas a value in \'HH:MM:SS\' or HHMMSS format, depending on whether the\nfunction is used in a string or numeric context.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT SEC_TO_TIME(2378);\n        -> \'00:39:38\'\nmysql> SELECT SEC_TO_TIME(2378) + 0;\n        -> 3938\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (154,21,'FLOAT','FLOAT[(M,D)] [UNSIGNED] [ZEROFILL]\n\nA small (single-precision) floating-point number. Allowable values are\n-3.402823466E+38 to -1.175494351E-38, 0, and 1.175494351E-38 to\n3.402823466E+38. These are the theoretical limits, based on the IEEE\nstandard. The actual range might be slightly smaller depending on your\nhardware or operating system.\n\nM is the total number of digits and D is the number of digits following\nthe decimal point. If M and D are omitted, values are stored to the\nlimits allowed by the hardware. A single-precision floating-point\nnumber is accurate to approximately 7 decimal places.\n\nUNSIGNED, if specified, disallows negative values.\n\nUsing FLOAT might give you some unexpected problems because all\ncalculations in MySQL are done with double precision. See\nhttp://dev.mysql.com/doc/refman/5.1/en/no-matching-rows.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (155,34,'LOCATE','Syntax:\nLOCATE(substr,str), LOCATE(substr,str,pos)\n\nThe first syntax returns the position of the first occurrence of\nsubstring substr in string str. The second syntax returns the position\nof the first occurrence of substring substr in string str, starting at\nposition pos. Returns 0 if substr is not in str.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT LOCATE(\'bar\', \'foobarbar\');\n        -> 4\nmysql> SELECT LOCATE(\'xbar\', \'foobar\');\n        -> 0\nmysql> SELECT LOCATE(\'bar\', \'foobarbar\', 5);\n        -> 7\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (156,16,'CHARSET','Syntax:\nCHARSET(str)\n\nReturns the character set of the string argument.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/information-functions.html\n\n','mysql> SELECT CHARSET(\'abc\');\n        -> \'latin1\'\nmysql> SELECT CHARSET(CONVERT(\'abc\' USING utf8));\n        -> \'utf8\'\nmysql> SELECT CHARSET(USER());\n        -> \'utf8\'\n','http://dev.mysql.com/doc/refman/5.1/en/information-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (157,29,'SUBDATE','Syntax:\nSUBDATE(date,INTERVAL expr unit), SUBDATE(expr,days)\n\nWhen invoked with the INTERVAL form of the second argument, SUBDATE()\nis a synonym for DATE_SUB(). For information on the INTERVAL unit\nargument, see the discussion for DATE_ADD().\n\nmysql> SELECT DATE_SUB(\'1998-01-02\', INTERVAL 31 DAY);\n        -> \'1997-12-02\'\nmysql> SELECT SUBDATE(\'1998-01-02\', INTERVAL 31 DAY);\n        -> \'1997-12-02\'\n\nThe second form allows the use of an integer value for days. In such\ncases, it is interpreted as the number of days to be subtracted from\nthe date or datetime expression expr.\n\nmysql> SELECT SUBDATE(\'1998-01-02 12:00:00\', 31);\n        -> \'1997-12-02 12:00:00\'\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (158,29,'DAYOFYEAR','Syntax:\nDAYOFYEAR(date)\n\nReturns the day of the year for date, in the range 1 to 366.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT DAYOFYEAR(\'1998-02-03\');\n        -> 34\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (159,21,'LONGTEXT','LONGTEXT [CHARACTER SET charset_name] [COLLATE collation_name]\n\nA TEXT column with a maximum length of 4,294,967,295 or 4GB (232 - 1)\ncharacters. The maximum effective (permitted) length of LONGTEXT\ncolumns depends on the configured maximum packet size in the\nclient/server protocol and available memory.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (160,4,'%','Syntax:\nN % M\n\nModulo operation. Returns the remainder of N divided by M. For more\ninformation, see the description for the MOD() function in [HELP ABS].\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/arithmetic-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/arithmetic-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (161,27,'DISJOINT','Disjoint(g1,g2)\n\nReturns 1 or 0 to indicate whether g1 is spatially disjoint from (does\nnot intersect) g2.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/functions-that-test-spatial-relationships-between-geometries.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/functions-that-test-spatial-relationships-between-geometries.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (162,26,'KILL','Syntax:\nKILL [CONNECTION | QUERY] thread_id\n\nEach connection to mysqld runs in a separate thread. You can see which\nthreads are running with the SHOW PROCESSLIST statement and kill a\nthread with the KILL thread_id statement.\n\nKILL allows the optional CONNECTION or QUERY modifier:\n\no KILL CONNECTION is the same as KILL with no modifier: It terminates\n  the connection associated with the given thread_id.\n\no KILL QUERY terminates the statement that the connection is currently\n  executing, but leaves the connection itself intact.\n\nIf you have the PROCESS privilege, you can see all threads. If you have\nthe SUPER privilege, you can kill all threads and statements.\nOtherwise, you can see and kill only your own threads and statements.\n\nYou can also use the mysqladmin processlist and mysqladmin kill\ncommands to examine and kill threads.\n\nNote: You cannot use KILL with the Embedded MySQL Server library,\nbecause the embedded server merely runs inside the threads of the host\napplication. It does not create any connection threads of its own.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/kill.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/kill.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (163,3,'ASTEXT','AsText(g)\n\nConverts a value in internal geometry format to its WKT representation\nand returns the string result.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/functions-to-convert-geometries-between-formats.html\n\n','mysql> SET @g = \'LineString(1 1,2 2,3 3)\';\nmysql> SELECT AsText(GeomFromText(@g));\n+--------------------------+\n| AsText(GeomFromText(@g)) |\n+--------------------------+\n| LINESTRING(1 1,2 2,3 3)  |\n+--------------------------+\n','http://dev.mysql.com/doc/refman/5.1/en/functions-to-convert-geometries-between-formats.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (164,34,'LPAD','Syntax:\nLPAD(str,len,padstr)\n\nReturns the string str, left-padded with the string padstr to a length\nof len characters. If str is longer than len, the return value is\nshortened to len characters.\n\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT LPAD(\'hi\',4,\'??\');\n        -> \'??hi\'\nmysql> SELECT LPAD(\'hi\',1,\'??\');\n        -> \'h\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (165,20,'RESTORE TABLE','Syntax:\nRESTORE TABLE tbl_name [, tbl_name] ... FROM \'/path/to/backup/directory\'\n\nRESTORE TABLE restores the table or tables from a backup that was made\nwith BACKUP TABLE. The directory should be specified as a full\npathname.\n\nExisting tables are not overwritten; if you try to restore over an\nexisting table, an error occurs. Just as for BACKUP TABLE, RESTORE\nTABLE currently works only for MyISAM tables. Restored tables are not\nreplicated from master to slave.\n\nThe backup for each table consists of its .frm format file and .MYD\ndata file. The restore operation restores those files, and then uses\nthem to rebuild the .MYI index file. Restoring takes longer than\nbacking up due to the need to rebuild the indexes. The more indexes the\ntable has, the longer it takes.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/restore-table.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/restore-table.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (166,36,'DECLARE CONDITION','Syntax:\nDECLARE condition_name CONDITION FOR condition_value\n\ncondition_value:\n    SQLSTATE [VALUE] sqlstate_value\n  | mysql_error_code\n\nThis statement specifies conditions that need specific handling. It\nassociates a name with a specified error condition. The name can\nsubsequently be used in a DECLARE HANDLER statement. See [HELP DECLARE\nHANDLER].\n\nA condition_value can be an SQLSTATE value or a MySQL error code.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/declare-conditions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/declare-conditions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (167,27,'OVERLAPS','Overlaps(g1,g2)\n\nReturns 1 or 0 to indicate whether g1 spatially overlaps g2. The term\nspatially overlaps is used if two geometries intersect and their\nintersection results in a geometry of the same dimension but not equal\nto either of the given geometries.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/functions-that-test-spatial-relationships-between-geometries.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/functions-that-test-spatial-relationships-between-geometries.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (168,24,'NUMGEOMETRIES','NumGeometries(gc)\n\nReturns the number of geometries in the GeometryCollection value gc.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/geometrycollection-property-functions.html\n\n','mysql> SET @gc = \'GeometryCollection(Point(1 1),LineString(2 2, 3 3))\';\nmysql> SELECT NumGeometries(GeomFromText(@gc));\n+----------------------------------+\n| NumGeometries(GeomFromText(@gc)) |\n+----------------------------------+\n|                                2 |\n+----------------------------------+\n','http://dev.mysql.com/doc/refman/5.1/en/geometrycollection-property-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (169,26,'SET GLOBAL SQL_SLAVE_SKIP_COUNTER','Syntax:\nSET GLOBAL SQL_SLAVE_SKIP_COUNTER = N\n\nThis statement skips the next N events from the master. This is useful\nfor recovering from replication stops caused by a statement.\n\nThis statement is valid only when the slave thread is not running.\nOtherwise, it produces an error.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/set-global-sql-slave-skip-counter.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/set-global-sql-slave-skip-counter.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (170,29,'MONTHNAME','Syntax:\nMONTHNAME(date)\n\nReturns the full name of the month for date. As of MySQL 5.1.12, the\nlanguage used for the name is controlled by the value of the\nlc_time_names system variable\n(http://dev.mysql.com/doc/refman/5.1/en/locale-support.html).\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT MONTHNAME(\'1998-02-05\');\n        -> \'February\'\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (171,35,'PROCEDURE ANALYSE','Syntax:\nanalyse([max_elements[,max_memory]])\n\nThis procedure is defined in the sql/sql_analyse.cc file. It examines\nthe result from a query and returns an analysis of the results that\nsuggests optimal data types for each column. To obtain this analysis,\nappend PROCEDURE ANALYSE to the end of a SELECT statement:\n\nSELECT ... FROM ... WHERE ... PROCEDURE ANALYSE([max_elements,[max_memory]])\n\nFor example:\n\nSELECT col1, col2 FROM table1 PROCEDURE ANALYSE(10, 2000);\n\nThe results show some statistics for the values returned by the query,\nand propose an optimal data type for the columns. This can be helpful\nfor checking your existing tables, or after importing new data. You may\nneed to try different settings for the arguments so that PROCEDURE\nANALYSE() does not suggest the ENUM data type when it is not\nappropriate.\n\nThe arguments are optional and are used as follows:\n\no max_elements (default 256) is the maximum number of distinct values\n  that analyse notices per column. This is used by analyse to check\n  whether the optimal data type should be of type ENUM.\n\no max_memory (default 8192) is the maximum amount of memory that\n  analyse should allocate per column while trying to find all distinct\n  values.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/procedure-analyse.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/procedure-analyse.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (172,6,'MBREQUAL','MBREqual(g1,g2)\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of\nthe two geometries g1 and g2 are the same.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/relations-on-geometry-mbr.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/relations-on-geometry-mbr.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (173,26,'CHANGE MASTER TO','Syntax:\nCHANGE MASTER TO master_def [, master_def] ...\n\nmaster_def:\n    MASTER_HOST = \'host_name\'\n  | MASTER_USER = \'user_name\'\n  | MASTER_PASSWORD = \'password\'\n  | MASTER_PORT = port_num\n  | MASTER_CONNECT_RETRY = count\n  | MASTER_LOG_FILE = \'master_log_name\'\n  | MASTER_LOG_POS = master_log_pos\n  | RELAY_LOG_FILE = \'relay_log_name\'\n  | RELAY_LOG_POS = relay_log_pos\n  | MASTER_SSL = {0|1}\n  | MASTER_SSL_CA = \'ca_file_name\'\n  | MASTER_SSL_CAPATH = \'ca_directory_name\'\n  | MASTER_SSL_CERT = \'cert_file_name\'\n  | MASTER_SSL_KEY = \'key_file_name\'\n  | MASTER_SSL_CIPHER = \'cipher_list\'\n  | MASTER_SSL_VERIFY_SERVER_CERT = {0|1}\n\nCHANGE MASTER TO changes the parameters that the slave server uses for\nconnecting to and communicating with the master server. It also updates\nthe contents of the master.info and relay-log.info files.\n\nMASTER_USER, MASTER_PASSWORD, MASTER_SSL, MASTER_SSL_CA,\nMASTER_SSL_CAPATH, MASTER_SSL_CERT, MASTER_SSL_KEY, MASTER_SSL_CIPHER,\nand MASTER_SSL_VERIFY_SERVER_CERT provide information to the slave\nabout how to connect to its master. MASTER_SSL_VERIFY_SERVER_CERT was\nadded in MySQL 5.1.18. It is used as described for the\n--ssl-verify-server-cert option in\nhttp://dev.mysql.com/doc/refman/5.1/en/ssl-options.html.\n\nThe SSL options (MASTER_SSL, MASTER_SSL_CA, MASTER_SSL_CAPATH,\nMASTER_SSL_CERT, MASTER_SSL_KEY, MASTER_SSL_CIPHER), and\nMASTER_SSL_VERIFY_SERVER_CERT can be changed even on slaves that are\ncompiled without SSL support. They are saved to the master.info file,\nbut are ignored unless you use a server that has SSL support enabled.\n\nIf you don\'t specify a given parameter, it keeps its old value, except\nas indicated in the following discussion. For example, if the password\nto connect to your MySQL master has changed, you just need to issue\nthese statements to tell the slave about the new password:\n\nSTOP SLAVE; -- if replication was running\nCHANGE MASTER TO MASTER_PASSWORD=\'new3cret\';\nSTART SLAVE; -- if you want to restart replication\n\nThere is no need to specify the parameters that do not change (host,\nport, user, and so forth).\n\nMASTER_HOST and MASTER_PORT are the hostname (or IP address) of the\nmaster host and its TCP/IP port. Note that if MASTER_HOST is equal to\nlocalhost, then, like in other parts of MySQL, the port number might be\nignored (if Unix socket files can be used, for example).\n\nIf you specify MASTER_HOST or MASTER_PORT, the slave assumes that the\nmaster server is different from before (even if you specify a host or\nport value that is the same as the current value.) In this case, the\nold values for the master binary log name and position are considered\nno longer applicable, so if you do not specify MASTER_LOG_FILE and\nMASTER_LOG_POS in the statement, MASTER_LOG_FILE=\'\' and\nMASTER_LOG_POS=4 are silently appended to it.\n\nMASTER_LOG_FILE and MASTER_LOG_POS are the coordinates at which the\nslave I/O thread should begin reading from the master the next time the\nthread starts. If you specify either of them, you cannot specify\nRELAY_LOG_FILE or RELAY_LOG_POS. If neither of MASTER_LOG_FILE or\nMASTER_LOG_POS are specified, the slave uses the last coordinates of\nthe slave SQL thread before CHANGE MASTER was issued. This ensures that\nthere is no discontinuity in replication, even if the slave SQL thread\nwas late compared to the slave I/O thread, when you merely want to\nchange, say, the password to use.\n\nCHANGE MASTER deletes all relay log files and starts a new one, unless\nyou specify RELAY_LOG_FILE or RELAY_LOG_POS. In that case, relay logs\nare kept; the relay_log_purge global variable is set silently to 0.\n\nCHANGE MASTER is useful for setting up a slave when you have the\nsnapshot of the master and have recorded the log and the offset\ncorresponding to it. After loading the snapshot into the slave, you can\nrun CHANGE MASTER TO MASTER_LOG_FILE=\'log_name_on_master\',\nMASTER_LOG_POS=log_offset_on_master on the slave.\n\nThe following example changes the master and master\'s binary log\ncoordinates. This is used when you want to set up the slave to\nreplicate the master:\n\nCHANGE MASTER TO\n  MASTER_HOST=\'master2.mycompany.com\',\n  MASTER_USER=\'replication\',\n  MASTER_PASSWORD=\'bigs3cret\',\n  MASTER_PORT=3306,\n  MASTER_LOG_FILE=\'master2-bin.001\',\n  MASTER_LOG_POS=4,\n  MASTER_CONNECT_RETRY=10;\n\nThe next example shows an operation that is less frequently employed.\nIt is used when the slave has relay logs that you want it to execute\nagain for some reason. To do this, the master need not be reachable.\nYou need only use CHANGE MASTER TO and start the SQL thread (START\nSLAVE SQL_THREAD):\n\nCHANGE MASTER TO\n  RELAY_LOG_FILE=\'slave-relay-bin.006\',\n  RELAY_LOG_POS=4025;\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/change-master-to.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/change-master-to.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (174,37,'DROP DATABASE','Syntax:\nDROP {DATABASE | SCHEMA} [IF EXISTS] db_name\n\nDROP DATABASE drops all tables in the database and deletes the\ndatabase. Be very careful with this statement! To use DROP DATABASE,\nyou need the DROP privilege on the database. DROP SCHEMA is a synonym\nfor DROP DATABASE.\n\nImportant: When a database is dropped, user privileges on the database\nare not automatically dropped. See [HELP GRANT].\n\nIF EXISTS is used to prevent an error from occurring if the database\ndoes not exist.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/drop-database.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/drop-database.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (175,29,'TIMESTAMP FUNCTION','Syntax:\nTIMESTAMP(expr), TIMESTAMP(expr1,expr2)\n\nWith a single argument, this function returns the date or datetime\nexpression expr as a datetime value. With two arguments, it adds the\ntime expression expr2 to the date or datetime expression expr1 and\nreturns the result as a datetime value.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT TIMESTAMP(\'2003-12-31\');\n        -> \'2003-12-31 00:00:00\'\nmysql> SELECT TIMESTAMP(\'2003-12-31 12:00:00\',\'12:00:00\');\n        -> \'2004-01-01 00:00:00\'\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (176,34,'CHARACTER_LENGTH','Syntax:\nCHARACTER_LENGTH(str)\n\nCHARACTER_LENGTH() is a synonym for CHAR_LENGTH().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (177,26,'SHOW GRANTS','Syntax:\nSHOW GRANTS [FOR user]\n\nThis statement lists the GRANT statement or statements that must be\nissued to duplicate the privileges that are granted to a MySQL user\naccount. The account is named using the same format as for the GRANT\nstatement; for example, \'jeffrey\'@\'localhost\'. If you specify only the\nusername part of the account name, a hostname part of \'%\' is used. For\nadditional information about specifying account names, see [HELP\nGRANT].\n\nmysql> SHOW GRANTS FOR \'root\'@\'localhost\';\n+---------------------------------------------------------------------+\n| Grants for root@localhost                                           |\n+---------------------------------------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'root\'@\'localhost\' WITH GRANT OPTION |\n+---------------------------------------------------------------------+\n\nTo list the privileges granted to the account that you are using to\nconnect to the server, you can use any of the following statements:\n\nSHOW GRANTS;\nSHOW GRANTS FOR CURRENT_USER;\nSHOW GRANTS FOR CURRENT_USER();\n\nAs of MySQL 5.1.12, if SHOW GRANTS FOR CURRENT_USER (or any of the\nequivalent syntaxes) is used in DEFINER context, such as within a\nstored procedure that is defined with SQL SECURITY DEFINER), the grants\ndisplayed are those of the definer and not the invoker.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-grants.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-grants.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (178,26,'SHOW PRIVILEGES','Syntax:\nSHOW PRIVILEGES\n\nSHOW PRIVILEGES shows the list of system privileges that the MySQL\nserver supports. The exact list of privileges depends on the version of\nyour server.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-privileges.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-privileges.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (179,34,'INSERT FUNCTION','Syntax:\nINSERT(str,pos,len,newstr)\n\nReturns the string str, with the substring beginning at position pos\nand len characters long replaced by the string newstr. Returns the\noriginal string if pos is not within the length of the string. Replaces\nthe rest of the string from position pos if len is not within the\nlength of the rest of the string. Returns NULL if any argument is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT INSERT(\'Quadratic\', 3, 4, \'What\');\n        -> \'QuWhattic\'\nmysql> SELECT INSERT(\'Quadratic\', -1, 4, \'What\');\n        -> \'Quadratic\'\nmysql> SELECT INSERT(\'Quadratic\', 3, 100, \'What\');\n        -> \'QuWhat\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (180,4,'CRC32','Syntax:\nCRC32(expr)\n\nComputes a cyclic redundancy check value and returns a 32-bit unsigned\nvalue. The result is NULL if the argument is NULL. The argument is\nexpected to be a string and (if possible) is treated as one if it is\nnot.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT CRC32(\'MySQL\');\n        -> 3259397556\nmysql> SELECT CRC32(\'mysql\');\n        -> 2501908538\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (181,13,'XOR','Syntax:\nXOR\n\nLogical XOR. Returns NULL if either operand is NULL. For non-NULL\noperands, evaluates to 1 if an odd number of operands is non-zero,\notherwise 0 is returned.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/logical-operators.html\n\n','mysql> SELECT 1 XOR 1;\n        -> 0\nmysql> SELECT 1 XOR 0;\n        -> 1\nmysql> SELECT 1 XOR NULL;\n        -> NULL\nmysql> SELECT 1 XOR 1 XOR 1;\n        -> 1\n','http://dev.mysql.com/doc/refman/5.1/en/logical-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (182,12,'STARTPOINT','StartPoint(ls)\n\nReturns the Point that is the start point of the LineString value ls.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/linestring-property-functions.html\n\n','mysql> SET @ls = \'LineString(1 1,2 2,3 3)\';\nmysql> SELECT AsText(StartPoint(GeomFromText(@ls)));\n+---------------------------------------+\n| AsText(StartPoint(GeomFromText(@ls))) |\n+---------------------------------------+\n| POINT(1 1)                            |\n+---------------------------------------+\n','http://dev.mysql.com/doc/refman/5.1/en/linestring-property-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (183,36,'DECLARE VARIABLE','Syntax:\nDECLARE var_name[,...] type [DEFAULT value]\n\nThis statement is used to declare local variables. To provide a default\nvalue for the variable, include a DEFAULT clause. The value can be\nspecified as an expression; it need not be a constant. If the DEFAULT\nclause is missing, the initial value is NULL.\n\nLocal variables are treated like routine parameters with respect to\ndata type and overflow checking. See [HELP CREATE PROCEDURE].\n\nThe scope of a local variable is within the BEGIN ... END block where\nit is declared. The variable can be referred to in blocks nested within\nthe declaring block, except those blocks that declare a variable with\nthe same name.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/declare-local-variables.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/declare-local-variables.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (184,3,'MPOLYFROMTEXT','MPolyFromText(wkt[,srid]), MultiPolygonFromText(wkt[,srid])\n\nConstructs a MULTIPOLYGON value using its WKT representation and SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/gis-wkt-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/gis-wkt-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (185,9,'GRANT','Syntax:\nGRANT priv_type [(column_list)] [, priv_type [(column_list)]] ...\n    ON [object_type] {tbl_name | * | *.* | db_name.*}\n    TO user [IDENTIFIED BY [PASSWORD] \'password\']\n        [, user [IDENTIFIED BY [PASSWORD] \'password\']] ...\n    [REQUIRE\n        NONE |\n        [{SSL| X509}]\n        [CIPHER \'cipher\' [AND]]\n        [ISSUER \'issuer\' [AND]]\n        [SUBJECT \'subject\']]\n    [WITH with_option [with_option] ...]\n\nobject_type =\n    TABLE\n  | FUNCTION\n  | PROCEDURE\n\nwith_option =\n    GRANT OPTION\n  | MAX_QUERIES_PER_HOUR count\n  | MAX_UPDATES_PER_HOUR count\n  | MAX_CONNECTIONS_PER_HOUR count\n  | MAX_USER_CONNECTIONS count\n\nThe GRANT statement enables system administrators to create MySQL user\naccounts and to grant rights to from accounts. To use GRANT, you must\nhave the GRANT OPTION privilege, and you must have the privileges that\nyou are granting. The REVOKE statement is related and enables\nadministrators to remove account privileges. See [HELP REVOKE].\n\nMySQL account information is stored in the tables of the mysql\ndatabase. This database and the access control system are discussed\nextensively in [HELP FLUSH QUERY CACHE], which you should consult for\nadditional details.\n\nImportant: Some releases of MySQL introduce changes to the structure of\nthe grant tables to add new privileges or features. Whenever you update\nto a new version of MySQL, you should update your grant tables to make\nsure that they have the current structure so that you can take\nadvantage of any new capabilities. See\nhttp://dev.mysql.com/doc/refman/5.1/en/mysql-upgrade.html.\n\nIf the grant tables hold privilege rows that contain mixed-case\ndatabase or table names and the lower_case_table_names system variable\nis set to a non-zero value, REVOKE cannot be used to revoke these\nprivileges. It will be necessary to manipulate the grant tables\ndirectly. (GRANT will not create such rows when lower_case_table_names\nis set, but such rows might have been created prior to setting the\nvariable.)\n\nPrivileges can be granted at several levels:\n\no Global level\n\n  Global privileges apply to all databases on a given server. These\n  privileges are stored in the mysql.user table. GRANT ALL ON *.* and\n  REVOKE ALL ON *.* grant and revoke only global privileges.\n\no Database level\n\n  Database privileges apply to all objects in a given database. These\n  privileges are stored in the mysql.db and mysql.host tables. GRANT\n  ALL ON db_name.* and REVOKE ALL ON db_name.* grant and revoke only\n  database privileges.\n\no Table level\n\n  Table privileges apply to all columns in a given table. These\n  privileges are stored in the mysql.tables_priv table. GRANT ALL ON\n  db_name.tbl_name and REVOKE ALL ON db_name.tbl_name grant and revoke\n  only table privileges.\n\no Column level\n\n  Column privileges apply to single columns in a given table. These\n  privileges are stored in the mysql.columns_priv table. When using\n  REVOKE, you must specify the same columns that were granted.\n\no Routine level\n\n  The CREATE ROUTINE, ALTER ROUTINE, EXECUTE, and GRANT privileges\n  apply to stored routines (functions and procedures). They can be\n  granted at the global and database levels. Also, except for CREATE\n  ROUTINE, these privileges can be granted at the routine level for\n  individual routines and are stored in the mysql.procs_priv table.\n\nThe object_type clause should be specified as TABLE, FUNCTION, or\nPROCEDURE when the following object is a table, a stored function, or a\nstored procedure.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/grant.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/grant.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (186,6,'MBRINTERSECTS','MBRIntersects(g1,g2)\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of\nthe two geometries g1 and g2 intersect.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/relations-on-geometry-mbr.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/relations-on-geometry-mbr.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (187,15,'BIT_OR','Syntax:\nBIT_OR(expr)\n\nReturns the bitwise OR of all bits in expr. The calculation is\nperformed with 64-bit (BIGINT) precision.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (188,29,'YEARWEEK','Syntax:\nYEARWEEK(date), YEARWEEK(date,mode)\n\nReturns year and week for a date. The mode argument works exactly like\nthe mode argument to WEEK(). The year in the result may be different\nfrom the year in the date argument for the first and the last week of\nthe year.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT YEARWEEK(\'1987-01-01\');\n        -> 198653\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (189,18,'NOT BETWEEN','Syntax:\nexpr NOT BETWEEN min AND max\n\nThis is the same as NOT (expr BETWEEN min AND max).\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (190,4,'LOG10','Syntax:\nLOG10(X)\n\nReturns the base-10 logarithm of X.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT LOG10(2);\n        -> 0.30102999566398\nmysql> SELECT LOG10(100);\n        -> 2\nmysql> SELECT LOG10(-100);\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (191,4,'SQRT','Syntax:\nSQRT(X)\n\nReturns the square root of a non-negative number X.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT SQRT(4);\n        -> 2\nmysql> SELECT SQRT(20);\n        -> 4.4721359549996\nmysql> SELECT SQRT(-16);\n        -> NULL        \n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (192,21,'DECIMAL','DECIMAL[(M[,D])] [UNSIGNED] [ZEROFILL]\n\nA packed "exact" fixed-point number. M is the total number of digits\n(the precision) and D is the number of digits after the decimal point\n(the scale). The decimal point and (for negative numbers) the `-\' sign\nare not counted in M. If D is 0, values have no decimal point or\nfractional part. The maximum number of digits (M) for DECIMAL is 65.\nThe maximum number of supported decimals (D) is 30. If D is omitted,\nthe default is 0. If M is omitted, the default is 10.\n\nUNSIGNED, if specified, disallows negative values.\n\nAll basic calculations (+, -, *, /) with DECIMAL columns are done with\na precision of 65 digits.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (193,35,'CREATE FUNCTION','Syntax:\nCREATE [AGGREGATE] FUNCTION function_name RETURNS {STRING|INTEGER|REAL|DECIMAL}\n    SONAME shared_library_name\n\nA user-defined function (UDF) is a way to extend MySQL with a new\nfunction that works like a native (built-in) MySQL function such as\nABS() or CONCAT().\n\nfunction_name is the name that should be used in SQL statements to\ninvoke the function. The RETURNS clause indicates the type of the\nfunction\'s return value. DECIMAL is a legal value after RETURNS, but\ncurrently DECIMAL functions return string values and should be written\nlike STRING functions.\n\nshared_library_name is the basename of the shared object file that\ncontains the code that implements the function. The file must be\nlocated in the plugin directory. This directory is given by the value\nof the plugin_dir system variable. (Note: This a change in MySQL 5.1.\nFor earlier versions of MySQL, the shared object can be located in any\ndirectory that is searched by your system\'s dynamic linker.)\n\nTo create a function, you must have the INSERT and privilege for the\nmysql database. This is necessary because CREATE FUNCTION adds a row to\nthe mysql.func system table that records the function\'s name, type, and\nshared library name. If you do not have this table, you should run the\nmysql_upgrade command to create it. See\nhttp://dev.mysql.com/doc/refman/5.1/en/mysql-upgrade.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/create-function.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/create-function.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (194,24,'GEOMETRYN','GeometryN(gc,N)\n\nReturns the N-th geometry in the GeometryCollection value gc.\nGeometries are numbered beginning with 1.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/geometrycollection-property-functions.html\n\n','mysql> SET @gc = \'GeometryCollection(Point(1 1),LineString(2 2, 3 3))\';\nmysql> SELECT AsText(GeometryN(GeomFromText(@gc),1));\n+----------------------------------------+\n| AsText(GeometryN(GeomFromText(@gc),1)) |\n+----------------------------------------+\n| POINT(1 1)                             |\n+----------------------------------------+\n','http://dev.mysql.com/doc/refman/5.1/en/geometrycollection-property-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (195,37,'CREATE INDEX','Syntax:\nCREATE [UNIQUE|FULLTEXT|SPATIAL] INDEX index_name\n    [index_type]\n    ON tbl_name (index_col_name,...)\n    [index_option ...]\n\nindex_col_name:\n    col_name [(length)] [ASC | DESC]\n\nindex_type:\n    USING {BTREE | HASH}\n\nindex_option:\n    KEY_BLOCK_SIZE value\n  | index_type\n  | WITH PARSER parser_name\n\nCREATE INDEX is mapped to an ALTER TABLE statement to create indexes.\nSee [HELP ALTER TABLE]. CREATE INDEX cannot be used to create a PRIMARY\nKEY; use ALTER TABLE instead. For more information about indexes, see\nhttp://dev.mysql.com/doc/refman/5.1/en/mysql-indexes.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/create-index.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/create-index.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (196,37,'ALTER DATABASE','Syntax:\nALTER {DATABASE | SCHEMA} [db_name]\n    alter_specification [alter_specification] ...\n\nalter_specification:\n    [DEFAULT] CHARACTER SET charset_name\n  | [DEFAULT] COLLATE collation_name\n\nALTER DATABASE enables you to change the overall characteristics of a\ndatabase. These characteristics are stored in the db.opt file in the\ndatabase directory. To use ALTER DATABASE, you need the ALTER privilege\non the database. ALTER SCHEMA is a synonym for ALTER DATABASE.\n\nThe CHARACTER SET clause changes the default database character set.\nThe COLLATE clause changes the default database collation.\nhttp://dev.mysql.com/doc/refman/5.1/en/charset.html, discusses\ncharacter set and collation names.\n\nThe database name can be omitted, in which case the statement applies\nto the default database.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/alter-database.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/alter-database.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (197,19,'<<','Syntax:\n<<\n\nShifts a longlong (BIGINT) number to the left.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/bit-functions.html\n\n','mysql> SELECT 1 << 2;\n        -> 4\n','http://dev.mysql.com/doc/refman/5.1/en/bit-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (198,26,'SHOW TABLE STATUS','Syntax:\nSHOW TABLE STATUS [FROM db_name] [LIKE \'pattern\']\n\nSHOW TABLE STATUS works likes SHOW TABLES, but provides a lot of\ninformation about each table. You can also get this list using the\nmysqlshow --status db_name command.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-table-status.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-table-status.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (199,11,'MD5','Syntax:\nMD5(str)\n\nCalculates an MD5 128-bit checksum for the string. The value is\nreturned as a binary string of 32 hex digits, or NULL if the argument\nwas NULL. The return value can, for example, be used as a hash key.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html\n\n','mysql> SELECT MD5(\'testing\');\n        -> \'ae2b1fca515949e5d54fb22b8ed95575\'\n','http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (200,18,'<','Syntax:\n<\n\nLess than:\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html\n\n','mysql> SELECT 2 < 2;\n        -> 0\n','http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (201,29,'UNIX_TIMESTAMP','Syntax:\nUNIX_TIMESTAMP(), UNIX_TIMESTAMP(date)\n\nIf called with no argument, returns a Unix timestamp (seconds since\n\'1970-01-01 00:00:00\' UTC) as an unsigned integer. If UNIX_TIMESTAMP()\nis called with a date argument, it returns the value of the argument as\nseconds since \'1970-01-01 00:00:00\' UTC. date may be a DATE string, a\nDATETIME string, a TIMESTAMP, or a number in the format YYMMDD or\nYYYYMMDD. The server interprets date as a value in the current time\nzone and converts it to an internal value in UTC. Clients can set their\ntime zone as described in\nhttp://dev.mysql.com/doc/refman/5.1/en/time-zone-support.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT UNIX_TIMESTAMP();\n        -> 882226357\nmysql> SELECT UNIX_TIMESTAMP(\'1997-10-04 22:23:00\');\n        -> 875996580\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (202,29,'DAYOFMONTH','Syntax:\nDAYOFMONTH(date)\n\nReturns the day of the month for date, in the range 0 to 31.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT DAYOFMONTH(\'1998-02-03\');\n        -> 3\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (203,34,'ASCII','Syntax:\nASCII(str)\n\nReturns the numeric value of the leftmost character of the string str.\nReturns 0 if str is the empty string. Returns NULL if str is NULL.\nASCII() works for characters with numeric values from 0 to 255.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT ASCII(\'2\');\n        -> 50\nmysql> SELECT ASCII(2);\n        -> 50\nmysql> SELECT ASCII(\'dx\');\n        -> 100\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (204,4,'DIV','Syntax:\nDIV\n\nInteger division. Similar to FLOOR(), but is safe with BIGINT values.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/arithmetic-functions.html\n\n','mysql> SELECT 5 DIV 2;\n        -> 2\n','http://dev.mysql.com/doc/refman/5.1/en/arithmetic-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (205,9,'RENAME USER','Syntax:\nRENAME USER old_user TO new_user\n    [, old_user TO new_user] ...\n\nThe RENAME USER statement renames existing MySQL accounts. To use it,\nyou must have the global CREATE USER privilege or the UPDATE privilege\nfor the mysql database. An error occurs if any old account does not\nexist or any new account exists. Each account is named using the same\nformat as for the GRANT statement; for example, \'jeffrey\'@\'localhost\'.\nIf you specify only the username part of the account name, a hostname\npart of \'%\' is used. For additional information about specifying\naccount names, see [HELP GRANT].\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/rename-user.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/rename-user.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (206,26,'SHOW SLAVE STATUS','Syntax:\nSHOW SLAVE STATUS\n\nThis statement provides status information on essential parameters of\nthe slave threads. If you issue this statement using the mysql client,\nyou can use a \\G statement terminator rather than a semicolon to obtain\na more readable vertical layout:\n\nmysql> SHOW SLAVE STATUS\\G\n*************************** 1. row ***************************\n               Slave_IO_State: Waiting for master to send event\n                  Master_Host: localhost\n                  Master_User: root\n                  Master_Port: 3306\n                Connect_Retry: 3\n              Master_Log_File: gbichot-bin.005\n          Read_Master_Log_Pos: 79\n               Relay_Log_File: gbichot-relay-bin.005\n                Relay_Log_Pos: 548\n        Relay_Master_Log_File: gbichot-bin.005\n             Slave_IO_Running: Yes\n            Slave_SQL_Running: Yes\n              Replicate_Do_DB:\n          Replicate_Ignore_DB:\n                   Last_Errno: 0\n                   Last_Error:\n                 Skip_Counter: 0\n          Exec_Master_Log_Pos: 79\n              Relay_Log_Space: 552\n              Until_Condition: None\n               Until_Log_File:\n                Until_Log_Pos: 0\n           Master_SSL_Allowed: No\n           Master_SSL_CA_File:\n           Master_SSL_CA_Path:\n              Master_SSL_Cert:\n            Master_SSL_Cipher:\n               Master_SSL_Key:\n        Seconds_Behind_Master: 8\nMaster_SSL_Verify_Server_Cert: No\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-slave-status.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-slave-status.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (207,31,'GEOMETRY','MySQL provides a standard way of creating spatial columns for geometry\ntypes, for example, with CREATE TABLE or ALTER TABLE. Currently,\nspatial columns are supported for MyISAM, InnoDB, NDB, and ARCHIVE\ntables. See also the annotations about spatial indexes under [HELP\nSPATIAL].\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-columns.html\n\n','CREATE TABLE geom (g GEOMETRY);\n','http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-columns.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (208,12,'NUMPOINTS','NumPoints(ls)\n\nReturns the number of Point objects in the LineString value ls.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/linestring-property-functions.html\n\n','mysql> SET @ls = \'LineString(1 1,2 2,3 3)\';\nmysql> SELECT NumPoints(GeomFromText(@ls));\n+------------------------------+\n| NumPoints(GeomFromText(@ls)) |\n+------------------------------+\n|                            3 |\n+------------------------------+\n','http://dev.mysql.com/doc/refman/5.1/en/linestring-property-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (209,19,'&','Syntax:\n&\n\nBitwise AND:\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/bit-functions.html\n\n','mysql> SELECT 29 & 15;\n        -> 13\n','http://dev.mysql.com/doc/refman/5.1/en/bit-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (210,29,'LOCALTIMESTAMP','Syntax:\nLOCALTIMESTAMP, LOCALTIMESTAMP()\n\nLOCALTIMESTAMP and LOCALTIMESTAMP() are synonyms for NOW().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (211,29,'ADDDATE','Syntax:\nADDDATE(date,INTERVAL expr unit), ADDDATE(expr,days)\n\nWhen invoked with the INTERVAL form of the second argument, ADDDATE()\nis a synonym for DATE_ADD(). The related function SUBDATE() is a\nsynonym for DATE_SUB(). For information on the INTERVAL unit argument,\nsee the discussion for DATE_ADD().\n\nmysql> SELECT DATE_ADD(\'1998-01-02\', INTERVAL 31 DAY);\n        -> \'1998-02-02\'\nmysql> SELECT ADDDATE(\'1998-01-02\', INTERVAL 31 DAY);\n        -> \'1998-02-02\'\n\nWhen invoked with the days form of the second argument, MySQL treats it\nas an integer number of days to be added to expr.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT ADDDATE(\'1998-01-02\', 31);\n        -> \'1998-02-02\'\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (212,36,'REPEAT LOOP','Syntax:\n[begin_label:] REPEAT\n    statement_list\nUNTIL search_condition\nEND REPEAT [end_label]\n\nThe statement list within a REPEAT statement is repeated until the\nsearch_condition is true. Thus, a REPEAT always enters the loop at\nleast once. statement_list consists of one or more statements.\n\nA REPEAT statement can be labeled. end_label cannot be given unless\nbegin_label also is present. If both are present, they must be the\nsame.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/repeat-statement.html\n\n','mysql> delimiter //\n\nmysql> CREATE PROCEDURE dorepeat(p1 INT)\n    -> BEGIN\n    ->   SET @x = 0;\n    ->   REPEAT SET @x = @x + 1; UNTIL @x > p1 END REPEAT;\n    -> END\n    -> //\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> CALL dorepeat(1000)//\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> SELECT @x//\n+------+\n| @x   |\n+------+\n| 1001 |\n+------+\n1 row in set (0.00 sec)\n','http://dev.mysql.com/doc/refman/5.1/en/repeat-statement.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (213,21,'SMALLINT','SMALLINT[(M)] [UNSIGNED] [ZEROFILL]\n\nA small integer. The signed range is -32768 to 32767. The unsigned\nrange is 0 to 65535.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (214,21,'DOUBLE PRECISION','DOUBLE PRECISION[(M,D)] [UNSIGNED] [ZEROFILL], REAL[(M,D)] [UNSIGNED]\n[ZEROFILL]\n\nThese types are synonyms for DOUBLE. Exception: If the REAL_AS_FLOAT\nSQL mode is enabled, REAL is a synonym for FLOAT rather than DOUBLE.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (215,34,'ORD','Syntax:\nORD(str)\n\nIf the leftmost character of the string str is a multi-byte character,\nreturns the code for that character, calculated from the numeric values\nof its constituent bytes using this formula:\n\n  (1st byte code)\n+ (2nd byte code x 256)\n+ (3rd byte code x 2562) ...\n\nIf the leftmost character is not a multi-byte character, ORD() returns\nthe same value as the ASCII() function.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT ORD(\'2\');\n        -> 50\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (216,33,'ENVELOPE','Envelope(g)\n\nReturns the Minimum Bounding Rectangle (MBR) for the geometry value g.\nThe result is returned as a Polygon value.\n\nThe polygon is defined by the corner points of the bounding box:\n\nPOLYGON((MINX MINY, MAXX MINY, MAXX MAXY, MINX MAXY, MINX MINY))\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/general-geometry-property-functions.html\n\n','mysql> SELECT AsText(Envelope(GeomFromText(\'LineString(1 1,2 2)\')));\n+-------------------------------------------------------+\n| AsText(Envelope(GeomFromText(\'LineString(1 1,2 2)\'))) |\n+-------------------------------------------------------+\n| POLYGON((1 1,2 1,2 2,1 2,1 1))                        |\n+-------------------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.1/en/general-geometry-property-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (217,26,'DEALLOCATE PREPARE','Syntax:\n{DEALLOCATE | DROP} PREPARE stmt_name\n\nTo deallocate a prepared statement, use the DEALLOCATE PREPARE\nstatement. Attempting to execute a prepared statement after\ndeallocating it results in an error.\n\nIf you terminate a client session without deallocating a previously\nprepared statement, the server deallocates it automatically.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/sqlps.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/sqlps.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (218,14,'IS_FREE_LOCK','Syntax:\nIS_FREE_LOCK(str)\n\nChecks whether the lock named str is free to use (that is, not locked).\nReturns 1 if the lock is free (no one is using the lock), 0 if the lock\nis in use, and NULL if an error occurs (such as an incorrect argument).\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (219,27,'TOUCHES','Touches(g1,g2)\n\nReturns 1 or 0 to indicate whether g1 spatially touches g2. Two\ngeometries spatially touch if the interiors of the geometries do not\nintersect, but the boundary of one of the geometries intersects either\nthe boundary or the interior of the other.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/functions-that-test-spatial-relationships-between-geometries.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/functions-that-test-spatial-relationships-between-geometries.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (220,14,'INET_ATON','Syntax:\nINET_ATON(expr)\n\nGiven the dotted-quad representation of a network address as a string,\nreturns an integer that represents the numeric value of the address.\nAddresses may be 4- or 8-byte addresses.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html\n\n','mysql> SELECT INET_ATON(\'209.207.224.40\');\n        -> 3520061480\n','http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (221,11,'UNCOMPRESS','Syntax:\nUNCOMPRESS(string_to_uncompress)\n\nUncompresses a string compressed by the COMPRESS() function. If the\nargument is not a compressed value, the result is NULL. This function\nrequires MySQL to have been compiled with a compression library such as\nzlib. Otherwise, the return value is always NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html\n\n','mysql> SELECT UNCOMPRESS(COMPRESS(\'any string\'));\n        -> \'any string\'\nmysql> SELECT UNCOMPRESS(\'any string\');\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (222,21,'AUTO_INCREMENT','The AUTO_INCREMENT attribute can be used to generate a unique identity\nfor new rows:\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/example-auto-increment.html\n\n','CREATE TABLE animals (\n     id MEDIUMINT NOT NULL AUTO_INCREMENT,\n     name CHAR(30) NOT NULL,\n     PRIMARY KEY (id)\n );\n\nINSERT INTO animals (name) VALUES \n    (\'dog\'),(\'cat\'),(\'penguin\'),\n    (\'lax\'),(\'whale\'),(\'ostrich\');\n\nSELECT * FROM animals;\n','http://dev.mysql.com/doc/refman/5.1/en/example-auto-increment.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (223,33,'ISSIMPLE','IsSimple(g)\n\nCurrently, this function is a placeholder and should not be used. If\nimplemented, its behavior will be as described in the next paragraph.\n\nReturns 1 if the geometry value g has no anomalous geometric points,\nsuch as self-intersection or self-tangency. IsSimple() returns 0 if the\nargument is not simple, and -1 if it is NULL.\n\nThe description of each instantiable geometric class given earlier in\nthe chapter includes the specific conditions that cause an instance of\nthat class to be classified as not simple. (See [HELP Geometry\nhierarchy].)\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/general-geometry-property-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/general-geometry-property-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (224,4,'- BINARY','Syntax:\n-\n\nSubtraction:\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/arithmetic-functions.html\n\n','mysql> SELECT 3-5;\n        -> -2\n','http://dev.mysql.com/doc/refman/5.1/en/arithmetic-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (225,3,'GEOMCOLLFROMTEXT','GeomCollFromText(wkt[,srid]), GeometryCollectionFromText(wkt[,srid])\n\nConstructs a GEOMETRYCOLLECTION value using its WKT representation and\nSRID.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/gis-wkt-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/gis-wkt-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (226,3,'WKT DEFINITION','The Well-Known Text (WKT) representation of Geometry is designed to\nexchange geometry data in ASCII form.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/gis-wkt-format.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/gis-wkt-format.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (227,29,'CURRENT_TIME','Syntax:\nCURRENT_TIME, CURRENT_TIME()\n\nCURRENT_TIME and CURRENT_TIME() are synonyms for CURTIME().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (228,9,'REVOKE','Syntax:\nREVOKE priv_type [(column_list)] [, priv_type [(column_list)]] ...\n    ON [object_type] {tbl_name | * | *.* | db_name.*}\n    FROM user [, user] ...\n\nREVOKE ALL PRIVILEGES, GRANT OPTION FROM user [, user] ...\n\nThe REVOKE statement enables system administrators to revoke privileges\nfrom MySQL accounts. To use REVOKE, you must have the GRANT OPTION\nprivilege, and you must have the privileges that you are revoking.\n\nEach account is named using the same format as for the GRANT statement;\nfor example, \'jeffrey\'@\'localhost\'. If you specify only the username\npart of the account name, a hostname part of \'%\' is used. For\nadditional information about specifying account names, see [HELP\nGRANT].\n\nFor details on the levels at which privileges exist, the allowable\npriv_type values, and the syntax for specifying users and passwords,\nsee [HELP GRANT]\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/revoke.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/revoke.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (229,16,'LAST_INSERT_ID','Syntax:\nLAST_INSERT_ID(), LAST_INSERT_ID(expr)\n\nFor MySQL 5.1.12 and later, LAST_INSERT_ID() (no arguments) returns the\nfirst automatically generated value successfully inserted for an\nAUTO_INCREMENT column as a result of the most recently executed INSERT\nstatement. The value of LAST_INSERT_ID() remains unchanged if no rows\nare successfully inserted.\n\nFor example, after inserting a row that generates an AUTO_INCREMENT\nvalue, you can get the value like this:\n\nmysql> SELECT LAST_INSERT_ID();\n        -> 195\n\nIn MySQL 5.1.11 and earlier, LAST_INSERT_ID() (no arguments) returns\nthe first automatically generated value if any rows were successfully\ninserted or updated. This means that the returned value could be a\nvalue that was not successfully inserted into the table. If no rows\nwere successfully inserted, LAST_INSERT_ID() returns 0.\n\nThe value of LAST_INSERT_ID() will be consistent across all versions if\nall rows in the INSERT or UPDATE statement were successful.\n\nThe currently executing statement does not affect the value of\nLAST_INSERT_ID(). Suppose that you generate an AUTO_INCREMENT value\nwith one statement, and then refer to LAST_INSERT_ID() in a\nmultiple-row INSERT statement that inserts rows into a table with its\nown AUTO_INCREMENT column. The value of LAST_INSERT_ID() will remain\nstable in the second statement; its value for the second and later rows\nis not affected by the earlier row insertions. (However, if you mix\nreferences to LAST_INSERT_ID() and LAST_INSERT_ID(expr), the effect is\nundefined.)\n\nIf the previous statement returned an error, the value of\nLAST_INSERT_ID() is undefined. For transactional tables, if the\nstatement is rolled back due to an error, the value of LAST_INSERT_ID()\nis left undefined. For manual ROLLBACK, the value of LAST_INSERT_ID()\nis not restored to that before the transaction; it remains as it was at\nthe point of the ROLLBACK.\n\nWithin the body of a stored routine (procedure or function) or a\ntrigger, the value of LAST_INSERT_ID() changes the same way as for\nstatements executed outside the body of these kinds of objects. The\neffect of a stored routine or trigger upon the value of\nLAST_INSERT_ID() that is seen by following statements depends on the\nkind of routine:\n\no If a stored procedure executes statements that change the value of\n  LAST_INSERT_ID(), the changed value will be seen by statements that\n  follow the procedure call.\n\no For stored functions and triggers that change the value, the value is\n  restored when the function or trigger ends, so following statements\n  will not see a changed value.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/information-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/information-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (230,29,'LAST_DAY','Syntax:\nLAST_DAY(date)\n\nTakes a date or datetime value and returns the corresponding value for\nthe last day of the month. Returns NULL if the argument is invalid.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT LAST_DAY(\'2003-02-05\');\n        -> \'2003-02-28\'\nmysql> SELECT LAST_DAY(\'2004-02-05\');\n        -> \'2004-02-29\'\nmysql> SELECT LAST_DAY(\'2004-01-01 01:01:01\');\n        -> \'2004-01-31\'\nmysql> SELECT LAST_DAY(\'2003-03-32\');\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (231,21,'MEDIUMINT','MEDIUMINT[(M)] [UNSIGNED] [ZEROFILL]\n\nA medium-sized integer. The signed range is -8388608 to 8388607. The\nunsigned range is 0 to 16777215.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (232,4,'FLOOR','Syntax:\nFLOOR(X)\n\nReturns the largest integer value not greater than X.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT FLOOR(1.23);\n        -> 1\nmysql> SELECT FLOOR(-1.23);\n        -> -2\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (233,34,'RTRIM','Syntax:\nRTRIM(str)\n\nReturns the string str with trailing space characters removed.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT RTRIM(\'barbar   \');\n        -> \'barbar\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (234,4,'DEGREES','Syntax:\nDEGREES(X)\n\nReturns the argument X, converted from radians to degrees.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT DEGREES(PI());\n        -> 180\nmysql> SELECT DEGREES(PI() / 2);\n        -> 90\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (235,26,'EXPLAIN','Syntax:\nEXPLAIN tbl_name\n\nOr:\n\nEXPLAIN [EXTENDED | PARTITIONS] SELECT select_options\n\nThe EXPLAIN statement can be used either as a synonym for DESCRIBE or\nas a way to obtain information about how MySQL executes a SELECT\nstatement:\n\no EXPLAIN tbl_name is synonymous with DESCRIBE tbl_name or SHOW COLUMNS\n  FROM tbl_name.\n\no When you precede a SELECT statement with the keyword EXPLAIN, MySQL\n  displays information from the optimizer about the query execution\n  plan. That is, MySQL explains how it would process the SELECT,\n  including information about how tables are joined and in which order.\n\no EXPLAIN PARTITIONS is available beginning with MySQL 5.1.5. It is\n  useful only when examining queries involving partitioned tables. For\n  details, see\n  http://dev.mysql.com/doc/refman/5.1/en/partitioning-info.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/explain.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/explain.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (236,21,'VARCHAR','[NATIONAL] VARCHAR(M) [CHARACTER SET charset_name] [COLLATE\ncollation_name]\n\nA variable-length string. M represents the maximum column length. The\nrange of M is 0 to 65,535. (The actual maximum length of a VARCHAR is\ndetermined by the maximum row size and the character set you use. The\nmaximum effective column length is subject to a row size of 65,532\nbytes.)\n\nNote: MySQL 5.1 follows the standard SQL specification, and does not\nremove trailing spaces from VARCHAR values.\n\nVARCHAR is shorthand for CHARACTER VARYING.\n\nVARCHAR is stored with a one-byte or two-byte length prefix plus data.\nThe length prefix is two bytes if the VARCHAR column is declared with a\nlength greater than 255.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (237,34,'UNHEX','Syntax:\n\nUNHEX(str)\n\nPerforms the inverse operation of HEX(str). That is, it interprets each\npair of hexadecimal digits in the argument as a number and converts it\nto the character represented by the number. The resulting characters\nare returned as a binary string.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT UNHEX(\'4D7953514C\');\n        -> \'MySQL\'\nmysql> SELECT 0x4D7953514C;\n        -> \'MySQL\'\nmysql> SELECT UNHEX(HEX(\'string\'));\n        -> \'string\'\nmysql> SELECT HEX(UNHEX(\'1267\'));\n        -> \'1267\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (238,4,'- UNARY','Syntax:\n-\n\nUnary minus. This operator changes the sign of the argument.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/arithmetic-functions.html\n\n','mysql> SELECT - 2;\n        -> -2\n','http://dev.mysql.com/doc/refman/5.1/en/arithmetic-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (239,36,'SELECT INTO','Syntax:\nSELECT col_name[,...] INTO var_name[,...] table_expr\n\nThis SELECT syntax stores selected columns directly into variables.\nTherefore, only a single row may be retrieved.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/select-into-statement.html\n\n','SELECT id,data INTO x,y FROM test.t1 LIMIT 1;\n','http://dev.mysql.com/doc/refman/5.1/en/select-into-statement.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (240,4,'COS','Syntax:\nCOS(X)\n\nReturns the cosine of X, where X is given in radians.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT COS(PI());\n        -> -1\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (241,29,'DATE FUNCTION','Syntax:\nDATE(expr)\n\nExtracts the date part of the date or datetime expression expr.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT DATE(\'2003-12-31 01:02:03\');\n        -> \'2003-12-31\'\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (242,22,'DROP TRIGGER','Syntax:\nDROP TRIGGER [IF EXISTS] [schema_name.]trigger_name\n\nThis statement drops a trigger. The schema (database) name is optional.\nIf the schema is omitted, the trigger is dropped from the default\nschema. DROP TRIGGER was added in MySQL 5.0.2. Its use requires the\nTRIGGER privilege for the table associated with the trigger. (This\nstatement requires the SUPER privilege prior to MySQL 5.1.6.)\n\nUse IF EXISTS to prevent an error from occurring for a trigger that\ndoes not exist. A NOTE is generated for a non-existent trigger when\nusing IF EXISTS. See [HELP SHOW WARNINGS]. The IF EXISTS clause was\nadded in MySQL 5.1.14.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/drop-trigger.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/drop-trigger.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (243,26,'RESET MASTER','Syntax:\nRESET MASTER\n\nDeletes all binary logs listed in the index file, resets the binary log\nindex file to be empty, and creates a new binary log file.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/reset-master.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/reset-master.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (244,4,'TAN','Syntax:\nTAN(X)\n\nReturns the tangent of X, where X is given in radians.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT TAN(PI());\n        -> -1.2246063538224e-16\nmysql> SELECT TAN(PI()+1);\n        -> 1.5574077246549\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (245,4,'PI','Syntax:\nPI()\n\nReturns the value of π (pi). The default number of decimal places\ndisplayed is seven, but MySQL uses the full double-precision value\ninternally.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT PI();\n        -> 3.141593\nmysql> SELECT PI()+0.000000000000000000;\n        -> 3.141592653589793116\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (246,29,'WEEKOFYEAR','Syntax:\nWEEKOFYEAR(date)\n\nReturns the calendar week of the date as a number in the range from 1\nto 53. WEEKOFYEAR() is a compatibility function that is equivalent to\nWEEK(date,3).\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT WEEKOFYEAR(\'1998-02-20\');\n        -> 8\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (247,4,'/','Syntax:\n/\n\nDivision:\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/arithmetic-functions.html\n\n','mysql> SELECT 3/5;\n        -> 0.60\n','http://dev.mysql.com/doc/refman/5.1/en/arithmetic-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (248,15,'STDDEV_SAMP','Syntax:\nSTDDEV_SAMP(expr)\n\nReturns the sample standard deviation of expr (the square root of\nVAR_SAMP().\n\nSTDDEV_SAMP() returns NULL if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (249,16,'SCHEMA','Syntax:\nSCHEMA()\n\nThis function is a synonym for DATABASE().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/information-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/information-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (250,30,'MLINEFROMWKB','MLineFromWKB(wkb[,srid]), MultiLineStringFromWKB(wkb[,srid])\n\nConstructs a MULTILINESTRING value using its WKB representation and\nSRID.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/gis-wkb-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/gis-wkb-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (251,4,'LOG2','Syntax:\nLOG2(X)\n\nReturns the base-2 logarithm of X.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT LOG2(65536);\n        -> 16\nmysql> SELECT LOG2(-100);\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (252,29,'SUBTIME','Syntax:\nSUBTIME(expr1,expr2)\n\nSUBTIME() returns expr1 - expr2 expressed as a value in the same format\nas expr1. expr1 is a time or datetime expression, and expr2 is a time\nexpression.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT SUBTIME(\'1997-12-31 23:59:59.999999\',\'1 1:1:1.000002\');\n        -> \'1997-12-30 22:58:58.999997\'\nmysql> SELECT SUBTIME(\'01:00:00.999999\', \'02:00:00.999998\');\n        -> \'-00:59:59.999999\'\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (253,11,'UNCOMPRESSED_LENGTH','Syntax:\nUNCOMPRESSED_LENGTH(compressed_string)\n\nReturns the length that the compressed string had before being\ncompressed.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html\n\n','mysql> SELECT UNCOMPRESSED_LENGTH(COMPRESS(REPEAT(\'a\',30)));\n        -> 30\n','http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (254,37,'DROP TABLE','Syntax:\nDROP [TEMPORARY] TABLE [IF EXISTS]\n    tbl_name [, tbl_name] ...\n    [RESTRICT | CASCADE]\n\nDROP TABLE removes one or more tables. You must have the DROP privilege\nfor each table. All table data and the table definition are removed, so\nbe careful with this statement! If any of the tables named in the\nargument list do not exist, MySQL returns an error indicating by name\nwhich non-existing tables it was unable to drop, but it also drops all\nof the tables in the list that do exist.\n\nImportant: When a table is dropped, user privileges on the table are\nnot automatically dropped. See [HELP GRANT].\n\nNote that for a partitioned table, DROP TABLE permanently removes the\ntable definition, all of its partitions, and all of the data which was\nstored in those partitions. It also removes the partitioning definition\n(.par) file associated with the dropped table.\n\nUse IF EXISTS to prevent an error from occurring for tables that do not\nexist. A NOTE is generated for each non-existent table when using IF\nEXISTS. See [HELP SHOW WARNINGS].\n\nRESTRICT and CASCADE are allowed to make porting easier. In MySQL 5.1,\nthey do nothing.\n\nNote: DROP TABLE automatically commits the current active transaction,\nunless you use the TEMPORARY keyword.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/drop-table.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/drop-table.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (255,26,'SHOW CREATE TABLE','Syntax:\nSHOW CREATE TABLE tbl_name\n\nShows the CREATE TABLE statement that creates the given table. This\nstatement also works with views.\nSHOW CREATE TABLE quotes table and column names according to the value\nof the SQL_QUOTE_SHOW_CREATE option. See [HELP SET].\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-create-table.html\n\n','mysql> SHOW CREATE TABLE t\\G\n*************************** 1. row ***************************\n       Table: t\nCreate Table: CREATE TABLE t (\n  id INT(11) default NULL auto_increment,\n  s char(60) default NULL,\n  PRIMARY KEY (id)\n) ENGINE=MyISAM\n','http://dev.mysql.com/doc/refman/5.1/en/show-create-table.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (256,26,'DUAL','You are allowed to specify DUAL as a dummy table name in situations\nwhere no tables are referenced:\n\nmysql> SELECT 1 + 1 FROM DUAL;\n        -> 2\n\nDUAL is purely for the convenience of people who require that all\nSELECT statements should have FROM and possibly other clauses. MySQL\nmay ignore the clauses. MySQL does not require FROM DUAL if no tables\nare referenced.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/select.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/select.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (257,34,'INSTR','Syntax:\nINSTR(str,substr)\n\nReturns the position of the first occurrence of substring substr in\nstring str. This is the same as the two-argument form of LOCATE(),\nexcept that the order of the arguments is reversed.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT INSTR(\'foobarbar\', \'bar\');\n        -> 4\nmysql> SELECT INSTR(\'xbar\', \'foobar\');\n        -> 0\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (258,29,'NOW','Syntax:\nNOW()\n\nReturns the current date and time as a value in \'YYYY-MM-DD HH:MM:SS\'\nor YYYYMMDDHHMMSS format, depending on whether the function is used in\na string or numeric context. The value is expressed in the current time\nzone.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT NOW();\n        -> \'1997-12-15 23:50:26\'\nmysql> SELECT NOW() + 0;\n        -> 19971215235026\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (259,26,'SHOW ENGINES','Syntax:\nSHOW [STORAGE] ENGINES\n\nSHOW ENGINES displays status information about the server\'s storage\nengines. This is particularly useful for checking whether a storage\nengine is supported, or to see what the default engine is. SHOW TABLE\nTYPES is a deprecated synonym.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-engines.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-engines.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (260,18,'>=','Syntax:\n>=\n\nGreater than or equal:\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html\n\n','mysql> SELECT 2 >= 2;\n        -> 1\n','http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (261,4,'EXP','Syntax:\nEXP(X)\n\nReturns the value of e (the base of natural logarithms) raised to the\npower of X.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT EXP(2);\n        -> 7.3890560989307\nmysql> SELECT EXP(-2);\n        -> 0.13533528323661\nmysql> SELECT EXP(0);\n        -> 1\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (262,11,'SHA','Syntax:\nSHA1(str), SHA(str)\n\nCalculates an SHA-1 160-bit checksum for the string, as described in\nRFC 3174 (Secure Hash Algorithm). The value is returned as a binary\nstring of 40 hex digits, or NULL if the argument was NULL. One of the\npossible uses for this function is as a hash key. You can also use it\nas a cryptographic function for storing passwords. SHA() is synonymous\nwith SHA1().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html\n\n','mysql> SELECT SHA1(\'abc\');\n        -> \'a9993e364706816aba3e25717850c26c9cd0d89d\'\n','http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (263,21,'LONGBLOB','LONGBLOB\n\nA BLOB column with a maximum length of 4,294,967,295 or 4GB (232 - 1)\nbytes. The maximum effective (permitted) length of LONGBLOB columns\ndepends on the configured maximum packet size in the client/server\nprotocol and available memory.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (264,12,'POINTN','PointN(ls,N)\n\nReturns the N-th Point in the Linestring value ls. Points are numbered\nbeginning with 1.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/linestring-property-functions.html\n\n','mysql> SET @ls = \'LineString(1 1,2 2,3 3)\';\nmysql> SELECT AsText(PointN(GeomFromText(@ls),2));\n+-------------------------------------+\n| AsText(PointN(GeomFromText(@ls),2)) |\n+-------------------------------------+\n| POINT(2 2)                          |\n+-------------------------------------+\n','http://dev.mysql.com/doc/refman/5.1/en/linestring-property-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (265,21,'YEAR DATA TYPE','YEAR[(2|4)]\n\nA year in two-digit or four-digit format. The default is four-digit\nformat. In four-digit format, the allowable values are 1901 to 2155,\nand 0000. In two-digit format, the allowable values are 70 to 69,\nrepresenting years from 1970 to 2069. MySQL displays YEAR values in\nYYYY format, but allows you to assign values to YEAR columns using\neither strings or numbers.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (266,15,'SUM','Syntax:\nSUM([DISTINCT] expr)\n\nReturns the sum of expr. If the return set has no rows, SUM() returns\nNULL. The DISTINCT keyword can be used in MySQL 5.1 to sum only the\ndistinct values of expr.\n\nSUM() returns NULL if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (267,34,'OCT','Syntax:\nOCT(N)\n\nReturns a string representation of the octal value of N, where N is a\nlonglong (BIGINT) number. This is equivalent to CONV(N,10,8). Returns\nNULL if N is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT OCT(12);\n        -> \'14\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (268,29,'SYSDATE','Syntax:\nSYSDATE()\n\nReturns the current date and time as a value in \'YYYY-MM-DD HH:MM:SS\'\nor YYYYMMDDHHMMSS format, depending on whether the function is used in\na string or numeric context.\n\nSYSDATE() returns the time at which it executes. This differs from the\nbehavior for NOW(), which returns a constant time that indicates the\ntime at which the statement began to execute. (Within a stored routine\nor trigger, NOW() returns the time at which the routine or triggering\nstatement began to execute.)\n\nmysql> SELECT NOW(), SLEEP(2), NOW();\n+---------------------+----------+---------------------+\n| NOW()               | SLEEP(2) | NOW()               |\n+---------------------+----------+---------------------+\n| 2006-04-12 13:47:36 |        0 | 2006-04-12 13:47:36 |\n+---------------------+----------+---------------------+\n\nmysql> SELECT SYSDATE(), SLEEP(2), SYSDATE();\n+---------------------+----------+---------------------+\n| SYSDATE()           | SLEEP(2) | SYSDATE()           |\n+---------------------+----------+---------------------+\n| 2006-04-12 13:47:44 |        0 | 2006-04-12 13:47:46 |\n+---------------------+----------+---------------------+\n\nIn addition, the SET TIMESTAMP statement affects the value returned by\nNOW() but not by SYSDATE(). This means that timestamp settings in the\nbinary log have no effect on invocations of SYSDATE().\n\nBecause SYSDATE() can return different values even within the same\nstatement, and is not affected by SET TIMESTAMP, it is\nnon-deterministic and therefore unsafe for replication if\nstatement-based binary logging is used. If that is a problem, you can\nuse row-based logging, or start the server with the --sysdate-is-now\noption to cause SYSDATE() to be an alias for NOW().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (269,5,'UNINSTALL PLUGIN','Syntax:\nUNINSTALL PLUGIN plugin_name\n\nThis statement removes an installed plugin. You cannot uninstall a\nplugin if any table that uses it is open.\n\nplugin_name must be the name of some plugin that is listed in the\nmysql.plugin table. The server executes the plugin\'s deinitialization\nfunction and removes the row for the plugin from the mysql.plugin\ntable, so that subsequent server restarts will not load and initialize\nthe plugin. UNINSTALL PLUGIN does not remove the plugin\'s shared\nlibrary file.\n\nTo use UNINSTALL PLUGIN, you must have the DELETE privilege for the\nmysql.plugin table.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/uninstall-plugin.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/uninstall-plugin.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (270,30,'ASBINARY','AsBinary(g)\n\nConverts a value in internal geometry format to its WKB representation\nand returns the binary result.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/functions-to-convert-geometries-between-formats.html\n\n','SELECT AsBinary(g) FROM geom;\n','http://dev.mysql.com/doc/refman/5.1/en/functions-to-convert-geometries-between-formats.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (271,34,'REPEAT FUNCTION','Syntax:\nREPEAT(str,count)\n\nReturns a string consisting of the string str repeated count times. If\ncount is less than 1, returns an empty string. Returns NULL if str or\ncount are NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT REPEAT(\'MySQL\', 3);\n        -> \'MySQLMySQLMySQL\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (272,26,'SHOW TABLES','Syntax:\nSHOW [FULL] TABLES [FROM db_name] [LIKE \'pattern\']\n\nSHOW TABLES lists the non-TEMPORARY tables in a given database. You can\nalso get this list using the mysqlshow db_name command.\n\nThis statement also lists any views in the database. The FULL modifier\nis supported such that SHOW FULL TABLES displays a second output\ncolumn. Values for the second column are BASE TABLE for a table and\nVIEW for a view.\n\nNote: If you have no privileges for a table, the table does not show up\nin the output from SHOW TABLES or mysqlshow db_name.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-tables.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-tables.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (273,29,'MAKEDATE','Syntax:\nMAKEDATE(year,dayofyear)\n\nReturns a date, given year and day-of-year values. dayofyear must be\ngreater than 0 or the result is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT MAKEDATE(2001,31), MAKEDATE(2001,32);\n        -> \'2001-01-31\', \'2001-02-01\'\nmysql> SELECT MAKEDATE(2001,365), MAKEDATE(2004,365);\n        -> \'2001-12-31\', \'2004-12-30\'\nmysql> SELECT MAKEDATE(2001,0);\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (274,34,'BINARY OPERATOR','Syntax:\nBINARY\n\nThe BINARY operator casts the string following it to a binary string.\nThis is an easy way to force a column comparison to be done byte by\nbyte rather than character by character. This causes the comparison to\nbe case sensitive even if the column isn\'t defined as BINARY or BLOB.\nBINARY also causes trailing spaces to be significant.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/cast-functions.html\n\n','mysql> SELECT \'a\' = \'A\';\n        -> 1\nmysql> SELECT BINARY \'a\' = \'A\';\n        -> 0\nmysql> SELECT \'a\' = \'a \';\n        -> 1\nmysql> SELECT BINARY \'a\' = \'a \';\n        -> 0\n','http://dev.mysql.com/doc/refman/5.1/en/cast-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (275,6,'MBROVERLAPS','MBROverlaps(g1,g2)\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of\nthe two geometries g1 and g2 overlap. The term spatially overlaps is\nused if two geometries intersect and their intersection results in a\ngeometry of the same dimension but not equal to either of the given\ngeometries.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/relations-on-geometry-mbr.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/relations-on-geometry-mbr.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (276,34,'SOUNDEX','Syntax:\nSOUNDEX(str)\n\nReturns a soundex string from str. Two strings that sound almost the\nsame should have identical soundex strings. A standard soundex string\nis four characters long, but the SOUNDEX() function returns an\narbitrarily long string. You can use SUBSTRING() on the result to get a\nstandard soundex string. All non-alphabetic characters in str are\nignored. All international alphabetic characters outside the A-Z range\nare treated as vowels.\n\nImportant: When using SOUNDEX(), you should be aware of the following\nlimitations:\n\no This function, as currently implemented, is intended to work well\n  with strings that are in the English language only. Strings in other\n  languages may not produce reliable results.\n\no This function is not guaranteed to provide consistent results with\n  strings that use multi-byte character sets, including utf-8.\n\n  We hope to remove these limitations in a future release. See\n  Bug#22638 (http://bugs.mysql.com/22638) for more information.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT SOUNDEX(\'Hello\');\n        -> \'H400\'\nmysql> SELECT SOUNDEX(\'Quadratically\');\n        -> \'Q36324\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (277,6,'MBRTOUCHES','MBRTouches(g1,g2)\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of\nthe two geometries g1 and g2 touch. Two geometries spatially touch if\nthe interiors of the geometries do not intersect, but the boundary of\none of the geometries intersects either the boundary or the interior of\nthe other.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/relations-on-geometry-mbr.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/relations-on-geometry-mbr.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (278,36,'CREATE PROCEDURE','Syntax:\nCREATE\n    [DEFINER = { user | CURRENT_USER }]\n    PROCEDURE sp_name ([proc_parameter[,...]])\n    [characteristic ...] routine_body\n\nCREATE\n    [DEFINER = { user | CURRENT_USER }]\n    FUNCTION sp_name ([func_parameter[,...]])\n    RETURNS type\n    [characteristic ...] routine_body\n    \nproc_parameter:\n    [ IN | OUT | INOUT ] param_name type\n    \nfunc_parameter:\n    param_name type\n\ntype:\n    Any valid MySQL data type\n\ncharacteristic:\n    LANGUAGE SQL\n  | [NOT] DETERMINISTIC\n  | { CONTAINS SQL | NO SQL | READS SQL DATA | MODIFIES SQL DATA }\n  | SQL SECURITY { DEFINER | INVOKER }\n  | COMMENT \'string\'\n\nroutine_body:\n    Valid SQL procedure statement\n\nThese statements create stored routines. To use them, it is necessary\nto have the CREATE ROUTINE privilege. If binary logging is enabled, the\nCREATE FUNCTION statement might may also require the SUPER privilege,\nas described in\nhttp://dev.mysql.com/doc/refman/5.1/en/stored-procedure-logging.html.\nMySQL automatically grants the ALTER ROUTINE and EXECUTE privileges to\nthe routine creator.\n\nBy default, the routine is associated with the default database. To\nassociate the routine explicitly with a given database, specify the\nname as db_name.sp_name when you create it.\n\nIf the routine name is the same as the name of a built-in SQL function,\nyou must use a space between the name and the following parenthesis\nwhen defining the routine, or a syntax error occurs. This is also true\nwhen you invoke the routine later. For this reason, we suggest that it\nis better to avoid re-using the names of existing SQL functions for\nyour own stored routines.\n\nThe IGNORE_SPACE SQL mode applies to built-in functions, not to stored\nroutines. it is always allowable to have spaces after a routine name,\nregardless of whether IGNORE_SPACE is enabled.\n\nThe parameter list enclosed within parentheses must always be present.\nIf there are no parameters, an empty parameter list of () should be\nused.\n\nEach parameter can be declared to use any valid data type, except that\nthe COLLATE attribute cannot be used.\n\nEach parameter is an IN parameter by default. To specify otherwise for\na parameter, use the keyword OUT or INOUT before the parameter name.\n\nNote: Specifying a parameter as IN, OUT, or INOUT is valid only for a\nPROCEDURE. (FUNCTION parameters are always regarded as IN parameters.)\n\nAn IN parameter passes a value into a procedure. The procedure might\nmodify the value, but the modification is not visible to the caller\nwhen the procedure returns. An OUT parameter passes a value from the\nprocedure back to the caller. Its initial value is NULL within the\nprocedure, and its value is visible to the caller when the procedure\nreturns. An INOUT parameter is initialized by the caller, can be\nmodified by the procedure, and any change made by the procedure is\nvisible to the caller when the procedure returns.\n\nFor each OUT or INOUT parameter, pass a user-defined variable so that\nyou can obtain its value when the procedure returns. (For an example,\nsee [HELP CALL].) If you are calling the procedure from within another\nstored procedure or function, you can also pass a routine parameter or\nlocal routine variable as an IN or INOUT parameter.\n\nThe RETURNS clause may be specified only for a FUNCTION, for which it\nis mandatory. It indicates the return type of the function, and the\nfunction body must contain a RETURN value statement. If the RETURN\nstatement returns a value of a different type, the value is coerced to\nthe proper type. For example, if a function specifies an ENUM or SET\nvalue in the RETURNS clause, but the RETURN statement returns an\ninteger, the value returned from the function is the string for the\ncorresponding ENUM member of set of SET members.\n\nThe routine_body consists of a valid SQL procedure statement. This can\nbe a simple statement such as SELECT or INSERT, or it can be a compound\nstatement written using BEGIN and END. Compound statement syntax is\ndescribed in [HELP BEGIN END]. Compound statements can contain\ndeclarations, loops, and other control structure statements. The syntax\nfor these statements is described later in this chapter. See, for\nexample, http://dev.mysql.com/doc/refman/5.1/en/declare.html, and [HELP\nIF statement]. Some statements are not allowed in stored routines; see\nhttp://dev.mysql.com/doc/refman/5.1/en/routine-restrictions.html.\n\nMySQL stores the sql_mode system variable setting that is in effect at\nthe time a routine is created, and always executes the routine with\nthis setting in force, regardless of the current server SQL mode.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/create-procedure.html\n\n','mysql> delimiter //\n\nmysql> CREATE PROCEDURE simpleproc (OUT param1 INT)\n    -> BEGIN\n    ->   SELECT COUNT(*) INTO param1 FROM t;\n    -> END;\n    -> //\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> delimiter ;\n\nmysql> CALL simpleproc(@a);\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> SELECT @a;\n+------+\n| @a   |\n+------+\n| 3    |\n+------+\n1 row in set (0.00 sec)\n','http://dev.mysql.com/doc/refman/5.1/en/create-procedure.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (279,26,'INSERT SELECT','Syntax:\nINSERT [LOW_PRIORITY | HIGH_PRIORITY] [IGNORE]\n    [INTO] tbl_name [(col_name,...)]\n    SELECT ...\n    [ ON DUPLICATE KEY UPDATE col_name=expr, ... ]\n\nWith INSERT ... SELECT, you can quickly insert many rows into a table\nfrom one or many tables. For example:\n\nINSERT INTO tbl_temp2 (fld_id)\n  SELECT tbl_temp1.fld_order_id\n  FROM tbl_temp1 WHERE tbl_temp1.fld_order_id > 100;\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/insert-select.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/insert-select.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (280,21,'VARBINARY','VARBINARY(M)\n\nThe VARBINARY type is similar to the VARCHAR type, but stores binary\nbyte strings rather than non-binary character strings.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (281,26,'LOAD INDEX','Syntax:\nLOAD INDEX INTO CACHE\n  tbl_index_list [, tbl_index_list] ...\n\ntbl_index_list:\n  tbl_name\n    [[INDEX|KEY] (index_name[, index_name] ...)]\n    [IGNORE LEAVES]\n\nThe LOAD INDEX INTO CACHE statement preloads a table index into the key\ncache to which it has been assigned by an explicit CACHE INDEX\nstatement, or into the default key cache otherwise. LOAD INDEX INTO\nCACHE is used only for MyISAM tables.\n\nThe IGNORE LEAVES modifier causes only blocks for the non-leaf nodes of\nthe index to be preloaded.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/load-index.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/load-index.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (282,26,'UNION','Syntax:\nSELECT ...\nUNION [ALL | DISTINCT] SELECT ...\n[UNION [ALL | DISTINCT] SELECT ...]\n\nUNION is used to combine the result from multiple SELECT statements\ninto a single result set.\n\nThe column names from the first SELECT statement are used as the column\nnames for the results returned. Selected columns listed in\ncorresponding positions of each SELECT statement should have the same\ndata type. (For example, the first column selected by the first\nstatement should have the same type as the first column selected by the\nother statements.)\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/union.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/union.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (283,29,'TO_DAYS','Syntax:\nTO_DAYS(date)\n\nGiven a date date, returns a day number (the number of days since year\n0).\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT TO_DAYS(950501);\n        -> 728779\nmysql> SELECT TO_DAYS(\'1997-10-07\');\n        -> 729669\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (284,34,'NOT REGEXP','Syntax:\nexpr NOT REGEXP pat, expr NOT RLIKE pat\n\nThis is the same as NOT (expr REGEXP pat).\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-comparison-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-comparison-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (285,26,'SHOW INDEX','Syntax:\nSHOW INDEX FROM tbl_name [FROM db_name]\n\nSHOW INDEX returns table index information. The format resembles that\nof the SQLStatistics call in ODBC.\nYou can use db_name.tbl_name as an alternative to the tbl_name FROM\ndb_name syntax. These two statements are equivalent:\n\nSHOW INDEX FROM mytable FROM mydb;\nSHOW INDEX FROM mydb.mytable;\n\nSHOW KEYS is a synonym for SHOW INDEX. You can also list a table\'s\nindexes with the mysqlshow -k db_name tbl_name command.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-index.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-index.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (286,26,'SHOW CREATE DATABASE','Syntax:\nSHOW CREATE {DATABASE | SCHEMA} db_name\n\nShows the CREATE DATABASE statement that creates the given database.\nSHOW CREATE SCHEMA is a synonym for SHOW CREATE DATABASE.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-create-database.html\n\n','mysql> SHOW CREATE DATABASE test\\G\n*************************** 1. row ***************************\n       Database: test\nCreate Database: CREATE DATABASE `test`\n                 /*!40100 DEFAULT CHARACTER SET latin1 */\n\nmysql> SHOW CREATE SCHEMA test\\G\n*************************** 1. row ***************************\n       Database: test\nCreate Database: CREATE DATABASE `test`\n                 /*!40100 DEFAULT CHARACTER SET latin1 */\n','http://dev.mysql.com/doc/refman/5.1/en/show-create-database.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (287,36,'LEAVE','Syntax:\nLEAVE label\n\nThis statement is used to exit any labeled flow control construct. It\ncan be used within BEGIN ... END or loop constructs (LOOP, REPEAT,\nWHILE).\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/leave-statement.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/leave-statement.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (288,18,'NOT IN','Syntax:\nexpr NOT IN (value,...)\n\nThis is the same as NOT (expr IN (value,...)).\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (289,13,'!','Syntax:\nNOT, !\n\nLogical NOT. Evaluates to 1 if the operand is 0, to 0 if the operand is\nnon-zero, and NOT NULL returns NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/logical-operators.html\n\n','mysql> SELECT NOT 10;\n        -> 0\nmysql> SELECT NOT 0;\n        -> 1\nmysql> SELECT NOT NULL;\n        -> NULL\nmysql> SELECT ! (1+1);\n        -> 0\nmysql> SELECT ! 1+1;\n        -> 1\n','http://dev.mysql.com/doc/refman/5.1/en/logical-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (290,36,'DECLARE HANDLER','Syntax:\nDECLARE handler_type HANDLER FOR condition_value[,...] statement\n\nhandler_type:\n    CONTINUE\n  | EXIT\n  | UNDO\n\ncondition_value:\n    SQLSTATE [VALUE] sqlstate_value\n  | condition_name\n  | SQLWARNING\n  | NOT FOUND\n  | SQLEXCEPTION\n  | mysql_error_code\n\nThe DECLARE ... HANDLER statement specifies handlers that each may deal\nwith one or more conditions. If one of these conditions occurs, the\nspecified statement is executed. statement can be a simple statement\n(for example, SET var_name = value), or it can be a compound statement\nwritten using BEGIN and END (see [HELP BEGIN END]).\n\nFor a CONTINUE handler, execution of the current routine continues\nafter execution of the handler statement. For an EXIT handler,\nexecution terminates for the BEGIN ... END compound statement in which\nthe handler is declared. (This is true even if the condition occurs in\nan inner block.) The UNDO handler type statement is not yet supported.\n\nIf a condition occurs for which no handler has been declared, the\ndefault action is EXIT.\n\nA condition_value can be any of the following values:\n\no An SQLSTATE value or a MySQL error code.\n\no A condition name previously specified with DECLARE ... CONDITION. See\n  [HELP DECLARE CONDITION].\n\no SQLWARNING is shorthand for all SQLSTATE codes that begin with 01.\n\no NOT FOUND is shorthand for all SQLSTATE codes that begin with 02.\n\no SQLEXCEPTION is shorthand for all SQLSTATE codes not caught by\n  SQLWARNING or NOT FOUND.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/declare-handlers.html\n\n','mysql> CREATE TABLE test.t (s1 int,primary key (s1));\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> delimiter //\n\nmysql> CREATE PROCEDURE handlerdemo ()\n    -> BEGIN\n    ->   DECLARE CONTINUE HANDLER FOR SQLSTATE \'23000\' SET @x2 = 1;\n    ->   SET @x = 1;\n    ->   INSERT INTO test.t VALUES (1);\n    ->   SET @x = 2;\n    ->   INSERT INTO test.t VALUES (1);\n    ->   SET @x = 3;\n    -> END;\n    -> //\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> CALL handlerdemo()//\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> SELECT @x//\n    +------+\n    | @x   |\n    +------+\n    | 3    |\n    +------+\n    1 row in set (0.00 sec)\n','http://dev.mysql.com/doc/refman/5.1/en/declare-handlers.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (291,21,'DOUBLE','DOUBLE[(M,D)] [UNSIGNED] [ZEROFILL]\n\nA normal-size (double-precision) floating-point number. Allowable\nvalues are -1.7976931348623157E+308 to -2.2250738585072014E-308, 0, and\n2.2250738585072014E-308 to 1.7976931348623157E+308. These are the\ntheoretical limits, based on the IEEE standard. The actual range might\nbe slightly smaller depending on your hardware or operating system.\n\nM is the total number of digits and D is the number of digits following\nthe decimal point. If M and D are omitted, values are stored to the\nlimits allowed by the hardware. A double-precision floating-point\nnumber is accurate to approximately 15 decimal places.\n\nUNSIGNED, if specified, disallows negative values.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (292,21,'TIME','TIME\n\nA time. The range is \'-838:59:59\' to \'838:59:59\'. MySQL displays TIME\nvalues in \'HH:MM:SS\' format, but allows assignment of values to TIME\ncolumns using either strings or numbers.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (293,13,'&&','Syntax:\nAND, &&\n\nLogical AND. Evaluates to 1 if all operands are non-zero and not NULL,\nto 0 if one or more operands are 0, otherwise NULL is returned.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/logical-operators.html\n\n','mysql> SELECT 1 && 1;\n        -> 1\nmysql> SELECT 1 && 0;\n        -> 0\nmysql> SELECT 1 && NULL;\n        -> NULL\nmysql> SELECT 0 && NULL;\n        -> 0\nmysql> SELECT NULL && 0;\n        -> 0\n','http://dev.mysql.com/doc/refman/5.1/en/logical-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (294,10,'X','X(p)\n\nReturns the X-coordinate value for the point p as a double-precision\nnumber.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/point-property-functions.html\n\n','mysql> SET @pt = \'Point(56.7 53.34)\';\nmysql> SELECT X(GeomFromText(@pt));\n+----------------------+\n| X(GeomFromText(@pt)) |\n+----------------------+\n|                 56.7 |\n+----------------------+\n','http://dev.mysql.com/doc/refman/5.1/en/point-property-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (295,16,'FOUND_ROWS','Syntax:\nFOUND_ROWS()\n\nA SELECT statement may include a LIMIT clause to restrict the number of\nrows the server returns to the client. In some cases, it is desirable\nto know how many rows the statement would have returned without the\nLIMIT, but without running the statement again. To obtain this row\ncount, include a SQL_CALC_FOUND_ROWS option in the SELECT statement,\nand then invoke FOUND_ROWS() afterward:\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/information-functions.html\n\n','mysql> SELECT SQL_CALC_FOUND_ROWS * FROM tbl_name\n    -> WHERE id > 100 LIMIT 10;\nmysql> SELECT FOUND_ROWS();\n','http://dev.mysql.com/doc/refman/5.1/en/information-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (296,16,'SYSTEM_USER','Syntax:\nSYSTEM_USER()\n\nSYSTEM_USER() is a synonym for USER().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/information-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/information-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (297,27,'CROSSES','Crosses(g1,g2)\n\nReturns 1 if g1 spatially crosses g2. Returns NULL if g1 is a Polygon\nor a MultiPolygon, or if g2 is a Point or a MultiPoint. Otherwise,\nreturns 0.\n\nThe term spatially crosses denotes a spatial relation between two given\ngeometries that has the following properties:\n\no The two geometries intersect\n\no Their intersection results in a geometry that has a dimension that is\n  one less than the maximum dimension of the two given geometries\n\no Their intersection is not equal to either of the two given geometries\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/functions-that-test-spatial-relationships-between-geometries.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/functions-that-test-spatial-relationships-between-geometries.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (298,26,'TRUNCATE TABLE','Syntax:\nTRUNCATE [TABLE] tbl_name\n\nTRUNCATE TABLE empties a table completely. Logically, this is\nequivalent to a DELETE statement that deletes all rows, but there are\npractical differences under some circumstances.\n\nFor InnoDB tables, TRUNCATE TABLE is mapped to DELETE if there are\nforeign key constraints that reference the table; otherwise fast\ntruncation (dropping and re-creating the table) is used. The\nAUTO_INCREMENT counter is reset by TRUNCATE TABLE, regardless of\nwhether there is a foreign key constraint.\n\nFor other storage engines, TRUNCATE TABLE differs from DELETE in the\nfollowing ways in MySQL 5.1:\n\no Truncate operations drop and re-create the table, which is much\n  faster than deleting rows one by one.\n\no Truncate operations are not transaction-safe; an error occurs when\n  attempting one in the course of an active transaction or active table\n  lock.\n\no The number of deleted rows is not returned.\n\no As long as the table format file tbl_name.frm is valid, the table can\n  be re-created as an empty table with TRUNCATE TABLE, even if the data\n  or index files have become corrupted.\n\no The table handler does not remember the last used AUTO_INCREMENT\n  value, but starts counting from the beginning. This is true even for\n  MyISAM and InnoDB, which normally do not reuse sequence values.\n\no When used with partitioned tables, TRUNCATE TABLE preserves the\n  partitioning; that is, the data and index files are dropped and\n  re-created, while the partition definitions (.par) file is\n  unaffected.\n\no Since truncation of a table does not make any use of DELETE, the\n  TRUNCATE statement does not invoke ON DELETE triggers.\n\nTRUNCATE TABLE requires the DROP privilege as of MySQL 5.1.16. (Before\n5.1.16, it requires the DELETE privilege.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/truncate.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/truncate.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (299,15,'BIT_XOR','Syntax:\nBIT_XOR(expr)\n\nReturns the bitwise XOR of all bits in expr. The calculation is\nperformed with 64-bit (BIGINT) precision.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (300,29,'CURRENT_DATE','Syntax:\nCURRENT_DATE, CURRENT_DATE()\n\nCURRENT_DATE and CURRENT_DATE() are synonyms for CURDATE().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (301,2,'AREA','Area(poly)\n\nReturns as a double-precision number the area of the Polygon value\npoly, as measured in its spatial reference system.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/polygon-property-functions.html\n\n','mysql> SET @poly = \'Polygon((0 0,0 3,3 0,0 0),(1 1,1 2,2 1,1 1))\';\nmysql> SELECT Area(GeomFromText(@poly));\n+---------------------------+\n| Area(GeomFromText(@poly)) |\n+---------------------------+\n|                         4 |\n+---------------------------+\n','http://dev.mysql.com/doc/refman/5.1/en/polygon-property-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (302,26,'START SLAVE','Syntax:\nSTART SLAVE [thread_type [, thread_type] ... ]\nSTART SLAVE [SQL_THREAD] UNTIL\n    MASTER_LOG_FILE = \'log_name\', MASTER_LOG_POS = log_pos\nSTART SLAVE [SQL_THREAD] UNTIL\n    RELAY_LOG_FILE = \'log_name\', RELAY_LOG_POS = log_pos\n\nthread_type: IO_THREAD | SQL_THREAD\n\nSTART SLAVE with no thread_type options starts both of the slave\nthreads. The I/O thread reads queries from the master server and stores\nthem in the relay log. The SQL thread reads the relay log and executes\nthe queries. START SLAVE requires the SUPER privilege.\n\nIf START SLAVE succeeds in starting the slave threads, it returns\nwithout any error. However, even in that case, it might be that the\nslave threads start and then later stop (for example, because they do\nnot manage to connect to the master or read its binary logs, or some\nother problem). START SLAVE does not warn you about this. You must\ncheck the slave\'s error log for error messages generated by the slave\nthreads, or check that they are running satisfactorily with SHOW SLAVE\nSTATUS.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/start-slave.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/start-slave.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (303,36,'BEGIN END','Syntax:\n[begin_label:] BEGIN\n    [statement_list]\nEND [end_label]\n\nBEGIN ... END syntax is used for writing compound statements, which can\nappear within stored routines and triggers. A compound statement can\ncontain multiple statements, enclosed by the BEGIN and END keywords.\nstatement_list represents a list of one or more statements. Each\nstatement within statement_list must be terminated by a semicolon (;)\nstatement delimiter. Note that statement_list is optional, which means\nthat the empty compound statement (BEGIN END) is legal.\n\nUse of multiple statements requires that a client is able to send\nstatement strings containing the ; statement delimiter. This is handled\nin the mysql command-line client with the delimiter command. Changing\nthe ; end-of-statement delimiter (for example, to //) allows ; to be\nused in a routine body. For an example, see [HELP CREATE PROCEDURE].\n\nA compound statement can be labeled. end_label cannot be given unless\nbegin_label also is present. If both are present, they must be the\nsame.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/begin-end.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/begin-end.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (304,26,'FLUSH','Syntax:\nFLUSH [LOCAL | NO_WRITE_TO_BINLOG]\n    flush_option [, flush_option] ...\n\nThe FLUSH statement clears or reloads various internal caches used by\nMySQL. To execute FLUSH, you must have the RELOAD privilege.\n\nThe RESET statement is similar to FLUSH. See [HELP RESET].\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/flush.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/flush.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (305,26,'SHOW PROCEDURE STATUS','Syntax:\nSHOW {PROCEDURE | FUNCTION} STATUS [LIKE \'pattern\']\n\nThese statements are MySQL extensions. They return characteristics of\nroutines, such as the database, name, type, creator, and creation and\nmodification dates. If no pattern is specified, the information for all\nstored procedures or all stored functions is listed, depending on which\nstatement you use.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-procedure-status.html\n\n','mysql> SHOW FUNCTION STATUS LIKE \'hello\'\\G\n*************************** 1. row ***************************\n           Db: test\n         Name: hello\n         Type: FUNCTION\n      Definer: testuser@localhost\n     Modified: 2004-08-03 15:29:37\n      Created: 2004-08-03 15:29:37\nSecurity_type: DEFINER\n      Comment:\n','http://dev.mysql.com/doc/refman/5.1/en/show-procedure-status.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (306,26,'SHOW WARNINGS','Syntax:\nSHOW WARNINGS [LIMIT [offset,] row_count]\nSHOW COUNT(*) WARNINGS\n\nSHOW WARNINGS shows the error, warning, and note messages that resulted\nfrom the last statement that generated messages, or nothing if the last\nstatement that used a table generated no messages. A related statement,\nSHOW ERRORS, shows only the errors. See [HELP SHOW ERRORS].\n\nThe list of messages is reset for each new statement that uses a table.\n\nThe SHOW COUNT(*) WARNINGS statement displays the total number of\nerrors, warnings, and notes. You can also retrieve this number from the\nwarning_count variable:\n\nSHOW COUNT(*) WARNINGS;\nSELECT @@warning_count;\n\nThe value of warning_count might be greater than the number of messages\ndisplayed by SHOW WARNINGS if the max_error_count system variable is\nset so low that not all messages are stored. An example shown later in\nthis section demonstrates how this can happen.\n\nThe LIMIT clause has the same syntax as for the SELECT statement. See\n[HELP SELECT].\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-warnings.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-warnings.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (307,25,'DESCRIBE','Syntax:\n{DESCRIBE | DESC} tbl_name [col_name | wild]\n\nDESCRIBE provides information about the columns in a table. It is a\nshortcut for SHOW COLUMNS FROM. These statements also display\ninformation for views. (See [HELP SHOW COLUMNS].)\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/describe.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/describe.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (308,9,'DROP USER','Syntax:\nDROP USER user [, user] ...\n\nThe DROP USER statement removes one or more MySQL accounts. It removes\nprivilege rows for the account from all grant tables. To use this\nstatement, you must have the global CREATE USER privilege or the DELETE\nprivilege for the mysql database. Each account is named using the same\nformat as for the GRANT statement; for example, \'jeffrey\'@\'localhost\'.\nIf you specify only the username part of the account name, a hostname\npart of \'%\' is used. For additional information about specifying\naccount names, see [HELP GRANT].\n\nWith DROP USER, you can remove an account and its privileges as\nfollows:\n\nDROP USER user;\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/drop-user.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/drop-user.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (309,15,'STDDEV_POP','Syntax:\nSTDDEV_POP(expr)\n\nReturns the population standard deviation of expr (the square root of\nVAR_POP()). You can also use STD() or STDDEV(), which are equivalent\nbut not standard SQL.\n\nSTDDEV_POP() returns NULL if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (310,26,'SHOW CHARACTER SET','Syntax:\nSHOW CHARACTER SET [LIKE \'pattern\']\n\nThe SHOW CHARACTER SET statement shows all available character sets. It\ntakes an optional LIKE clause that indicates which character set names\nto match. For example:\n\nmysql> SHOW CHARACTER SET LIKE \'latin%\';\n+---------+-----------------------------+-------------------+--------+\n| Charset | Description                 | Default collation | Maxlen |\n+---------+-----------------------------+-------------------+--------+\n| latin1  | cp1252 West European        | latin1_swedish_ci |      1 |\n| latin2  | ISO 8859-2 Central European | latin2_general_ci |      1 |\n| latin5  | ISO 8859-9 Turkish          | latin5_turkish_ci |      1 |\n| latin7  | ISO 8859-13 Baltic          | latin7_general_ci |      1 |\n+---------+-----------------------------+-------------------+--------+\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-character-set.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-character-set.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (311,34,'SUBSTRING','Syntax:\nSUBSTRING(str,pos), SUBSTRING(str FROM pos), SUBSTRING(str,pos,len),\nSUBSTRING(str FROM pos FOR len)\n\nThe forms without a len argument return a substring from string str\nstarting at position pos. The forms with a len argument return a\nsubstring len characters long from string str, starting at position\npos. The forms that use FROM are standard SQL syntax. It is also\npossible to use a negative value for pos. In this case, the beginning\nof the substring is pos characters from the end of the string, rather\nthan the beginning. A negative value may be used for pos in any of the\nforms of this function.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT SUBSTRING(\'Quadratically\',5);\n        -> \'ratically\'\nmysql> SELECT SUBSTRING(\'foobarbar\' FROM 4);\n        -> \'barbar\'\nmysql> SELECT SUBSTRING(\'Quadratically\',5,6);\n        -> \'ratica\'        \nmysql> SELECT SUBSTRING(\'Sakila\', -3);\n        -> \'ila\'        \nmysql> SELECT SUBSTRING(\'Sakila\', -5, 3);\n        -> \'aki\'\nmysql> SELECT SUBSTRING(\'Sakila\' FROM -4 FOR 2);\n        -> \'ki\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (312,33,'ISEMPTY','IsEmpty(g)\n\nReturns 1 if the geometry value g is the empty geometry, 0 if it is not\nempty, and -1 if the argument is NULL. If the geometry is empty, it\nrepresents the empty point set.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/general-geometry-property-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/general-geometry-property-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (313,34,'LTRIM','Syntax:\nLTRIM(str)\n\nReturns the string str with leading space characters removed.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT LTRIM(\'  barbar\');\n        -> \'barbar\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (314,27,'INTERSECTS','Intersects(g1,g2)\n\nReturns 1 or 0 to indicate whether g1 spatially intersects g2.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/functions-that-test-spatial-relationships-between-geometries.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/functions-that-test-spatial-relationships-between-geometries.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (315,36,'CALL','Syntax:\nCALL sp_name([parameter[,...]])\nCALL sp_name[()]\n\nThe CALL statement invokes a procedure that was defined previously with\nCREATE PROCEDURE.\n\nCALL can pass back values to its caller using parameters that are\ndeclared as OUT or INOUT parameters. It also "returns" the number of\nrows affected, which a client program can obtain at the SQL level by\ncalling the ROW_COUNT() function and from C by calling the\nmysql_affected_rows() C API function.\n\nAs of MySQL 5.1.13, stored procedures that take no arguments now can be\ninvoked without parentheses. That is, CALL p() and CALL p are\nequivalent.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/call.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/call.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (316,6,'MBRDISJOINT','MBRDisjoint(g1,g2)\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of\nthe two geometries g1 and g2 are disjoint (do not intersect).\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/relations-on-geometry-mbr.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/relations-on-geometry-mbr.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (317,14,'VALUES','Syntax:\nVALUES(col_name)\n\nIn an INSERT ... ON DUPLICATE KEY UPDATE statement, you can use the\nVALUES(col_name) function in the UPDATE clause to refer to column\nvalues from the INSERT portion of the statement. In other words,\nVALUES(col_name) in the UPDATE clause refers to the value of col_name\nthat would be inserted, had no duplicate-key conflict occurred. This\nfunction is especially useful in multiple-row inserts. The VALUES()\nfunction is meaningful only in INSERT ... ON DUPLICATE KEY UPDATE\nstatements and returns NULL otherwise.\nhttp://dev.mysql.com/doc/refman/5.1/en/insert-on-duplicate.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html\n\n','mysql> INSERT INTO table (a,b,c) VALUES (1,2,3),(4,5,6)\n    -> ON DUPLICATE KEY UPDATE c=VALUES(a)+VALUES(b);\n','http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (318,34,'SUBSTRING_INDEX','Syntax:\nSUBSTRING_INDEX(str,delim,count)\n\nReturns the substring from string str before count occurrences of the\ndelimiter delim. If count is positive, everything to the left of the\nfinal delimiter (counting from the left) is returned. If count is\nnegative, everything to the right of the final delimiter (counting from\nthe right) is returned. SUBSTRING_INDEX() performs a case-sensitive\nmatch when searching for delim.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT SUBSTRING_INDEX(\'www.mysql.com\', \'.\', 2);\n        -> \'www.mysql\'\nmysql> SELECT SUBSTRING_INDEX(\'www.mysql.com\', \'.\', -2);\n        -> \'mysql.com\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (319,11,'ENCODE','Syntax:\nENCODE(str,pass_str)\n\nEncrypt str using pass_str as the password. To decrypt the result, use\nDECODE().\n\nThe result is a binary string of the same length as str.\n\nThe strength of the encryption is based on how good the random\ngenerator is. It should suffice for short strings.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (320,36,'LOOP','Syntax:\n[begin_label:] LOOP\n    statement_list\nEND LOOP [end_label]\n\nLOOP implements a simple loop construct, enabling repeated execution of\nthe statement list, which consists of one or more statements. The\nstatements within the loop are repeated until the loop is exited;\nusually this is accomplished with a LEAVE statement.\n\nA LOOP statement can be labeled. end_label cannot be given unless\nbegin_label also is present. If both are present, they must be the\nsame.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/loop-statement.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/loop-statement.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (321,4,'TRUNCATE','Syntax:\nTRUNCATE(X,D)\n\nReturns the number X, truncated to D decimal places. If D is 0, the\nresult has no decimal point or fractional part. D can be negative to\ncause D digits left of the decimal point of the value X to become zero.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT TRUNCATE(1.223,1);\n        -> 1.2\nmysql> SELECT TRUNCATE(1.999,1);\n        -> 1.9\nmysql> SELECT TRUNCATE(1.999,0);\n        -> 1\nmysql> SELECT TRUNCATE(-1.999,1);\n        -> -1.9\nmysql> SELECT TRUNCATE(122,-2);\n       -> 100\nmysql> SELECT TRUNCATE(10.28*100,0);\n       -> 1028\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (322,29,'TIMESTAMPADD','Syntax:\nTIMESTAMPADD(unit,interval,datetime_expr)\n\nAdds the integer expression interval to the date or datetime expression\ndatetime_expr. The unit for interval is given by the unit argument,\nwhich should be one of the following values: FRAC_SECOND, SECOND,\nMINUTE, HOUR, DAY, WEEK, MONTH, QUARTER, or YEAR.\n\nThe unit value may be specified using one of keywords as shown, or with\na prefix of SQL_TSI_. For example, DAY and SQL_TSI_DAY both are legal.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT TIMESTAMPADD(MINUTE,1,\'2003-01-02\');\n        -> \'2003-01-02 00:01:00\'\nmysql> SELECT TIMESTAMPADD(WEEK,1,\'2003-01-02\');\n        -> \'2003-01-09\'\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (323,26,'SHOW','SHOW has many forms that provide information about databases, tables,\ncolumns, or status information about the server. This section describes\nthose following:\n\nSHOW AUTHORS\nSHOW CHARACTER SET [LIKE \'pattern\']\nSHOW COLLATION [LIKE \'pattern\']\nSHOW [FULL] COLUMNS FROM tbl_name [FROM db_name] [LIKE \'pattern\']\nSHOW CONTRIBUTORS\nSHOW CREATE DATABASE db_name\nSHOW CREATE EVENT event_name\nSHOW CREATE FUNCTION funcname\nSHOW CREATE PROCEDURE procname\nSHOW CREATE TABLE tbl_name\nSHOW CREATE VIEW view_name\nSHOW DATABASES [LIKE \'pattern\']\nSHOW ENGINE engine_name {LOGS | STATUS | MUTEX}\nSHOW [STORAGE] ENGINES\nSHOW ERRORS [LIMIT [offset,] row_count]\nSHOW [FULL] EVENTS\nSHOW FUNCTION CODE sp_name\nSHOW FUNCTION STATUS [LIKE \'pattern\']\nSHOW GRANTS FOR user\nSHOW INDEX FROM tbl_name [FROM db_name]\nSHOW INNODB STATUS\nSHOW PROCEDURE CODE sp_name\nSHOW PROCEDURE STATUS [LIKE \'pattern\']\nSHOW PLUGINS\nSHOW PRIVILEGES\nSHOW [FULL] PROCESSLIST\nSHOW SCHEDULER STATUS\nSHOW [GLOBAL | SESSION] STATUS [LIKE \'pattern\']\nSHOW TABLE STATUS [FROM db_name] [LIKE \'pattern\']\nSHOW [OPEN] TABLES [FROM db_name] [LIKE \'pattern\']\nSHOW TRIGGERS\nSHOW [GLOBAL | SESSION] VARIABLES [LIKE \'pattern\']\nSHOW WARNINGS [LIMIT [offset,] row_count]\n\nThe SHOW statement also has forms that provide information about\nreplication master and slave servers and are described in [HELP PURGE\nMASTER LOGS]:\n\nSHOW BINARY LOGS\nSHOW BINLOG EVENTS\nSHOW MASTER STATUS\nSHOW SLAVE HOSTS\nSHOW SLAVE STATUS\n\nIf the syntax for a given SHOW statement includes a LIKE \'pattern\'\npart, \'pattern\' is a string that can contain the SQL `%\' and `_\'\nwildcard characters. The pattern is useful for restricting statement\noutput to matching values.\n\nSeveral SHOW statements also accept a WHERE clause that provides more\nflexibility in specifying which rows to display. See\nhttp://dev.mysql.com/doc/refman/5.1/en/extended-show.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (324,18,'GREATEST','Syntax:\nGREATEST(value1,value2,...)\n\nWith two or more arguments, returns the largest (maximum-valued)\nargument. The arguments are compared using the same rules as for\nLEAST().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html\n\n','mysql> SELECT GREATEST(2,0);\n        -> 2\nmysql> SELECT GREATEST(34.0,3.0,5.0,767.0);\n        -> 767.0\nmysql> SELECT GREATEST(\'B\',\'A\',\'C\');\n        -> \'C\'\n','http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (325,34,'OCTETLENGTH','Syntax:\nOCTET_LENGTH(str)\n\nOCTET_LENGTH() is a synonym for LENGTH().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (326,26,'SHOW VARIABLES','Syntax:\nSHOW [GLOBAL | SESSION] VARIABLES [LIKE \'pattern\']\n\nSHOW VARIABLES shows the values of MySQL system variables. This\ninformation also can be obtained using the mysqladmin variables\ncommand.\n\nWith the GLOBAL modifier, SHOW VARIABLES displays the values that are\nused for new connections to MySQL. With SESSION, it displays the values\nthat are in effect for the current connection. If no modifier is\npresent, the default is SESSION. LOCAL is a synonym for SESSION.\nWith a LIKE clause, the statement displays only rows for those\nvariables with names that match the pattern. To obtain the row for a\nspecific variable, use a LIKE clause as shown:\n\nSHOW VARIABLES LIKE \'max_join_size\';\nSHOW SESSION VARIABLES LIKE \'max_join_size\';\n\nTo get a list of variables whose name match a pattern, use the `%\'\nwildcard character in a LIKE clause:\n\nSHOW VARIABLES LIKE \'%size%\';\nSHOW GLOBAL VARIABLES LIKE \'%size%\';\n\nWildcard characters can be used in any position within the pattern to\nbe matched. Strictly speaking, because `_\' is a wildcard that matches\nany single character, you should escape it as `\\_\' to match it\nliterally. In practice, this is rarely necessary.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-variables.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-variables.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (327,15,'BIT_AND','Syntax:\nBIT_AND(expr)\n\nReturns the bitwise AND of all bits in expr. The calculation is\nperformed with 64-bit (BIGINT) precision.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (328,29,'SECOND','Syntax:\nSECOND(time)\n\nReturns the second for time, in the range 0 to 59.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT SECOND(\'10:05:03\');\n        -> 3\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (329,4,'ATAN2','Syntax:\nATAN(Y,X), ATAN2(Y,X)\n\nReturns the arc tangent of the two variables X and Y. It is similar to\ncalculating the arc tangent of Y / X, except that the signs of both\narguments are used to determine the quadrant of the result.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT ATAN(-2,2);\n        -> -0.78539816339745\nmysql> SELECT ATAN2(PI(),0);\n        -> 1.5707963267949\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (330,6,'MBRCONTAINS','MBRContains(g1,g2)\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1\ncontains the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRWithin().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/relations-on-geometry-mbr.html\n\n','mysql> SET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nmysql> SET @g2 = GeomFromText(\'Point(1 1)\');\nmysql> SELECT MBRContains(@g1,@g2), MBRContains(@g2,@g1);\n----------------------+----------------------+\n| MBRContains(@g1,@g2) | MBRContains(@g2,@g1) |\n+----------------------+----------------------+\n|                    1 |                    0 |\n+----------------------+----------------------+\n','http://dev.mysql.com/doc/refman/5.1/en/relations-on-geometry-mbr.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (331,29,'HOUR','Syntax:\nHOUR(time)\n\nReturns the hour for time. The range of the return value is 0 to 23 for\ntime-of-day values. However, the range of TIME values actually is much\nlarger, so HOUR can return values greater than 23.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT HOUR(\'10:05:03\');\n        -> 10\nmysql> SELECT HOUR(\'272:59:59\');\n        -> 272\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (332,26,'SELECT','Syntax:\nSELECT\n    [ALL | DISTINCT | DISTINCTROW ]\n      [HIGH_PRIORITY]\n      [STRAIGHT_JOIN]\n      [SQL_SMALL_RESULT] [SQL_BIG_RESULT] [SQL_BUFFER_RESULT]\n      [SQL_CACHE | SQL_NO_CACHE] [SQL_CALC_FOUND_ROWS]\n    select_expr, ...\n    [FROM table_references\n    [WHERE where_condition]\n    [GROUP BY {col_name | expr | position}\n      [ASC | DESC], ... [WITH ROLLUP]]\n    [HAVING where_condition]\n    [ORDER BY {col_name | expr | position}\n      [ASC | DESC], ...]\n    [LIMIT {[offset,] row_count | row_count OFFSET offset}]\n    [PROCEDURE procedure_name(argument_list)]\n    [INTO OUTFILE \'file_name\' export_options\n      | INTO DUMPFILE \'file_name\'\n      | INTO var_name [, var_name]]\n    [FOR UPDATE | LOCK IN SHARE MODE]]\n\nSELECT is used to retrieve rows selected from one or more tables, and\ncan include UNION statements and subqueries. See [HELP UNION], and\nhttp://dev.mysql.com/doc/refman/5.1/en/subqueries.html.\n\nThe most commonly used clauses of SELECT statements are these:\n\no Each select_expr indicates a column that you want to retrieve. There\n  must be at least one select_expr.\n\no table_references indicates the table or tables from which to retrieve\n  rows. Its syntax is described in [HELP JOIN].\n\no The WHERE clause, if given, indicates the condition or conditions\n  that rows must satisfy to be selected. where_condition is an\n  expression that evaluates to true for each row to be selected. The\n  statement selects all rows if there is no WHERE clause.\n\n  In the WHERE clause, you can use any of the functions and operators\n  that MySQL supports, except for aggregate (summary) functions. See\n  [HELP =].\n\nSELECT can also be used to retrieve rows computed without reference to\nany table.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/select.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/select.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (333,4,'COT','Syntax:\nCOT(X)\n\nReturns the cotangent of X.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT COT(12);\n        -> -1.5726734063977\nmysql> SELECT COT(0);\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (334,26,'SHOW CREATE EVENT','Syntax:\nSHOW CREATE EVENT event_name\n\nThis statement displays the CREATE EVENT statement needed to re-create\na given event. For example (using the same event e_daily defined and\nthen altered in\nhttp://dev.mysql.com/doc/refman/5.1/en/show-events.html):\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-create-event.html\n\n','mysql> SHOW CREATE EVENT test.e_daily\\G\n\n*************************** 1. row ***************************\n       Event: e_daily\nCreate Event: CREATE EVENT e_daily\n                ON SCHEDULE EVERY 1 DAY\n                STARTS CURRENT_TIMESTAMP + INTERVAL 6 HOUR\n                ENABLE\n                COMMENT \'Saves total number of sessions and\n                         clears the table once per day.\'\n                DO\n                  BEGIN\n                    INSERT INTO site_activity.totals (when, total)\n                      SELECT CURRENT_TIMESTAMP, COUNT(*) \n                      FROM site_activity.sessions;\n                    DELETE FROM site_activity.sessions;\n                  END\n','http://dev.mysql.com/doc/refman/5.1/en/show-create-event.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (335,20,'BACKUP TABLE','Syntax:\nBACKUP TABLE tbl_name [, tbl_name] ... TO \'/path/to/backup/directory\'\n\nNote: This statement is deprecated. We are working on a better\nreplacement for it that will provide online backup capabilities. In the\nmeantime, the mysqlhotcopy script can be used instead.\n\nBACKUP TABLE copies to the backup directory the minimum number of table\nfiles needed to restore the table, after flushing any buffered changes\nto disk. The statement works only for MyISAM tables. It copies the .frm\ndefinition and .MYD data files. The .MYI index file can be rebuilt from\nthose two files. The directory should be specified as a full pathname.\nTo restore the table, use RESTORE TABLE.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/backup-table.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/backup-table.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (336,34,'LOAD_FILE','Syntax:\nLOAD_FILE(file_name)\n\nReads the file and returns the file contents as a string. To use this\nfunction, the file must be located on the server host, you must specify\nthe full pathname to the file, and you must have the FILE privilege.\nThe file must be readable by all and its size less than\nmax_allowed_packet bytes.\n\nIf the file does not exist or cannot be read because one of the\npreceding conditions is not satisfied, the function returns NULL.\n\nAs of MySQL 5.1.6, the character_set_filesystem system variable\ncontrols interpretation of filenames that are given as literal strings.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> UPDATE t\n            SET blob_col=LOAD_FILE(\'/tmp/picture\')\n            WHERE id=1;\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (337,3,'POINTFROMTEXT','PointFromText(wkt[,srid])\n\nConstructs a POINT value using its WKT representation and SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/gis-wkt-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/gis-wkt-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (338,26,'LOAD TABLE FROM MASTER','Syntax:\nLOAD TABLE tbl_name FROM MASTER\n\nThis feature is deprecated. We recommend not using it anymore. It is\nsubject to removal in a future version of MySQL.\n\nSince the current implementation of LOAD DATA FROM MASTER and LOAD\nTABLE FROM MASTER is very limited, these statements are deprecated in\nversions 4.1 of MySQL and above. We will introduce a more advanced\ntechnique (called "online backup") in a future version. That technique\nwill have the additional advantage of working with more storage\nengines.\n\nFor MySQL 5.1 and earlier, the recommended alternative solution to\nusing LOAD DATA FROM MASTER or LOAD TABLE FROM MASTER is using\nmysqldump or mysqlhotcopy. The latter requires Perl and two Perl\nmodules (DBI and DBD:mysql) and works for MyISAM and ARCHIVE tables\nonly. With mysqldump, you can create SQL dumps on the master and pipe\n(or copy) these to a mysql client on the slave. This has the advantage\nof working for all storage engines, but can be quite slow, since it\nworks using SELECT.\n\nTransfers a copy of the table from the master to the slave. This\nstatement is implemented mainly debugging LOAD DATA FROM MASTER\noperations. To use LOAD TABLE, the account used for connecting to the\nmaster server must have the RELOAD and SUPER privileges on the master\nand the SELECT privilege for the master table to load. On the slave\nside, the user that issues LOAD TABLE FROM MASTER must have privileges\nfor dropping and creating the table.\n\nThe conditions for LOAD DATA FROM MASTER apply here as well. For\nexample, LOAD TABLE FROM MASTER works only for MyISAM tables. The\ntimeout notes for LOAD DATA FROM MASTER apply as well.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/load-table-from-master.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/load-table-from-master.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (339,15,'GROUP_CONCAT','Syntax:\nGROUP_CONCAT(expr)\n\nThis function returns a string result with the concatenated non-NULL\nvalues from a group. It returns NULL if there are no non-NULL values.\nThe full syntax is as follows:\n\nGROUP_CONCAT([DISTINCT] expr [,expr ...]\n             [ORDER BY {unsigned_integer | col_name | expr}\n                 [ASC | DESC] [,col_name ...]]\n             [SEPARATOR str_val])\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html\n\n','mysql> SELECT student_name,\n    ->     GROUP_CONCAT(test_score)\n    ->     FROM student\n    ->     GROUP BY student_name;\n','http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (340,29,'DATE_FORMAT','Syntax:\nDATE_FORMAT(date,format)\n\nFormats the date value according to the format string.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT DATE_FORMAT(\'1997-10-04 22:23:00\', \'%W %M %Y\');\n        -> \'Saturday October 1997\'\nmysql> SELECT DATE_FORMAT(\'1997-10-04 22:23:00\', \'%H:%i:%s\');\n        -> \'22:23:00\'\nmysql> SELECT DATE_FORMAT(\'1997-10-04 22:23:00\',\n                          \'%D %y %a %d %m %b %j\');\n        -> \'4th 97 Sat 04 10 Oct 277\'\nmysql> SELECT DATE_FORMAT(\'1997-10-04 22:23:00\',\n                          \'%H %k %I %r %T %S %w\');\n        -> \'22 22 10 10:23:00 PM 22:23:00 00 6\'\nmysql> SELECT DATE_FORMAT(\'1999-01-01\', \'%X %V\');\n        -> \'1998 52\'\nmysql> SELECT DATE_FORMAT(\'2006-06-00\', \'%d\');\n        -> \'00\'\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (341,16,'BENCHMARK','Syntax:\nBENCHMARK(count,expr)\n\nThe BENCHMARK() function executes the expression expr repeatedly count\ntimes. It may be used to time how quickly MySQL processes the\nexpression. The result value is always 0. The intended use is from\nwithin the mysql client, which reports query execution times:\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/information-functions.html\n\n','mysql> SELECT BENCHMARK(1000000,ENCODE(\'hello\',\'goodbye\'));\n+----------------------------------------------+\n| BENCHMARK(1000000,ENCODE(\'hello\',\'goodbye\')) |\n+----------------------------------------------+\n|                                            0 |\n+----------------------------------------------+\n1 row in set (4.74 sec)\n','http://dev.mysql.com/doc/refman/5.1/en/information-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (342,29,'YEAR','Syntax:\nYEAR(date)\n\nReturns the year for date, in the range 1000 to 9999, or 0 for the\n"zero" date.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT YEAR(\'98-02-03\');\n        -> 1998\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (343,26,'SHOW ENGINE','Syntax:\nSHOW ENGINE engine_name {LOGS | STATUS | MUTEX}\n\nSHOW ENGINE displays log or status information about a storage engine.\nThe following statements currently are supported:\n\nSHOW ENGINE INNODB STATUS\nSHOW ENGINE INNODB MUTEX\nSHOW ENGINE NDB STATUS\nSHOW ENGINE NDBCLUSTER STATUS\n\nOlder (and now deprecated) synonyms for SHOW ENGINE INNODB STATUS and\nSHOW ENGINE INNODB MUTEX are SHOW INNODB STATUS and SHOW MUTEX STATUS.\n\nSHOW ENGINE INNODB STATUS displays extensive information about the\nstate of the InnoDB storage engine.\n\nThe InnoDB Monitors provide additional information about InnoDB\nprocessing. See\nhttp://dev.mysql.com/doc/refman/5.1/en/innodb-monitor.html.\n\nSHOW ENGINE INNODB MUTEX displays InnoDB mutex statistics. The output\nfields are:\n\no Type\n\n  Always InnoDB.\n\no Name\n\n  The mutex name and the source file where it is implemented. Example:\n  &pool->mutex:mem0pool.c\n\n  The mutex name indicates its purpose. For example, the log_sys mutex\n  is used by the InnoDB logging subsystem and indicates how intensive\n  logging activity is. The buf_pool mutex protects the InnoDB buffer\n  pool.\n\no Status\n\n  The mutex status. The fields contains several values:\n\n  o count indicates how many times the mutex was requested.\n\n  o spin_waits indicates how many times the spinlock had to run.\n\n  o spin_rounds indicates the number of spinlock rounds. (spin_rounds\n    divided by spin_waits provides the average round count.)\n\n  o os_waits indicates the number of operating system waits. This\n    occurs when the spinlock did not work (the mutex was not locked\n    during the spinlock and it was necessary to yield to the operating\n    system and wait).\n\n  o os_yields indicates the number of times a the thread trying to lock\n    a mutex gave up its timeslice and yielded to the operating system\n    (on the presumption that allowing other threads to run will free\n    the mutex so that it can be locked).\n\n  o os_wait_times indicates the amount of time (in ms) spent in\n    operating system waits, if the timed_mutexes system variable is 1\n    (ON). If timed_mutexes is 0 (OFF), timing is disabled, so\n    os_wait_times is 0. timed_mutexes is off by default.\n\nInformation from this statement can be used to diagnose system\nproblems. For example, large values of spin_waits and spin_rounds may\nindicate scalability problems.\n\nIf the server has the NDBCLUSTER storage engine enabled, SHOW ENGINE\nNDB STATUS displays cluster status information such as the number of\nconnected data nodes, the cluster connectstring, and cluster binlog\nepochs, as well as counts of various Cluster API objects created by the\nMySQL Server when connected to the cluster.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-engine.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-engine.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (344,14,'NAME_CONST','Syntax:\nNAME_CONST(name,value)\n\nReturns the given value. When used to produce a result set column,\nNAME_CONST() causes the column to have the given name.\n\nmysql> SELECT NAME_CONST(\'myname\', 14);\n+--------+\n| myname |\n+--------+\n|     14 |\n+--------+\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (345,14,'RELEASE_LOCK','Syntax:\nRELEASE_LOCK(str)\n\nReleases the lock named by the string str that was obtained with\nGET_LOCK(). Returns 1 if the lock was released, 0 if the lock was not\nestablished by this thread (in which case the lock is not released),\nand NULL if the named lock did not exist. The lock does not exist if it\nwas never obtained by a call to GET_LOCK() or if it has previously been\nreleased.\n\nThe DO statement is convenient to use with RELEASE_LOCK(). See [HELP\nDO].\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (346,18,'IS NULL','Syntax:\nIS NULL, IS NOT NULL\n\nTests whether a value is or is not NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html\n\n','mysql> SELECT 1 IS NULL, 0 IS NULL, NULL IS NULL;\n        -> 0, 0, 1\nmysql> SELECT 1 IS NOT NULL, 0 IS NOT NULL, NULL IS NOT NULL;\n        -> 1, 1, 0\n','http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (347,29,'CONVERT_TZ','Syntax:\nCONVERT_TZ(dt,from_tz,to_tz)\n\nCONVERT_TZ() converts a datetime value dt from the time zone given by\nfrom_tz to the time zone given by to_tz and returns the resulting\nvalue. Time zones are specified as described in\nhttp://dev.mysql.com/doc/refman/5.1/en/time-zone-support.html. This\nfunction returns NULL if the arguments are invalid.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT CONVERT_TZ(\'2004-01-01 12:00:00\',\'GMT\',\'MET\');\n        -> \'2004-01-01 13:00:00\'\nmysql> SELECT CONVERT_TZ(\'2004-01-01 12:00:00\',\'+00:00\',\'+10:00\');\n        -> \'2004-01-01 22:00:00\'\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (348,29,'TIME_TO_SEC','Syntax:\nTIME_TO_SEC(time)\n\nReturns the time argument, converted to seconds.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT TIME_TO_SEC(\'22:23:00\');\n        -> 80580\nmysql> SELECT TIME_TO_SEC(\'00:39:38\');\n        -> 2378\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (349,29,'WEEKDAY','Syntax:\nWEEKDAY(date)\n\nReturns the weekday index for date (0 = Monday, 1 = Tuesday, ... 6 =\nSunday).\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT WEEKDAY(\'1998-02-03 22:23:00\');\n        -> 1\nmysql> SELECT WEEKDAY(\'1997-11-05\');\n        -> 2\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (350,34,'EXPORT_SET','Syntax:\nEXPORT_SET(bits,on,off[,separator[,number_of_bits]])\n\nReturns a string such that for every bit set in the value bits, you get\nan on string and for every bit not set in the value, you get an off\nstring. Bits in bits are examined from right to left (from low-order to\nhigh-order bits). Strings are added to the result from left to right,\nseparated by the separator string (the default being the comma\ncharacter `,\'). The number of bits examined is given by number_of_bits\n(defaults to 64).\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT EXPORT_SET(5,\'Y\',\'N\',\',\',4);\n        -> \'Y,N,Y,N\'\nmysql> SELECT EXPORT_SET(6,\'1\',\'0\',\',\',10);\n        -> \'0,1,1,0,0,0,0,0,0,0\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (351,37,'ALTER SERVER','Syntax:\nALTER SERVER  server_name\nOPTIONS (option ...)\n\nAlters the server information for server_name, adjusting the specified\noptions as per the CREATE SERVER command. See [HELP CREATE SERVER]. The\ncorresponding fields in the mysql.servers table are updated\naccordingly. This statement requires the SUPER privilege.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/alter-server.html\n\n','ALTER SERVER s OPTIONS (USER \'sally\');\n','http://dev.mysql.com/doc/refman/5.1/en/alter-server.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (352,29,'TIME FUNCTION','Syntax:\nTIME(expr)\n\nExtracts the time part of the time or datetime expression expr and\nreturns it as a string.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT TIME(\'2003-12-31 01:02:03\');\n        -> \'01:02:03\'\nmysql> SELECT TIME(\'2003-12-31 01:02:03.000123\');\n        -> \'01:02:03.000123\'\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (353,29,'DATE_ADD','Syntax:\nDATE_ADD(date,INTERVAL expr unit), DATE_SUB(date,INTERVAL expr unit)\n\nThese functions perform date arithmetic. date is a DATETIME or DATE\nvalue specifying the starting date. expr is an expression specifying\nthe interval value to be added or subtracted from the starting date.\nexpr is a string; it may start with a `-\' for negative intervals. unit\nis a keyword indicating the units in which the expression should be\ninterpreted.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT \'1997-12-31 23:59:59\' + INTERVAL 1 SECOND;\n        -> \'1998-01-01 00:00:00\'\nmysql> SELECT INTERVAL 1 DAY + \'1997-12-31\';\n        -> \'1998-01-01\'\nmysql> SELECT \'1998-01-01\' - INTERVAL 1 SECOND;\n        -> \'1997-12-31 23:59:59\'\nmysql> SELECT DATE_ADD(\'1997-12-31 23:59:59\',\n    ->                 INTERVAL 1 SECOND);\n        -> \'1998-01-01 00:00:00\'\nmysql> SELECT DATE_ADD(\'1997-12-31 23:59:59\',\n    ->                 INTERVAL 1 DAY);\n        -> \'1998-01-01 23:59:59\'\nmysql> SELECT DATE_ADD(\'1997-12-31 23:59:59\',\n    ->                 INTERVAL \'1:1\' MINUTE_SECOND);\n        -> \'1998-01-01 00:01:00\'\nmysql> SELECT DATE_SUB(\'1998-01-01 00:00:00\',\n    ->                 INTERVAL \'1 1:1:1\' DAY_SECOND);\n        -> \'1997-12-30 22:58:59\'\nmysql> SELECT DATE_ADD(\'1998-01-01 00:00:00\',\n    ->                 INTERVAL \'-1 10\' DAY_HOUR);\n        -> \'1997-12-30 14:00:00\'\nmysql> SELECT DATE_SUB(\'1998-01-02\', INTERVAL 31 DAY);\n        -> \'1997-12-02\'\nmysql> SELECT DATE_ADD(\'1992-12-31 23:59:59.000002\',\n    ->            INTERVAL \'1.999999\' SECOND_MICROSECOND);\n        -> \'1993-01-01 00:00:01.000001\'\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (354,34,'CAST','Syntax:\nCAST(expr AS type), CONVERT(expr,type), CONVERT(expr USING\ntranscoding_name)\n\nThe CAST() and CONVERT() functions take a value of one type and produce\na value of another type.\n\nThe type can be one of the following values:\n\no BINARY[(N)]\n\no CHAR[(N)]\n\no DATE\n\no DATETIME\n\no DECIMAL\n\no SIGNED [INTEGER]\n\no TIME\n\no UNSIGNED [INTEGER]\n\nBINARY produces a string with the BINARY data type. See\nhttp://dev.mysql.com/doc/refman/5.1/en/binary-varbinary.html for a\ndescription of how this affects comparisons. If the optional length N\nis given, BINARY(N) causes the cast to use no more than N bytes of the\nargument. Values shorter than N bytes are padded with 0x00 bytes to a\nlength of N.\n\nCHAR(N) causes the cast to use no more than N characters of the\nargument.\n\nCAST() and CONVERT(... USING ...) are standard SQL syntax. The\nnon-USING form of CONVERT() is ODBC syntax.\n\nCONVERT() with USING is used to convert data between different\ncharacter sets. In MySQL, transcoding names are the same as the\ncorresponding character set names. For example, this statement converts\nthe string \'abc\' in the default character set to the corresponding\nstring in the utf8 character set:\n\nSELECT CONVERT(\'abc\' USING utf8);\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/cast-functions.html\n\n','SELECT enum_col FROM tbl_name ORDER BY CAST(enum_col AS CHAR);\n','http://dev.mysql.com/doc/refman/5.1/en/cast-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (355,34,'SOUNDS LIKE','Syntax:\nexpr1 SOUNDS LIKE expr2\n\nThis is the same as SOUNDEX(expr1) = SOUNDEX(expr2).\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (356,29,'PERIOD_DIFF','Syntax:\nPERIOD_DIFF(P1,P2)\n\nReturns the number of months between periods P1 and P2. P1 and P2\nshould be in the format YYMM or YYYYMM. Note that the period arguments\nP1 and P2 are not date values.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT PERIOD_DIFF(9802,199703);\n        -> 11\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (357,34,'LIKE','Syntax:\nexpr LIKE pat [ESCAPE \'escape_char\']\n\nPattern matching using SQL simple regular expression comparison.\nReturns 1 (TRUE) or 0 (FALSE). If either expr or pat is NULL, the\nresult is NULL.\n\nThe pattern need not be a literal string. For example, it can be\nspecified as a string expression or table column.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-comparison-functions.html\n\n','mysql> SELECT \'David!\' LIKE \'David_\';\n        -> 1\nmysql> SELECT \'David!\' LIKE \'%D%v%\';\n        -> 1\n','http://dev.mysql.com/doc/refman/5.1/en/string-comparison-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (358,23,'MULTIPOINT','MultiPoint(pt1,pt2,...)\n\nConstructs a WKB MultiPoint value using WKB Point arguments. If any\nargument is not a WKB Point, the return value is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/gis-mysql-specific-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/gis-mysql-specific-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (359,19,'>>','Syntax:\n>>\n\nShifts a longlong (BIGINT) number to the right.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/bit-functions.html\n\n','mysql> SELECT 4 >> 2;\n        -> 1\n','http://dev.mysql.com/doc/refman/5.1/en/bit-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (360,36,'FETCH','Syntax:\nFETCH cursor_name INTO var_name [, var_name] ...\n\nThis statement fetches the next row (if a row exists) using the\nspecified open cursor, and advances the cursor pointer.\n\nIf no more rows are available, a No Data condition occurs with SQLSTATE\nvalue 02000. To detect this condition, you can set up a handler for it.\nAn example is shown in [HELP DECLARE CURSOR].\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/fetch.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/fetch.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (361,15,'AVG','Syntax:\nAVG([DISTINCT] expr)\n\nReturns the average value of expr. The DISTINCT option can be used to\nreturn the average of the distinct values of expr.\n\nAVG() returns NULL if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html\n\n','mysql> SELECT student_name, AVG(test_score)\n    ->        FROM student\n    ->        GROUP BY student_name;\n','http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (362,28,'TRUE FALSE','The constants TRUE and FALSE evaluate to 1 and 0, respectively. The\nconstant names can be written in any lettercase.\n\nmysql> SELECT TRUE, true, FALSE, false;\n        -> 1, 1, 0, 0\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/boolean-values.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/boolean-values.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (363,6,'MBRWITHIN','MBRWithin(g1,g2)\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1\nis within the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRWithin().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/relations-on-geometry-mbr.html\n\n','mysql> SET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nmysql> SET @g2 = GeomFromText(\'Polygon((0 0,0 5,5 5,5 0,0 0))\');\nmysql> SELECT MBRWithin(@g1,@g2), MBRWithin(@g2,@g1);\n+--------------------+--------------------+\n| MBRWithin(@g1,@g2) | MBRWithin(@g2,@g1) |\n+--------------------+--------------------+\n|                  1 |                  0 |\n+--------------------+--------------------+\n','http://dev.mysql.com/doc/refman/5.1/en/relations-on-geometry-mbr.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (364,18,'IN','Syntax:\nexpr IN (value,...)\n\nReturns 1 if expr is equal to any of the values in the IN list, else\nreturns 0. If all values are constants, they are evaluated according to\nthe type of expr and sorted. The search for the item then is done using\na binary search. This means IN is very quick if the IN value list\nconsists entirely of constants. Otherwise, type conversion takes place\naccording to the rules described in\nhttp://dev.mysql.com/doc/refman/5.1/en/type-conversion.html, but\napplied to all the arguments.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html\n\n','mysql> SELECT 2 IN (0,3,5,7);\n        -> 0\nmysql> SELECT \'wefwf\' IN (\'wee\',\'wefwf\',\'weg\');\n        -> 1\n','http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (365,34,'QUOTE','Syntax:\nQUOTE(str)\n\nQuotes a string to produce a result that can be used as a properly\nescaped data value in an SQL statement. The string is returned enclosed\nby single quotes and with each instance of single quote (`\'\'),\nbackslash (`\\\'), ASCII NUL, and Control-Z preceded by a backslash. If\nthe argument is NULL, the return value is the word "NULL" without\nenclosing single quotes.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT QUOTE(\'Don\\\'t!\');\n        -> \'Don\\\'t!\'\nmysql> SELECT QUOTE(NULL);\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (366,16,'SESSION_USER','Syntax:\nSESSION_USER()\n\nSESSION_USER() is a synonym for USER().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/information-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/information-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (367,25,'HELP COMMAND','Syntax:\nmysql> help search_string\n\nIf you provide an argument to the help command, mysql uses it as a\nsearch string to access server-side help from the contents of the MySQL\nReference Manual. The proper operation of this command requires that\nthe help tables in the mysql database be initialized with help topic\ninformation (see\nhttp://dev.mysql.com/doc/refman/5.1/en/server-side-help-support.html).\n\nIf there is no match for the search string, the search fails:\n\nmysql> help me\n\nNothing found\nPlease try to run \'help contents\' for a list of all accessible topics\n\nUse help contents to see a list of the help categories:\n\nmysql> help contents\nYou asked for help about help category: "Contents"\nFor more information, type \'help <item>\', where <item> is one of the\nfollowing categories:\n   Account Management\n   Administration\n   Data Definition\n   Data Manipulation\n   Data Types\n   Functions\n   Functions and Modifiers for Use with GROUP BY\n   Geographic Features\n   Language Structure\n   Plugins\n   Storage Engines\n   Stored Routines\n   Table Maintenance\n   Transactions\n   Triggers\n\nIf the search string matches multiple items, mysql shows a list of\nmatching topics:\n\nmysql> help logs\nMany help items for your request exist.\nTo make a more specific request, please type \'help <item>\',\nwhere <item> is one of the following topics:\n   SHOW\n   SHOW BINARY LOGS\n   SHOW ENGINE\n   SHOW LOGS\n\nUse a topic as the search string to see the help entry for that topic:\n\nmysql> help show binary logs\nName: \'SHOW BINARY LOGS\'\nDescription:\nSyntax:\nSHOW BINARY LOGS\nSHOW MASTER LOGS\n\nLists the binary log files on the server. This statement is used as\npart of the procedure described in [purge-master-logs], that shows how\nto determine which logs can be purged.\n\nmysql> SHOW BINARY LOGS;\n+---------------+-----------+\n| Log_name      | File_size |\n+---------------+-----------+\n| binlog.000015 |    724935 |\n| binlog.000016 |    733481 |\n+---------------+-----------+\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mysql-server-side-help.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/mysql-server-side-help.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (368,29,'QUARTER','Syntax:\nQUARTER(date)\n\nReturns the quarter of the year for date, in the range 1 to 4.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT QUARTER(\'98-04-01\');\n        -> 2\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (369,34,'POSITION','Syntax:\nPOSITION(substr IN str)\n\nPOSITION(substr IN str) is a synonym for LOCATE(substr,str).\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (370,14,'IS_USED_LOCK','Syntax:\nIS_USED_LOCK(str)\n\nChecks whether the lock named str is in use (that is, locked). If so,\nit returns the connection identifier of the client that holds the lock.\nOtherwise, it returns NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (371,3,'POLYFROMTEXT','PolyFromText(wkt[,srid]), PolygonFromText(wkt[,srid])\n\nConstructs a POLYGON value using its WKT representation and SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/gis-wkt-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/gis-wkt-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (372,11,'DES_ENCRYPT','Syntax:\nDES_ENCRYPT(str[,{key_num|key_str}])\n\nEncrypts the string with the given key using the Triple-DES algorithm.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html\n\n','key_num des_key_str\n','http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (373,34,'LENGTH','Syntax:\nLENGTH(str)\n\nReturns the length of the string str, measured in bytes. A multi-byte\ncharacter counts as multiple bytes. This means that for a string\ncontaining five two-byte characters, LENGTH() returns 10, whereas\nCHAR_LENGTH() returns 5.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT LENGTH(\'text\');\n        -> 4\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (374,29,'STR_TO_DATE','Syntax:\nSTR_TO_DATE(str,format)\n\nThis is the inverse of the DATE_FORMAT() function. It takes a string\nstr and a format string format. STR_TO_DATE() returns a DATETIME value\nif the format string contains both date and time parts, or a DATE or\nTIME value if the string contains only date or time parts.\n\nThe date, time, or datetime values contained in str should be given in\nthe format indicated by format. For the specifiers that can be used in\nformat, see the DATE_FORMAT() function description. If str contains an\nillegal date, time, or datetime value, STR_TO_DATE() returns NULL. An\nillegal value also produces a warning.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (375,10,'Y','Y(p)\n\nReturns the Y-coordinate value for the point p as a double-precision\nnumber.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/point-property-functions.html\n\n','mysql> SET @pt = \'Point(56.7 53.34)\';\nmysql> SELECT Y(GeomFromText(@pt));\n+----------------------+\n| Y(GeomFromText(@pt)) |\n+----------------------+\n|                53.34 |\n+----------------------+\n','http://dev.mysql.com/doc/refman/5.1/en/point-property-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (376,26,'SHOW INNODB STATUS','Syntax:\nSHOW INNODB STATUS\n\nIn MySQL 5.1, this is a deprecated synonym for SHOW ENGINE INNODB\nSTATUS. See [HELP SHOW ENGINE].\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-innodb-status.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-innodb-status.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (377,20,'CHECKSUM TABLE','Syntax:\nCHECKSUM TABLE tbl_name [, tbl_name] ... [ QUICK | EXTENDED ]\n\nCHECKSUM TABLE reports a table checksum.\n\nWith QUICK, the live table checksum is reported if it is available, or\nNULL otherwise. This is very fast. A live checksum is enabled by\nspecifying the CHECKSUM=1 table option when you create the table;\ncurrently, this is supported only for MyISAM tables. See [HELP CREATE\nTABLE].\n\nWith EXTENDED, the entire table is read row by row and the checksum is\ncalculated. This can be very slow for large tables.\n\nIf neither QUICK nor EXTENDED is specified, MySQL returns a live\nchecksum if the table storage engine supports it and scans the table\notherwise.\n\nFor a non-existent table, CHECKSUM TABLE returns NULL and generates a\nwarning.\n\nThe checksum value depends on the table row format. If the row format\nchanges, the checksum also changes. For example, the storage format for\nVARCHAR changed between MySQL 4.1 and 5.0, so if a 4.1 table is\nupgraded to MySQL 5.0, the checksum value may change.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/checksum-table.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/checksum-table.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (378,2,'NUMINTERIORRINGS','NumInteriorRings(poly)\n\nReturns the number of interior rings in the Polygon value poly.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/polygon-property-functions.html\n\n','mysql> SET @poly =\n    -> \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\nmysql> SELECT NumInteriorRings(GeomFromText(@poly));\n+---------------------------------------+\n| NumInteriorRings(GeomFromText(@poly)) |\n+---------------------------------------+\n|                                     1 |\n+---------------------------------------+\n','http://dev.mysql.com/doc/refman/5.1/en/polygon-property-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (379,2,'INTERIORRINGN','InteriorRingN(poly,N)\n\nReturns the N-th interior ring for the Polygon value poly as a\nLineString. Rings are numbered beginning with 1.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/polygon-property-functions.html\n\n','mysql> SET @poly =\n    -> \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\nmysql> SELECT AsText(InteriorRingN(GeomFromText(@poly),1));\n+----------------------------------------------+\n| AsText(InteriorRingN(GeomFromText(@poly),1)) |\n+----------------------------------------------+\n| LINESTRING(1 1,1 2,2 2,2 1,1 1)              |\n+----------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.1/en/polygon-property-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (380,29,'UTC_TIME','Syntax:\nUTC_TIME, UTC_TIME()\n\nReturns the current UTC time as a value in \'HH:MM:SS\' or HHMMSS format,\ndepending on whether the function is used in a string or numeric\ncontext.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT UTC_TIME(), UTC_TIME() + 0;\n        -> \'18:07:53\', 180753\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (381,35,'DROP FUNCTION','Syntax:\nDROP FUNCTION function_name\n\nThis statement drops the user-defined function (UDF) named\nfunction_name.\n\nTo drop a function, you must have the DELETE privilege for the mysql\ndatabase. This is because DROP FUNCTION removes a row from the\nmysql.func system table that records the function\'s name, type, and\nshared library name.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/drop-function.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/drop-function.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (382,15,'STDDEV','Syntax:\nSTD(expr) STDDEV(expr)\n\nReturns the population standard deviation of expr. This is an extension\nto standard SQL. The STDDEV() form of this function is provided for\ncompatibility with Oracle. The standard SQL function STDDEV_POP() can\nbe used instead.\n\nThese functions return NULL if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (383,29,'DATE_SUB','Syntax:\nDATE_SUB(date,INTERVAL expr unit)\n\nSee DATE_ADD().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (384,29,'PERIOD_ADD','Syntax:\nPERIOD_ADD(P,N)\n\nAdds N months to period P (in the format YYMM or YYYYMM). Returns a\nvalue in the format YYYYMM. Note that the period argument P is not a\ndate value.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT PERIOD_ADD(9801,2);\n        -> 199803\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (385,19,'|','Syntax:\n|\n\nBitwise OR:\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/bit-functions.html\n\n','mysql> SELECT 29 | 15;\n        -> 31\n','http://dev.mysql.com/doc/refman/5.1/en/bit-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (386,3,'GEOMFROMTEXT','GeomFromText(wkt[,srid]), GeometryFromText(wkt[,srid])\n\nConstructs a geometry value of any type using its WKT representation\nand SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/gis-wkt-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/gis-wkt-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (387,34,'RIGHT','Syntax:\nRIGHT(str,len)\n\nReturns the rightmost len characters from the string str, or NULL if\nany argument is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT RIGHT(\'foobarbar\', 4);\n        -> \'rbar\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (388,29,'DATEDIFF','Syntax:\nDATEDIFF(expr1,expr2)\n\nDATEDIFF() returns expr1 - expr2 expressed as a value in days from one\ndate to the other. expr1 and expr2 are date or date-and-time\nexpressions. Only the date parts of the values are used in the\ncalculation.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT DATEDIFF(\'1997-12-31 23:59:59\',\'1997-12-30\');\n        -> 1\nmysql> SELECT DATEDIFF(\'1997-11-30 23:59:59\',\'1997-12-31\');\n        -> -31\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (389,36,'DROP PROCEDURE','Syntax:\nDROP {PROCEDURE | FUNCTION} [IF EXISTS] sp_name\n\nThis statement is used to drop a stored procedure or function. That is,\nthe specified routine is removed from the server. You must have the\nALTER ROUTINE privilege for the routine. (That privilege is granted\nautomatically to the routine creator.)\n\nThe IF EXISTS clause is a MySQL extension. It prevents an error from\noccurring if the procedure or function does not exist. A warning is\nproduced that can be viewed with SHOW WARNINGS.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/drop-procedure.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/drop-procedure.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (390,20,'CHECK TABLE','Syntax:\nCHECK TABLE tbl_name [, tbl_name] ... [option] ...\n\noption = {FOR UPGRADE | QUICK | FAST | MEDIUM | EXTENDED | CHANGED}\n\nCHECK TABLE checks a table or tables for errors. CHECK TABLE works for\nMyISAM, InnoDB, and ARCHIVE tables. Starting with MySQL 5.1.9, CHECK is\nalso valid for CSV tables, see\nhttp://dev.mysql.com/doc/refman/5.1/en/csv-storage-engine.html. For\nMyISAM tables, the key statistics are updated as well.\n\nCHECK TABLE can also check views for problems, such as tables that are\nreferenced in the view definition that no longer exist.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/check-table.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/check-table.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (391,34,'BIN','Syntax:\nBIN(N)\n\nReturns a string representation of the binary value of N, where N is a\nlonglong (BIGINT) number. This is equivalent to CONV(N,10,2). Returns\nNULL if N is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT BIN(12);\n        -> \'1100\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (392,7,'CASE FUNCTION','Syntax:\nCASE value WHEN [compare_value] THEN result [WHEN [compare_value] THEN\nresult ...] [ELSE result] END\n\nCASE WHEN [condition] THEN result [WHEN [condition] THEN result ...]\n[ELSE result] END\n\nThe first version returns the result where value=compare_value. The\nsecond version returns the result for the first condition that is true.\nIf there was no matching result value, the result after ELSE is\nreturned, or NULL if there is no ELSE part.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/control-flow-functions.html\n\n','mysql> SELECT CASE 1 WHEN 1 THEN \'one\'\n    ->     WHEN 2 THEN \'two\' ELSE \'more\' END;\n        -> \'one\'\nmysql> SELECT CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END;\n        -> \'true\'\nmysql> SELECT CASE BINARY \'B\'\n    ->     WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END;\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.1/en/control-flow-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (393,5,'INSTALL PLUGIN','Syntax:\nINSTALL PLUGIN plugin_name SONAME \'plugin_library\'\n\nThis statement installs a plugin.\n\nplugin_name is the name of the plugin as defined in the plugin\ndeclaration structure contained in the library file. Plugin name case\nsensitivity is determined by the host system filename semantics.\n\nplugin_library is the name of the shared library that contains the\nplugin code. The name includes the filename extension (for example,\nlibmyplugin.so or libmyplugin.dylib).\n\nThe shared library must be located in the plugin directory (that is,\nthe directory named by the plugin_dir system variable). The library\nmust be in the plugin directory itself, not in a subdirectory. By\ndefault, plugin_dir is the directory named by the pkglibdir\nconfiguration variable, but it can be changed by setting the value of\nplugin_dir at server startup. For example, set its value in a my.cnf\nfile:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\n\nIf the value of plugin_dir is a relative pathname, it is taken to be\nrelative to the MySQL base directory (the value of the basedir system\nvariable).\n\nINSTALL PLUGIN adds a line to the mysql.plugin table that describes the\nplugin. This table contains the plugin name and library filename.\n\nINSTALL PLUGIN also loads and initializes the plugin code to make the\nplugin available for use. A plugin is initialized by executing its\ninitialization function, which handles any setup that the plugin must\nperform before it can be used.\n\nTo use INSTALL PLUGIN, you must have the INSERT privilege for the\nmysql.plugin table.\n\nAt server startup, the server loads and initializes any plugin that is\nlisted in the mysql.plugin table. This means that a plugin is installed\nwith INSTALL PLUGIN only once, not every time the server starts. Plugin\nloading at startup does not occur if the server is started with the\n--skip-grant-tables option.\n\nWhen the server shuts down, it executes the deinitialization function\nfor each plugin that is loaded so that the plugin has a change to\nperform any final cleanup.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/install-plugin.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/install-plugin.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (394,36,'DECLARE CURSOR','Syntax:\nDECLARE cursor_name CURSOR FOR select_statement\n\nThis statement declares a cursor. Multiple cursors may be declared in a\nroutine, but each cursor in a given block must have a unique name.\n\nThe SELECT statement cannot have an INTO clause.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/declare-cursors.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/declare-cursors.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (395,23,'MULTILINESTRING','MultiLineString(ls1,ls2,...)\n\nConstructs a WKB MultiLineString value using WKB LineString arguments.\nIf any argument is not a WKB LineString, the return value is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/gis-mysql-specific-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/gis-mysql-specific-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (396,26,'LOAD DATA','Syntax:\nLOAD DATA [LOW_PRIORITY | CONCURRENT] [LOCAL] INFILE \'file_name\'\n    [REPLACE | IGNORE]\n    INTO TABLE tbl_name\n    [CHARACTER SET charset_name]\n    [FIELDS\n        [TERMINATED BY \'string\']\n        [[OPTIONALLY] ENCLOSED BY \'char\']\n        [ESCAPED BY \'char\']\n    ]\n    [LINES\n        [STARTING BY \'string\']\n        [TERMINATED BY \'string\']\n    ]\n    [IGNORE number LINES]\n    [(col_name_or_user_var,...)]\n    [SET col_name = expr,...]\n\nThe LOAD DATA INFILE statement reads rows from a text file into a table\nat a very high speed. The filename must be given as a literal string.\n\nLOAD DATA INFILE is the complement of SELECT ... INTO OUTFILE. (See\n[HELP SELECT].) To write data from a table to a file, use SELECT ...\nINTO OUTFILE. To read the file back into a table, use LOAD DATA INFILE.\nThe syntax of the FIELDS and LINES clauses is the same for both\nstatements. Both clauses are optional, but FIELDS must precede LINES if\nboth are specified.\n\nFor more information about the efficiency of INSERT versus LOAD DATA\nINFILE and speeding up LOAD DATA INFILE, see\nhttp://dev.mysql.com/doc/refman/5.1/en/insert-speed.html.\n\nThe character set indicated by the character_set_database system\nvariable is used to interpret the information in the file. SET NAMES\nand the setting of character_set_client do not affect interpretation of\ninput. Beginning with MySQL 5.1.17, if the contents of the input file\nuse a character set that differs from the default, it is possible (and\nusually preferable) to use the CHARACTER SET clause to specify the\ncharacter set of the file.\n\nNote that it is currently not possible to load data files that use the\nucs2 character set.\n\nAs of MySQL 5.1.6, the character_set_filesystem system variable\ncontrols the interpretation of the filename.\n\nYou can also load data files by using the mysqlimport utility; it\noperates by sending a LOAD DATA INFILE statement to the server. The\n--local option causes mysqlimport to read data files from the client\nhost. You can specify the --compress option to get better performance\nover slow networks if the client and server support the compressed\nprotocol. See http://dev.mysql.com/doc/refman/5.1/en/mysqlimport.html.\n\nIf you use LOW_PRIORITY, execution of the LOAD DATA statement is\ndelayed until no other clients are reading from the table. This affects\nonly storage engines that use only table-level locking (MyISAM, MEMORY,\nMERGE).\n\nIf you specify CONCURRENT with a MyISAM table that satisfies the\ncondition for concurrent inserts (that is, it contains no free blocks\nin the middle), other threads can retrieve data from the table while\nLOAD DATA is executing. Using this option affects the performance of\nLOAD DATA a bit, even if no other thread is using the table at the same\ntime.\n\nThe LOCAL keyword, if specified, is interpreted with respect to the\nclient end of the connection:\n\no If LOCAL is specified, the file is read by the client program on the\n  client host and sent to the server. The file can be given as a full\n  pathname to specify its exact location. If given as a relative\n  pathname, the name is interpreted relative to the directory in which\n  the client program was started.\n\no If LOCAL is not specified, the file must be located on the server\n  host and is read directly by the server. The server uses the\n  following rules to locate the file:\n\n  o If the filename is an absolute pathname, the server uses it as\n    given.\n\n  o If the filename is a relative pathname with one or more leading\n    components, the server searches for the file relative to the\n    server\'s data directory.\n\n  o If a filename with no leading components is given, the server looks\n    for the file in the database directory of the default database.\n\nNote that, in the non-LOCAL case, these rules mean that a file named as\n./myfile.txt is read from the server\'s data directory, whereas the file\nnamed as myfile.txt is read from the database directory of the default\ndatabase. For example, if db1 is the default database, the following\nLOAD DATA statement reads the file data.txt from the database directory\nfor db1, even though the statement explicitly loads the file into a\ntable in the db2 database:\n\nLOAD DATA INFILE \'data.txt\' INTO TABLE db2.my_table;\n\nWindows pathnames are specified using forward slashes rather than\nbackslashes. If you do use backslashes, you must double them.\n\nFor security reasons, when reading text files located on the server,\nthe files must either reside in the database directory or be readable\nby all. Also, to use LOAD DATA INFILE on server files, you must have\nthe FILE privilege. See\nhttp://dev.mysql.com/doc/refman/5.1/en/privileges-provided.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/load-data.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/load-data.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (397,29,'LOCALTIME','Syntax:\nLOCALTIME, LOCALTIME()\n\nLOCALTIME and LOCALTIME() are synonyms for NOW().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (398,3,'MPOINTFROMTEXT','MPointFromText(wkt[,srid]), MultiPointFromText(wkt[,srid])\n\nConstructs a MULTIPOINT value using its WKT representation and SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/gis-wkt-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/gis-wkt-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (399,21,'BLOB','BLOB[(M)]\n\nA BLOB column with a maximum length of 65,535 (216 - 1) bytes.\n\nAn optional length M can be given for this type. If this is done, MySQL\ncreates the column as the smallest BLOB type large enough to hold\nvalues M bytes long.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (400,11,'PASSWORD','Syntax:\nPASSWORD(str)\n\nCalculates and returns a password string from the plaintext password\nstr and returns a binary string, or NULL if the argument was NULL. This\nis the function that is used for encrypting MySQL passwords for storage\nin the Password column of the user grant table.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html\n\n','mysql> SELECT PASSWORD(\'badpwd\');\n        -> \'*AAB3E285149C0135D51A520E1940DD3263DC008C\'\n','http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (401,21,'CHAR','[NATIONAL] CHAR(M) [CHARACTER SET charset_name] [COLLATE\ncollation_name]\n\nA fixed-length string that is always right-padded with spaces to the\nspecified length when stored. M represents the column length. The range\nof M is 0 to 255 characters.\n\nNote: Trailing spaces are removed when CHAR values are retrieved.\n\nIf you attempt to set the length of a CHAR greater than 255, the CREATE\nTABLE or ALTER TABLE statement in which this is done fails with an\nerror:\n\nmysql> CREATE TABLE c1 (col1 INT, col2 CHAR(500));\nERROR 1074 (42000): Column length too big for column \'col\' (max = 255);\nuse BLOB or TEXT instead\nmysql> SHOW CREATE TABLE c1;\nERROR 1146 (42S02): Table \'test.c1\' doesn\'t exist\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (402,29,'UTC_DATE','Syntax:\nUTC_DATE, UTC_DATE()\n\nReturns the current UTC date as a value in \'YYYY-MM-DD\' or YYYYMMDD\nformat, depending on whether the function is used in a string or\nnumeric context.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT UTC_DATE(), UTC_DATE() + 0;\n        -> \'2003-08-14\', 20030814\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (403,33,'DIMENSION','Dimension(g)\n\nReturns the inherent dimension of the geometry value g. The result can\nbe -1, 0, 1, or 2. The meaning of these values is given in [HELP MBR\ndefinition].\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/general-geometry-property-functions.html\n\n','mysql> SELECT Dimension(GeomFromText(\'LineString(1 1,2 2)\'));\n+------------------------------------------------+\n| Dimension(GeomFromText(\'LineString(1 1,2 2)\')) |\n+------------------------------------------------+\n|                                              1 |\n+------------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.1/en/general-geometry-property-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (404,15,'COUNT DISTINCT','Syntax:\nCOUNT(DISTINCT expr,[expr...])\n\nReturns a count of the number of different non-NULL values.\n\nCOUNT(DISTINCT) returns 0 if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html\n\n','mysql> SELECT COUNT(DISTINCT results) FROM student;\n','http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (405,21,'BIT','BIT[(M)]\n\nA bit-field type. M indicates the number of bits per value, from 1 to\n64. The default is 1 if M is omitted.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (406,27,'EQUALS','Equals(g1,g2)\n\nReturns 1 or 0 to indicate whether g1 is spatially equal to g2.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/functions-that-test-spatial-relationships-between-geometries.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/functions-that-test-spatial-relationships-between-geometries.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (407,26,'SHOW CREATE VIEW','Syntax:\nSHOW CREATE VIEW view_name\n\nThis statement shows a CREATE VIEW statement that creates the given\nview.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-create-view.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-create-view.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (408,18,'INTERVAL','Syntax:\nINTERVAL(N,N1,N2,N3,...)\n\nReturns 0 if N < N1, 1 if N < N2 and so on or -1 if N is NULL. All\narguments are treated as integers. It is required that N1 < N2 < N3 <\n... < Nn for this function to work correctly. This is because a binary\nsearch is used (very fast).\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html\n\n','mysql> SELECT INTERVAL(23, 1, 15, 17, 30, 44, 200);\n        -> 3\nmysql> SELECT INTERVAL(10, 1, 10, 100, 1000);\n        -> 2\nmysql> SELECT INTERVAL(22, 23, 30, 44, 200);\n        -> 0\n','http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (409,29,'FROM_DAYS','Syntax:\nFROM_DAYS(N)\n\nGiven a day number N, returns a DATE value.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT FROM_DAYS(729669);\n        -> \'1997-10-07\'\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (410,36,'ALTER PROCEDURE','Syntax:\nALTER {PROCEDURE | FUNCTION} sp_name [characteristic ...]\n\ncharacteristic:\n    { CONTAINS SQL | NO SQL | READS SQL DATA | MODIFIES SQL DATA }\n  | SQL SECURITY { DEFINER | INVOKER }\n  | COMMENT \'string\'\n\nThis statement can be used to change the characteristics of a stored\nprocedure or function. You must have the ALTER ROUTINE privilege for\nthe routine. (That privilege is granted automatically to the routine\ncreator.) If binary logging is enabled, the ALTER FUNCTION statement\nmight also require the SUPER privilege, as described in\nhttp://dev.mysql.com/doc/refman/5.1/en/stored-procedure-logging.html.\n\nMore than one change may be specified in an ALTER PROCEDURE or ALTER\nFUNCTION statement.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/alter-procedure.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/alter-procedure.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (411,19,'BIT_COUNT','Syntax:\nBIT_COUNT(N)\n\nReturns the number of bits that are set in the argument N.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/bit-functions.html\n\n','mysql> SELECT BIT_COUNT(29), BIT_COUNT(b\'101010\');\n        -> 4, 3\n','http://dev.mysql.com/doc/refman/5.1/en/bit-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (412,29,'UTC_TIMESTAMP','Syntax:\nUTC_TIMESTAMP, UTC_TIMESTAMP()\n\nReturns the current UTC date and time as a value in \'YYYY-MM-DD\nHH:MM:SS\' or YYYYMMDDHHMMSS format, depending on whether the function\nis used in a string or numeric context.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT UTC_TIMESTAMP(), UTC_TIMESTAMP() + 0;\n        -> \'2003-08-14 18:08:04\', 20030814180804\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (413,4,'+','Syntax:\n+\n\nAddition:\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/arithmetic-functions.html\n\n','mysql> SELECT 3+5;\n        -> 8\n','http://dev.mysql.com/doc/refman/5.1/en/arithmetic-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (414,14,'INET_NTOA','Syntax:\nINET_NTOA(expr)\n\nGiven a numeric network address (4 or 8 byte), returns the dotted-quad\nrepresentation of the address as a string.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html\n\n','mysql> SELECT INET_NTOA(3520061480);\n        -> \'209.207.224.40\'\n','http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (415,4,'ACOS','Syntax:\nACOS(X)\n\nReturns the arc cosine of X, that is, the value whose cosine is X.\nReturns NULL if X is not in the range -1 to 1.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT ACOS(1);\n        -> 0\nmysql> SELECT ACOS(1.0001);\n        -> NULL\nmysql> SELECT ACOS(0);\n        -> 1.5707963267949\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (416,8,'ISOLATION','Syntax:\nSET [GLOBAL | SESSION] TRANSACTION ISOLATION LEVEL\n{ READ UNCOMMITTED | READ COMMITTED | REPEATABLE READ | SERIALIZABLE }\n\nThis statement sets the transaction isolation level for the next\ntransaction, globally, or for the current session.\n\nThe default behavior of SET TRANSACTION is to set the isolation level\nfor the next (not yet started) transaction. If you use the GLOBAL\nkeyword, the statement sets the default transaction level globally for\nall new connections created from that point on. Existing connections\nare unaffected. You need the SUPER privilege to do this. Using the\nSESSION keyword sets the default transaction level for all future\ntransactions performed on the current connection.\n\nFor descriptions of each InnoDB transaction isolation level, see\nhttp://dev.mysql.com/doc/refman/5.1/en/innodb-transaction-isolation.htm\nl. InnoDB supports each of these levels in MySQL 5.1. The default level\nis REPEATABLE READ.\n\nIn MySQL 5.1, if the READ COMMITTED isolation level is used or the\ninnodb_locks_unsafe_for_binlog system variable is enabled, there is no\nInnoDB gap locking except in constraint checking. Also, record locks\nfor non-matching rows are released after MySQL has evaluated the WHERE\ncondition.\n\nTo set the initial default global isolation level for mysqld, use the\n--transaction-isolation option. See\nhttp://dev.mysql.com/doc/refman/5.1/en/server-options.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/set-transaction.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/set-transaction.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (417,4,'CEILING','Syntax:\nCEILING(X), CEIL(X)\n\nReturns the smallest integer value not less than X. CEILING() and\nCEIL() are synonymous.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT CEILING(1.23);\n        -> 2\nmysql> SELECT CEIL(-1.23);\n        -> -1\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (418,4,'SIN','Syntax:\nSIN(X)\n\nReturns the sine of X, where X is given in radians.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT SIN(PI());\n        -> 1.2246063538224e-16\nmysql> SELECT ROUND(SIN(PI()));\n        -> 0\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (419,29,'DAYOFWEEK','Syntax:\nDAYOFWEEK(date)\n\nReturns the weekday index for date (1 = Sunday, 2 = Monday, ..., 7 =\nSaturday). These index values correspond to the ODBC standard.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT DAYOFWEEK(\'1998-02-03\');\n        -> 3\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (420,30,'LINEFROMWKB','LineFromWKB(wkb[,srid]), LineStringFromWKB(wkb[,srid])\n\nConstructs a LINESTRING value using its WKB representation and SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/gis-wkb-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/gis-wkb-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (421,26,'SHOW PROCESSLIST','Syntax:\nSHOW [FULL] PROCESSLIST\n\nSHOW PROCESSLIST shows you which threads are running. You can also get\nthis information using the mysqladmin processlist command. If you have\nthe PROCESS privilege, you can see all threads. Otherwise, you can see\nonly your own threads (that is, threads associated with the MySQL\naccount that you are using). See [HELP KILL]. If you do not use the\nFULL keyword, only the first 100 characters of each statement are shown\nin the Info field.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-processlist.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-processlist.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (422,33,'GEOMETRYTYPE','GeometryType(g)\n\nReturns as a string the name of the geometry type of which the geometry\ninstance g is a member. The name corresponds to one of the instantiable\nGeometry subclasses.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/general-geometry-property-functions.html\n\n','mysql> SELECT GeometryType(GeomFromText(\'POINT(1 1)\'));\n+------------------------------------------+\n| GeometryType(GeomFromText(\'POINT(1 1)\')) |\n+------------------------------------------+\n| POINT                                    |\n+------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.1/en/general-geometry-property-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (423,37,'CREATE VIEW','Syntax:\nCREATE\n    [OR REPLACE]\n    [ALGORITHM = {UNDEFINED | MERGE | TEMPTABLE}]\n    [DEFINER = { user | CURRENT_USER }]\n    [SQL SECURITY { DEFINER | INVOKER }]\n    VIEW view_name [(column_list)]\n    AS select_statement\n    [WITH [CASCADED | LOCAL] CHECK OPTION]\n\nThis statement creates a new view, or replaces an existing one if the\nOR REPLACE clause is given. If the view does not exist, CREATE OR\nREPLACE VIEW is the same as CREATE VIEW. If the view does exist, CREATE\nOR REPLACE VIEW is the same as ALTER VIEW. The select_statement is a\nSELECT statement that provides the definition of the view. The\nstatement can select from base tables or other views.\n\nThis statement requires the CREATE VIEW privilege for the view, and\nsome privilege for each column selected by the SELECT statement. For\ncolumns used elsewhere in the SELECT statement you must have the SELECT\nprivilege. If the OR REPLACE clause is present, you must also have the\nDROP privilege for the view.\n\nA view belongs to a database. By default, a new view is created in the\ndefault database. To create the view explicitly in a given database,\nspecify the name as db_name.view_name when you create it.\n\nmysql> CREATE VIEW test.v AS SELECT * FROM t;\n\nBase tables and views share the same namespace within a database, so a\ndatabase cannot contain a base table and a view that have the same\nname.\n\nViews must have unique column names with no duplicates, just like base\ntables. By default, the names of the columns retrieved by the SELECT\nstatement are used for the view column names. To define explicit names\nfor the view columns, the optional column_list clause can be given as a\nlist of comma-separated identifiers. The number of names in column_list\nmust be the same as the number of columns retrieved by the SELECT\nstatement.\n\nColumns retrieved by the SELECT statement can be simple references to\ntable columns. They can also be expressions that use functions,\nconstant values, operators, and so forth.\n\nUnqualified table or view names in the SELECT statement are interpreted\nwith respect to the default database. A view can refer to tables or\nviews in other databases by qualifying the table or view name with the\nproper database name.\n\nA view can be created from many kinds of SELECT statements. It can\nrefer to base tables or other views. It can use joins, UNION, and\nsubqueries. The SELECT need not even refer to any tables. The following\nexample defines a view that selects two columns from another table, as\nwell as an expression calculated from those columns:\n\nmysql> CREATE TABLE t (qty INT, price INT);\nmysql> INSERT INTO t VALUES(3, 50);\nmysql> CREATE VIEW v AS SELECT qty, price, qty*price AS value FROM t;\nmysql> SELECT * FROM v;\n+------+-------+-------+\n| qty  | price | value |\n+------+-------+-------+\n|    3 |    50 |   150 |\n+------+-------+-------+\n\nA view definition is subject to the following restrictions:\n\no The SELECT statement cannot contain a subquery in the FROM clause.\n\no The SELECT statement cannot refer to system or user variables.\n\no The SELECT statement cannot refer to prepared statement parameters.\n\no Within a stored routine, the definition cannot refer to routine\n  parameters or local variables.\n\no Any table or view referred to in the definition must exist. However,\n  after a view has been created, it is possible to drop a table or view\n  that the definition refers to. In this case, use of the view results\n  in an error. To check a view definition for problems of this kind,\n  use the CHECK TABLE statement.\n\no The definition cannot refer to a TEMPORARY table, and you cannot\n  create a TEMPORARY view.\n\no The tables named in the view definition must already exist.\n\no You cannot associate a trigger with a view.\n\nORDER BY is allowed in a view definition, but it is ignored if you\nselect from a view using a statement that has its own ORDER BY.\n\nFor other options or clauses in the definition, they are added to the\noptions or clauses of the statement that references the view, but the\neffect is undefined. For example, if a view definition includes a LIMIT\nclause, and you select from the view using a statement that has its own\nLIMIT clause, it is undefined which limit applies. This same principle\napplies to options such as ALL, DISTINCT, or SQL_SMALL_RESULT that\nfollow the SELECT keyword, and to clauses such as INTO, FOR UPDATE,\nLOCK IN SHARE MODE, and PROCEDURE.\n\nIf you create a view and then change the query processing environment\nby changing system variables, that may affect the results that you get\nfrom the view:\n\nmysql> CREATE VIEW v AS SELECT CHARSET(CHAR(65)), COLLATION(CHAR(65));\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> SET NAMES \'latin1\';\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> SELECT * FROM v;\n+-------------------+---------------------+\n| CHARSET(CHAR(65)) | COLLATION(CHAR(65)) |\n+-------------------+---------------------+\n| latin1            | latin1_swedish_ci   |\n+-------------------+---------------------+\n1 row in set (0.00 sec)\n\nmysql> SET NAMES \'utf8\';\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> SELECT * FROM v;\n+-------------------+---------------------+\n| CHARSET(CHAR(65)) | COLLATION(CHAR(65)) |\n+-------------------+---------------------+\n| utf8              | utf8_general_ci     |\n+-------------------+---------------------+\n1 row in set (0.00 sec)\n\nThe DEFINER and SQL SECURITY clauses specify the security context to be\nused when checking access privileges at view invocation time. They were\naddded in MySQL 5.1.2.\n\nCURRENT_USER also can be given as CURRENT_USER().\n\nWithin a stored routine that is defined with the SQL SECURITY DEFINER\ncharacteristic, CURRENT_USER returns the routine creator. This also\naffects a view defined within such a routine, if the view definition\ncontains a DEFINER value of CURRENT_USER.\n\nThe default DEFINER value is the user who executes the CREATE VIEW\nstatement. (This is the same as DEFINER = CURRENT_USER.) If a user\nvalue is given, it should be a MySQL account in \'user_name\'@\'host_name\'\nformat (the same format used in the GRANT statement). The user_name and\nhost_name values both are required.\n\nIf you specify the DEFINER clause, you cannot set the value to any user\nbut your own unless you have the SUPER privilege. These rules determine\nthe legal DEFINER user values:\n\no If you do not have the SUPER privilege, the only legal user value is\n  your own account, either specified literally or by using\n  CURRENT_USER. You cannot set the definer to some other account.\n\no If you have the SUPER privilege, you can specify any syntactically\n  legal account name. If the account does not actually exist, a warning\n  is generated.\n\nThe SQL SECURITY characteristic determines which MySQL account to use\nwhen checking access privileges for the view when the view is executed.\nThe legal characteristic values are DEFINER and INVOKER. These indicate\nthat the view must be executable by the user who defined it or invoked\nit, respectively. The default SQL SECURITY value is DEFINER.\n\nAs of MySQL 5.1.2 (when the DEFINER and SQL SECURITY clauses were\nimplemented), view privileges are checked like this:\n\no At view definition time, the view creator must have the privileges\n  needed to use the top-level objects accessed by the view. For\n  example, if the view definition refers to a stored function, only the\n  privileges needed to invoke the function can be checked. The\n  privileges required when the function runs can be checked only as it\n  executes: For different invocations of the function, different\n  execution paths within the function might be taken.\n\no At view execution time, privileges for objects accessed by the view\n  are checked against the privileges held by the view creator or\n  invoker, depending on whether the SQL SECURITY characteristic is\n  DEFINER or INVOKER, respectively.\n\no If view execution causes execution of a stored function, privilege\n  checking for statements executed within the function depend on\n  whether the function is defined with a SQL SECURITY characteristic of\n  DEFINER or INVOKER. If the security characteristic is DEFINER, the\n  function runs with the privileges of its creator. If the\n  characteristic is INVOKER, the function runs with the privileges\n  determined by the view\'s SQL SECURITY characteristic.\n\nPrior to MySQL 5.1.2 (before the DEFINER and SQL SECURITY clauses were\nimplemented), privileges required for objects used in a view are\nchecked at view creation time.\n\nExample: A view might depend on a stored function, and that function\nmight invoke other stored routines. For example, the following view\ninvokes a stored function f():\n\nCREATE VIEW v AS SELECT * FROM t WHERE t.id = f(t.name);\n\nSuppose that f() contains a statement such as this:\n\nIF name IS NULL then\n  CALL p1();\nELSE\n  CALL p2();\nEND IF;\n\nThe privileges required for executing statements within f() need to be\nchecked when f() executes. This might mean that privileges are needed\nfor p1() or p2(), depending on the execution path within f(). Those\nprivileges need to be checked at runtime, and the user who must possess\nthe privileges is determined by the SQL SECURITY values of the function\nf() and the view v.\n\nThe DEFINER and SQL SECURITY clauses for views are extensions to\nstandard SQL. In standard SQL, views are handled using the rules for\nSQL SECURITY INVOKER.\n\nIf you invoke a view that was created before MySQL 5.0.13/5.1.2, it is\ntreated as though it was created with a SQL SECURITY DEFINER clause and\nwith a DEFINER value that is the same as your account. However, because\nthe actual definer is unknown, MySQL issues a warning. To make the\nwarning go away, it is sufficient to re-create the view so that the\nview definition includes a DEFINER clause.\n\nThe optional ALGORITHM clause is a MySQL extension to standard SQL.\nALGORITHM takes three values: MERGE, TEMPTABLE, or UNDEFINED. The\ndefault algorithm is UNDEFINED if no ALGORITHM clause is present. The\nalgorithm affects how MySQL processes the view.\n\nFor MERGE, the text of a statement that refers to the view and the view\ndefinition are merged such that parts of the view definition replace\ncorresponding parts of the statement.\n\nFor TEMPTABLE, the results from the view are retrieved into a temporary\ntable, which then is used to execute the statement.\n\nFor UNDEFINED, MySQL chooses which algorithm to use. It prefers MERGE\nover TEMPTABLE if possible, because MERGE is usually more efficient and\nbecause a view cannot be updatable if a temporary table is used.\n\nA reason to choose TEMPTABLE explicitly is that locks can be released\non underlying tables after the temporary table has been created and\nbefore it is used to finish processing the statement. This might result\nin quicker lock release than the MERGE algorithm so that other clients\nthat use the view are not blocked as long.\n\nA view algorithm can be UNDEFINED for three reasons:\n\no No ALGORITHM clause is present in the CREATE VIEW statement.\n\no The CREATE VIEW statement has an explicit ALGORITHM = UNDEFINED\n  clause.\n\no ALGORITHM = MERGE is specified for a view that can be processed only\n  with a temporary table. In this case, MySQL generates a warning and\n  sets the algorithm to UNDEFINED.\n\nAs mentioned earlier, MERGE is handled by merging corresponding parts\nof a view definition into the statement that refers to the view. The\nfollowing examples briefly illustrate how the MERGE algorithm works.\nThe examples assume that there is a view v_merge that has this\ndefinition:\n\nCREATE ALGORITHM = MERGE VIEW v_merge (vc1, vc2) AS\nSELECT c1, c2 FROM t WHERE c3 > 100;\n\nExample 1: Suppose that we issue this statement:\n\nSELECT * FROM v_merge;\n\nMySQL handles the statement as follows:\n\no v_merge becomes t\n\no * becomes vc1, vc2, which corresponds to c1, c2\n\no The view WHERE clause is added\n\nThe resulting statement to be executed becomes:\n\nSELECT c1, c2 FROM t WHERE c3 > 100;\n\nExample 2: Suppose that we issue this statement:\n\nSELECT * FROM v_merge WHERE vc1 < 100;\n\nThis statement is handled similarly to the previous one, except that\nvc1 < 100 becomes c1 < 100 and the view WHERE clause is added to the\nstatement WHERE clause using an AND connective (and parentheses are\nadded to make sure the parts of the clause are executed with correct\nprecedence). The resulting statement to be executed becomes:\n\nSELECT c1, c2 FROM t WHERE (c3 > 100) AND (c1 < 100);\n\nEffectively, the statement to be executed has a WHERE clause of this\nform:\n\nWHERE (select WHERE) AND (view WHERE)\n\nThe MERGE algorithm requires a one-to-one relationship between the rows\nin the view and the rows in the underlying table. If this relationship\ndoes not hold, a temporary table must be used instead. Lack of a\none-to-one relationship occurs if the view contains any of a number of\nconstructs:\n\no Aggregate functions (SUM(), MIN(), MAX(), COUNT(), and so forth)\n\no DISTINCT\n\no GROUP BY\n\no HAVING\n\no UNION or UNION ALL\n\no Subquery in the select list\n\no Refers only to literal values (in this case, there is no underlying\n  table)\n\nSome views are updatable. That is, you can use them in statements such\nas UPDATE, DELETE, or INSERT to update the contents of the underlying\ntable. For a view to be updatable, there must be a one-to-one\nrelationship between the rows in the view and the rows in the\nunderlying table. There are also certain other constructs that make a\nview non-updatable. To be more specific, a view is not updatable if it\ncontains any of the following:\n\no Aggregate functions (SUM(), MIN(), MAX(), COUNT(), and so forth)\n\no DISTINCT\n\no GROUP BY\n\no HAVING\n\no UNION or UNION ALL\n\no Subquery in the select list\n\no Certain joins (see additional join discussion later in this section)\n\no Non-updatable view in the FROM clause\n\no A subquery in the WHERE clause that refers to a table in the FROM\n  clause\n\no Refers only to literal values (in this case, there is no underlying\n  table to update)\n\no ALGORITHM = TEMPTABLE (use of a temporary table always makes a view\n  non-updatable)\n\nWith respect to insertability (being updatable with INSERT statements),\nan updatable view is insertable if it also satisfies these additional\nrequirements for the view columns:\n\no There must be no duplicate view column names.\n\no The view must contain all columns in the base table that do not have\n  a default value.\n\no The view columns must be simple column references and not derived\n  columns. A derived column is one that is not a simple column\n  reference but is derived from an expression. These are examples of\n  derived columns:\n\n3.14159\ncol1 + 3\nUPPER(col2)\ncol3 / col4\n(subquery)\n\nA view that has a mix of simple column references and derived columns\nis not insertable, but it can be updatable if you update only those\ncolumns that are not derived. Consider this view:\n\nCREATE VIEW v AS SELECT col1, 1 AS col2 FROM t;\n\nThis view is not insertable because col2 is derived from an expression.\nBut it is updatable if the update does not try to update col2. This\nupdate is allowable:\n\nUPDATE v SET col1 = 0;\n\nThis update is not allowable because it attempts to update a derived\ncolumn:\n\nUPDATE v SET col2 = 0;\n\nIt is sometimes possible for a multiple-table view to be updatable,\nassuming that it can be processed with the MERGE algorithm. For this to\nwork, the view must use an inner join (not an outer join or a UNION).\nAlso, only a single table in the view definition can be updated, so the\nSET clause must name only columns from one of the tables in the view.\nViews that use UNION ALL are disallowed even though they might be\ntheoretically updatable, because the implementation uses temporary\ntables to process them.\n\nFor a multiple-table updatable view, INSERT can work if it inserts into\na single table. DELETE is not supported.\n\nINSERT DELAYED is not supported for views.\n\nIf a table contains an AUTO_INCREMENT column, inserting into an\ninsertable view on the table that does not include the AUTO_INCREMENT\ncolumn does not change the value of LAST_INSERT_ID(), because the side\neffects of inserting default values into columns not part of the view\nshould not be visible.\n\nThe WITH CHECK OPTION clause can be given for an updatable view to\nprevent inserts or updates to rows except those for which the WHERE\nclause in the select_statement is true.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/create-view.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/create-view.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (424,34,'TRIM','Syntax:\nTRIM([{BOTH | LEADING | TRAILING} [remstr] FROM] str), TRIM([remstr\nFROM] str)\n\nReturns the string str with all remstr prefixes or suffixes removed. If\nnone of the specifiers BOTH, LEADING, or TRAILING is given, BOTH is\nassumed. remstr is optional and, if not specified, spaces are removed.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT TRIM(\'  bar   \');\n        -> \'bar\'\nmysql> SELECT TRIM(LEADING \'x\' FROM \'xxxbarxxx\');\n        -> \'barxxx\'\nmysql> SELECT TRIM(BOTH \'x\' FROM \'xxxbarxxx\');\n        -> \'bar\'\nmysql> SELECT TRIM(TRAILING \'xyz\' FROM \'barxxyz\');\n        -> \'barx\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (425,18,'IS','Syntax:\nIS boolean_value, IS NOT boolean_value\n\nTests a value against a boolean value, where boolean_value can be TRUE,\nFALSE, or UNKNOWN.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html\n\n','mysql> SELECT 1 IS TRUE, 0 IS FALSE, NULL IS UNKNOWN;\n        -> 1, 1, 1\nmysql> SELECT 1 IS NOT UNKNOWN, 0 IS NOT UNKNOWN, NULL IS NOT UNKNOWN;\n        -> 1, 1, 0\n','http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (426,29,'GET_FORMAT','Syntax:\nGET_FORMAT(DATE|TIME|DATETIME, \'EUR\'|\'USA\'|\'JIS\'|\'ISO\'|\'INTERNAL\')\n\nReturns a format string. This function is useful in combination with\nthe DATE_FORMAT() and the STR_TO_DATE() functions.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT DATE_FORMAT(\'2003-10-03\',GET_FORMAT(DATE,\'EUR\'));\n        -> \'03.10.2003\'\nmysql> SELECT STR_TO_DATE(\'10.31.2003\',GET_FORMAT(DATE,\'USA\'));\n        -> \'2003-10-31\'\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (427,21,'TINYBLOB','TINYBLOB\n\nA BLOB column with a maximum length of 255 (28 - 1) bytes.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (428,8,'SAVEPOINT','Syntax:\nSAVEPOINT identifier\nROLLBACK [WORK] TO SAVEPOINT identifier\nRELEASE SAVEPOINT identifier\n\nInnoDB supports the SQL statements SAVEPOINT, ROLLBACK TO SAVEPOINT,\nRELEASE SAVEPOINT and the optional WORK keyword for ROLLBACK.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/savepoints.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/savepoints.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (429,16,'USER','Syntax:\nUSER()\n\nReturns the current MySQL username and hostname as a string in the utf8\ncharacter set.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/information-functions.html\n\n','mysql> SELECT USER();\n        -> \'davida@localhost\'\n','http://dev.mysql.com/doc/refman/5.1/en/information-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (430,30,'MPOINTFROMWKB','MPointFromWKB(wkb[,srid]), MultiPointFromWKB(wkb[,srid])\n\nConstructs a MULTIPOINT value using its WKB representation and SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/gis-wkb-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/gis-wkb-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (431,37,'ALTER TABLE','Syntax:\nALTER [IGNORE] TABLE tbl_name\n    alter_specification [, alter_specification] ...\n\nalter_specification:\n    table_option ...\n  | ADD [COLUMN] column_definition [FIRST | AFTER col_name ]\n  | ADD [COLUMN] (column_definition,...)\n  | ADD {INDEX|KEY} [index_name] [index_type] (index_col_name,...)\n  | ADD [CONSTRAINT [symbol]]\n        PRIMARY KEY [index_type] (index_col_name,...)\n  | ADD [CONSTRAINT [symbol]]\n        UNIQUE [INDEX|KEY] [index_name] [index_type] (index_col_name,...)\n  | ADD FULLTEXT [INDEX|KEY] [index_name] (index_col_name,...)\n      [WITH PARSER parser_name]\n  | ADD SPATIAL [INDEX|KEY] [index_name] (index_col_name,...)\n  | ADD [CONSTRAINT [symbol]]\n        FOREIGN KEY [index_name] (index_col_name,...)\n        [reference_definition]\n  | ALTER [COLUMN] col_name {SET DEFAULT literal | DROP DEFAULT}\n  | CHANGE [COLUMN] old_col_name column_definition\n        [FIRST|AFTER col_name]\n  | MODIFY [COLUMN] column_definition [FIRST | AFTER col_name]\n  | DROP [COLUMN] col_name\n  | DROP PRIMARY KEY\n  | DROP {INDEX|KEY} index_name\n  | DROP FOREIGN KEY fk_symbol\n  | DISABLE KEYS\n  | ENABLE KEYS\n  | RENAME [TO] new_tbl_name\n  | ORDER BY col_name [, col_name] ...\n  | CONVERT TO CHARACTER SET charset_name [COLLATE collation_name]\n  | [DEFAULT] CHARACTER SET charset_name [COLLATE collation_name]\n  | DISCARD TABLESPACE\n  | IMPORT TABLESPACE\n  | PARTITION BY partition_options\n  | ADD PARTITION (partition_definition)\n  | DROP PARTITION partition_names\n  | COALESCE PARTITION number\n  | REORGANIZE PARTITION partition_names INTO (partition_definitions)\n  | ANALYZE PARTITION partition_names\n  | CHECK PARTITION partition_names\n  | OPTIMIZE PARTITION partition_names\n  | REBUILD PARTITION partition_names\n  | REPAIR PARTITION partition_names\n  | REMOVE PARTITIONING\n\nindex_col_name:\n    col_name [(length)] [ASC | DESC]\n\nindex_type:\n    USING {BTREE | HASH}\n\nALTER TABLE enables you to change the structure of an existing table.\nFor example, you can add or delete columns, create or destroy indexes,\nchange the type of existing columns, or rename columns or the table\nitself. You can also change the comment for the table and type of the\ntable.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/alter-table.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/alter-table.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (432,26,'PURGE MASTER LOGS','Syntax:\nPURGE {MASTER | BINARY} LOGS TO \'log_name\'\nPURGE {MASTER | BINARY} LOGS BEFORE \'date\'\n\nDeletes all the binary logs listed in the log index prior to the\nspecified log or date. The logs also are removed from the list recorded\nin the log index file, so that the given log becomes the first.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/purge-master-logs.html\n\n','PURGE MASTER LOGS TO \'mysql-bin.010\';\nPURGE MASTER LOGS BEFORE \'2003-04-02 22:46:26\';\n','http://dev.mysql.com/doc/refman/5.1/en/purge-master-logs.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (433,21,'CHAR BYTE','The CHAR BYTE data type is an alias for the BINARY data type. This is a\ncompatibility feature.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (434,20,'REPAIR TABLE','Syntax:\nREPAIR [LOCAL | NO_WRITE_TO_BINLOG] TABLE\n    tbl_name [, tbl_name] ... [QUICK] [EXTENDED] [USE_FRM]\n\nREPAIR TABLE repairs a possibly corrupted table. By default, it has the\nsame effect as myisamchk --recover tbl_name. REPAIR TABLE works for\nMyISAM and for ARCHIVE tables. Starting with MySQL 5.1.9, REPAIR is\nalso valid for CSV tables. See\nhttp://dev.mysql.com/doc/refman/5.1/en/myisam-storage-engine.html, and\nhttp://dev.mysql.com/doc/refman/5.1/en/archive-storage-engine.html, and\nhttp://dev.mysql.com/doc/refman/5.1/en/csv-storage-engine.html\n\nThis statement requires SELECT and INSERT privileges for the table.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/repair-table.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/repair-table.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (435,37,'MERGE','The MERGE storage engine, also known as the MRG_MyISAM engine, is a\ncollection of identical MyISAM tables that can be used as one.\n"Identical" means that all tables have identical column and index\ninformation. You cannot merge MyISAM tables in which the columns are\nlisted in a different order, do not have exactly the same columns, or\nhave the indexes in different order. However, any or all of the MyISAM\ntables can be compressed with myisampack. See\nhttp://dev.mysql.com/doc/refman/5.1/en/myisampack.html. Differences in\ntable options such as AVG_ROW_LENGTH, MAX_ROWS, or PACK_KEYS do not\nmatter.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/merge-storage-engine.html\n\n','mysql> CREATE TABLE t1 (\n    ->    a INT NOT NULL AUTO_INCREMENT PRIMARY KEY,\n    ->    message CHAR(20)) ENGINE=MyISAM;\nmysql> CREATE TABLE t2 (\n    ->    a INT NOT NULL AUTO_INCREMENT PRIMARY KEY,\n    ->    message CHAR(20)) ENGINE=MyISAM;\nmysql> INSERT INTO t1 (message) VALUES (\'Testing\'),(\'table\'),(\'t1\');\nmysql> INSERT INTO t2 (message) VALUES (\'Testing\'),(\'table\'),(\'t2\');\nmysql> CREATE TABLE total (\n    ->    a INT NOT NULL AUTO_INCREMENT,\n    ->    message CHAR(20), INDEX(a))\n    ->    ENGINE=MERGE UNION=(t1,t2) INSERT_METHOD=LAST;\n','http://dev.mysql.com/doc/refman/5.1/en/merge-storage-engine.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (436,37,'CREATE TABLE','Syntax:\nCREATE [TEMPORARY] TABLE [IF NOT EXISTS] tbl_name\n    (create_definition,...)\n    [table_option ...]\n    [partition_options]\n\nOr:\n\nCREATE [TEMPORARY] TABLE [IF NOT EXISTS] tbl_name\n    [(create_definition,...)]\n    [table_option ...]\n    [partition_options]\n    select_statement\n\nOr:\n\nCREATE [TEMPORARY] TABLE [IF NOT EXISTS] tbl_name\n    { LIKE old_tbl_name | (LIKE old_tbl_name) }\n\ncreate_definition:\n    column_definition\n  | [CONSTRAINT [symbol]] PRIMARY KEY [index_type] (index_col_name,...)\n      [index_option ...]\n  | {INDEX|KEY} [index_name] [index_type] (index_col_name,...)\n      [index_option ...]\n  | [CONSTRAINT [symbol]] UNIQUE [INDEX|KEY]\n      [index_name] [index_type] (index_col_name,...)\n      [index_option ...]\n  | {FULLTEXT|SPATIAL} [INDEX|KEY] [index_name] (index_col_name,...)\n      [index_option ...]\n  | [CONSTRAINT [symbol]] FOREIGN KEY\n      [index_name] (index_col_name,...) [reference_definition]\n  | CHECK (expr)\n\ncolumn_definition:\n    col_name data_type [NOT NULL | NULL] [DEFAULT default_value]\n      [AUTO_INCREMENT] [UNIQUE [KEY] | [PRIMARY] KEY]\n      [COMMENT \'string\'] [reference_definition]\n\ndata_type:\n    BIT[(length)]\n  | TINYINT[(length)] [UNSIGNED] [ZEROFILL]\n  | SMALLINT[(length)] [UNSIGNED] [ZEROFILL]\n  | MEDIUMINT[(length)] [UNSIGNED] [ZEROFILL]\n  | INT[(length)] [UNSIGNED] [ZEROFILL]\n  | INTEGER[(length)] [UNSIGNED] [ZEROFILL]\n  | BIGINT[(length)] [UNSIGNED] [ZEROFILL]\n  | REAL[(length,decimals)] [UNSIGNED] [ZEROFILL]\n  | DOUBLE[(length,decimals)] [UNSIGNED] [ZEROFILL]\n  | FLOAT[(length,decimals)] [UNSIGNED] [ZEROFILL]\n  | DECIMAL(length,decimals) [UNSIGNED] [ZEROFILL]\n  | NUMERIC(length,decimals) [UNSIGNED] [ZEROFILL]\n  | DATE\n  | TIME\n  | TIMESTAMP\n  | DATETIME\n  | YEAR\n  | CHAR(length)\n      [CHARACTER SET charset_name] [COLLATE collation_name]\n  | VARCHAR(length)\n      [CHARACTER SET charset_name] [COLLATE collation_name]\n  | BINARY(length)\n  | VARBINARY(length)\n  | TINYBLOB\n  | BLOB\n  | MEDIUMBLOB\n  | LONGBLOB\n  | TINYTEXT [BINARY]\n      [CHARACTER SET charset_name] [COLLATE collation_name]\n  | TEXT [BINARY]\n      [CHARACTER SET charset_name] [COLLATE collation_name]\n  | MEDIUMTEXT [BINARY]\n      [CHARACTER SET charset_name] [COLLATE collation_name]\n  | LONGTEXT [BINARY]\n      [CHARACTER SET charset_name] [COLLATE collation_name]\n  | ENUM(value1,value2,value3,...)\n      [CHARACTER SET charset_name] [COLLATE collation_name]\n  | SET(value1,value2,value3,...)\n      [CHARACTER SET charset_name] [COLLATE collation_name]\n  | spatial_type\n\nindex_col_name:\n    col_name [(length)] [ASC | DESC]\n\nindex_type:\n    USING {BTREE | HASH}\n\nindex_option:\n    KEY_BLOCK_SIZE value\n  | index_type\n  | WITH PARSER parser_name\n\nreference_definition:\n    REFERENCES tbl_name [(index_col_name,...)]\n      [MATCH FULL | MATCH PARTIAL | MATCH SIMPLE]\n      [ON DELETE reference_option]\n      [ON UPDATE reference_option]\n\nreference_option:\n    RESTRICT | CASCADE | SET NULL | NO ACTION\n\ntable_option:\n    [TABLESPACE tablespace_name STORAGE DISK]\n    ENGINE [=] engine_name\n  | AUTO_INCREMENT [=] value\n  | AVG_ROW_LENGTH [=] value\n  | [DEFAULT] CHARACTER SET charset_name\n  | CHECKSUM [=] {0 | 1}\n  | COLLATE collation_name\n  | COMMENT [=] \'string\'\n  | CONNECTION [=] \'connect_string\'\n  | DATA DIRECTORY [=] \'absolute path to directory\'\n  | DELAY_KEY_WRITE [=] {0 | 1}\n  | INDEX DIRECTORY [=] \'absolute path to directory\'\n  | INSERT_METHOD [=] { NO | FIRST | LAST }\n  | KEY_BLOCK_SIZE [=] value\n  | MAX_ROWS [=] value\n  | MIN_ROWS [=] value\n  | PACK_KEYS [=] {0 | 1 | DEFAULT}\n  | PASSWORD [=] \'string\'\n  | ROW_FORMAT [=] {DEFAULT|DYNAMIC|FIXED|COMPRESSED|REDUNDANT|COMPACT}\n  | UNION [=] (tbl_name[,tbl_name]...)\n\npartition_options:\n    PARTITION BY\n          [LINEAR] HASH(expr)\n        | [LINEAR] KEY(column_list)\n        | RANGE(expr)\n        | LIST(expr)\n    [PARTITIONS num]\n    [SUBPARTITION BY\n          [LINEAR] HASH(expr)\n        | [LINEAR] KEY(column_list)\n      [SUBPARTITIONS num]\n    ]\n    [(partition_definition [, partition_definition] ...)]\n\npartition_definition:\n    PARTITION partition_name\n        [VALUES {LESS THAN (expr) | MAXVALUE | IN (value_list)}]\n        [[STORAGE] ENGINE [=] engine_name]\n        [COMMENT [=] \'comment_text\' ]\n        [DATA DIRECTORY [=] \'data_dir\']\n        [INDEX DIRECTORY [=] \'index_dir\']\n        [MAX_ROWS [=] max_number_of_rows]\n        [MIN_ROWS [=] min_number_of_rows]\n        [TABLESPACE [=] (tablespace_name)]\n        [NODEGROUP [=] node_group_id]\n        [(subpartition_definition [, subpartition_definition] ...)]\n\nsubpartition_definition:\n    SUBPARTITION logical_name\n        [[STORAGE] ENGINE [=] engine_name]\n        [COMMENT [=] \'comment_text\' ]\n        [DATA DIRECTORY [=] \'data_dir\']\n        [INDEX DIRECTORY [=] \'index_dir\']\n        [MAX_ROWS [=] max_number_of_rows]\n        [MIN_ROWS [=] min_number_of_rows]\n        [TABLESPACE [=] (tablespace_name)]\n        [NODEGROUP [=] node_group_id]\n\nselect_statement:\n    [IGNORE | REPLACE] [AS] SELECT ...   (Some legal select statement)\n\nCREATE TABLE creates a table with the given name. You must have the\nCREATE privilege for the table.\n\nRules for allowable table names are given in\nhttp://dev.mysql.com/doc/refman/5.1/en/identifiers.html. By default,\nthe table is created in the default database. An error occurs if the\ntable exists, if there is no default database, or if the database does\nnot exist.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/create-table.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/create-table.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (437,18,'>','Syntax:\n>\n\nGreater than:\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html\n\n','mysql> SELECT 2 > 2;\n        -> 0\n','http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (438,20,'ANALYZE TABLE','Syntax:\nANALYZE [LOCAL | NO_WRITE_TO_BINLOG] TABLE tbl_name [, tbl_name] ...\n\nANALYZE TABLE analyzes and stores the key distribution for a table.\nDuring the analysis, the table is locked with a read lock for MyISAM.\nFor InnoDB the table is locked with a write lock. This statement works\nwith MyISAM, and InnoDB tables. For MyISAM tables, this statement is\nequivalent to using myisamchk --analyze.\n\nFor more information on how the analysis works withinInnoDB, see\nhttp://dev.mysql.com/doc/refman/5.1/en/innodb-restrictions.html.\n\nMySQL uses the stored key distribution to decide the order in which\ntables should be joined when you perform a join on something other than\na constant.\n\nThis statement requires SELECT and INSERT privileges for the table.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/analyze-table.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/analyze-table.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (439,29,'MICROSECOND','Syntax:\nMICROSECOND(expr)\n\nReturns the microseconds from the time or datetime expression expr as a\nnumber in the range from 0 to 999999.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT MICROSECOND(\'12:00:00.123456\');\n        -> 123456\nmysql> SELECT MICROSECOND(\'1997-12-31 23:59:59.000010\');\n        -> 10\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (440,37,'CONSTRAINT','InnoDB also supports foreign key constraints. The syntax for a foreign\nkey constraint definition in InnoDB looks like this:\n\n[CONSTRAINT symbol] FOREIGN KEY [id] (index_col_name, ...)\n    REFERENCES tbl_name (index_col_name, ...)\n    [ON DELETE {RESTRICT | CASCADE | SET NULL | NO ACTION}]\n    [ON UPDATE {RESTRICT | CASCADE | SET NULL | NO ACTION}]\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/innodb-foreign-key-constraints.html\n\n','CREATE TABLE product (category INT NOT NULL, id INT NOT NULL,\n                      price DECIMAL,\n                      PRIMARY KEY(category, id)) ENGINE=INNODB;\nCREATE TABLE customer (id INT NOT NULL,\n                       PRIMARY KEY (id)) ENGINE=INNODB;\nCREATE TABLE product_order (no INT NOT NULL AUTO_INCREMENT,\n                            product_category INT NOT NULL,\n                            product_id INT NOT NULL,\n                            customer_id INT NOT NULL,\n                            PRIMARY KEY(no),\n                            INDEX (product_category, product_id),\n                            FOREIGN KEY (product_category, product_id)\n                              REFERENCES product(category, id)\n                              ON UPDATE CASCADE ON DELETE RESTRICT,\n                            INDEX (customer_id),\n                            FOREIGN KEY (customer_id)\n                              REFERENCES customer(id)) ENGINE=INNODB;\n','http://dev.mysql.com/doc/refman/5.1/en/innodb-foreign-key-constraints.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (441,37,'CREATE SERVER','Syntax:\nCREATE SERVER server_name\n    FOREIGN DATA WRAPPER wrapper_name\n    OPTIONS (option ...)\n\noption:\n  { HOST character-literal\n  | DATABASE character-literal\n  | USER character-literal\n  | PASSWORD character-literal\n  | SOCKET character-literal\n  | OWNER character-literal\n  | PORT numeric-literal }\n\nThis statement creates the definition of a server for use with the\nFEDERATED storage engine. The CREATE SERVER statement creates a new row\nwithin the servers table within the mysql database. This statement\nrequires the SUPER privilege.\n\nThe server_name should be a unique reference to the server. Server\ndefinitions are global within the scope of the server, it is not\npossible to qualify the server definition to a specific database.\nserver_name has a maximum length of 63 characters (names longer than 63\ncharacters are silently truncated), and is case insensitive. You may\nspecify the name using single quotes.\n\nThe wrapper_name should be mysql, and may be quoted with single quotes.\nOther values for wrapper_name are not currently supported.\n\nFor each option you must specify either a character literal or numeric\nliteral. Character literals are UTF8, support a maximum length of 64\ncharacters and default to a blank (empty) string. String literals are\nsilently truncated to 64 characters. Numeric literals must be a number\nbetween 0 and 9999, default value is 0.\n\nThe CREATE SERVER statement creates an entry in the mysql.server table\nthat can later be used with the CREATE TABLE statement when creating a\nFEDERATED table. The options that you specify will be used to populate\nthe columns in the mysql.server table. The table columns are\nServer_name, Host, Db, Username, Password, Port and Socket.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/create-server.html\n\n','CREATE SERVER s\nFOREIGN DATA WRAPPER mysql\nOPTIONS (USER \'Remote\', HOST \'192.168.1.106\', DATABASE \'test\');\n','http://dev.mysql.com/doc/refman/5.1/en/create-server.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (442,34,'FIELD','Syntax:\nFIELD(str,str1,str2,str3,...)\n\nReturns the index (position) of str in the str1, str2, str3, ... list.\nReturns 0 if str is not found.\n\nIf all arguments to FIELD() are strings, all arguments are compared as\nstrings. If all arguments are numbers, they are compared as numbers.\nOtherwise, the arguments are compared as double.\n\nIf str is NULL, the return value is 0 because NULL fails equality\ncomparison with any value. FIELD() is the complement of ELT().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT FIELD(\'ej\', \'Hej\', \'ej\', \'Heja\', \'hej\', \'foo\');\n        -> 2\nmysql> SELECT FIELD(\'fo\', \'Hej\', \'ej\', \'Heja\', \'hej\', \'foo\');\n        -> 0\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (443,29,'MAKETIME','Syntax:\nMAKETIME(hour,minute,second)\n\nReturns a time value calculated from the hour, minute, and second\narguments.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT MAKETIME(12,15,30);\n        -> \'12:15:30\'\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (444,29,'CURDATE','Syntax:\nCURDATE()\n\nReturns the current date as a value in \'YYYY-MM-DD\' or YYYYMMDD format,\ndepending on whether the function is used in a string or numeric\ncontext.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT CURDATE();\n        -> \'1997-12-15\'\nmysql> SELECT CURDATE() + 0;\n        -> 19971215\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (445,15,'MIN MAX','Syntax:\nMIN([DISTINCT] expr), MAX([DISTINCT] expr)\n\nReturns the minimum or maximum value of expr. MIN() and MAX() may take\na string argument; in such cases they return the minimum or maximum\nstring value. See\nhttp://dev.mysql.com/doc/refman/5.1/en/mysql-indexes.html. The DISTINCT\nkeyword can be used to find the minimum or maximum of the distinct\nvalues of expr, however, this produces the same result as omitting\nDISTINCT.\n\nMIN() and MAX() return NULL if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html\n\n','mysql> SELECT student_name, MIN(test_score), MAX(test_score)\n    ->        FROM student\n    ->        GROUP BY student_name;\n','http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (446,9,'SET PASSWORD','Syntax:\nSET PASSWORD [FOR user] = PASSWORD(\'some password\')\n\nThe SET PASSWORD statement assigns a password to an existing MySQL user\naccount.\n\nWith no FOR clause, this statement sets the password for the current\nuser. Any client that has connected to the server using a non-anonymous\naccount can change the password for that account.\n\nWith a FOR clause, this statement sets the password for a specific\naccount on the current server host. Only clients that have the UPDATE\nprivilege for the mysql database can do this. The user value should be\ngiven in user_name@host_name format, where user_name and host_name are\nexactly as they are listed in the User and Host columns of the\nmysql.user table entry. For example, if you had an entry with User and\nHost column values of \'bob\' and \'%.loc.gov\', you would write the\nstatement like this:\n\nSET PASSWORD FOR \'bob\'@\'%.loc.gov\' = PASSWORD(\'newpass\');\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/set-password.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/set-password.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (447,21,'ENUM','ENUM(\'value1\',\'value2\',...) [CHARACTER SET charset_name] [COLLATE\ncollation_name]\n\nAn enumeration. A string object that can have only one value, chosen\nfrom the list of values \'value1\', \'value2\', ..., NULL or the special \'\'\nerror value. An ENUM column can have a maximum of 65,535 distinct\nvalues. ENUM values are represented internally as integers.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (448,7,'IF FUNCTION','Syntax:\nIF(expr1,expr2,expr3)\n\nIf expr1 is TRUE (expr1 <> 0 and expr1 <> NULL) then IF() returns\nexpr2; otherwise it returns expr3. IF() returns a numeric or string\nvalue, depending on the context in which it is used.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/control-flow-functions.html\n\n','mysql> SELECT IF(1>2,2,3);\n        -> 3\nmysql> SELECT IF(1<2,\'yes\',\'no\');\n        -> \'yes\'\nmysql> SELECT IF(STRCMP(\'test\',\'test1\'),\'no\',\'yes\');\n        -> \'no\'\n','http://dev.mysql.com/doc/refman/5.1/en/control-flow-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (449,16,'DATABASE','Syntax:\nDATABASE()\n\nReturns the default (current) database name as a string in the utf8\ncharacter set. If there is no default database, DATABASE() returns\nNULL. Within a stored routine, the default database is the database\nthat the routine is associated with, which is not necessarily the same\nas the database that is the default in the calling context.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/information-functions.html\n\n','mysql> SELECT DATABASE();\n        -> \'test\'\n','http://dev.mysql.com/doc/refman/5.1/en/information-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (450,30,'POINTFROMWKB','PointFromWKB(wkb[,srid])\n\nConstructs a POINT value using its WKB representation and SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/gis-wkb-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/gis-wkb-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (451,4,'POWER','Syntax:\nPOW(X,Y), POWER(X,Y)\n\nReturns the value of X raised to the power of Y.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT POW(2,2);\n        -> 4\nmysql> SELECT POW(2,-2);\n        -> 0.25\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (452,4,'ATAN','Syntax:\nATAN(X)\n\nReturns the arc tangent of X, that is, the value whose tangent is X.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT ATAN(2);\n        -> 1.1071487177941\nmysql> SELECT ATAN(-2);\n        -> -1.1071487177941\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (453,34,'STRCMP','Syntax:\nSTRCMP(expr1,expr2)\n\nSTRCMP() returns 0 if the strings are the same, -1 if the first\nargument is smaller than the second according to the current sort\norder, and 1 otherwise.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-comparison-functions.html\n\n','mysql> SELECT STRCMP(\'text\', \'text2\');\n        -> -1\nmysql> SELECT STRCMP(\'text2\', \'text\');\n        -> 1\nmysql> SELECT STRCMP(\'text\', \'text\');\n        -> 0\n','http://dev.mysql.com/doc/refman/5.1/en/string-comparison-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (454,26,'INSERT DELAYED','Syntax:\nINSERT DELAYED ...\n\nThe DELAYED option for the INSERT statement is a MySQL extension to\nstandard SQL that is very useful if you have clients that cannot or\nneed not wait for the INSERT to complete. This is a common situation\nwhen you use MySQL for logging and you also periodically run SELECT and\nUPDATE statements that take a long time to complete.\n\nWhen a client uses INSERT DELAYED, it gets an okay from the server at\nonce, and the row is queued to be inserted when the table is not in use\nby any other thread.\n\nAnother major benefit of using INSERT DELAYED is that inserts from many\nclients are bundled together and written in one block. This is much\nfaster than performing many separate inserts.\n\nNote that INSERT DELAYED is slower than a normal INSERT if the table is\nnot otherwise in use. There is also the additional overhead for the\nserver to handle a separate thread for each table for which there are\ndelayed rows. This means that you should use INSERT DELAYED only when\nyou are really sure that you need it.\n\nThe queued rows are held only in memory until they are inserted into\nthe table. This means that if you terminate mysqld forcibly (for\nexample, with kill -9) or if mysqld dies unexpectedly, any queued rows\nthat have not been written to disk are lost.\n\nThere are some constraints on the use of DELAYED:\n\no INSERT DELAYED works only with MyISAM, MEMORY, and ARCHIVE tables.\n  See\n  http://dev.mysql.com/doc/refman/5.1/en/myisam-storage-engine.html,\n  http://dev.mysql.com/doc/refman/5.1/en/memory-storage-engine.html,\n  and\n  http://dev.mysql.com/doc/refman/5.1/en/archive-storage-engine.html.\n\n  For MyISAM tables, if there are no free blocks in the middle of the\n  data file, concurrent SELECT and INSERT statements are supported.\n  Under these circumstances, you very seldom need to use INSERT DELAYED\n  with MyISAM.\n\no INSERT DELAYED should be used only for INSERT statements that specify\n  value lists. The server ignores DELAYED for INSERT ... SELECT or\n  INSERT ... ON DUPLICATE KEY UPDATE statements.\n\no Because the INSERT DELAYED statement returns immediately, before the\n  rows are inserted, you cannot use LAST_INSERT_ID() to get the\n  AUTO_INCREMENT value that the statement might generate.\n\no DELAYED rows are not visible to SELECT statements until they actually\n  have been inserted.\n\no DELAYED is ignored on slave replication servers because it could\n  cause the slave to have different data than the master.\n\no Pending INSERT DELAYED statements are lost if a table is write locked\n  and ALTER TABLE is used to modify the table structure.\n\no INSERT DELAYED is not supported for views.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/insert-delayed.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/insert-delayed.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (455,26,'SHOW PROCEDURE CODE','Syntax:\nSHOW {PROCEDURE | FUNCTION} CODE sp_name\n\nThese statements are MySQL extensions that are available only for\nservers that have been built with debugging support. They display a\nrepresentation of the internal implementation of the named routine. The\nstatements require that you be the owner of the routine or have SELECT\naccess to the mysql.proc table.\n\nIf the named routine is available, each statement produces a result\nset. Each row in the result set corresponds to one "instruction" in the\nroutine. The first column is Pos, which is an ordinal number beginning\nwith 0. The second column is Instruction, which contains an SQL\nstatement (usually changed from the original source), or a directive\nwhich has meaning only to the stored-routine handler.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-procedure-code.html\n\n','mysql> DELIMITER //\nmysql> CREATE PROCEDURE p1 ()\n    -> BEGIN\n    ->   DECLARE fanta INT DEFAULT 55;\n    ->   DROP TABLE t2;\n    ->   LOOP\n    ->     INSERT INTO t3 VALUES (fanta);\n    ->     END LOOP;\n    ->   END//\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> SHOW PROCEDURE CODE p1//\n+-----+----------------------------------------+\n| Pos | Instruction                            |\n+-----+----------------------------------------+\n|   0 | set fanta@0 55                         |\n|   1 | stmt 9 "DROP TABLE t2"                 |\n|   2 | stmt 5 "INSERT INTO t3 VALUES (fanta)" |\n|   3 | jump 2                                 |\n+-----+----------------------------------------+\n4 rows in set (0.00 sec)\n','http://dev.mysql.com/doc/refman/5.1/en/show-procedure-code.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (456,21,'MEDIUMTEXT','MEDIUMTEXT [CHARACTER SET charset_name] [COLLATE collation_name]\n\nA TEXT column with a maximum length of 16,777,215 (224 - 1) characters.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (457,4,'LN','Syntax:\nLN(X)\n\nReturns the natural logarithm of X; that is, the base-e logarithm of X.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT LN(2);\n        -> 0.69314718055995\nmysql> SELECT LN(-2);\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (458,26,'SHOW COLLATION','Syntax:\nSHOW COLLATION [LIKE \'pattern\']\n\nThe output from SHOW COLLATION includes all available character sets.\nIt takes an optional LIKE clause whose pattern indicates which\ncollation names to match. For example:\n\nmysql> SHOW COLLATION LIKE \'latin1%\';\n+-------------------+---------+----+---------+----------+---------+\n| Collation         | Charset | Id | Default | Compiled | Sortlen |\n+-------------------+---------+----+---------+----------+---------+\n| latin1_german1_ci | latin1  |  5 |         |          |       0 |\n| latin1_swedish_ci | latin1  |  8 | Yes     | Yes      |       0 |\n| latin1_danish_ci  | latin1  | 15 |         |          |       0 |\n| latin1_german2_ci | latin1  | 31 |         | Yes      |       2 |\n| latin1_bin        | latin1  | 47 |         | Yes      |       0 |\n| latin1_general_ci | latin1  | 48 |         |          |       0 |\n| latin1_general_cs | latin1  | 49 |         |          |       0 |\n| latin1_spanish_ci | latin1  | 94 |         |          |       0 |\n+-------------------+---------+----+---------+----------+---------+\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-collation.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-collation.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (459,4,'LOG','Syntax:\nLOG(X), LOG(B,X)\n\nIf called with one parameter, this function returns the natural\nlogarithm of X.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT LOG(2);\n        -> 0.69314718055995\nmysql> SELECT LOG(-2);\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (460,26,'SET SQL_LOG_BIN','Syntax:\nSET SQL_LOG_BIN = {0|1}\n\nDisables or enables binary logging for the current connection\n(SQL_LOG_BIN is a session variable) if the client has the SUPER\nprivilege. The statement is refused with an error if the client does\nnot have that privilege.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/set-sql-log-bin.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/set-sql-log-bin.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (461,18,'!=','Syntax:\n<>, !=\n\nNot equal:\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html\n\n','mysql> SELECT \'.01\' <> \'0.01\';\n        -> 1\nmysql> SELECT .01 <> \'0.01\';\n        -> 0\nmysql> SELECT \'zapp\' <> \'zappp\';\n        -> 1\n','http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (462,36,'WHILE','Syntax:\n[begin_label:] WHILE search_condition DO\n    statement_list\nEND WHILE [end_label]\n\nThe statement list within a WHILE statement is repeated as long as the\nsearch_condition is true. statement_list consists of one or more\nstatements.\n\nA WHILE statement can be labeled. end_label cannot be given unless\nbegin_label also is present. If both are present, they must be the\nsame.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/while-statement.html\n\n','CREATE PROCEDURE dowhile()\nBEGIN\n  DECLARE v1 INT DEFAULT 5;\n\n  WHILE v1 > 0 DO\n    ...\n    SET v1 = v1 - 1;\n  END WHILE;\nEND\n','http://dev.mysql.com/doc/refman/5.1/en/while-statement.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (463,11,'AES_DECRYPT','Syntax:\nAES_ENCRYPT(str,key_str), AES_DECRYPT(crypt_str,key_str)\n\nThese functions allow encryption and decryption of data using the\nofficial AES (Advanced Encryption Standard) algorithm, previously known\nas "Rijndael." Encoding with a 128-bit key length is used, but you can\nextend it up to 256 bits by modifying the source. We chose 128 bits\nbecause it is much faster and it is secure enough for most purposes.\n\nAES_ENCRYPT() encrypts a string and returns a binary string.\nAES_DECRYPT() decrypts the encrypted string and returns the original\nstring. The input arguments may be any length. If either argument is\nNULL, the result of this function is also NULL.\n\nBecause AES is a block-level algorithm, padding is used to encode\nuneven length strings and so the result string length may be calculated\nusing this formula:\n\n16 x (trunc(string_length / 16) + 1)\n\nIf AES_DECRYPT() detects invalid data or incorrect padding, it returns\nNULL. However, it is possible for AES_DECRYPT() to return a non-NULL\nvalue (possibly garbage) if the input data or the key is invalid.\n\nYou can use the AES functions to store data in an encrypted form by\nmodifying your queries:\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html\n\n','INSERT INTO t VALUES (1,AES_ENCRYPT(\'text\',\'password\'));\n','http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (464,37,'RENAME DATABASE','Syntax:\nRENAME {DATABASE | SCHEMA} db_name TO new_db_name;\n\nThis statement renames a database. It requires the ALTER and DROP\nprivileges for the database, and the CREATE privilege for the new\ndatabase. RENAME SCHEMA is a synonym for RENAME DATABASE.\n\nWhen the server receives this statement, it creates a new database.\nThen it moves tables and other database objects such as triggers to the\nnew database. It also updates the Db column in the system tables for\nobjects such as stored routines and events. Finally, the server drops\nthe old database.\n\nNote that currently there are these limitations: RENAME DATABASE does\nnot change any account privileges listed in the system tables. They\nmust be changed manually. RENAME DATABASE does not migrate any stored\nroutines or events to the new schema name. This means that: For stored\nroutines, it does not change any values in the ROUTINE_SCHEMA column of\nthe INFORMATION_SCHEMA.ROUTINES table, or in the db column of the\nmysql.proc table. For events, it does not change any values in the\nEVENT_SCHEMA column of the INFORMATION_SCHEMA.EVENTS table, or in the\ndb column of the mysql.event table.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/rename-database.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/rename-database.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (465,29,'DAYNAME','Syntax:\nDAYNAME(date)\n\nReturns the name of the weekday for date. As of MySQL 5.1.12, the\nlanguage used for the name is controlled by the value of the\nlc_time_names system variable\n(http://dev.mysql.com/doc/refman/5.1/en/locale-support.html).\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT DAYNAME(\'1998-02-05\');\n        -> \'Thursday\'\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (466,16,'COERCIBILITY','Syntax:\nCOERCIBILITY(str)\n\nReturns the collation coercibility value of the string argument.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/information-functions.html\n\n','mysql> SELECT COERCIBILITY(\'abc\' COLLATE latin1_swedish_ci);\n        -> 0\nmysql> SELECT COERCIBILITY(USER());\n        -> 3\nmysql> SELECT COERCIBILITY(\'abc\');\n        -> 4\n','http://dev.mysql.com/doc/refman/5.1/en/information-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (467,21,'INT','INT[(M)] [UNSIGNED] [ZEROFILL]\n\nA normal-size integer. The signed range is -2147483648 to 2147483647.\nThe unsigned range is 0 to 4294967295.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (468,12,'GLENGTH','GLength(ls)\n\nReturns as a double-precision number the length of the LineString value\nls in its associated spatial reference.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/linestring-property-functions.html\n\n','mysql> SET @ls = \'LineString(1 1,2 2,3 3)\';\nmysql> SELECT GLength(GeomFromText(@ls));\n+----------------------------+\n| GLength(GeomFromText(@ls)) |\n+----------------------------+\n|            2.8284271247462 |\n+----------------------------+\n','http://dev.mysql.com/doc/refman/5.1/en/linestring-property-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (469,4,'RADIANS','Syntax:\nRADIANS(X)\n\nReturns the argument X, converted from degrees to radians. (Note that\nπ radians equals 180 degrees.)\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT RADIANS(90);\n        -> 1.5707963267949\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (470,16,'COLLATION','Syntax:\nCOLLATION(str)\n\nReturns the collation of the string argument.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/information-functions.html\n\n','mysql> SELECT COLLATION(\'abc\');\n        -> \'latin1_swedish_ci\'\nmysql> SELECT COLLATION(_utf8\'abc\');\n        -> \'utf8_general_ci\'\n','http://dev.mysql.com/doc/refman/5.1/en/information-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (471,18,'COALESCE','Syntax:\nCOALESCE(value,...)\n\nReturns the first non-NULL value in the list, or NULL if there are no\nnon-NULL values.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html\n\n','mysql> SELECT COALESCE(NULL,1);\n        -> 1\nmysql> SELECT COALESCE(NULL,NULL,NULL);\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (472,16,'VERSION','Syntax:\nVERSION()\n\nReturns a string that indicates the MySQL server version. The string\nuses the utf8 character set.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/information-functions.html\n\n','mysql> SELECT VERSION();\n        -> \'5.1.18-beta-standard\'\n','http://dev.mysql.com/doc/refman/5.1/en/information-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (473,34,'MAKE_SET','Syntax:\nMAKE_SET(bits,str1,str2,...)\n\nReturns a set value (a string containing substrings separated by `,\'\ncharacters) consisting of the strings that have the corresponding bit\nin bits set. str1 corresponds to bit 0, str2 to bit 1, and so on. NULL\nvalues in str1, str2, ... are not appended to the result.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT MAKE_SET(1,\'a\',\'b\',\'c\');\n        -> \'a\'\nmysql> SELECT MAKE_SET(1 | 4,\'hello\',\'nice\',\'world\');\n        -> \'hello,world\'\nmysql> SELECT MAKE_SET(1 | 4,\'hello\',\'nice\',NULL,\'world\');\n        -> \'hello\'\nmysql> SELECT MAKE_SET(0,\'a\',\'b\',\'c\');\n        -> \'\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (474,34,'FIND_IN_SET','Syntax:\nFIND_IN_SET(str,strlist)\n\nReturns a value in the range of 1 to N if the string str is in the\nstring list strlist consisting of N substrings. A string list is a\nstring composed of substrings separated by `,\' characters. If the first\nargument is a constant string and the second is a column of type SET,\nthe FIND_IN_SET() function is optimized to use bit arithmetic. Returns\n0 if str is not in strlist or if strlist is the empty string. Returns\nNULL if either argument is NULL. This function does not work properly\nif the first argument contains a comma (`,\') character.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT FIND_IN_SET(\'b\',\'a,b,c,d\');\n        -> 2\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');

insert into help_keyword (help_keyword_id,name) values (0,'JOIN');
insert into help_keyword (help_keyword_id,name) values (1,'HOST');
insert into help_keyword (help_keyword_id,name) values (2,'REPEAT');
insert into help_keyword (help_keyword_id,name) values (3,'SERIALIZABLE');
insert into help_keyword (help_keyword_id,name) values (4,'REPLACE');
insert into help_keyword (help_keyword_id,name) values (5,'RETURNS');
insert into help_keyword (help_keyword_id,name) values (6,'MASTER_SSL_CA');
insert into help_keyword (help_keyword_id,name) values (7,'NCHAR');
insert into help_keyword (help_keyword_id,name) values (8,'COLUMNS');
insert into help_keyword (help_keyword_id,name) values (9,'WORK');
insert into help_keyword (help_keyword_id,name) values (10,'DATETIME');
insert into help_keyword (help_keyword_id,name) values (11,'MODE');
insert into help_keyword (help_keyword_id,name) values (12,'OPEN');
insert into help_keyword (help_keyword_id,name) values (13,'INTEGER');
insert into help_keyword (help_keyword_id,name) values (14,'ESCAPE');
insert into help_keyword (help_keyword_id,name) values (15,'VALUE');
insert into help_keyword (help_keyword_id,name) values (16,'GEOMETRYCOLLECTIONFROMWKB');
insert into help_keyword (help_keyword_id,name) values (17,'SQL_BIG_RESULT');
insert into help_keyword (help_keyword_id,name) values (18,'DROP');
insert into help_keyword (help_keyword_id,name) values (19,'EVENTS');
insert into help_keyword (help_keyword_id,name) values (20,'MONTH');
insert into help_keyword (help_keyword_id,name) values (21,'INFO');
insert into help_keyword (help_keyword_id,name) values (22,'DUPLICATE');
insert into help_keyword (help_keyword_id,name) values (23,'REPLICATION');
insert into help_keyword (help_keyword_id,name) values (24,'INNODB');
insert into help_keyword (help_keyword_id,name) values (25,'YEAR_MONTH');
insert into help_keyword (help_keyword_id,name) values (26,'SUBJECT');
insert into help_keyword (help_keyword_id,name) values (27,'PREPARE');
insert into help_keyword (help_keyword_id,name) values (28,'LOCK');
insert into help_keyword (help_keyword_id,name) values (29,'NDB');
insert into help_keyword (help_keyword_id,name) values (30,'CHECK');
insert into help_keyword (help_keyword_id,name) values (31,'FULL');
insert into help_keyword (help_keyword_id,name) values (32,'INT4');
insert into help_keyword (help_keyword_id,name) values (33,'BY');
insert into help_keyword (help_keyword_id,name) values (34,'NO');
insert into help_keyword (help_keyword_id,name) values (35,'MINUTE');
insert into help_keyword (help_keyword_id,name) values (36,'PARTITION');
insert into help_keyword (help_keyword_id,name) values (37,'DATA');
insert into help_keyword (help_keyword_id,name) values (38,'DAY');
insert into help_keyword (help_keyword_id,name) values (39,'SHARE');
insert into help_keyword (help_keyword_id,name) values (40,'REAL');
insert into help_keyword (help_keyword_id,name) values (41,'SEPARATOR');
insert into help_keyword (help_keyword_id,name) values (42,'DELETE');
insert into help_keyword (help_keyword_id,name) values (43,'ON');
insert into help_keyword (help_keyword_id,name) values (44,'CONNECTION');
insert into help_keyword (help_keyword_id,name) values (45,'CLOSE');
insert into help_keyword (help_keyword_id,name) values (46,'X509');
insert into help_keyword (help_keyword_id,name) values (47,'USE');
insert into help_keyword (help_keyword_id,name) values (48,'WHERE');
insert into help_keyword (help_keyword_id,name) values (49,'PRIVILEGES');
insert into help_keyword (help_keyword_id,name) values (50,'EVENT');
insert into help_keyword (help_keyword_id,name) values (51,'SPATIAL');
insert into help_keyword (help_keyword_id,name) values (52,'SUPER');
insert into help_keyword (help_keyword_id,name) values (53,'SQL_BUFFER_RESULT');
insert into help_keyword (help_keyword_id,name) values (54,'IGNORE');
insert into help_keyword (help_keyword_id,name) values (55,'QUICK');
insert into help_keyword (help_keyword_id,name) values (56,'SIGNED');
insert into help_keyword (help_keyword_id,name) values (57,'SECURITY');
insert into help_keyword (help_keyword_id,name) values (58,'POLYGONFROMWKB');
insert into help_keyword (help_keyword_id,name) values (59,'NDBCLUSTER');
insert into help_keyword (help_keyword_id,name) values (60,'FALSE');
insert into help_keyword (help_keyword_id,name) values (61,'LEVEL');
insert into help_keyword (help_keyword_id,name) values (62,'FORCE');
insert into help_keyword (help_keyword_id,name) values (63,'BINARY');
insert into help_keyword (help_keyword_id,name) values (64,'TO');
insert into help_keyword (help_keyword_id,name) values (65,'CHANGE');
insert into help_keyword (help_keyword_id,name) values (66,'HOUR_MINUTE');
insert into help_keyword (help_keyword_id,name) values (67,'UPDATE');
insert into help_keyword (help_keyword_id,name) values (68,'INTO');
insert into help_keyword (help_keyword_id,name) values (69,'FEDERATED');
insert into help_keyword (help_keyword_id,name) values (70,'VARYING');
insert into help_keyword (help_keyword_id,name) values (71,'HOUR_SECOND');
insert into help_keyword (help_keyword_id,name) values (72,'VARIABLE');
insert into help_keyword (help_keyword_id,name) values (73,'ROLLBACK');
insert into help_keyword (help_keyword_id,name) values (74,'PROCEDURE');
insert into help_keyword (help_keyword_id,name) values (75,'RTREE');
insert into help_keyword (help_keyword_id,name) values (76,'TIMESTAMP');
insert into help_keyword (help_keyword_id,name) values (77,'IMPORT');
insert into help_keyword (help_keyword_id,name) values (78,'AGAINST');
insert into help_keyword (help_keyword_id,name) values (79,'CHECKSUM');
insert into help_keyword (help_keyword_id,name) values (80,'COUNT');
insert into help_keyword (help_keyword_id,name) values (81,'LONGBINARY');
insert into help_keyword (help_keyword_id,name) values (82,'THEN');
insert into help_keyword (help_keyword_id,name) values (83,'INSERT');
insert into help_keyword (help_keyword_id,name) values (84,'HANDLER');
insert into help_keyword (help_keyword_id,name) values (85,'ENGINES');
insert into help_keyword (help_keyword_id,name) values (86,'PORT');
insert into help_keyword (help_keyword_id,name) values (87,'DAY_SECOND');
insert into help_keyword (help_keyword_id,name) values (88,'EXISTS');
insert into help_keyword (help_keyword_id,name) values (89,'MUTEX');
insert into help_keyword (help_keyword_id,name) values (90,'RELEASE');
insert into help_keyword (help_keyword_id,name) values (91,'BOOLEAN');
insert into help_keyword (help_keyword_id,name) values (92,'MOD');
insert into help_keyword (help_keyword_id,name) values (93,'DEFAULT');
insert into help_keyword (help_keyword_id,name) values (94,'TYPE');
insert into help_keyword (help_keyword_id,name) values (95,'NO_WRITE_TO_BINLOG');
insert into help_keyword (help_keyword_id,name) values (96,'RESET');
insert into help_keyword (help_keyword_id,name) values (97,'INSTALL');
insert into help_keyword (help_keyword_id,name) values (98,'DO');
insert into help_keyword (help_keyword_id,name) values (99,'ITERATE');
insert into help_keyword (help_keyword_id,name) values (100,'BIGINT');
insert into help_keyword (help_keyword_id,name) values (101,'SET');
insert into help_keyword (help_keyword_id,name) values (102,'ISSUER');
insert into help_keyword (help_keyword_id,name) values (103,'DATE');
insert into help_keyword (help_keyword_id,name) values (104,'STATUS');
insert into help_keyword (help_keyword_id,name) values (105,'FULLTEXT');
insert into help_keyword (help_keyword_id,name) values (106,'COMMENT');
insert into help_keyword (help_keyword_id,name) values (107,'MASTER_CONNECT_RETRY');
insert into help_keyword (help_keyword_id,name) values (108,'INNER');
insert into help_keyword (help_keyword_id,name) values (109,'STOP');
insert into help_keyword (help_keyword_id,name) values (110,'MASTER_LOG_FILE');
insert into help_keyword (help_keyword_id,name) values (111,'MRG_MYISAM');
insert into help_keyword (help_keyword_id,name) values (112,'PRECISION');
insert into help_keyword (help_keyword_id,name) values (113,'REQUIRE');
insert into help_keyword (help_keyword_id,name) values (114,'TRAILING');
insert into help_keyword (help_keyword_id,name) values (115,'LONG');
insert into help_keyword (help_keyword_id,name) values (116,'OPTION');
insert into help_keyword (help_keyword_id,name) values (117,'ELSE');
insert into help_keyword (help_keyword_id,name) values (118,'DEALLOCATE');
insert into help_keyword (help_keyword_id,name) values (119,'IO_THREAD');
insert into help_keyword (help_keyword_id,name) values (120,'CASE');
insert into help_keyword (help_keyword_id,name) values (121,'CIPHER');
insert into help_keyword (help_keyword_id,name) values (122,'CONTINUE');
insert into help_keyword (help_keyword_id,name) values (123,'FROM');
insert into help_keyword (help_keyword_id,name) values (124,'READ');
insert into help_keyword (help_keyword_id,name) values (125,'LEFT');
insert into help_keyword (help_keyword_id,name) values (126,'ELSEIF');
insert into help_keyword (help_keyword_id,name) values (127,'MINUTE_SECOND');
insert into help_keyword (help_keyword_id,name) values (128,'COMPACT');
insert into help_keyword (help_keyword_id,name) values (129,'DEC');
insert into help_keyword (help_keyword_id,name) values (130,'FOR');
insert into help_keyword (help_keyword_id,name) values (131,'WARNINGS');
insert into help_keyword (help_keyword_id,name) values (132,'MIN_ROWS');
insert into help_keyword (help_keyword_id,name) values (133,'STRING');
insert into help_keyword (help_keyword_id,name) values (134,'CONDITION');
insert into help_keyword (help_keyword_id,name) values (135,'FUNCTION');
insert into help_keyword (help_keyword_id,name) values (136,'ENCLOSED');
insert into help_keyword (help_keyword_id,name) values (137,'AGGREGATE');
insert into help_keyword (help_keyword_id,name) values (138,'FIELDS');
insert into help_keyword (help_keyword_id,name) values (139,'INT3');
insert into help_keyword (help_keyword_id,name) values (140,'ARCHIVE');
insert into help_keyword (help_keyword_id,name) values (141,'ADD');
insert into help_keyword (help_keyword_id,name) values (142,'AVG_ROW_LENGTH');
insert into help_keyword (help_keyword_id,name) values (143,'FLOAT4');
insert into help_keyword (help_keyword_id,name) values (144,'VIEW');
insert into help_keyword (help_keyword_id,name) values (145,'REPEATABLE');
insert into help_keyword (help_keyword_id,name) values (146,'INFILE');
insert into help_keyword (help_keyword_id,name) values (147,'ORDER');
insert into help_keyword (help_keyword_id,name) values (148,'USING');
insert into help_keyword (help_keyword_id,name) values (149,'MIDDLEINT');
insert into help_keyword (help_keyword_id,name) values (150,'GRANT');
insert into help_keyword (help_keyword_id,name) values (151,'UNSIGNED');
insert into help_keyword (help_keyword_id,name) values (152,'DECIMAL');
insert into help_keyword (help_keyword_id,name) values (153,'GEOMETRYFROMTEXT');
insert into help_keyword (help_keyword_id,name) values (154,'INDEXES');
insert into help_keyword (help_keyword_id,name) values (155,'FOREIGN');
insert into help_keyword (help_keyword_id,name) values (156,'CACHE');
insert into help_keyword (help_keyword_id,name) values (157,'HOSTS');
insert into help_keyword (help_keyword_id,name) values (158,'COMMIT');
insert into help_keyword (help_keyword_id,name) values (159,'SCHEMAS');
insert into help_keyword (help_keyword_id,name) values (160,'LEADING');
insert into help_keyword (help_keyword_id,name) values (161,'SNAPSHOT');
insert into help_keyword (help_keyword_id,name) values (162,'DECLARE');
insert into help_keyword (help_keyword_id,name) values (163,'LOAD');
insert into help_keyword (help_keyword_id,name) values (164,'SQL_CACHE');
insert into help_keyword (help_keyword_id,name) values (165,'CONVERT');
insert into help_keyword (help_keyword_id,name) values (166,'DYNAMIC');
insert into help_keyword (help_keyword_id,name) values (167,'POLYGONFROMTEXT');
insert into help_keyword (help_keyword_id,name) values (168,'COLLATE');
insert into help_keyword (help_keyword_id,name) values (169,'BYTE');
insert into help_keyword (help_keyword_id,name) values (170,'LINESTRINGFROMWKB');
insert into help_keyword (help_keyword_id,name) values (171,'GLOBAL');
insert into help_keyword (help_keyword_id,name) values (172,'WHEN');
insert into help_keyword (help_keyword_id,name) values (173,'HAVING');
insert into help_keyword (help_keyword_id,name) values (174,'AS');
insert into help_keyword (help_keyword_id,name) values (175,'STARTING');
insert into help_keyword (help_keyword_id,name) values (176,'RELOAD');
insert into help_keyword (help_keyword_id,name) values (177,'AUTOCOMMIT');
insert into help_keyword (help_keyword_id,name) values (178,'REVOKE');
insert into help_keyword (help_keyword_id,name) values (179,'GRANTS');
insert into help_keyword (help_keyword_id,name) values (180,'OUTER');
insert into help_keyword (help_keyword_id,name) values (181,'FLOOR');
insert into help_keyword (help_keyword_id,name) values (182,'WITH');
insert into help_keyword (help_keyword_id,name) values (183,'STD');
insert into help_keyword (help_keyword_id,name) values (184,'AFTER');
insert into help_keyword (help_keyword_id,name) values (185,'CSV');
insert into help_keyword (help_keyword_id,name) values (186,'DISABLE');
insert into help_keyword (help_keyword_id,name) values (187,'UNINSTALL');
insert into help_keyword (help_keyword_id,name) values (188,'OUTFILE');
insert into help_keyword (help_keyword_id,name) values (189,'LOW_PRIORITY');
insert into help_keyword (help_keyword_id,name) values (190,'FILE');
insert into help_keyword (help_keyword_id,name) values (191,'SCHEMA');
insert into help_keyword (help_keyword_id,name) values (192,'SONAME');
insert into help_keyword (help_keyword_id,name) values (193,'POW');
insert into help_keyword (help_keyword_id,name) values (194,'MULTIPOINTFROMWKB');
insert into help_keyword (help_keyword_id,name) values (195,'INDEX');
insert into help_keyword (help_keyword_id,name) values (196,'MULTIPOINTFROMTEXT');
insert into help_keyword (help_keyword_id,name) values (197,'BACKUP');
insert into help_keyword (help_keyword_id,name) values (198,'MULTILINESTRINGFROMWKB');
insert into help_keyword (help_keyword_id,name) values (199,'EXTENDED');
insert into help_keyword (help_keyword_id,name) values (200,'CROSS');
insert into help_keyword (help_keyword_id,name) values (201,'CONTRIBUTORS');
insert into help_keyword (help_keyword_id,name) values (202,'NATIONAL');
insert into help_keyword (help_keyword_id,name) values (203,'GROUP');
insert into help_keyword (help_keyword_id,name) values (204,'UNDO');
insert into help_keyword (help_keyword_id,name) values (205,'ZEROFILL');
insert into help_keyword (help_keyword_id,name) values (206,'CLIENT');
insert into help_keyword (help_keyword_id,name) values (207,'MASTER_PASSWORD');
insert into help_keyword (help_keyword_id,name) values (208,'OWNER');
insert into help_keyword (help_keyword_id,name) values (209,'RELAY_LOG_FILE');
insert into help_keyword (help_keyword_id,name) values (210,'TRUE');
insert into help_keyword (help_keyword_id,name) values (211,'CHARACTER');
insert into help_keyword (help_keyword_id,name) values (212,'MASTER_USER');
insert into help_keyword (help_keyword_id,name) values (213,'ENGINE');
insert into help_keyword (help_keyword_id,name) values (214,'TABLE');
insert into help_keyword (help_keyword_id,name) values (215,'INSERT_METHOD');
insert into help_keyword (help_keyword_id,name) values (216,'CASCADE');
insert into help_keyword (help_keyword_id,name) values (217,'RELAY_LOG_POS');
insert into help_keyword (help_keyword_id,name) values (218,'SQL_CALC_FOUND_ROWS');
insert into help_keyword (help_keyword_id,name) values (219,'MYISAM');
insert into help_keyword (help_keyword_id,name) values (220,'LEAVE');
insert into help_keyword (help_keyword_id,name) values (221,'MODIFY');
insert into help_keyword (help_keyword_id,name) values (222,'MATCH');
insert into help_keyword (help_keyword_id,name) values (223,'MASTER_LOG_POS');
insert into help_keyword (help_keyword_id,name) values (224,'DESC');
insert into help_keyword (help_keyword_id,name) values (225,'DISTINCTROW');
insert into help_keyword (help_keyword_id,name) values (226,'TIME');
insert into help_keyword (help_keyword_id,name) values (227,'NUMERIC');
insert into help_keyword (help_keyword_id,name) values (228,'EXPANSION');
insert into help_keyword (help_keyword_id,name) values (229,'CURSOR');
insert into help_keyword (help_keyword_id,name) values (230,'CODE');
insert into help_keyword (help_keyword_id,name) values (231,'GEOMETRYCOLLECTIONFROMTEXT');
insert into help_keyword (help_keyword_id,name) values (232,'CHAIN');
insert into help_keyword (help_keyword_id,name) values (233,'FLUSH');
insert into help_keyword (help_keyword_id,name) values (234,'CREATE');
insert into help_keyword (help_keyword_id,name) values (235,'ISAM');
insert into help_keyword (help_keyword_id,name) values (236,'MAX_UPDATES_PER_HOUR');
insert into help_keyword (help_keyword_id,name) values (237,'INT2');
insert into help_keyword (help_keyword_id,name) values (238,'PROCESSLIST');
insert into help_keyword (help_keyword_id,name) values (239,'LOGS');
insert into help_keyword (help_keyword_id,name) values (240,'HEAP');
insert into help_keyword (help_keyword_id,name) values (241,'SOUNDS');
insert into help_keyword (help_keyword_id,name) values (242,'BETWEEN');
insert into help_keyword (help_keyword_id,name) values (243,'MULTILINESTRINGFROMTEXT');
insert into help_keyword (help_keyword_id,name) values (244,'PACK_KEYS');
insert into help_keyword (help_keyword_id,name) values (245,'CALL');
insert into help_keyword (help_keyword_id,name) values (246,'FAST');
insert into help_keyword (help_keyword_id,name) values (247,'VALUES');
insert into help_keyword (help_keyword_id,name) values (248,'LOOP');
insert into help_keyword (help_keyword_id,name) values (249,'VARCHARACTER');
insert into help_keyword (help_keyword_id,name) values (250,'BEFORE');
insert into help_keyword (help_keyword_id,name) values (251,'SHOW');
insert into help_keyword (help_keyword_id,name) values (252,'REDUNDANT');
insert into help_keyword (help_keyword_id,name) values (253,'ALL');
insert into help_keyword (help_keyword_id,name) values (254,'USER_RESOURCES');
insert into help_keyword (help_keyword_id,name) values (255,'PARTIAL');
insert into help_keyword (help_keyword_id,name) values (256,'BINLOG');
insert into help_keyword (help_keyword_id,name) values (257,'END');
insert into help_keyword (help_keyword_id,name) values (258,'SECOND');
insert into help_keyword (help_keyword_id,name) values (259,'AND');
insert into help_keyword (help_keyword_id,name) values (260,'FLOAT8');
insert into help_keyword (help_keyword_id,name) values (261,'PREV');
insert into help_keyword (help_keyword_id,name) values (262,'HOUR');
insert into help_keyword (help_keyword_id,name) values (263,'SELECT');
insert into help_keyword (help_keyword_id,name) values (264,'DATABASES');
insert into help_keyword (help_keyword_id,name) values (265,'OR');
insert into help_keyword (help_keyword_id,name) values (266,'IDENTIFIED');
insert into help_keyword (help_keyword_id,name) values (267,'WRAPPER');
insert into help_keyword (help_keyword_id,name) values (268,'MASTER_SSL_CIPHER');
insert into help_keyword (help_keyword_id,name) values (269,'SQL_SLAVE_SKIP_COUNTER');
insert into help_keyword (help_keyword_id,name) values (270,'BOTH');
insert into help_keyword (help_keyword_id,name) values (271,'BOOL');
insert into help_keyword (help_keyword_id,name) values (272,'YEAR');
insert into help_keyword (help_keyword_id,name) values (273,'MASTER_PORT');
insert into help_keyword (help_keyword_id,name) values (274,'CONCURRENT');
insert into help_keyword (help_keyword_id,name) values (275,'HELP');
insert into help_keyword (help_keyword_id,name) values (276,'UNIQUE');
insert into help_keyword (help_keyword_id,name) values (277,'TRIGGERS');
insert into help_keyword (help_keyword_id,name) values (278,'PROCESS');
insert into help_keyword (help_keyword_id,name) values (279,'OPTIONS');
insert into help_keyword (help_keyword_id,name) values (280,'CONSISTENT');
insert into help_keyword (help_keyword_id,name) values (281,'MASTER_SSL');
insert into help_keyword (help_keyword_id,name) values (282,'DATE_ADD');
insert into help_keyword (help_keyword_id,name) values (283,'MAX_CONNECTIONS_PER_HOUR');
insert into help_keyword (help_keyword_id,name) values (284,'LIKE');
insert into help_keyword (help_keyword_id,name) values (285,'PLUGIN');
insert into help_keyword (help_keyword_id,name) values (286,'FETCH');
insert into help_keyword (help_keyword_id,name) values (287,'IN');
insert into help_keyword (help_keyword_id,name) values (288,'COLUMN');
insert into help_keyword (help_keyword_id,name) values (289,'DUMPFILE');
insert into help_keyword (help_keyword_id,name) values (290,'USAGE');
insert into help_keyword (help_keyword_id,name) values (291,'EXECUTE');
insert into help_keyword (help_keyword_id,name) values (292,'MEMORY');
insert into help_keyword (help_keyword_id,name) values (293,'CEIL');
insert into help_keyword (help_keyword_id,name) values (294,'QUERY');
insert into help_keyword (help_keyword_id,name) values (295,'MASTER_HOST');
insert into help_keyword (help_keyword_id,name) values (296,'LINES');
insert into help_keyword (help_keyword_id,name) values (297,'SQL_THREAD');
insert into help_keyword (help_keyword_id,name) values (298,'MAX_QUERIES_PER_HOUR');
insert into help_keyword (help_keyword_id,name) values (299,'MULTIPOLYGONFROMWKB');
insert into help_keyword (help_keyword_id,name) values (300,'MASTER_SSL_CERT');
insert into help_keyword (help_keyword_id,name) values (301,'DAY_MINUTE');
insert into help_keyword (help_keyword_id,name) values (302,'TRANSACTION');
insert into help_keyword (help_keyword_id,name) values (303,'DATE_SUB');
insert into help_keyword (help_keyword_id,name) values (304,'GEOMETRYFROMWKB');
insert into help_keyword (help_keyword_id,name) values (305,'RENAME');
insert into help_keyword (help_keyword_id,name) values (306,'INT1');
insert into help_keyword (help_keyword_id,name) values (307,'PARSER');
insert into help_keyword (help_keyword_id,name) values (308,'ALTER');
insert into help_keyword (help_keyword_id,name) values (309,'MAX_ROWS');
insert into help_keyword (help_keyword_id,name) values (310,'RIGHT');
insert into help_keyword (help_keyword_id,name) values (311,'SOCKET');
insert into help_keyword (help_keyword_id,name) values (312,'STRAIGHT_JOIN');
insert into help_keyword (help_keyword_id,name) values (313,'NATURAL');
insert into help_keyword (help_keyword_id,name) values (314,'VARIABLES');
insert into help_keyword (help_keyword_id,name) values (315,'ESCAPED');
insert into help_keyword (help_keyword_id,name) values (316,'SHA1');
insert into help_keyword (help_keyword_id,name) values (317,'KEY_BLOCK_SIZE');
insert into help_keyword (help_keyword_id,name) values (318,'PASSWORD');
insert into help_keyword (help_keyword_id,name) values (319,'CHAR');
insert into help_keyword (help_keyword_id,name) values (320,'OFFSET');
insert into help_keyword (help_keyword_id,name) values (321,'NEXT');
insert into help_keyword (help_keyword_id,name) values (322,'SQL_LOG_BIN');
insert into help_keyword (help_keyword_id,name) values (323,'ERRORS');
insert into help_keyword (help_keyword_id,name) values (324,'TEMPORARY');
insert into help_keyword (help_keyword_id,name) values (325,'COMMITTED');
insert into help_keyword (help_keyword_id,name) values (326,'SQL_SMALL_RESULT');
insert into help_keyword (help_keyword_id,name) values (327,'UPGRADE');
insert into help_keyword (help_keyword_id,name) values (328,'DELAY_KEY_WRITE');
insert into help_keyword (help_keyword_id,name) values (329,'BEGIN');
insert into help_keyword (help_keyword_id,name) values (330,'MEDIUM');
insert into help_keyword (help_keyword_id,name) values (331,'INTERVAL');
insert into help_keyword (help_keyword_id,name) values (332,'SSL');
insert into help_keyword (help_keyword_id,name) values (333,'DAY_HOUR');
insert into help_keyword (help_keyword_id,name) values (334,'REFERENCES');
insert into help_keyword (help_keyword_id,name) values (335,'AES_ENCRYPT');
insert into help_keyword (help_keyword_id,name) values (336,'STORAGE');
insert into help_keyword (help_keyword_id,name) values (337,'ISOLATION');
insert into help_keyword (help_keyword_id,name) values (338,'INT8');
insert into help_keyword (help_keyword_id,name) values (339,'AUTHORS');
insert into help_keyword (help_keyword_id,name) values (340,'RESTRICT');
insert into help_keyword (help_keyword_id,name) values (341,'LINESTRINGFROMTEXT');
insert into help_keyword (help_keyword_id,name) values (342,'UNCOMMITTED');
insert into help_keyword (help_keyword_id,name) values (343,'IS');
insert into help_keyword (help_keyword_id,name) values (344,'NOT');
insert into help_keyword (help_keyword_id,name) values (345,'ANALYSE');
insert into help_keyword (help_keyword_id,name) values (346,'DES_KEY_FILE');
insert into help_keyword (help_keyword_id,name) values (347,'COMPRESSED');
insert into help_keyword (help_keyword_id,name) values (348,'START');
insert into help_keyword (help_keyword_id,name) values (349,'PLUGINS');
insert into help_keyword (help_keyword_id,name) values (350,'SAVEPOINT');
insert into help_keyword (help_keyword_id,name) values (351,'IF');
insert into help_keyword (help_keyword_id,name) values (352,'PRIMARY');
insert into help_keyword (help_keyword_id,name) values (353,'INNOBASE');
insert into help_keyword (help_keyword_id,name) values (354,'USER');
insert into help_keyword (help_keyword_id,name) values (355,'LAST');
insert into help_keyword (help_keyword_id,name) values (356,'EXIT');
insert into help_keyword (help_keyword_id,name) values (357,'KEYS');
insert into help_keyword (help_keyword_id,name) values (358,'LIMIT');
insert into help_keyword (help_keyword_id,name) values (359,'KEY');
insert into help_keyword (help_keyword_id,name) values (360,'MERGE');
insert into help_keyword (help_keyword_id,name) values (361,'UNTIL');
insert into help_keyword (help_keyword_id,name) values (362,'SQL_NO_CACHE');
insert into help_keyword (help_keyword_id,name) values (363,'DELAYED');
insert into help_keyword (help_keyword_id,name) values (364,'CONSTRAINT');
insert into help_keyword (help_keyword_id,name) values (365,'SERIAL');
insert into help_keyword (help_keyword_id,name) values (366,'ACTION');
insert into help_keyword (help_keyword_id,name) values (367,'WRITE');
insert into help_keyword (help_keyword_id,name) values (368,'SESSION');
insert into help_keyword (help_keyword_id,name) values (369,'DATABASE');
insert into help_keyword (help_keyword_id,name) values (370,'NULL');
insert into help_keyword (help_keyword_id,name) values (371,'USE_FRM');
insert into help_keyword (help_keyword_id,name) values (372,'SLAVE');
insert into help_keyword (help_keyword_id,name) values (373,'TERMINATED');
insert into help_keyword (help_keyword_id,name) values (374,'ASC');
insert into help_keyword (help_keyword_id,name) values (375,'ENABLE');
insert into help_keyword (help_keyword_id,name) values (376,'OPTIONALLY');
insert into help_keyword (help_keyword_id,name) values (377,'DIRECTORY');
insert into help_keyword (help_keyword_id,name) values (378,'WHILE');
insert into help_keyword (help_keyword_id,name) values (379,'MAX_USER_CONNECTIONS');
insert into help_keyword (help_keyword_id,name) values (380,'DISTINCT');
insert into help_keyword (help_keyword_id,name) values (381,'LOCAL');
insert into help_keyword (help_keyword_id,name) values (382,'MASTER_SSL_KEY');
insert into help_keyword (help_keyword_id,name) values (383,'NONE');
insert into help_keyword (help_keyword_id,name) values (384,'TABLES');
insert into help_keyword (help_keyword_id,name) values (385,'<>');
insert into help_keyword (help_keyword_id,name) values (386,'RLIKE');
insert into help_keyword (help_keyword_id,name) values (387,'TRIGGER');
insert into help_keyword (help_keyword_id,name) values (388,'COLLATION');
insert into help_keyword (help_keyword_id,name) values (389,'SHUTDOWN');
insert into help_keyword (help_keyword_id,name) values (390,'HIGH_PRIORITY');
insert into help_keyword (help_keyword_id,name) values (391,'BTREE');
insert into help_keyword (help_keyword_id,name) values (392,'FIRST');
insert into help_keyword (help_keyword_id,name) values (393,'TYPES');
insert into help_keyword (help_keyword_id,name) values (394,'MASTER');
insert into help_keyword (help_keyword_id,name) values (395,'FIXED');
insert into help_keyword (help_keyword_id,name) values (396,'MULTIPOLYGONFROMTEXT');
insert into help_keyword (help_keyword_id,name) values (397,'ROW_FORMAT');

insert into help_relation (help_topic_id,help_keyword_id) values (332,0);
insert into help_relation (help_topic_id,help_keyword_id) values (441,1);
insert into help_relation (help_topic_id,help_keyword_id) values (212,2);
insert into help_relation (help_topic_id,help_keyword_id) values (416,3);
insert into help_relation (help_topic_id,help_keyword_id) values (396,4);
insert into help_relation (help_topic_id,help_keyword_id) values (193,5);
insert into help_relation (help_topic_id,help_keyword_id) values (173,6);
insert into help_relation (help_topic_id,help_keyword_id) values (401,7);
insert into help_relation (help_topic_id,help_keyword_id) values (323,8);
insert into help_relation (help_topic_id,help_keyword_id) values (20,8);
insert into help_relation (help_topic_id,help_keyword_id) values (132,9);
insert into help_relation (help_topic_id,help_keyword_id) values (354,10);
insert into help_relation (help_topic_id,help_keyword_id) values (78,11);
insert into help_relation (help_topic_id,help_keyword_id) values (332,11);
insert into help_relation (help_topic_id,help_keyword_id) values (15,12);
insert into help_relation (help_topic_id,help_keyword_id) values (119,12);
insert into help_relation (help_topic_id,help_keyword_id) values (323,12);
insert into help_relation (help_topic_id,help_keyword_id) values (93,12);
insert into help_relation (help_topic_id,help_keyword_id) values (467,13);
insert into help_relation (help_topic_id,help_keyword_id) values (193,13);
insert into help_relation (help_topic_id,help_keyword_id) values (357,14);
insert into help_relation (help_topic_id,help_keyword_id) values (222,15);
insert into help_relation (help_topic_id,help_keyword_id) values (95,16);
insert into help_relation (help_topic_id,help_keyword_id) values (332,17);
insert into help_relation (help_topic_id,help_keyword_id) values (217,18);
insert into help_relation (help_topic_id,help_keyword_id) values (254,18);
insert into help_relation (help_topic_id,help_keyword_id) values (389,18);
insert into help_relation (help_topic_id,help_keyword_id) values (77,18);
insert into help_relation (help_topic_id,help_keyword_id) values (28,18);
insert into help_relation (help_topic_id,help_keyword_id) values (242,18);
insert into help_relation (help_topic_id,help_keyword_id) values (174,18);
insert into help_relation (help_topic_id,help_keyword_id) values (381,18);
insert into help_relation (help_topic_id,help_keyword_id) values (431,18);
insert into help_relation (help_topic_id,help_keyword_id) values (109,19);
insert into help_relation (help_topic_id,help_keyword_id) values (353,20);
insert into help_relation (help_topic_id,help_keyword_id) values (239,21);
insert into help_relation (help_topic_id,help_keyword_id) values (91,22);
insert into help_relation (help_topic_id,help_keyword_id) values (185,23);
insert into help_relation (help_topic_id,help_keyword_id) values (376,24);
insert into help_relation (help_topic_id,help_keyword_id) values (323,24);
insert into help_relation (help_topic_id,help_keyword_id) values (436,24);
insert into help_relation (help_topic_id,help_keyword_id) values (353,25);
insert into help_relation (help_topic_id,help_keyword_id) values (185,26);
insert into help_relation (help_topic_id,help_keyword_id) values (32,27);
insert into help_relation (help_topic_id,help_keyword_id) values (217,27);
insert into help_relation (help_topic_id,help_keyword_id) values (332,28);
insert into help_relation (help_topic_id,help_keyword_id) values (436,29);
insert into help_relation (help_topic_id,help_keyword_id) values (436,30);
insert into help_relation (help_topic_id,help_keyword_id) values (323,31);
insert into help_relation (help_topic_id,help_keyword_id) values (20,31);
insert into help_relation (help_topic_id,help_keyword_id) values (272,31);
insert into help_relation (help_topic_id,help_keyword_id) values (436,31);
insert into help_relation (help_topic_id,help_keyword_id) values (421,31);
insert into help_relation (help_topic_id,help_keyword_id) values (467,32);
insert into help_relation (help_topic_id,help_keyword_id) values (46,33);
insert into help_relation (help_topic_id,help_keyword_id) values (436,33);
insert into help_relation (help_topic_id,help_keyword_id) values (74,33);
insert into help_relation (help_topic_id,help_keyword_id) values (185,33);
insert into help_relation (help_topic_id,help_keyword_id) values (332,33);
insert into help_relation (help_topic_id,help_keyword_id) values (396,33);
insert into help_relation (help_topic_id,help_keyword_id) values (339,33);
insert into help_relation (help_topic_id,help_keyword_id) values (431,33);
insert into help_relation (help_topic_id,help_keyword_id) values (440,34);
insert into help_relation (help_topic_id,help_keyword_id) values (436,34);
insert into help_relation (help_topic_id,help_keyword_id) values (353,35);
insert into help_relation (help_topic_id,help_keyword_id) values (436,36);
insert into help_relation (help_topic_id,help_keyword_id) values (441,37);
insert into help_relation (help_topic_id,help_keyword_id) values (104,37);
insert into help_relation (help_topic_id,help_keyword_id) values (436,37);
insert into help_relation (help_topic_id,help_keyword_id) values (396,37);
insert into help_relation (help_topic_id,help_keyword_id) values (353,38);
insert into help_relation (help_topic_id,help_keyword_id) values (332,39);
insert into help_relation (help_topic_id,help_keyword_id) values (291,40);
insert into help_relation (help_topic_id,help_keyword_id) values (193,40);
insert into help_relation (help_topic_id,help_keyword_id) values (339,41);
insert into help_relation (help_topic_id,help_keyword_id) values (440,42);
insert into help_relation (help_topic_id,help_keyword_id) values (436,42);
insert into help_relation (help_topic_id,help_keyword_id) values (440,43);
insert into help_relation (help_topic_id,help_keyword_id) values (0,43);
insert into help_relation (help_topic_id,help_keyword_id) values (436,44);
insert into help_relation (help_topic_id,help_keyword_id) values (49,45);
insert into help_relation (help_topic_id,help_keyword_id) values (93,45);
insert into help_relation (help_topic_id,help_keyword_id) values (185,46);
insert into help_relation (help_topic_id,help_keyword_id) values (0,47);
insert into help_relation (help_topic_id,help_keyword_id) values (46,48);
insert into help_relation (help_topic_id,help_keyword_id) values (74,48);
insert into help_relation (help_topic_id,help_keyword_id) values (93,48);
insert into help_relation (help_topic_id,help_keyword_id) values (178,49);
insert into help_relation (help_topic_id,help_keyword_id) values (228,49);
insert into help_relation (help_topic_id,help_keyword_id) values (185,49);
insert into help_relation (help_topic_id,help_keyword_id) values (334,50);
insert into help_relation (help_topic_id,help_keyword_id) values (195,51);
insert into help_relation (help_topic_id,help_keyword_id) values (431,51);
insert into help_relation (help_topic_id,help_keyword_id) values (185,52);
insert into help_relation (help_topic_id,help_keyword_id) values (332,53);
insert into help_relation (help_topic_id,help_keyword_id) values (0,54);
insert into help_relation (help_topic_id,help_keyword_id) values (332,54);
insert into help_relation (help_topic_id,help_keyword_id) values (91,54);
insert into help_relation (help_topic_id,help_keyword_id) values (74,54);
insert into help_relation (help_topic_id,help_keyword_id) values (396,54);
insert into help_relation (help_topic_id,help_keyword_id) values (431,54);
insert into help_relation (help_topic_id,help_keyword_id) values (434,55);
insert into help_relation (help_topic_id,help_keyword_id) values (390,55);
insert into help_relation (help_topic_id,help_keyword_id) values (46,55);
insert into help_relation (help_topic_id,help_keyword_id) values (354,56);
insert into help_relation (help_topic_id,help_keyword_id) values (185,57);
insert into help_relation (help_topic_id,help_keyword_id) values (80,58);
insert into help_relation (help_topic_id,help_keyword_id) values (450,58);
insert into help_relation (help_topic_id,help_keyword_id) values (436,59);
insert into help_relation (help_topic_id,help_keyword_id) values (362,60);
insert into help_relation (help_topic_id,help_keyword_id) values (416,61);
insert into help_relation (help_topic_id,help_keyword_id) values (0,62);
insert into help_relation (help_topic_id,help_keyword_id) values (36,63);
insert into help_relation (help_topic_id,help_keyword_id) values (354,63);
insert into help_relation (help_topic_id,help_keyword_id) values (432,64);
insert into help_relation (help_topic_id,help_keyword_id) values (428,64);
insert into help_relation (help_topic_id,help_keyword_id) values (173,64);
insert into help_relation (help_topic_id,help_keyword_id) values (173,65);
insert into help_relation (help_topic_id,help_keyword_id) values (431,65);
insert into help_relation (help_topic_id,help_keyword_id) values (353,66);
insert into help_relation (help_topic_id,help_keyword_id) values (440,67);
insert into help_relation (help_topic_id,help_keyword_id) values (332,67);
insert into help_relation (help_topic_id,help_keyword_id) values (91,67);
insert into help_relation (help_topic_id,help_keyword_id) values (281,68);
insert into help_relation (help_topic_id,help_keyword_id) values (332,68);
insert into help_relation (help_topic_id,help_keyword_id) values (91,68);
insert into help_relation (help_topic_id,help_keyword_id) values (41,68);
insert into help_relation (help_topic_id,help_keyword_id) values (436,69);
insert into help_relation (help_topic_id,help_keyword_id) values (236,70);
insert into help_relation (help_topic_id,help_keyword_id) values (353,71);
insert into help_relation (help_topic_id,help_keyword_id) values (116,72);
insert into help_relation (help_topic_id,help_keyword_id) values (132,73);
insert into help_relation (help_topic_id,help_keyword_id) values (428,73);
insert into help_relation (help_topic_id,help_keyword_id) values (16,74);
insert into help_relation (help_topic_id,help_keyword_id) values (410,74);
insert into help_relation (help_topic_id,help_keyword_id) values (323,74);
insert into help_relation (help_topic_id,help_keyword_id) values (278,74);
insert into help_relation (help_topic_id,help_keyword_id) values (455,74);
insert into help_relation (help_topic_id,help_keyword_id) values (389,74);
insert into help_relation (help_topic_id,help_keyword_id) values (305,74);
insert into help_relation (help_topic_id,help_keyword_id) values (171,74);
insert into help_relation (help_topic_id,help_keyword_id) values (332,74);
insert into help_relation (help_topic_id,help_keyword_id) values (195,75);
insert into help_relation (help_topic_id,help_keyword_id) values (175,76);
insert into help_relation (help_topic_id,help_keyword_id) values (86,76);
insert into help_relation (help_topic_id,help_keyword_id) values (396,77);
insert into help_relation (help_topic_id,help_keyword_id) values (78,78);
insert into help_relation (help_topic_id,help_keyword_id) values (436,79);
insert into help_relation (help_topic_id,help_keyword_id) values (61,80);
insert into help_relation (help_topic_id,help_keyword_id) values (404,80);
insert into help_relation (help_topic_id,help_keyword_id) values (306,80);
insert into help_relation (help_topic_id,help_keyword_id) values (263,81);
insert into help_relation (help_topic_id,help_keyword_id) values (75,82);
insert into help_relation (help_topic_id,help_keyword_id) values (26,82);
insert into help_relation (help_topic_id,help_keyword_id) values (392,82);
insert into help_relation (help_topic_id,help_keyword_id) values (179,83);
insert into help_relation (help_topic_id,help_keyword_id) values (91,83);
insert into help_relation (help_topic_id,help_keyword_id) values (454,83);
insert into help_relation (help_topic_id,help_keyword_id) values (290,84);
insert into help_relation (help_topic_id,help_keyword_id) values (323,85);
insert into help_relation (help_topic_id,help_keyword_id) values (259,85);
insert into help_relation (help_topic_id,help_keyword_id) values (441,86);
insert into help_relation (help_topic_id,help_keyword_id) values (353,87);
insert into help_relation (help_topic_id,help_keyword_id) values (141,88);
insert into help_relation (help_topic_id,help_keyword_id) values (28,88);
insert into help_relation (help_topic_id,help_keyword_id) values (8,88);
insert into help_relation (help_topic_id,help_keyword_id) values (254,88);
insert into help_relation (help_topic_id,help_keyword_id) values (323,89);
insert into help_relation (help_topic_id,help_keyword_id) values (343,89);
insert into help_relation (help_topic_id,help_keyword_id) values (132,90);
insert into help_relation (help_topic_id,help_keyword_id) values (78,91);
insert into help_relation (help_topic_id,help_keyword_id) values (22,91);
insert into help_relation (help_topic_id,help_keyword_id) values (99,92);
insert into help_relation (help_topic_id,help_keyword_id) values (160,92);
insert into help_relation (help_topic_id,help_keyword_id) values (91,93);
insert into help_relation (help_topic_id,help_keyword_id) values (436,93);
insert into help_relation (help_topic_id,help_keyword_id) values (222,93);
insert into help_relation (help_topic_id,help_keyword_id) values (183,93);
insert into help_relation (help_topic_id,help_keyword_id) values (431,93);
insert into help_relation (help_topic_id,help_keyword_id) values (431,94);
insert into help_relation (help_topic_id,help_keyword_id) values (434,95);
insert into help_relation (help_topic_id,help_keyword_id) values (304,95);
insert into help_relation (help_topic_id,help_keyword_id) values (101,95);
insert into help_relation (help_topic_id,help_keyword_id) values (438,95);
insert into help_relation (help_topic_id,help_keyword_id) values (35,96);
insert into help_relation (help_topic_id,help_keyword_id) values (243,96);
insert into help_relation (help_topic_id,help_keyword_id) values (137,96);
insert into help_relation (help_topic_id,help_keyword_id) values (393,97);
insert into help_relation (help_topic_id,help_keyword_id) values (462,98);
insert into help_relation (help_topic_id,help_keyword_id) values (111,99);
insert into help_relation (help_topic_id,help_keyword_id) values (204,100);
insert into help_relation (help_topic_id,help_keyword_id) values (125,101);
insert into help_relation (help_topic_id,help_keyword_id) values (310,101);
insert into help_relation (help_topic_id,help_keyword_id) values (323,101);
insert into help_relation (help_topic_id,help_keyword_id) values (436,101);
insert into help_relation (help_topic_id,help_keyword_id) values (74,101);
insert into help_relation (help_topic_id,help_keyword_id) values (132,101);
insert into help_relation (help_topic_id,help_keyword_id) values (440,101);
insert into help_relation (help_topic_id,help_keyword_id) values (169,101);
insert into help_relation (help_topic_id,help_keyword_id) values (460,101);
insert into help_relation (help_topic_id,help_keyword_id) values (196,101);
insert into help_relation (help_topic_id,help_keyword_id) values (396,101);
insert into help_relation (help_topic_id,help_keyword_id) values (41,101);
insert into help_relation (help_topic_id,help_keyword_id) values (431,101);
insert into help_relation (help_topic_id,help_keyword_id) values (185,102);
insert into help_relation (help_topic_id,help_keyword_id) values (241,103);
insert into help_relation (help_topic_id,help_keyword_id) values (117,103);
insert into help_relation (help_topic_id,help_keyword_id) values (354,103);
insert into help_relation (help_topic_id,help_keyword_id) values (353,103);
insert into help_relation (help_topic_id,help_keyword_id) values (323,104);
insert into help_relation (help_topic_id,help_keyword_id) values (343,104);
insert into help_relation (help_topic_id,help_keyword_id) values (206,104);
insert into help_relation (help_topic_id,help_keyword_id) values (376,104);
insert into help_relation (help_topic_id,help_keyword_id) values (53,104);
insert into help_relation (help_topic_id,help_keyword_id) values (305,104);
insert into help_relation (help_topic_id,help_keyword_id) values (122,104);
insert into help_relation (help_topic_id,help_keyword_id) values (198,104);
insert into help_relation (help_topic_id,help_keyword_id) values (436,105);
insert into help_relation (help_topic_id,help_keyword_id) values (195,105);
insert into help_relation (help_topic_id,help_keyword_id) values (431,105);
insert into help_relation (help_topic_id,help_keyword_id) values (436,106);
insert into help_relation (help_topic_id,help_keyword_id) values (173,107);
insert into help_relation (help_topic_id,help_keyword_id) values (0,108);
insert into help_relation (help_topic_id,help_keyword_id) values (50,109);
insert into help_relation (help_topic_id,help_keyword_id) values (173,110);
insert into help_relation (help_topic_id,help_keyword_id) values (436,111);
insert into help_relation (help_topic_id,help_keyword_id) values (291,112);
insert into help_relation (help_topic_id,help_keyword_id) values (185,113);
insert into help_relation (help_topic_id,help_keyword_id) values (424,114);
insert into help_relation (help_topic_id,help_keyword_id) values (263,115);
insert into help_relation (help_topic_id,help_keyword_id) values (185,116);
insert into help_relation (help_topic_id,help_keyword_id) values (75,117);
insert into help_relation (help_topic_id,help_keyword_id) values (392,117);
insert into help_relation (help_topic_id,help_keyword_id) values (217,118);
insert into help_relation (help_topic_id,help_keyword_id) values (50,119);
insert into help_relation (help_topic_id,help_keyword_id) values (302,119);
insert into help_relation (help_topic_id,help_keyword_id) values (75,120);
insert into help_relation (help_topic_id,help_keyword_id) values (392,120);
insert into help_relation (help_topic_id,help_keyword_id) values (185,121);
insert into help_relation (help_topic_id,help_keyword_id) values (290,122);
insert into help_relation (help_topic_id,help_keyword_id) values (323,123);
insert into help_relation (help_topic_id,help_keyword_id) values (104,123);
insert into help_relation (help_topic_id,help_keyword_id) values (424,123);
insert into help_relation (help_topic_id,help_keyword_id) values (46,123);
insert into help_relation (help_topic_id,help_keyword_id) values (109,123);
insert into help_relation (help_topic_id,help_keyword_id) values (332,123);
insert into help_relation (help_topic_id,help_keyword_id) values (338,123);
insert into help_relation (help_topic_id,help_keyword_id) values (416,124);
insert into help_relation (help_topic_id,help_keyword_id) values (33,124);
insert into help_relation (help_topic_id,help_keyword_id) values (93,124);
insert into help_relation (help_topic_id,help_keyword_id) values (0,125);
insert into help_relation (help_topic_id,help_keyword_id) values (26,126);
insert into help_relation (help_topic_id,help_keyword_id) values (353,127);
insert into help_relation (help_topic_id,help_keyword_id) values (436,128);
insert into help_relation (help_topic_id,help_keyword_id) values (192,129);
insert into help_relation (help_topic_id,help_keyword_id) values (290,130);
insert into help_relation (help_topic_id,help_keyword_id) values (323,130);
insert into help_relation (help_topic_id,help_keyword_id) values (166,130);
insert into help_relation (help_topic_id,help_keyword_id) values (332,130);
insert into help_relation (help_topic_id,help_keyword_id) values (394,130);
insert into help_relation (help_topic_id,help_keyword_id) values (323,131);
insert into help_relation (help_topic_id,help_keyword_id) values (306,131);
insert into help_relation (help_topic_id,help_keyword_id) values (436,132);
insert into help_relation (help_topic_id,help_keyword_id) values (193,133);
insert into help_relation (help_topic_id,help_keyword_id) values (166,134);
insert into help_relation (help_topic_id,help_keyword_id) values (16,135);
insert into help_relation (help_topic_id,help_keyword_id) values (410,135);
insert into help_relation (help_topic_id,help_keyword_id) values (323,135);
insert into help_relation (help_topic_id,help_keyword_id) values (278,135);
insert into help_relation (help_topic_id,help_keyword_id) values (455,135);
insert into help_relation (help_topic_id,help_keyword_id) values (389,135);
insert into help_relation (help_topic_id,help_keyword_id) values (305,135);
insert into help_relation (help_topic_id,help_keyword_id) values (193,135);
insert into help_relation (help_topic_id,help_keyword_id) values (381,135);
insert into help_relation (help_topic_id,help_keyword_id) values (396,136);
insert into help_relation (help_topic_id,help_keyword_id) values (193,137);
insert into help_relation (help_topic_id,help_keyword_id) values (323,138);
insert into help_relation (help_topic_id,help_keyword_id) values (396,138);
insert into help_relation (help_topic_id,help_keyword_id) values (231,139);
insert into help_relation (help_topic_id,help_keyword_id) values (436,140);
insert into help_relation (help_topic_id,help_keyword_id) values (55,141);
insert into help_relation (help_topic_id,help_keyword_id) values (431,141);
insert into help_relation (help_topic_id,help_keyword_id) values (436,142);
insert into help_relation (help_topic_id,help_keyword_id) values (431,142);
insert into help_relation (help_topic_id,help_keyword_id) values (154,143);
insert into help_relation (help_topic_id,help_keyword_id) values (28,144);
insert into help_relation (help_topic_id,help_keyword_id) values (145,144);
insert into help_relation (help_topic_id,help_keyword_id) values (416,145);
insert into help_relation (help_topic_id,help_keyword_id) values (396,146);
insert into help_relation (help_topic_id,help_keyword_id) values (46,147);
insert into help_relation (help_topic_id,help_keyword_id) values (332,147);
insert into help_relation (help_topic_id,help_keyword_id) values (74,147);
insert into help_relation (help_topic_id,help_keyword_id) values (431,147);
insert into help_relation (help_topic_id,help_keyword_id) values (339,147);
insert into help_relation (help_topic_id,help_keyword_id) values (0,148);
insert into help_relation (help_topic_id,help_keyword_id) values (76,148);
insert into help_relation (help_topic_id,help_keyword_id) values (46,148);
insert into help_relation (help_topic_id,help_keyword_id) values (231,149);
insert into help_relation (help_topic_id,help_keyword_id) values (185,150);
insert into help_relation (help_topic_id,help_keyword_id) values (291,151);
insert into help_relation (help_topic_id,help_keyword_id) values (467,151);
insert into help_relation (help_topic_id,help_keyword_id) values (192,151);
insert into help_relation (help_topic_id,help_keyword_id) values (22,151);
insert into help_relation (help_topic_id,help_keyword_id) values (354,151);
insert into help_relation (help_topic_id,help_keyword_id) values (154,151);
insert into help_relation (help_topic_id,help_keyword_id) values (115,151);
insert into help_relation (help_topic_id,help_keyword_id) values (142,152);
insert into help_relation (help_topic_id,help_keyword_id) values (193,152);
insert into help_relation (help_topic_id,help_keyword_id) values (386,153);
insert into help_relation (help_topic_id,help_keyword_id) values (323,154);
insert into help_relation (help_topic_id,help_keyword_id) values (440,155);
insert into help_relation (help_topic_id,help_keyword_id) values (441,155);
insert into help_relation (help_topic_id,help_keyword_id) values (436,155);
insert into help_relation (help_topic_id,help_keyword_id) values (431,155);
insert into help_relation (help_topic_id,help_keyword_id) values (281,156);
insert into help_relation (help_topic_id,help_keyword_id) values (89,156);
insert into help_relation (help_topic_id,help_keyword_id) values (137,156);
insert into help_relation (help_topic_id,help_keyword_id) values (131,157);
insert into help_relation (help_topic_id,help_keyword_id) values (323,157);
insert into help_relation (help_topic_id,help_keyword_id) values (132,158);
insert into help_relation (help_topic_id,help_keyword_id) values (323,159);
insert into help_relation (help_topic_id,help_keyword_id) values (146,159);
insert into help_relation (help_topic_id,help_keyword_id) values (424,160);
insert into help_relation (help_topic_id,help_keyword_id) values (132,161);
insert into help_relation (help_topic_id,help_keyword_id) values (290,162);
insert into help_relation (help_topic_id,help_keyword_id) values (166,162);
insert into help_relation (help_topic_id,help_keyword_id) values (394,162);
insert into help_relation (help_topic_id,help_keyword_id) values (183,162);
insert into help_relation (help_topic_id,help_keyword_id) values (281,163);
insert into help_relation (help_topic_id,help_keyword_id) values (104,163);
insert into help_relation (help_topic_id,help_keyword_id) values (396,163);
insert into help_relation (help_topic_id,help_keyword_id) values (338,163);
insert into help_relation (help_topic_id,help_keyword_id) values (332,164);
insert into help_relation (help_topic_id,help_keyword_id) values (354,165);
insert into help_relation (help_topic_id,help_keyword_id) values (436,166);
insert into help_relation (help_topic_id,help_keyword_id) values (371,167);
insert into help_relation (help_topic_id,help_keyword_id) values (436,168);
insert into help_relation (help_topic_id,help_keyword_id) values (433,169);
insert into help_relation (help_topic_id,help_keyword_id) values (420,170);
insert into help_relation (help_topic_id,help_keyword_id) values (116,171);
insert into help_relation (help_topic_id,help_keyword_id) values (416,171);
insert into help_relation (help_topic_id,help_keyword_id) values (169,171);
insert into help_relation (help_topic_id,help_keyword_id) values (326,171);
insert into help_relation (help_topic_id,help_keyword_id) values (122,171);
insert into help_relation (help_topic_id,help_keyword_id) values (75,172);
insert into help_relation (help_topic_id,help_keyword_id) values (392,172);
insert into help_relation (help_topic_id,help_keyword_id) values (332,173);
insert into help_relation (help_topic_id,help_keyword_id) values (0,174);
insert into help_relation (help_topic_id,help_keyword_id) values (33,174);
insert into help_relation (help_topic_id,help_keyword_id) values (332,174);
insert into help_relation (help_topic_id,help_keyword_id) values (396,175);
insert into help_relation (help_topic_id,help_keyword_id) values (185,176);
insert into help_relation (help_topic_id,help_keyword_id) values (132,177);
insert into help_relation (help_topic_id,help_keyword_id) values (228,178);
insert into help_relation (help_topic_id,help_keyword_id) values (323,179);
insert into help_relation (help_topic_id,help_keyword_id) values (177,179);
insert into help_relation (help_topic_id,help_keyword_id) values (0,180);
insert into help_relation (help_topic_id,help_keyword_id) values (204,181);
insert into help_relation (help_topic_id,help_keyword_id) values (78,182);
insert into help_relation (help_topic_id,help_keyword_id) values (436,182);
insert into help_relation (help_topic_id,help_keyword_id) values (195,182);
insert into help_relation (help_topic_id,help_keyword_id) values (185,182);
insert into help_relation (help_topic_id,help_keyword_id) values (431,182);
insert into help_relation (help_topic_id,help_keyword_id) values (382,183);
insert into help_relation (help_topic_id,help_keyword_id) values (431,184);
insert into help_relation (help_topic_id,help_keyword_id) values (436,185);
insert into help_relation (help_topic_id,help_keyword_id) values (396,185);
insert into help_relation (help_topic_id,help_keyword_id) values (431,186);
insert into help_relation (help_topic_id,help_keyword_id) values (269,187);
insert into help_relation (help_topic_id,help_keyword_id) values (332,188);
insert into help_relation (help_topic_id,help_keyword_id) values (33,189);
insert into help_relation (help_topic_id,help_keyword_id) values (46,189);
insert into help_relation (help_topic_id,help_keyword_id) values (91,189);
insert into help_relation (help_topic_id,help_keyword_id) values (74,189);
insert into help_relation (help_topic_id,help_keyword_id) values (41,189);
insert into help_relation (help_topic_id,help_keyword_id) values (396,189);
insert into help_relation (help_topic_id,help_keyword_id) values (185,190);
insert into help_relation (help_topic_id,help_keyword_id) values (323,191);
insert into help_relation (help_topic_id,help_keyword_id) values (464,191);
insert into help_relation (help_topic_id,help_keyword_id) values (141,191);
insert into help_relation (help_topic_id,help_keyword_id) values (286,191);
insert into help_relation (help_topic_id,help_keyword_id) values (174,191);
insert into help_relation (help_topic_id,help_keyword_id) values (196,191);
insert into help_relation (help_topic_id,help_keyword_id) values (193,192);
insert into help_relation (help_topic_id,help_keyword_id) values (451,193);
insert into help_relation (help_topic_id,help_keyword_id) values (430,194);
insert into help_relation (help_topic_id,help_keyword_id) values (323,195);
insert into help_relation (help_topic_id,help_keyword_id) values (0,195);
insert into help_relation (help_topic_id,help_keyword_id) values (436,195);
insert into help_relation (help_topic_id,help_keyword_id) values (281,195);
insert into help_relation (help_topic_id,help_keyword_id) values (77,195);
insert into help_relation (help_topic_id,help_keyword_id) values (55,195);
insert into help_relation (help_topic_id,help_keyword_id) values (285,195);
insert into help_relation (help_topic_id,help_keyword_id) values (89,195);
insert into help_relation (help_topic_id,help_keyword_id) values (195,195);
insert into help_relation (help_topic_id,help_keyword_id) values (431,195);
insert into help_relation (help_topic_id,help_keyword_id) values (398,196);
insert into help_relation (help_topic_id,help_keyword_id) values (335,197);
insert into help_relation (help_topic_id,help_keyword_id) values (250,198);
insert into help_relation (help_topic_id,help_keyword_id) values (434,199);
insert into help_relation (help_topic_id,help_keyword_id) values (0,200);
insert into help_relation (help_topic_id,help_keyword_id) values (323,201);
insert into help_relation (help_topic_id,help_keyword_id) values (6,201);
insert into help_relation (help_topic_id,help_keyword_id) values (236,202);
insert into help_relation (help_topic_id,help_keyword_id) values (401,202);
insert into help_relation (help_topic_id,help_keyword_id) values (332,203);
insert into help_relation (help_topic_id,help_keyword_id) values (290,204);
insert into help_relation (help_topic_id,help_keyword_id) values (291,205);
insert into help_relation (help_topic_id,help_keyword_id) values (467,205);
insert into help_relation (help_topic_id,help_keyword_id) values (192,205);
insert into help_relation (help_topic_id,help_keyword_id) values (22,205);
insert into help_relation (help_topic_id,help_keyword_id) values (154,205);
insert into help_relation (help_topic_id,help_keyword_id) values (115,205);
insert into help_relation (help_topic_id,help_keyword_id) values (185,206);
insert into help_relation (help_topic_id,help_keyword_id) values (173,207);
insert into help_relation (help_topic_id,help_keyword_id) values (441,208);
insert into help_relation (help_topic_id,help_keyword_id) values (173,209);
insert into help_relation (help_topic_id,help_keyword_id) values (362,210);
insert into help_relation (help_topic_id,help_keyword_id) values (310,211);
insert into help_relation (help_topic_id,help_keyword_id) values (323,211);
insert into help_relation (help_topic_id,help_keyword_id) values (236,211);
insert into help_relation (help_topic_id,help_keyword_id) values (401,211);
insert into help_relation (help_topic_id,help_keyword_id) values (436,211);
insert into help_relation (help_topic_id,help_keyword_id) values (196,211);
insert into help_relation (help_topic_id,help_keyword_id) values (396,211);
insert into help_relation (help_topic_id,help_keyword_id) values (173,212);
insert into help_relation (help_topic_id,help_keyword_id) values (323,213);
insert into help_relation (help_topic_id,help_keyword_id) values (343,213);
insert into help_relation (help_topic_id,help_keyword_id) values (436,213);
insert into help_relation (help_topic_id,help_keyword_id) values (431,213);
insert into help_relation (help_topic_id,help_keyword_id) values (255,214);
insert into help_relation (help_topic_id,help_keyword_id) values (323,214);
insert into help_relation (help_topic_id,help_keyword_id) values (55,214);
insert into help_relation (help_topic_id,help_keyword_id) values (198,214);
insert into help_relation (help_topic_id,help_keyword_id) values (335,214);
insert into help_relation (help_topic_id,help_keyword_id) values (338,214);
insert into help_relation (help_topic_id,help_keyword_id) values (254,214);
insert into help_relation (help_topic_id,help_keyword_id) values (436,215);
insert into help_relation (help_topic_id,help_keyword_id) values (440,216);
insert into help_relation (help_topic_id,help_keyword_id) values (28,216);
insert into help_relation (help_topic_id,help_keyword_id) values (436,216);
insert into help_relation (help_topic_id,help_keyword_id) values (254,216);
insert into help_relation (help_topic_id,help_keyword_id) values (173,217);
insert into help_relation (help_topic_id,help_keyword_id) values (332,218);
insert into help_relation (help_topic_id,help_keyword_id) values (436,219);
insert into help_relation (help_topic_id,help_keyword_id) values (287,220);
insert into help_relation (help_topic_id,help_keyword_id) values (431,221);
insert into help_relation (help_topic_id,help_keyword_id) values (78,222);
insert into help_relation (help_topic_id,help_keyword_id) values (173,223);
insert into help_relation (help_topic_id,help_keyword_id) values (307,224);
insert into help_relation (help_topic_id,help_keyword_id) values (332,224);
insert into help_relation (help_topic_id,help_keyword_id) values (339,224);
insert into help_relation (help_topic_id,help_keyword_id) values (332,225);
insert into help_relation (help_topic_id,help_keyword_id) values (292,226);
insert into help_relation (help_topic_id,help_keyword_id) values (352,226);
insert into help_relation (help_topic_id,help_keyword_id) values (354,226);
insert into help_relation (help_topic_id,help_keyword_id) values (192,227);
insert into help_relation (help_topic_id,help_keyword_id) values (78,228);
insert into help_relation (help_topic_id,help_keyword_id) values (394,229);
insert into help_relation (help_topic_id,help_keyword_id) values (455,230);
insert into help_relation (help_topic_id,help_keyword_id) values (225,231);
insert into help_relation (help_topic_id,help_keyword_id) values (132,232);
insert into help_relation (help_topic_id,help_keyword_id) values (137,233);
insert into help_relation (help_topic_id,help_keyword_id) values (16,234);
insert into help_relation (help_topic_id,help_keyword_id) values (323,234);
insert into help_relation (help_topic_id,help_keyword_id) values (19,234);
insert into help_relation (help_topic_id,help_keyword_id) values (141,234);
insert into help_relation (help_topic_id,help_keyword_id) values (436,234);
insert into help_relation (help_topic_id,help_keyword_id) values (278,234);
insert into help_relation (help_topic_id,help_keyword_id) values (255,234);
insert into help_relation (help_topic_id,help_keyword_id) values (55,234);
insert into help_relation (help_topic_id,help_keyword_id) values (286,234);
insert into help_relation (help_topic_id,help_keyword_id) values (193,234);
insert into help_relation (help_topic_id,help_keyword_id) values (195,234);
insert into help_relation (help_topic_id,help_keyword_id) values (334,234);
insert into help_relation (help_topic_id,help_keyword_id) values (436,235);
insert into help_relation (help_topic_id,help_keyword_id) values (185,236);
insert into help_relation (help_topic_id,help_keyword_id) values (213,237);
insert into help_relation (help_topic_id,help_keyword_id) values (323,238);
insert into help_relation (help_topic_id,help_keyword_id) values (421,238);
insert into help_relation (help_topic_id,help_keyword_id) values (36,239);
insert into help_relation (help_topic_id,help_keyword_id) values (323,239);
insert into help_relation (help_topic_id,help_keyword_id) values (343,239);
insert into help_relation (help_topic_id,help_keyword_id) values (436,240);
insert into help_relation (help_topic_id,help_keyword_id) values (355,241);
insert into help_relation (help_topic_id,help_keyword_id) values (133,242);
insert into help_relation (help_topic_id,help_keyword_id) values (94,243);
insert into help_relation (help_topic_id,help_keyword_id) values (436,244);
insert into help_relation (help_topic_id,help_keyword_id) values (315,245);
insert into help_relation (help_topic_id,help_keyword_id) values (390,246);
insert into help_relation (help_topic_id,help_keyword_id) values (41,247);
insert into help_relation (help_topic_id,help_keyword_id) values (320,248);
insert into help_relation (help_topic_id,help_keyword_id) values (236,249);
insert into help_relation (help_topic_id,help_keyword_id) values (432,250);
insert into help_relation (help_topic_id,help_keyword_id) values (178,251);
insert into help_relation (help_topic_id,help_keyword_id) values (310,251);
insert into help_relation (help_topic_id,help_keyword_id) values (61,251);
insert into help_relation (help_topic_id,help_keyword_id) values (6,251);
insert into help_relation (help_topic_id,help_keyword_id) values (119,251);
insert into help_relation (help_topic_id,help_keyword_id) values (376,251);
insert into help_relation (help_topic_id,help_keyword_id) values (255,251);
insert into help_relation (help_topic_id,help_keyword_id) values (9,251);
insert into help_relation (help_topic_id,help_keyword_id) values (259,251);
insert into help_relation (help_topic_id,help_keyword_id) values (122,251);
insert into help_relation (help_topic_id,help_keyword_id) values (198,251);
insert into help_relation (help_topic_id,help_keyword_id) values (16,251);
insert into help_relation (help_topic_id,help_keyword_id) values (20,251);
insert into help_relation (help_topic_id,help_keyword_id) values (326,251);
insert into help_relation (help_topic_id,help_keyword_id) values (206,251);
insert into help_relation (help_topic_id,help_keyword_id) values (131,251);
insert into help_relation (help_topic_id,help_keyword_id) values (23,251);
insert into help_relation (help_topic_id,help_keyword_id) values (272,251);
insert into help_relation (help_topic_id,help_keyword_id) values (334,251);
insert into help_relation (help_topic_id,help_keyword_id) values (31,251);
insert into help_relation (help_topic_id,help_keyword_id) values (343,251);
insert into help_relation (help_topic_id,help_keyword_id) values (146,251);
insert into help_relation (help_topic_id,help_keyword_id) values (455,251);
insert into help_relation (help_topic_id,help_keyword_id) values (36,251);
insert into help_relation (help_topic_id,help_keyword_id) values (286,251);
insert into help_relation (help_topic_id,help_keyword_id) values (458,251);
insert into help_relation (help_topic_id,help_keyword_id) values (285,251);
insert into help_relation (help_topic_id,help_keyword_id) values (53,251);
insert into help_relation (help_topic_id,help_keyword_id) values (305,251);
insert into help_relation (help_topic_id,help_keyword_id) values (306,251);
insert into help_relation (help_topic_id,help_keyword_id) values (109,251);
insert into help_relation (help_topic_id,help_keyword_id) values (177,251);
insert into help_relation (help_topic_id,help_keyword_id) values (421,251);
insert into help_relation (help_topic_id,help_keyword_id) values (436,252);
insert into help_relation (help_topic_id,help_keyword_id) values (282,253);
insert into help_relation (help_topic_id,help_keyword_id) values (228,253);
insert into help_relation (help_topic_id,help_keyword_id) values (332,253);
insert into help_relation (help_topic_id,help_keyword_id) values (185,253);
insert into help_relation (help_topic_id,help_keyword_id) values (304,254);
insert into help_relation (help_topic_id,help_keyword_id) values (436,255);
insert into help_relation (help_topic_id,help_keyword_id) values (109,256);
insert into help_relation (help_topic_id,help_keyword_id) values (75,257);
insert into help_relation (help_topic_id,help_keyword_id) values (26,257);
insert into help_relation (help_topic_id,help_keyword_id) values (303,257);
insert into help_relation (help_topic_id,help_keyword_id) values (392,257);
insert into help_relation (help_topic_id,help_keyword_id) values (320,257);
insert into help_relation (help_topic_id,help_keyword_id) values (462,257);
insert into help_relation (help_topic_id,help_keyword_id) values (212,257);
insert into help_relation (help_topic_id,help_keyword_id) values (353,258);
insert into help_relation (help_topic_id,help_keyword_id) values (133,259);
insert into help_relation (help_topic_id,help_keyword_id) values (293,259);
insert into help_relation (help_topic_id,help_keyword_id) values (291,260);
insert into help_relation (help_topic_id,help_keyword_id) values (93,261);
insert into help_relation (help_topic_id,help_keyword_id) values (353,262);
insert into help_relation (help_topic_id,help_keyword_id) values (239,263);
insert into help_relation (help_topic_id,help_keyword_id) values (41,263);
insert into help_relation (help_topic_id,help_keyword_id) values (235,263);
insert into help_relation (help_topic_id,help_keyword_id) values (323,264);
insert into help_relation (help_topic_id,help_keyword_id) values (146,264);
insert into help_relation (help_topic_id,help_keyword_id) values (127,265);
insert into help_relation (help_topic_id,help_keyword_id) values (185,266);
insert into help_relation (help_topic_id,help_keyword_id) values (441,267);
insert into help_relation (help_topic_id,help_keyword_id) values (173,268);
insert into help_relation (help_topic_id,help_keyword_id) values (169,269);
insert into help_relation (help_topic_id,help_keyword_id) values (424,270);
insert into help_relation (help_topic_id,help_keyword_id) values (97,271);
insert into help_relation (help_topic_id,help_keyword_id) values (22,271);
insert into help_relation (help_topic_id,help_keyword_id) values (353,272);
insert into help_relation (help_topic_id,help_keyword_id) values (173,273);
insert into help_relation (help_topic_id,help_keyword_id) values (396,274);
insert into help_relation (help_topic_id,help_keyword_id) values (367,275);
insert into help_relation (help_topic_id,help_keyword_id) values (106,275);
insert into help_relation (help_topic_id,help_keyword_id) values (431,276);
insert into help_relation (help_topic_id,help_keyword_id) values (23,277);
insert into help_relation (help_topic_id,help_keyword_id) values (185,278);
insert into help_relation (help_topic_id,help_keyword_id) values (351,279);
insert into help_relation (help_topic_id,help_keyword_id) values (441,279);
insert into help_relation (help_topic_id,help_keyword_id) values (132,280);
insert into help_relation (help_topic_id,help_keyword_id) values (173,281);
insert into help_relation (help_topic_id,help_keyword_id) values (353,282);
insert into help_relation (help_topic_id,help_keyword_id) values (185,283);
insert into help_relation (help_topic_id,help_keyword_id) values (323,284);
insert into help_relation (help_topic_id,help_keyword_id) values (355,284);
insert into help_relation (help_topic_id,help_keyword_id) values (269,285);
insert into help_relation (help_topic_id,help_keyword_id) values (323,285);
insert into help_relation (help_topic_id,help_keyword_id) values (393,285);
insert into help_relation (help_topic_id,help_keyword_id) values (360,286);
insert into help_relation (help_topic_id,help_keyword_id) values (78,287);
insert into help_relation (help_topic_id,help_keyword_id) values (109,287);
insert into help_relation (help_topic_id,help_keyword_id) values (332,287);
insert into help_relation (help_topic_id,help_keyword_id) values (431,288);
insert into help_relation (help_topic_id,help_keyword_id) values (332,289);
insert into help_relation (help_topic_id,help_keyword_id) values (185,290);
insert into help_relation (help_topic_id,help_keyword_id) values (76,291);
insert into help_relation (help_topic_id,help_keyword_id) values (185,291);
insert into help_relation (help_topic_id,help_keyword_id) values (332,292);
insert into help_relation (help_topic_id,help_keyword_id) values (417,293);
insert into help_relation (help_topic_id,help_keyword_id) values (78,294);
insert into help_relation (help_topic_id,help_keyword_id) values (137,294);
insert into help_relation (help_topic_id,help_keyword_id) values (173,295);
insert into help_relation (help_topic_id,help_keyword_id) values (396,296);
insert into help_relation (help_topic_id,help_keyword_id) values (50,297);
insert into help_relation (help_topic_id,help_keyword_id) values (302,297);
insert into help_relation (help_topic_id,help_keyword_id) values (185,298);
insert into help_relation (help_topic_id,help_keyword_id) values (110,299);
insert into help_relation (help_topic_id,help_keyword_id) values (173,300);
insert into help_relation (help_topic_id,help_keyword_id) values (353,301);
insert into help_relation (help_topic_id,help_keyword_id) values (132,302);
insert into help_relation (help_topic_id,help_keyword_id) values (416,302);
insert into help_relation (help_topic_id,help_keyword_id) values (353,303);
insert into help_relation (help_topic_id,help_keyword_id) values (130,304);
insert into help_relation (help_topic_id,help_keyword_id) values (431,305);
insert into help_relation (help_topic_id,help_keyword_id) values (22,306);
insert into help_relation (help_topic_id,help_keyword_id) values (436,307);
insert into help_relation (help_topic_id,help_keyword_id) values (195,307);
insert into help_relation (help_topic_id,help_keyword_id) values (431,307);
insert into help_relation (help_topic_id,help_keyword_id) values (410,308);
insert into help_relation (help_topic_id,help_keyword_id) values (55,308);
insert into help_relation (help_topic_id,help_keyword_id) values (145,308);
insert into help_relation (help_topic_id,help_keyword_id) values (185,308);
insert into help_relation (help_topic_id,help_keyword_id) values (431,308);
insert into help_relation (help_topic_id,help_keyword_id) values (436,309);
insert into help_relation (help_topic_id,help_keyword_id) values (0,310);
insert into help_relation (help_topic_id,help_keyword_id) values (441,311);
insert into help_relation (help_topic_id,help_keyword_id) values (0,312);
insert into help_relation (help_topic_id,help_keyword_id) values (332,312);
insert into help_relation (help_topic_id,help_keyword_id) values (0,313);
insert into help_relation (help_topic_id,help_keyword_id) values (323,314);
insert into help_relation (help_topic_id,help_keyword_id) values (326,314);
insert into help_relation (help_topic_id,help_keyword_id) values (396,315);
insert into help_relation (help_topic_id,help_keyword_id) values (262,316);
insert into help_relation (help_topic_id,help_keyword_id) values (436,317);
insert into help_relation (help_topic_id,help_keyword_id) values (441,318);
insert into help_relation (help_topic_id,help_keyword_id) values (185,318);
insert into help_relation (help_topic_id,help_keyword_id) values (433,319);
insert into help_relation (help_topic_id,help_keyword_id) values (354,319);
insert into help_relation (help_topic_id,help_keyword_id) values (332,320);
insert into help_relation (help_topic_id,help_keyword_id) values (93,321);
insert into help_relation (help_topic_id,help_keyword_id) values (460,322);
insert into help_relation (help_topic_id,help_keyword_id) values (61,323);
insert into help_relation (help_topic_id,help_keyword_id) values (323,323);
insert into help_relation (help_topic_id,help_keyword_id) values (254,324);
insert into help_relation (help_topic_id,help_keyword_id) values (416,325);
insert into help_relation (help_topic_id,help_keyword_id) values (332,326);
insert into help_relation (help_topic_id,help_keyword_id) values (390,327);
insert into help_relation (help_topic_id,help_keyword_id) values (436,328);
insert into help_relation (help_topic_id,help_keyword_id) values (132,329);
insert into help_relation (help_topic_id,help_keyword_id) values (303,329);
insert into help_relation (help_topic_id,help_keyword_id) values (390,330);
insert into help_relation (help_topic_id,help_keyword_id) values (353,331);
insert into help_relation (help_topic_id,help_keyword_id) values (185,332);
insert into help_relation (help_topic_id,help_keyword_id) values (353,333);
insert into help_relation (help_topic_id,help_keyword_id) values (440,334);
insert into help_relation (help_topic_id,help_keyword_id) values (436,334);
insert into help_relation (help_topic_id,help_keyword_id) values (185,334);
insert into help_relation (help_topic_id,help_keyword_id) values (463,335);
insert into help_relation (help_topic_id,help_keyword_id) values (259,336);
insert into help_relation (help_topic_id,help_keyword_id) values (416,337);
insert into help_relation (help_topic_id,help_keyword_id) values (115,338);
insert into help_relation (help_topic_id,help_keyword_id) values (9,339);
insert into help_relation (help_topic_id,help_keyword_id) values (323,339);
insert into help_relation (help_topic_id,help_keyword_id) values (440,340);
insert into help_relation (help_topic_id,help_keyword_id) values (28,340);
insert into help_relation (help_topic_id,help_keyword_id) values (254,340);
insert into help_relation (help_topic_id,help_keyword_id) values (52,341);
insert into help_relation (help_topic_id,help_keyword_id) values (416,342);
insert into help_relation (help_topic_id,help_keyword_id) values (346,343);
insert into help_relation (help_topic_id,help_keyword_id) values (141,344);
insert into help_relation (help_topic_id,help_keyword_id) values (289,344);
insert into help_relation (help_topic_id,help_keyword_id) values (171,345);
insert into help_relation (help_topic_id,help_keyword_id) values (304,346);
insert into help_relation (help_topic_id,help_keyword_id) values (436,347);
insert into help_relation (help_topic_id,help_keyword_id) values (132,348);
insert into help_relation (help_topic_id,help_keyword_id) values (302,348);
insert into help_relation (help_topic_id,help_keyword_id) values (31,349);
insert into help_relation (help_topic_id,help_keyword_id) values (428,350);
insert into help_relation (help_topic_id,help_keyword_id) values (448,351);
insert into help_relation (help_topic_id,help_keyword_id) values (26,351);
insert into help_relation (help_topic_id,help_keyword_id) values (141,351);
insert into help_relation (help_topic_id,help_keyword_id) values (28,351);
insert into help_relation (help_topic_id,help_keyword_id) values (174,351);
insert into help_relation (help_topic_id,help_keyword_id) values (8,351);
insert into help_relation (help_topic_id,help_keyword_id) values (254,351);
insert into help_relation (help_topic_id,help_keyword_id) values (431,352);
insert into help_relation (help_topic_id,help_keyword_id) values (436,353);
insert into help_relation (help_topic_id,help_keyword_id) values (441,354);
insert into help_relation (help_topic_id,help_keyword_id) values (93,355);
insert into help_relation (help_topic_id,help_keyword_id) values (290,356);
insert into help_relation (help_topic_id,help_keyword_id) values (323,357);
insert into help_relation (help_topic_id,help_keyword_id) values (285,357);
insert into help_relation (help_topic_id,help_keyword_id) values (431,357);
insert into help_relation (help_topic_id,help_keyword_id) values (46,358);
insert into help_relation (help_topic_id,help_keyword_id) values (109,358);
insert into help_relation (help_topic_id,help_keyword_id) values (332,358);
insert into help_relation (help_topic_id,help_keyword_id) values (74,358);
insert into help_relation (help_topic_id,help_keyword_id) values (93,358);
insert into help_relation (help_topic_id,help_keyword_id) values (440,359);
insert into help_relation (help_topic_id,help_keyword_id) values (55,359);
insert into help_relation (help_topic_id,help_keyword_id) values (91,359);
insert into help_relation (help_topic_id,help_keyword_id) values (436,359);
insert into help_relation (help_topic_id,help_keyword_id) values (431,359);
insert into help_relation (help_topic_id,help_keyword_id) values (436,360);
insert into help_relation (help_topic_id,help_keyword_id) values (212,361);
insert into help_relation (help_topic_id,help_keyword_id) values (332,362);
insert into help_relation (help_topic_id,help_keyword_id) values (91,363);
insert into help_relation (help_topic_id,help_keyword_id) values (41,363);
insert into help_relation (help_topic_id,help_keyword_id) values (454,363);
insert into help_relation (help_topic_id,help_keyword_id) values (436,364);
insert into help_relation (help_topic_id,help_keyword_id) values (431,364);
insert into help_relation (help_topic_id,help_keyword_id) values (436,365);
insert into help_relation (help_topic_id,help_keyword_id) values (222,365);
insert into help_relation (help_topic_id,help_keyword_id) values (440,366);
insert into help_relation (help_topic_id,help_keyword_id) values (436,366);
insert into help_relation (help_topic_id,help_keyword_id) values (33,367);
insert into help_relation (help_topic_id,help_keyword_id) values (116,368);
insert into help_relation (help_topic_id,help_keyword_id) values (416,368);
insert into help_relation (help_topic_id,help_keyword_id) values (326,368);
insert into help_relation (help_topic_id,help_keyword_id) values (122,368);
insert into help_relation (help_topic_id,help_keyword_id) values (323,369);
insert into help_relation (help_topic_id,help_keyword_id) values (441,369);
insert into help_relation (help_topic_id,help_keyword_id) values (141,369);
insert into help_relation (help_topic_id,help_keyword_id) values (286,369);
insert into help_relation (help_topic_id,help_keyword_id) values (174,369);
insert into help_relation (help_topic_id,help_keyword_id) values (440,370);
insert into help_relation (help_topic_id,help_keyword_id) values (346,370);
insert into help_relation (help_topic_id,help_keyword_id) values (434,371);
insert into help_relation (help_topic_id,help_keyword_id) values (35,372);
insert into help_relation (help_topic_id,help_keyword_id) values (131,372);
insert into help_relation (help_topic_id,help_keyword_id) values (206,372);
insert into help_relation (help_topic_id,help_keyword_id) values (50,372);
insert into help_relation (help_topic_id,help_keyword_id) values (302,372);
insert into help_relation (help_topic_id,help_keyword_id) values (396,373);
insert into help_relation (help_topic_id,help_keyword_id) values (332,374);
insert into help_relation (help_topic_id,help_keyword_id) values (339,374);
insert into help_relation (help_topic_id,help_keyword_id) values (431,375);
insert into help_relation (help_topic_id,help_keyword_id) values (396,376);
insert into help_relation (help_topic_id,help_keyword_id) values (436,377);
insert into help_relation (help_topic_id,help_keyword_id) values (462,378);
insert into help_relation (help_topic_id,help_keyword_id) values (185,379);
insert into help_relation (help_topic_id,help_keyword_id) values (282,380);
insert into help_relation (help_topic_id,help_keyword_id) values (404,380);
insert into help_relation (help_topic_id,help_keyword_id) values (445,380);
insert into help_relation (help_topic_id,help_keyword_id) values (361,380);
insert into help_relation (help_topic_id,help_keyword_id) values (332,380);
insert into help_relation (help_topic_id,help_keyword_id) values (266,380);
insert into help_relation (help_topic_id,help_keyword_id) values (339,380);
insert into help_relation (help_topic_id,help_keyword_id) values (434,381);
insert into help_relation (help_topic_id,help_keyword_id) values (304,381);
insert into help_relation (help_topic_id,help_keyword_id) values (33,381);
insert into help_relation (help_topic_id,help_keyword_id) values (101,381);
insert into help_relation (help_topic_id,help_keyword_id) values (396,381);
insert into help_relation (help_topic_id,help_keyword_id) values (438,381);
insert into help_relation (help_topic_id,help_keyword_id) values (173,382);
insert into help_relation (help_topic_id,help_keyword_id) values (185,383);
insert into help_relation (help_topic_id,help_keyword_id) values (119,384);
insert into help_relation (help_topic_id,help_keyword_id) values (323,384);
insert into help_relation (help_topic_id,help_keyword_id) values (272,384);
insert into help_relation (help_topic_id,help_keyword_id) values (33,384);
insert into help_relation (help_topic_id,help_keyword_id) values (461,385);
insert into help_relation (help_topic_id,help_keyword_id) values (25,386);
insert into help_relation (help_topic_id,help_keyword_id) values (19,387);
insert into help_relation (help_topic_id,help_keyword_id) values (242,387);
insert into help_relation (help_topic_id,help_keyword_id) values (323,388);
insert into help_relation (help_topic_id,help_keyword_id) values (458,388);
insert into help_relation (help_topic_id,help_keyword_id) values (185,389);
insert into help_relation (help_topic_id,help_keyword_id) values (332,390);
insert into help_relation (help_topic_id,help_keyword_id) values (91,390);
insert into help_relation (help_topic_id,help_keyword_id) values (195,391);
insert into help_relation (help_topic_id,help_keyword_id) values (436,392);
insert into help_relation (help_topic_id,help_keyword_id) values (93,392);
insert into help_relation (help_topic_id,help_keyword_id) values (431,392);
insert into help_relation (help_topic_id,help_keyword_id) values (323,393);
insert into help_relation (help_topic_id,help_keyword_id) values (36,394);
insert into help_relation (help_topic_id,help_keyword_id) values (104,394);
insert into help_relation (help_topic_id,help_keyword_id) values (53,394);
insert into help_relation (help_topic_id,help_keyword_id) values (173,394);
insert into help_relation (help_topic_id,help_keyword_id) values (243,394);
insert into help_relation (help_topic_id,help_keyword_id) values (338,394);
insert into help_relation (help_topic_id,help_keyword_id) values (192,395);
insert into help_relation (help_topic_id,help_keyword_id) values (436,395);
insert into help_relation (help_topic_id,help_keyword_id) values (184,396);
insert into help_relation (help_topic_id,help_keyword_id) values (436,397);

